/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm.v40;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.bolt.fsm.v40.BoltStateMachineV4StateTestBase;
import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.message.Error;
import org.neo4j.bolt.protocol.common.message.result.BoltResult;
import org.neo4j.bolt.protocol.common.message.result.ResponseHandler;
import org.neo4j.bolt.protocol.v40.fsm.StateMachineV40;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.SessionExtension;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.testing.assertions.ResponseRecorderAssertions;
import org.neo4j.bolt.testing.assertions.StateMachineAssertions;
import org.neo4j.bolt.testing.messages.BoltV40Messages;
import org.neo4j.bolt.testing.response.RecordedMessage;
import org.neo4j.bolt.testing.response.ResponseRecorder;
import org.neo4j.internal.helpers.Strings;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

class BoltConnectionIT
extends BoltStateMachineV4StateTestBase {
    private static final String[] IRIS_CLASS_NAMES = new String[]{"Iris-setosa", "Iris-versicolor", "Iris-virginica"};
    static final String IRIS_DATA = "sepal_length,sepal_width,petal_length,petal_width,class_name\n5.1,3.5,1.4,0.2,Iris-setosa\n4.9,3.0,1.4,0.2,Iris-setosa\n4.7,3.2,1.3,0.2,Iris-setosa\n4.6,3.1,1.5,0.2,Iris-setosa\n5.0,3.6,1.4,0.2,Iris-setosa\n5.4,3.9,1.7,0.4,Iris-setosa\n4.6,3.4,1.4,0.3,Iris-setosa\n5.0,3.4,1.5,0.2,Iris-setosa\n4.4,2.9,1.4,0.2,Iris-setosa\n4.9,3.1,1.5,0.1,Iris-setosa\n5.4,3.7,1.5,0.2,Iris-setosa\n4.8,3.4,1.6,0.2,Iris-setosa\n4.8,3.0,1.4,0.1,Iris-setosa\n4.3,3.0,1.1,0.1,Iris-setosa\n5.8,4.0,1.2,0.2,Iris-setosa\n5.7,4.4,1.5,0.4,Iris-setosa\n5.4,3.9,1.3,0.4,Iris-setosa\n5.1,3.5,1.4,0.3,Iris-setosa\n5.7,3.8,1.7,0.3,Iris-setosa\n5.1,3.8,1.5,0.3,Iris-setosa\n5.4,3.4,1.7,0.2,Iris-setosa\n5.1,3.7,1.5,0.4,Iris-setosa\n4.6,3.6,1.0,0.2,Iris-setosa\n5.1,3.3,1.7,0.5,Iris-setosa\n4.8,3.4,1.9,0.2,Iris-setosa\n5.0,3.0,1.6,0.2,Iris-setosa\n5.0,3.4,1.6,0.4,Iris-setosa\n5.2,3.5,1.5,0.2,Iris-setosa\n5.2,3.4,1.4,0.2,Iris-setosa\n4.7,3.2,1.6,0.2,Iris-setosa\n4.8,3.1,1.6,0.2,Iris-setosa\n5.4,3.4,1.5,0.4,Iris-setosa\n5.2,4.1,1.5,0.1,Iris-setosa\n5.5,4.2,1.4,0.2,Iris-setosa\n4.9,3.1,1.5,0.2,Iris-setosa\n5.0,3.2,1.2,0.2,Iris-setosa\n5.5,3.5,1.3,0.2,Iris-setosa\n4.9,3.6,1.4,0.1,Iris-setosa\n4.4,3.0,1.3,0.2,Iris-setosa\n5.1,3.4,1.5,0.2,Iris-setosa\n5.0,3.5,1.3,0.3,Iris-setosa\n4.5,2.3,1.3,0.3,Iris-setosa\n4.4,3.2,1.3,0.2,Iris-setosa\n5.0,3.5,1.6,0.6,Iris-setosa\n5.1,3.8,1.9,0.4,Iris-setosa\n4.8,3.0,1.4,0.3,Iris-setosa\n5.1,3.8,1.6,0.2,Iris-setosa\n4.6,3.2,1.4,0.2,Iris-setosa\n5.3,3.7,1.5,0.2,Iris-setosa\n5.0,3.3,1.4,0.2,Iris-setosa\n7.0,3.2,4.7,1.4,Iris-versicolor\n6.4,3.2,4.5,1.5,Iris-versicolor\n6.9,3.1,4.9,1.5,Iris-versicolor\n5.5,2.3,4.0,1.3,Iris-versicolor\n6.5,2.8,4.6,1.5,Iris-versicolor\n5.7,2.8,4.5,1.3,Iris-versicolor\n6.3,3.3,4.7,1.6,Iris-versicolor\n4.9,2.4,3.3,1.0,Iris-versicolor\n6.6,2.9,4.6,1.3,Iris-versicolor\n5.2,2.7,3.9,1.4,Iris-versicolor\n5.0,2.0,3.5,1.0,Iris-versicolor\n5.9,3.0,4.2,1.5,Iris-versicolor\n6.0,2.2,4.0,1.0,Iris-versicolor\n6.1,2.9,4.7,1.4,Iris-versicolor\n5.6,2.9,3.6,1.3,Iris-versicolor\n6.7,3.1,4.4,1.4,Iris-versicolor\n5.6,3.0,4.5,1.5,Iris-versicolor\n5.8,2.7,4.1,1.0,Iris-versicolor\n6.2,2.2,4.5,1.5,Iris-versicolor\n5.6,2.5,3.9,1.1,Iris-versicolor\n5.9,3.2,4.8,1.8,Iris-versicolor\n6.1,2.8,4.0,1.3,Iris-versicolor\n6.3,2.5,4.9,1.5,Iris-versicolor\n6.1,2.8,4.7,1.2,Iris-versicolor\n6.4,2.9,4.3,1.3,Iris-versicolor\n6.6,3.0,4.4,1.4,Iris-versicolor\n6.8,2.8,4.8,1.4,Iris-versicolor\n6.7,3.0,5.0,1.7,Iris-versicolor\n6.0,2.9,4.5,1.5,Iris-versicolor\n5.7,2.6,3.5,1.0,Iris-versicolor\n5.5,2.4,3.8,1.1,Iris-versicolor\n5.5,2.4,3.7,1.0,Iris-versicolor\n5.8,2.7,3.9,1.2,Iris-versicolor\n6.0,2.7,5.1,1.6,Iris-versicolor\n5.4,3.0,4.5,1.5,Iris-versicolor\n6.0,3.4,4.5,1.6,Iris-versicolor\n6.7,3.1,4.7,1.5,Iris-versicolor\n6.3,2.3,4.4,1.3,Iris-versicolor\n5.6,3.0,4.1,1.3,Iris-versicolor\n5.5,2.5,4.0,1.3,Iris-versicolor\n5.5,2.6,4.4,1.2,Iris-versicolor\n6.1,3.0,4.6,1.4,Iris-versicolor\n5.8,2.6,4.0,1.2,Iris-versicolor\n5.0,2.3,3.3,1.0,Iris-versicolor\n5.6,2.7,4.2,1.3,Iris-versicolor\n5.7,3.0,4.2,1.2,Iris-versicolor\n5.7,2.9,4.2,1.3,Iris-versicolor\n6.2,2.9,4.3,1.3,Iris-versicolor\n5.1,2.5,3.0,1.1,Iris-versicolor\n5.7,2.8,4.1,1.3,Iris-versicolor\n6.3,3.3,6.0,2.5,Iris-virginica\n5.8,2.7,5.1,1.9,Iris-virginica\n7.1,3.0,5.9,2.1,Iris-virginica\n6.3,2.9,5.6,1.8,Iris-virginica\n6.5,3.0,5.8,2.2,Iris-virginica\n7.6,3.0,6.6,2.1,Iris-virginica\n4.9,2.5,4.5,1.7,Iris-virginica\n7.3,2.9,6.3,1.8,Iris-virginica\n6.7,2.5,5.8,1.8,Iris-virginica\n7.2,3.6,6.1,2.5,Iris-virginica\n6.5,3.2,5.1,2.0,Iris-virginica\n6.4,2.7,5.3,1.9,Iris-virginica\n6.8,3.0,5.5,2.1,Iris-virginica\n5.7,2.5,5.0,2.0,Iris-virginica\n5.8,2.8,5.1,2.4,Iris-virginica\n6.4,3.2,5.3,2.3,Iris-virginica\n6.5,3.0,5.5,1.8,Iris-virginica\n7.7,3.8,6.7,2.2,Iris-virginica\n7.7,2.6,6.9,2.3,Iris-virginica\n6.0,2.2,5.0,1.5,Iris-virginica\n6.9,3.2,5.7,2.3,Iris-virginica\n5.6,2.8,4.9,2.0,Iris-virginica\n7.7,2.8,6.7,2.0,Iris-virginica\n6.3,2.7,4.9,1.8,Iris-virginica\n6.7,3.3,5.7,2.1,Iris-virginica\n7.2,3.2,6.0,1.8,Iris-virginica\n6.2,2.8,4.8,1.8,Iris-virginica\n6.1,3.0,4.9,1.8,Iris-virginica\n6.4,2.8,5.6,2.1,Iris-virginica\n7.2,3.0,5.8,1.6,Iris-virginica\n7.4,2.8,6.1,1.9,Iris-virginica\n7.9,3.8,6.4,2.0,Iris-virginica\n6.4,2.8,5.6,2.2,Iris-virginica\n6.3,2.8,5.1,1.5,Iris-virginica\n6.1,2.6,5.6,1.4,Iris-virginica\n7.7,3.0,6.1,2.3,Iris-virginica\n6.3,3.4,5.6,2.4,Iris-virginica\n6.4,3.1,5.5,1.8,Iris-virginica\n6.0,3.0,4.8,1.8,Iris-virginica\n6.9,3.1,5.4,2.1,Iris-virginica\n6.7,3.1,5.6,2.4,Iris-virginica\n6.9,3.1,5.1,2.3,Iris-virginica\n5.8,2.7,5.1,1.9,Iris-virginica\n6.8,3.2,5.9,2.3,Iris-virginica\n6.7,3.3,5.7,2.5,Iris-virginica\n6.7,3.0,5.2,2.3,Iris-virginica\n6.3,2.5,5.0,1.9,Iris-virginica\n6.5,3.0,5.2,2.0,Iris-virginica\n6.2,3.4,5.4,2.3,Iris-virginica\n5.9,3.0,5.1,1.8,Iris-virginica\n\n";

    BoltConnectionIT() {
    }

    @Test
    void shouldExecuteStatement() throws Throwable {
        ResponseRecorder runRecorder = new ResponseRecorder();
        StateMachineV40 machine = this.newStateMachineAfterAuth();
        machine.process(BoltV40Messages.run((String)"CREATE (n {k:'k'}) RETURN n.k"), (ResponseHandler)runRecorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)runRecorder).hasSuccessResponse();
        ResponseRecorder pullRecorder = new ResponseRecorder();
        machine.process(BoltV40Messages.pull(), (ResponseHandler)pullRecorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)pullRecorder).hasRecord(new AnyValue[]{Values.stringValue((String)"k")});
    }

    @Test
    void shouldHandleImplicitCommitFailure() throws Throwable {
        StateMachineV40 machine = this.newStateMachineAfterAuth();
        ResponseRecorder recorder = new ResponseRecorder();
        machine.process(BoltV40Messages.run((String)"CREATE (n:Victim)-[:REL]->()"), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV40Messages.discard(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV40Messages.run((String)"MATCH (n:Victim) DELETE n"), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
        machine.process(BoltV40Messages.discard(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.Schema.ConstraintValidationFailed);
    }

    @Test
    void shouldAllowUserControlledRollbackOnExplicitTxFailure() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.newStateMachineAfterAuth();
        machine.process(BoltV40Messages.begin(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV40Messages.run((String)"CREATE (n:Victim)-[:REL]->()"), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV40Messages.discard(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV40Messages.run((String)"this is not valid syntax"), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.Statement.SyntaxError);
        StateMachineAssertions.assertThat((StateMachine)machine).doesNotHaveOpenStatement();
        recorder.reset();
        BoltConnectionIT.resetReceived(machine, recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
        StateMachineAssertions.assertThat((StateMachine)machine).doesNotHaveOpenStatement();
    }

    @Test
    void shouldHandleFailureDuringResultPublishing() throws Throwable {
        StateMachineV40 machine = this.newStateMachineAfterAuth();
        final CountDownLatch pullAllCallbackCalled = new CountDownLatch(1);
        final AtomicReference error = new AtomicReference();
        machine.process(BoltV40Messages.run(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV40Messages.pull(), new ResponseHandler(){

            public boolean onPullRecords(BoltResult result, long size) {
                throw new RuntimeException("Ooopsies!");
            }

            public boolean onDiscardRecords(BoltResult result, long size) {
                throw new RuntimeException("Not this one!");
            }

            public void onMetadata(String key, AnyValue value) {
            }

            public void markFailed(Error err) {
                error.set(err);
                pullAllCallbackCalled.countDown();
            }

            public void markIgnored() {
            }

            public void onFinish() {
            }
        });
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pullAllCallbackCalled.await(30L, TimeUnit.SECONDS));
        Error err = (Error)error.get();
        Assertions.assertThat((Object)err.status()).isEqualTo((Object)Status.General.UnknownError);
        Assertions.assertThat((String)err.message()).contains(new CharSequence[]{"Ooopsies!"});
    }

    @Test
    void shouldBeAbleToCleanlyRunMultipleSessionsInSingleThread() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 firstMachine = this.newStateMachineAfterAuth("conn1");
        StateMachineV40 secondMachine = this.newStateMachineAfterAuth("conn2");
        firstMachine.process(BoltV40Messages.begin(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
        secondMachine.process(BoltV40Messages.run((String)"CREATE (a:Person) RETURN id(a)"), (ResponseHandler)recorder);
        secondMachine.process(BoltV40Messages.pull(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
        RecordedMessage response = recorder.next();
        Assertions.assertThat((boolean)response.isRecord()).isTrue();
        long id = ((LongValue)response.asRecord()[0]).longValue();
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
        firstMachine.process(BoltV40Messages.rollback(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
        recorder.reset();
        secondMachine.process(BoltV40Messages.run((String)("MATCH (a:Person) WHERE id(a) = " + id + " RETURN COUNT(*)")), (ResponseHandler)recorder);
        secondMachine.process(BoltV40Messages.pull(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse().hasRecord(new AnyValue[]{Values.longValue((long)1L)});
    }

    @Test
    void shouldSupportUsingExplainCallInTransactionsInTransaction() throws Exception {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.newStateMachineAfterAuth();
        MapValue params = BoltConnectionIT.map("csvFileUrl", BoltConnectionIT.createLocalIrisData((StateMachine)machine));
        machine.process(BoltV40Messages.begin(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV40Messages.run((String)Strings.joinAsLines((String[])new String[]{"LOAD CSV WITH HEADERS FROM $csvFileUrl AS l", "CALL {", "  WITH l", "  MATCH (c:Class {name: l.class_name})", "  CREATE (s:Sample {sepal_length: l.sepal_length,", "                    sepal_width: l.sepal_width,", "                    petal_length: l.petal_length,", "                    petal_width: l.petal_width})", "  CREATE (c)<-[:HAS_CLASS]-(s)", "  RETURN c, s", "} IN TRANSACTIONS OF 40 ROWS", "RETURN count(*) AS c"}), (MapValue)params), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
    }

    @Test
    void shouldCloseTransactionOnCommit() throws Exception {
        StateMachineV40 machine = this.newStateMachineAfterAuth();
        machine.process(BoltV40Messages.begin(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltConnectionIT.runAndPull((StateMachine)machine);
        machine.process(BoltV40Messages.commit(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        StateMachineAssertions.assertThat((StateMachine)machine).doesNotHaveTransaction();
    }

    @Test
    void shouldCloseTransactionEvenIfCommitFails() throws Exception {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.newStateMachineAfterAuth();
        machine.process(BoltV40Messages.begin(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV40Messages.run((String)"X"), (ResponseHandler)recorder);
        machine.process(BoltV40Messages.pull(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.Statement.SyntaxError).hasIgnoredResponse();
        StateMachineAssertions.assertThat((StateMachine)machine).hasTransaction();
        recorder.reset();
        machine.process(BoltV40Messages.commit(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasIgnoredResponse();
        BoltConnectionIT.resetReceived(machine, recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
        StateMachineAssertions.assertThat((StateMachine)machine).doesNotHaveTransaction();
    }

    @Test
    void shouldCloseTransactionOnRollback() throws Exception {
        StateMachineV40 machine = this.newStateMachineAfterAuth();
        machine.process(BoltV40Messages.begin(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        BoltConnectionIT.runAndPull((StateMachine)machine);
        machine.process(BoltV40Messages.rollback(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        StateMachineAssertions.assertThat((StateMachine)machine).doesNotHaveTransaction();
    }

    @Test
    void shouldCloseTransactionOnRollbackAfterFailure() throws Exception {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.newStateMachineAfterAuth();
        machine.process(BoltV40Messages.begin(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV40Messages.run((String)"X"), (ResponseHandler)recorder);
        machine.process(BoltV40Messages.pull(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.Statement.SyntaxError).hasIgnoredResponse();
        StateMachineAssertions.assertThat((StateMachine)machine).hasTransaction();
        recorder.reset();
        machine.process(BoltV40Messages.rollback(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasIgnoredResponse();
        BoltConnectionIT.resetReceived(machine, recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
        StateMachineAssertions.assertThat((StateMachine)machine).doesNotHaveTransaction();
    }

    private static void resetReceived(StateMachineV40 machine, ResponseRecorder recorder) throws BoltConnectionFatality {
        machine.connection().interrupt();
        machine.interrupt();
        machine.process(BoltV40Messages.reset(), (ResponseHandler)recorder);
    }

    static String createLocalIrisData(StateMachine machine) throws Exception {
        for (String className : IRIS_CLASS_NAMES) {
            MapValue params = BoltConnectionIT.map("className", className);
            BoltConnectionIT.runAndPull(machine, "CREATE (c:Class {name: $className}) RETURN c", params);
        }
        return SessionExtension.putTmpFile((String)"iris", (String)".csv", (String)IRIS_DATA).toExternalForm();
    }

    private static void runAndPull(StateMachine machine) throws Exception {
        BoltConnectionIT.runAndPull(machine, "RETURN 1", EMPTY_PARAMS);
    }

    private static void runAndPull(StateMachine machine, String statement, MapValue params) throws Exception {
        ResponseRecorder recorder = new ResponseRecorder();
        machine.process(BoltV40Messages.run((String)statement, (MapValue)params), (ResponseHandler)recorder);
        machine.process(BoltV40Messages.pull(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse().hasRecord().hasSuccessResponse();
    }

    private static MapValue map(Object ... keyValues) {
        return ValueUtils.asMapValue((Map)MapUtil.map((Object[])keyValues));
    }
}

