/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm.v40;

import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.mockito.Mockito;
import org.neo4j.bolt.protocol.common.message.result.ResponseHandler;
import org.neo4j.bolt.protocol.v40.BoltProtocolV40;
import org.neo4j.bolt.protocol.v40.fsm.StateMachineV40;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.SessionExtension;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.testing.messages.BoltV40Messages;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

@ResourceLock(value="boltStateMachineV4")
public class BoltStateMachineV4StateTestBase {
    protected static final MapValue EMPTY_PARAMS = VirtualValues.EMPTY_MAP;
    @RegisterExtension
    static final SessionExtension env = new SessionExtension();

    protected StateMachineV40 newStateMachine() {
        return (StateMachineV40)env.newMachine(BoltProtocolV40.VERSION);
    }

    protected StateMachineV40 newStateMachineAfterAuth() throws BoltConnectionFatality {
        return BoltStateMachineV4StateTestBase.newStateMachineAfterAuth(env);
    }

    protected StateMachineV40 newStateMachineAfterAuth(String connectionId) throws BoltConnectionFatality {
        StateMachineV40 machine = (StateMachineV40)env.newMachine(BoltProtocolV40.VERSION);
        Mockito.when((Object)machine.connection().id()).thenReturn((Object)connectionId);
        machine.process(BoltV40Messages.hello(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        return machine;
    }

    protected static StateMachineV40 newStateMachineAfterAuth(SessionExtension env) throws BoltConnectionFatality {
        StateMachineV40 machine = (StateMachineV40)env.newMachine(BoltProtocolV40.VERSION);
        machine.process(BoltV40Messages.hello(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        return machine;
    }
}

