/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.struct;

import java.io.IOException;
import org.neo4j.bolt.protocol.common.connector.connection.Feature;
import org.neo4j.bolt.protocol.io.StructType;
import org.neo4j.bolt.struct.AbstractStructArgumentIT;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.initializer.EnableFeature;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.storable.CoordinateReferenceSystem;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class StructArgumentIT
extends AbstractStructArgumentIT {
    @ProtocolTest
    void shouldFailWhenPoint2DIsSentWithInvalidCrsId(@Authenticated TransportConnection connection) throws IOException {
        this.testFailureWithUnpackableValue(connection, buf -> buf.writeStructHeader(new StructHeader(3L, StructType.POINT_2D.getTag())).writeInt(5L).writeFloat(3.15).writeFloat(4.012), "Illegal value for field \"params\": Illegal value for field \"crs\": Illegal coordinate reference system: \"5\"");
    }

    @ProtocolTest
    void shouldFailWhenPoint3DIsSentWithInvalidCrsId(@Authenticated TransportConnection connection) throws IOException {
        this.testFailureWithUnpackableValue(connection, buf -> buf.writeStructHeader(new StructHeader(4L, StructType.POINT_3D.getTag())).writeInt(1200L).writeFloat(3.15).writeFloat(4.012).writeFloat(5.905), "Illegal value for field \"params\": Illegal value for field \"crs\": Illegal coordinate reference system: \"1200\"");
    }

    @ProtocolTest
    void shouldFailWhenPoint2DDimensionsDoNotMatch(@Authenticated TransportConnection connection) throws IOException {
        this.testFailureWithUnpackableValue(connection, buf -> buf.writeStructHeader(new StructHeader(3L, StructType.POINT_2D.getTag())).writeInt((long)CoordinateReferenceSystem.CARTESIAN_3D.getCode()).writeFloat(3.15).writeFloat(4.012), "Illegal value for field \"params\": Illegal value for field \"coords\": Illegal CRS/coords combination (crs=cartesian-3d, x=3.15, y=4.012)");
    }

    @ProtocolTest
    void shouldFailWhenPoint3DDimensionsDoNotMatch(@Authenticated TransportConnection connection) throws IOException {
        this.testFailureWithUnpackableValue(connection, buf -> buf.writeStructHeader(new StructHeader(4L, StructType.POINT_3D.getTag())).writeInt((long)CoordinateReferenceSystem.CARTESIAN.getCode()).writeFloat(3.15).writeFloat(4.012).writeFloat(5.905), "Illegal value for field \"params\": Illegal value for field \"coords\": Illegal CRS/coords combination (crs=cartesian, x=3.15, y=4.012, z=5.905)");
    }

    @ProtocolTest
    @EnableFeature(value={Feature.UTC_DATETIME})
    void shouldFailWhenZonedDateTimeZoneIdIsNotKnown(@Authenticated TransportConnection connection) throws IOException {
        this.testFailureWithUnpackableValue(connection, buf -> buf.writeStructHeader(new StructHeader(3L, StructType.DATE_TIME_ZONE_ID.getTag())).writeInt(0L).writeInt(0L).writeString("Europe/Marmaris"), "Illegal value for field \"params\": Illegal value for field \"tz_id\": Illegal zone identifier: \"Europe/Marmaris\"");
    }
}

