/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.struct;

import java.time.ZoneId;
import java.time.ZoneOffset;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.ListValueBuilder;
import org.neo4j.values.virtual.MapValueBuilder;
import org.neo4j.values.virtual.VirtualValues;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class StructTypeIT {
    private static <T extends AnyValue> void testSendingOfBoltV2Value(BoltWire wire, TransportConnection connection, T value) throws Exception {
        connection.send(wire.run("CREATE (n:Node {value: $value}) RETURN 42", VirtualValues.map((String[])new String[]{"value"}, (AnyValue[])new AnyValue[]{value}))).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesRecord(new AnyValue[]{Values.longValue((long)42L)}).receivesSuccess();
    }

    private static <T extends AnyValue> void testReceivingOfBoltV2Value(BoltWire wire, TransportConnection connection, String query, T expectedValue) throws Exception {
        connection.send(wire.run(query)).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesRecord(new AnyValue[]{expectedValue}).receivesSuccess();
    }

    private static <T extends AnyValue> void testSendingAndReceivingOfBoltV2Value(BoltWire wire, TransportConnection connection, T value) throws Exception {
        connection.send(wire.run("RETURN $value", VirtualValues.map((String[])new String[]{"value"}, (AnyValue[])new AnyValue[]{value}))).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesRecord(new AnyValue[]{value}).receivesSuccess();
    }

    @ProtocolTest
    void shouldSendPoint2D(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testSendingOfBoltV2Value(wire, connection, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84, (double[])new double[]{39.111748, -76.775635}));
    }

    @ProtocolTest
    void shouldReceivePoint2D(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testReceivingOfBoltV2Value(wire, connection, "RETURN point({x: 40.7624, y: 73.9738})", Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.CARTESIAN, (double[])new double[]{40.7624, 73.9738}));
    }

    @ProtocolTest
    void shouldSendAndReceivePoint2D(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testSendingAndReceivingOfBoltV2Value(wire, connection, Values.pointValue((CoordinateReferenceSystem)CoordinateReferenceSystem.WGS_84, (double[])new double[]{38.8719, 77.0563}));
    }

    @ProtocolTest
    void shouldSendDuration(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testSendingOfBoltV2Value(wire, connection, DurationValue.duration((long)5L, (long)3L, (long)34L, (long)0L));
    }

    @ProtocolTest
    void shouldReceiveDuration(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testReceivingOfBoltV2Value(wire, connection, "RETURN duration({months: 3, days: 100, seconds: 999, nanoseconds: 42})", DurationValue.duration((long)3L, (long)100L, (long)999L, (long)42L));
    }

    @ProtocolTest
    void shouldSendAndReceiveDuration(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testSendingAndReceivingOfBoltV2Value(wire, connection, DurationValue.duration((long)17L, (long)9L, (long)2L, (long)1000000L));
    }

    @ProtocolTest
    void shouldSendDate(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testSendingOfBoltV2Value(wire, connection, DateValue.date((int)1991, (int)8, (int)24));
    }

    @ProtocolTest
    void shouldReceiveDate(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testReceivingOfBoltV2Value(wire, connection, "RETURN date('2015-02-18')", DateValue.date((int)2015, (int)2, (int)18));
    }

    @ProtocolTest
    void shouldSendAndReceiveDate(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testSendingAndReceivingOfBoltV2Value(wire, connection, DateValue.date((int)2005, (int)5, (int)22));
    }

    @ProtocolTest
    void shouldSendLocalTime(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testSendingOfBoltV2Value(wire, connection, LocalTimeValue.localTime((int)2, (int)35, (int)10, (int)1));
    }

    @ProtocolTest
    void shouldReceiveLocalTime(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testReceivingOfBoltV2Value(wire, connection, "RETURN localtime('11:04:35')", LocalTimeValue.localTime((int)11, (int)4, (int)35, (int)0));
    }

    @ProtocolTest
    void shouldSendAndReceiveLocalTime(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testSendingAndReceivingOfBoltV2Value(wire, connection, LocalTimeValue.localTime((int)22, (int)10, (int)10, (int)99));
    }

    @ProtocolTest
    void shouldSendTime(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testSendingOfBoltV2Value(wire, connection, TimeValue.time((long)424242L, (ZoneOffset)ZoneOffset.of("+08:30")));
    }

    @ProtocolTest
    void shouldReceiveTime(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testReceivingOfBoltV2Value(wire, connection, "RETURN time('14:30+0100')", TimeValue.time((int)14, (int)30, (int)0, (int)0, (ZoneOffset)ZoneOffset.ofHours(1)));
    }

    @ProtocolTest
    void shouldSendAndReceiveTime(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testSendingAndReceivingOfBoltV2Value(wire, connection, TimeValue.time((int)19, (int)22, (int)44, (int)100, (ZoneOffset)ZoneOffset.ofHours(-5)));
    }

    @ProtocolTest
    void shouldSendLocalDateTime(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testSendingOfBoltV2Value(wire, connection, LocalDateTimeValue.localDateTime((int)2002, (int)5, (int)22, (int)15, (int)15, (int)25, (int)0));
    }

    @ProtocolTest
    void shouldReceiveLocalDateTime(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testReceivingOfBoltV2Value(wire, connection, "RETURN localdatetime('20150202T19:32:24')", LocalDateTimeValue.localDateTime((int)2015, (int)2, (int)2, (int)19, (int)32, (int)24, (int)0));
    }

    @ProtocolTest
    void shouldSendAndReceiveLocalDateTime(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testSendingAndReceivingOfBoltV2Value(wire, connection, LocalDateTimeValue.localDateTime((int)1995, (int)12, (int)12, (int)10, (int)30, (int)0, (int)0));
    }

    @ProtocolTest
    void shouldSendDateTimeWithTimeZoneName(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testSendingOfBoltV2Value(wire, connection, DateTimeValue.datetime((int)1956, (int)9, (int)14, (int)11, (int)20, (int)25, (int)0, (String)"Europe/Stockholm"));
    }

    @ProtocolTest
    void shouldReceiveDateTimeWithTimeZoneName(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testReceivingOfBoltV2Value(wire, connection, "RETURN datetime({year:1984, month:10, day:11, hour:21, minute:30, timezone:'Europe/London'})", DateTimeValue.datetime((int)1984, (int)10, (int)11, (int)21, (int)30, (int)0, (int)0, (String)"Europe/London"));
    }

    @ProtocolTest
    void shouldSendAndReceiveDateTimeWithTimeZoneName(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testSendingAndReceivingOfBoltV2Value(wire, connection, DateTimeValue.datetime((int)1984, (int)10, (int)11, (int)21, (int)30, (int)0, (int)0, (String)"Europe/London"));
    }

    @ProtocolTest
    void shouldSendDateTimeWithTimeZoneOffset(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testSendingOfBoltV2Value(wire, connection, DateTimeValue.datetime((long)424242L, (long)0L, (ZoneOffset)ZoneOffset.ofHoursMinutes(-7, -15)));
    }

    @ProtocolTest
    void shouldReceiveDateTimeWithTimeZoneOffset(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testReceivingOfBoltV2Value(wire, connection, "RETURN datetime({year:2022, month:3, day:2, hour:19, minute:10, timezone:'+02:30'})", DateTimeValue.datetime((int)2022, (int)3, (int)2, (int)19, (int)10, (int)0, (int)0, (ZoneId)ZoneOffset.ofHoursMinutes(2, 30)));
    }

    @ProtocolTest
    void shouldSendAndReceiveDateTimeWithTimeZoneOffset(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        StructTypeIT.testSendingAndReceivingOfBoltV2Value(wire, connection, DateTimeValue.datetime((int)1899, (int)1, (int)1, (int)12, (int)12, (int)32, (int)0, (ZoneId)ZoneOffset.ofHoursMinutes(-4, -15)));
    }

    @ProtocolTest
    public void shouldSendAndReceiveMapContainingStruct(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        MapValueBuilder mapValueBuilder = new MapValueBuilder();
        mapValueBuilder.add("foo", (AnyValue)DateTimeValue.datetime((int)1899, (int)1, (int)1, (int)12, (int)12, (int)32, (int)0, (ZoneId)ZoneOffset.ofHoursMinutes(-4, -15)));
        StructTypeIT.testSendingAndReceivingOfBoltV2Value(wire, connection, mapValueBuilder.build());
    }

    @ProtocolTest
    public void shouldSendAndReceiveListContainingStruct(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        ListValueBuilder listValueBuilder = ListValueBuilder.newListBuilder();
        listValueBuilder.add((AnyValue)DateTimeValue.datetime((int)1899, (int)1, (int)1, (int)12, (int)12, (int)32, (int)0, (ZoneId)ZoneOffset.ofHoursMinutes(-4, -15)));
        StructTypeIT.testSendingAndReceivingOfBoltV2Value(wire, connection, listValueBuilder.build());
    }
}

