/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.connection.transport;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.bolt.test.annotation.connection.transport.ExcludeTransport;
import org.neo4j.bolt.test.annotation.connection.transport.IncludeTransport;
import org.neo4j.bolt.test.connection.transport.TransportSelector;
import org.neo4j.bolt.test.util.AnnotationUtil;
import org.neo4j.bolt.testing.client.TransportType;

public class FilteredTransportSelector
implements TransportSelector {
    @Override
    public Stream<TransportType> select(ExtensionContext context) {
        Stream explicitIncludes = AnnotationUtil.findAnnotation(context, IncludeTransport.class).map(annotation -> Stream.of(annotation.value())).orElseGet(() -> Stream.of(TransportType.values()));
        List explicitExcludes = AnnotationUtil.findAnnotation(context, ExcludeTransport.class).map(annotation -> List.of(annotation.value())).orElseGet(Collections::emptyList);
        return explicitIncludes.distinct().filter(transport -> !explicitExcludes.contains(transport));
    }
}

