/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.extension.context;

import java.util.List;
import java.util.function.BiConsumer;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.neo4j.bolt.test.extension.lifecycle.ServerInstanceManager;
import org.neo4j.bolt.test.extension.lifecycle.TransportConnectionManager;
import org.neo4j.bolt.test.extension.resolver.StaticParameterResolver;
import org.neo4j.bolt.test.extension.resolver.SupplierParameterResolver;
import org.neo4j.bolt.test.extension.resolver.connection.ConnectionProviderParameterResolver;
import org.neo4j.bolt.test.extension.resolver.connection.TransportConnectionParameterResolver;
import org.neo4j.bolt.testing.client.TransportType;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketSupportExtension;
import org.neo4j.internal.helpers.HostnamePort;

public class BoltTestTemplateInvocationContext
implements TestTemplateInvocationContext {
    private final BiConsumer<ExtensionContext, Neo4jWithSocket> serverInitializer;
    private final TransportType transportType;
    private final BoltWire wire;

    public BoltTestTemplateInvocationContext(BiConsumer<ExtensionContext, Neo4jWithSocket> serverInitializer, TransportType transportType, BoltWire wire) {
        this.serverInitializer = serverInitializer;
        this.transportType = transportType;
        this.wire = wire;
    }

    public String getDisplayName(int invocationIndex) {
        return "v" + this.wire.getProtocolVersion() + " via " + this.transportType.name();
    }

    public List<Extension> getAdditionalExtensions() {
        TransportConnectionManager connectionManager = new TransportConnectionManager(this.transportType);
        return List.of(new StaticParameterResolver<TransportType>(this.transportType), new StaticParameterResolver<BoltWire>(BoltWire.class, this.wire), new ServerInstanceManager(this.serverInitializer), connectionManager, new SupplierParameterResolver<HostnamePort>(HostnamePort.class, Neo4jWithSocketSupportExtension::getDefaultConnectorAddress), new TransportConnectionParameterResolver(connectionManager, this.wire), new ConnectionProviderParameterResolver(connectionManager, this.wire));
    }
}

