/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.extension.lifecycle;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.client.TransportType;
import org.neo4j.internal.helpers.HostnamePort;

public class TransportConnectionManager
implements AfterEachCallback {
    private final TransportType transportType;
    private final Lock lock = new ReentrantLock();
    private final List<TransportConnection> activeConnections = new ArrayList<TransportConnection>();

    public TransportConnectionManager(TransportType transportType) {
        this.transportType = transportType;
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.lock.lock();
        try {
            this.activeConnections.forEach(connection -> {
                try {
                    connection.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
            this.activeConnections.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public TransportConnection acquire(HostnamePort address) {
        TransportConnection connection = this.transportType.getFactory().create(address);
        this.lock.lock();
        try {
            this.activeConnections.add(connection);
        }
        finally {
            this.lock.unlock();
        }
        return connection;
    }
}

