/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.authentication;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Negotiated;
import org.neo4j.bolt.test.annotation.setup.SettingsFunction;
import org.neo4j.bolt.test.annotation.test.TransportTest;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.connectors.BoltConnectorInternalSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.ByteUnit;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.packstream.io.PackstreamBuf;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.test.extension.OtherThreadExtension;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
@ExtendWith(value={OtherThreadExtension.class})
public class UnauthenticatedIT {
    @SettingsFunction
    static void customizeSettings(Map<Setting<?>, Object> settings) {
        settings.put(BoltConnectorInternalSettings.unsupported_bolt_unauth_connection_timeout, Duration.ofSeconds(5L));
        settings.put(BoltConnectorInternalSettings.unsupported_bolt_unauth_connection_max_inbound_bytes, ByteUnit.kibiBytes((long)1L));
    }

    @TransportTest
    void shouldTimeoutWhenTruncatedHelloIsReceived(BoltWire wire, @Negotiated TransportConnection connection) throws IOException {
        ByteBuf msg = wire.hello();
        ByteBuf buffer = msg.readSlice(msg.readableBytes() / 2);
        connection.send(buffer);
        BoltConnectionAssertions.assertThat((TransportConnection)connection).isEventuallyTerminated();
    }

    @TransportTest
    void shouldTerminateConnectionWhenLargeHelloIsReceived(BoltWire wire, @Negotiated TransportConnection connection) throws IOException {
        HashMap<CallSite, Integer> meta = new HashMap<CallSite, Integer>();
        for (int i = 0; i < 200; ++i) {
            meta.put((CallSite)((Object)("index-" + i)), i);
        }
        connection.send(wire.hello(meta, null));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).isEventuallyTerminated();
    }

    @TransportTest
    void shouldTerminateConnectionWhenLargeDeclaredMetaMapIsReceived(@Negotiated TransportConnection connection) throws IOException {
        connection.send(PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(1L, 1)).writeMapHeader(Integer.MAX_VALUE).writeString("foo").writeString("bar"));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailureFuzzy((Status)Status.Request.Invalid, "Illegal value for field \"extra\": Value of size 2147483647 exceeded limit of").isEventuallyTerminated();
    }

    @TransportTest
    void shouldTerminateConnectionWhenLargeDeclaredListParameterIsReceived(@Negotiated TransportConnection connection) throws IOException {
        connection.send(PackstreamBuf.allocUnpooled().writeStructHeader(new StructHeader(1L, 1)).writeMapHeader(1L).writeString("x").writeListHeader(Integer.MAX_VALUE).writeString("foo").writeString("bar"));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailureFuzzy((Status)Status.Request.Invalid, "Illegal value for field \"extra\": Value of size 2147483647 exceeded limit of").isEventuallyTerminated();
    }
}

