/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm.v40;

import java.util.stream.Stream;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.bolt.fsm.v40.BoltStateMachineV4StateTestBase;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.request.Signal;
import org.neo4j.bolt.protocol.common.message.result.BoltResult;
import org.neo4j.bolt.protocol.common.message.result.ResponseHandler;
import org.neo4j.bolt.protocol.v40.fsm.FailedState;
import org.neo4j.bolt.protocol.v40.fsm.InTransactionState;
import org.neo4j.bolt.protocol.v40.fsm.InterruptedState;
import org.neo4j.bolt.protocol.v40.fsm.ReadyState;
import org.neo4j.bolt.protocol.v40.fsm.StateMachineV40;
import org.neo4j.bolt.protocol.v40.messaging.request.CommitMessage;
import org.neo4j.bolt.protocol.v40.messaging.request.RollbackMessage;
import org.neo4j.bolt.protocol.v40.messaging.request.RunMessage;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.testing.assertions.MapValueAssertions;
import org.neo4j.bolt.testing.assertions.ResponseRecorderAssertions;
import org.neo4j.bolt.testing.assertions.StateMachineAssertions;
import org.neo4j.bolt.testing.messages.BoltV40Messages;
import org.neo4j.bolt.testing.response.ResponseRecorder;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

class InTransactionStateIT
extends BoltStateMachineV4StateTestBase {
    InTransactionStateIT() {
    }

    @Test
    void shouldMoveFromInTxToReadyOnCommit_succ() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.getBoltStateMachineInTxState();
        machine.process((RequestMessage)CommitMessage.INSTANCE, (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsKey("bookmark"));
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(ReadyState.class);
    }

    @Test
    void shouldMoveFromInTxToReadyOnRollback_succ() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.getBoltStateMachineInTxState();
        machine.process((RequestMessage)RollbackMessage.INSTANCE, (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).doesNotContainKey("bookmark").doesNotContainKey("db"));
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(ReadyState.class);
    }

    @Test
    void shouldStayInTxOnDiscard_succ() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.getBoltStateMachineInTxState();
        machine.process(BoltV40Messages.discard((long)100L), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).doesNotContainKey("bookmark").containsKey("db"));
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(InTransactionState.class);
    }

    @Test
    void shouldStayInTxOnDiscard_succ_hasMore() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.getBoltStateMachineInTxState("Unwind [1, 2, 3] as n return n");
        machine.process(BoltV40Messages.discard((long)2L), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsEntry("has_more", (AnyValue)BooleanValue.TRUE).doesNotContainKey("db"));
        machine.process(BoltV40Messages.discard((long)2L), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsKey("type").containsKey("t_last").doesNotContainKey("bookmark").containsKey("db").doesNotContainKey("has_more"));
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(InTransactionState.class);
    }

    @Test
    void shouldStayInTxOnPull_succ() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.getBoltStateMachineInTxState();
        machine.process(BoltV40Messages.pull((long)100L), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasRecord().hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsKey("type").containsKey("t_last").doesNotContainKey("bookmark").containsKey("db"));
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(InTransactionState.class);
    }

    @Test
    void shouldStayInTxOnPull_succ_hasMore() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.getBoltStateMachineInTxState("Unwind [1, 2, 3] as n return n");
        machine.process(BoltV40Messages.pull((long)2L), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasRecord(new AnyValue[]{Values.longValue((long)1L)}).hasRecord(new AnyValue[]{Values.longValue((long)2L)}).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsEntry("has_more", (AnyValue)BooleanValue.TRUE).doesNotContainKey("db"));
        machine.process(BoltV40Messages.pull((long)2L), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasRecord(new AnyValue[]{Values.longValue((long)3L)}).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsKey("type").containsKey("t_last").doesNotContainKey("bookmark").containsKey("db"));
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(InTransactionState.class);
    }

    @Test
    void shouldStayInTxOnAnotherRun_succ() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.getBoltStateMachineInTxState();
        machine.process((RequestMessage)new RunMessage("MATCH (n) RETURN n LIMIT 1"), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).doesNotContainKey("bookmark"));
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(InTransactionState.class);
    }

    @Test
    void shouldMoveFromInTxToFailedOnAnotherRun_fail() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.getBoltStateMachineInTxState();
        machine.process((RequestMessage)new RunMessage("any string"), (ResponseHandler)recorder);
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(FailedState.class);
    }

    @Test
    void shouldMoveFromInTxToInterruptedOnInterrupt() throws Throwable {
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineV40 machine = this.getBoltStateMachineInTxState();
        machine.process((RequestMessage)Signal.INTERRUPT, (ResponseHandler)recorder);
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(InterruptedState.class);
    }

    @ParameterizedTest
    @MethodSource(value={"pullAllDiscardAllMessages"})
    void shouldMoveFromInTxStateToFailedStateOnfail(RequestMessage message) throws Throwable {
        StateMachineV40 machine = this.getBoltStateMachineInTxState();
        ResponseHandler handler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        ((ResponseHandler)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Fail")}).when((Object)handler)).onPullRecords((BoltResult)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        ((ResponseHandler)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Fail")}).when((Object)handler)).onDiscardRecords((BoltResult)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
        machine.process(message, handler);
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(FailedState.class);
    }

    @ParameterizedTest
    @MethodSource(value={"illegalV4Messages"})
    void shouldCloseConnectionOnIllegalV4MessagesInTxStreamingState(RequestMessage message) throws Throwable {
        StateMachineV40 machine = this.newStateMachine();
        machine.process(BoltV40Messages.hello(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV40Messages.begin(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV40Messages.run((String)"CREATE (n {k:'k'}) RETURN n.k"), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(InTransactionState.class);
        ResponseRecorder recorder = new ResponseRecorder();
        StateMachineAssertions.assertThat((StateMachine)machine).shouldKillConnection(fsm -> fsm.process(message, (ResponseHandler)recorder)).isInInvalidState();
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.Request.Invalid);
    }

    private static Stream<RequestMessage> illegalV4Messages() {
        return Stream.of(BoltV40Messages.hello(), BoltV40Messages.begin(), BoltV40Messages.reset(), BoltV40Messages.goodbye());
    }

    private static Stream<RequestMessage> pullAllDiscardAllMessages() throws BoltIOException {
        return Stream.of(BoltV40Messages.pull((long)100L), BoltV40Messages.discard((long)100L));
    }

    private StateMachineV40 getBoltStateMachineInTxState() throws BoltConnectionFatality {
        return this.getBoltStateMachineInTxState("CREATE (n {k:'k'}) RETURN n.k");
    }

    private StateMachineV40 getBoltStateMachineInTxState(String query) throws BoltConnectionFatality {
        StateMachineV40 machine = this.newStateMachine();
        machine.process(BoltV40Messages.hello(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        machine.process(BoltV40Messages.begin(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(InTransactionState.class);
        machine.process(BoltV40Messages.run((String)query), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        StateMachineAssertions.assertThat((StateMachine)machine).isInState(InTransactionState.class);
        return machine;
    }
}

