/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm.v41;

import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.common.message.result.ResponseHandler;
import org.neo4j.bolt.protocol.v41.BoltProtocolV41;
import org.neo4j.bolt.protocol.v41.fsm.StateMachineV41;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.SessionExtension;
import org.neo4j.bolt.testing.NullResponseHandler;
import org.neo4j.bolt.testing.messages.BoltV40Messages;
import org.neo4j.bolt.testing.messages.BoltV41Messages;

@ResourceLock(value="boltStateMachineV41")
public class BoltStateMachineV41StateTestBase {
    @RegisterExtension
    static final SessionExtension env = new SessionExtension();

    protected StateMachineV41 newStateMachine() {
        return (StateMachineV41)env.newMachine(BoltProtocolV41.VERSION);
    }

    protected StateMachineV41 newStateMachineAfterAuth() throws BoltConnectionFatality {
        StateMachineV41 machine = (StateMachineV41)env.newMachine(BoltProtocolV41.VERSION);
        machine.process(BoltV40Messages.hello(), (ResponseHandler)NullResponseHandler.nullResponseHandler());
        return machine;
    }

    protected static RequestMessage newHelloMessage() {
        return BoltV41Messages.hello();
    }

    protected static RequestMessage newPullMessage(long size) throws BoltIOException {
        return BoltV41Messages.pull((long)size);
    }

    protected static RequestMessage newDiscardMessage(long size) throws BoltIOException {
        return BoltV41Messages.discard((long)size);
    }
}

