/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.extension;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.neo4j.bolt.test.extension.lifecycle.ServerInstanceManager;
import org.neo4j.bolt.test.extension.lifecycle.TransportConnectionManager;
import org.neo4j.bolt.test.extension.resolver.StaticParameterResolver;
import org.neo4j.bolt.test.extension.resolver.connection.ConnectionProviderParameterResolver;
import org.neo4j.bolt.test.extension.resolver.connection.HostnamePortParameterResolver;
import org.neo4j.bolt.test.extension.resolver.connection.TransportConnectionParameterResolver;
import org.neo4j.bolt.testing.client.TransportType;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;

record BoltTestConfig(Class<? extends TestDatabaseManagementServiceBuilder> databaseFactoryType, Method databaseFactoryFunction, Method databaseSettingsFunction, TransportType transport, BoltWire wire) implements TestTemplateInvocationContext
{
    public String getDisplayName(int invocationIndex) {
        return this.wire.getProtocolVersion() + " via " + this.transport.name();
    }

    public List<Extension> getAdditionalExtensions() {
        TransportConnectionManager connectionManager = new TransportConnectionManager(this.transport);
        return List.of(new ServerInstanceManager(this::initializeServer), connectionManager, new StaticParameterResolver<BoltWire>(BoltWire.class, this.wire), new StaticParameterResolver<TransportType>(TransportType.class, this.transport), new HostnamePortParameterResolver(), new ConnectionProviderParameterResolver(connectionManager, this.wire), new TransportConnectionParameterResolver(connectionManager, this.wire));
    }

    private void initializeServer(ExtensionContext context, Neo4jWithSocket server) {
        TestDatabaseManagementServiceBuilder factory = this.createDatabaseFactory(context);
        Consumer<Map<Setting<?>, Object>> settingsFunction = this.createSettingsFunction(context);
        server.setGraphDatabaseFactory(factory);
        server.setConfigure(settingsFunction);
    }

    private TestDatabaseManagementServiceBuilder createDatabaseFactory(ExtensionContext context) {
        TestDatabaseManagementServiceBuilder factory;
        Constructor<? extends TestDatabaseManagementServiceBuilder> factoryConstructor;
        Class<? extends TestDatabaseManagementServiceBuilder> factoryType = this.databaseFactoryType;
        Method function = this.databaseFactoryFunction;
        if (function != null && function.getParameterCount() == 0) {
            MethodHandle handle = BoltTestConfig.unreflectDatabaseFactoryFunctionHandle(context, function);
            try {
                return handle.invoke();
            }
            catch (Throwable ex) {
                Assertions.fail((String)("Failed to invoke @FactoryFunction " + function.getName()), (Throwable)ex);
            }
        }
        try {
            factoryConstructor = factoryType.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            Assertions.fail((String)("Illegal database factory type " + factoryType.getName() + ": Missing default no-args constructor - Try creating a @FactoryFunction method instead"), (Throwable)ex);
            return null;
        }
        try {
            factory = factoryConstructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Assertions.fail((String)("Illegal database factory type " + factoryType.getName() + ": Inaccessible default no-args constructor - Try creationg a @FactoryFunction method instead"), (Throwable)ex);
            return null;
        }
        catch (InstantiationException | InvocationTargetException ex) {
            Assertions.fail((String)("Failed to instantiate database factory type " + factoryType.getName()), (Throwable)ex);
            return null;
        }
        if (function != null) {
            Class<?> expectedFactoryType = function.getParameterTypes()[0];
            if (!expectedFactoryType.isInstance(factory)) {
                Assertions.fail((String)("Failed to invoke @FactoryFunction " + function.getName() + ": Expected factory of type " + expectedFactoryType.getName() + " but got " + factory.getClass().getName()));
            }
            MethodHandle handle = BoltTestConfig.unreflectDatabaseFactoryFunctionHandle(context, function);
            try {
                handle.invoke(factory);
            }
            catch (Throwable ex) {
                Assertions.fail((String)("Failed to invoke @FactoryFunction " + function.getName()), (Throwable)ex);
            }
        }
        return factory;
    }

    private Consumer<Map<Setting<?>, Object>> createSettingsFunction(ExtensionContext context) {
        Consumer<Map<Setting<?>, Object>> baseFunction = this.createDefaultSettingsFunction(context);
        Method function = this.databaseSettingsFunction;
        if (function == null) {
            return this.createDefaultSettingsFunction(context);
        }
        MethodHandle handle = BoltTestConfig.unreflectDatabaseFactoryFunctionHandle(context, function);
        return baseFunction.andThen(settings -> {
            try {
                handle.invoke((Map)settings);
            }
            catch (Throwable ex) {
                Assertions.fail((String)"Failed to invoke settings function", (Throwable)ex);
            }
        });
    }

    private Consumer<Map<Setting<?>, Object>> createDefaultSettingsFunction(ExtensionContext context) {
        return settings -> {
            settings.put(BoltConnector.enabled, true);
            settings.put(BoltConnector.encryption_level, BoltConnector.EncryptionLevel.OPTIONAL);
        };
    }

    private static MethodHandle unreflectDatabaseFactoryFunctionHandle(ExtensionContext context, Method function) {
        MethodHandle handle;
        function.setAccessible(true);
        try {
            handle = MethodHandles.lookup().unreflect(function);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Cannot access @FactoryFunction " + function.getName(), ex);
        }
        if (Modifier.isStatic(function.getModifiers())) {
            return handle;
        }
        Object instance = context.getRequiredTestInstance();
        return handle.bindTo(instance);
    }
}

