/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;

public final class AnnotationUtil {
    private AnnotationUtil() {
    }

    public static <A extends Annotation> Optional<A> findAnnotation(ExtensionContext context, Class<A> annotationType) {
        return context.getTestMethod().flatMap(method -> AnnotationSupport.findAnnotation((AnnotatedElement)method, (Class)annotationType)).or(() -> context.getTestClass().flatMap(clazz -> AnnotationSupport.findAnnotation((AnnotatedElement)clazz, (Class)annotationType)));
    }

    public static <A extends Annotation> List<A> findAnnotations(ExtensionContext context, Class<A> annotationType) {
        ArrayList results = new ArrayList();
        context.getTestClass().map(clazz -> AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)clazz, (Class)annotationType)).ifPresent(results::addAll);
        context.getTestMethod().map(method -> AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)method, (Class)annotationType)).ifPresent(results::addAll);
        return results;
    }

    private static <T> T instantiateProvider(Class<? extends T> type) {
        Constructor<T> constructor;
        try {
            constructor = type.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException("Invalid provider implementation " + type.getName() + ": Missing default no-args constructor", ex);
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Invalid provider implementation " + type.getName() + ": Inaccessible no-args constructor", ex);
        }
        catch (InstantiationException | InvocationTargetException ex) {
            throw new IllegalStateException("Failed to instantiate provider implementation " + type.getName(), ex);
        }
    }

    private static <A extends Annotation, T> T instantiateProvider(A annotation, Function<A, Class<? extends T>> typeParameter) {
        return AnnotationUtil.instantiateProvider(typeParameter.apply(annotation));
    }

    public static <A extends Annotation, T> Optional<T> selectProvider(ExtensionContext context, Class<A> annotationType, Function<A, Class<? extends T>> typeParameter) {
        return AnnotationUtil.findAnnotation(context, annotationType).map(annotation -> AnnotationUtil.instantiateProvider(annotation, typeParameter));
    }

    public static <A extends Annotation, T> Optional<T> selectProvider(AnnotatedElement element, Class<A> annotationType, Function<A, Class<? extends T>> typeParameter) {
        return AnnotationSupport.findAnnotation((AnnotatedElement)element, annotationType).map(annotation -> AnnotationUtil.instantiateProvider(annotation, typeParameter));
    }

    public static <A extends Annotation, T> List<T> selectProviders(ExtensionContext context, Class<A> annotationType, Function<A, Class<? extends T>> typeParameter, boolean distinct) {
        Stream<Class> stream = AnnotationUtil.findAnnotations(context, annotationType).stream().map(typeParameter::apply);
        if (distinct) {
            stream = stream.distinct();
        }
        return stream.map(AnnotationUtil::instantiateProvider).toList();
    }

    public static <A extends Annotation, T> List<T> selectProviders(AnnotatedElement element, Class<A> annotationType, Function<A, Class<? extends T>> typeParameter, boolean distinct) {
        Stream<Class> stream = AnnotationSupport.findRepeatableAnnotations((AnnotatedElement)element, annotationType).stream().map(typeParameter::apply);
        if (distinct) {
            stream = stream.distinct();
        }
        return stream.map(AnnotationUtil::instantiateProvider).toList();
    }
}

