/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.authentication;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.TestInstance;
import org.neo4j.bolt.protocol.common.connector.connection.AtomicSchedulingConnection;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Negotiated;
import org.neo4j.bolt.test.annotation.setup.FactoryFunction;
import org.neo4j.bolt.test.annotation.setup.SettingsFunction;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.selector.ExcludeWire;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogAssertions;
import org.neo4j.logging.LogProvider;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.conditions.Conditions;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.VirtualValues;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
@ExcludeWire(value={@Version(major=4), @Version(major=5, minor=0)})
public class AuthenticationIT {
    protected final AssertableLogProvider userLogProvider = new AssertableLogProvider();

    @FactoryFunction
    protected void customizeDatabase(TestDatabaseManagementServiceBuilder factory) {
        factory.setUserLogProvider((LogProvider)this.userLogProvider);
    }

    @SettingsFunction
    protected void customizeSettings(Map<Setting<?>, Object> settings) {
        settings.put(GraphDatabaseSettings.auth_enabled, true);
    }

    @AfterEach
    void cleanup() {
        this.userLogProvider.clear();
    }

    private static MapValue singletonMap(String key, Object value) {
        return VirtualValues.map((String[])new String[]{key}, (AnyValue[])new AnyValue[]{ValueUtils.of((Object)value)});
    }

    @ProtocolTest
    void shouldRespondWithCredentialsExpiredOnFirstUse(BoltWire wire, @Negotiated TransportConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"credentials_expired", (Object)true));
    }

    @ProtocolTest
    void shouldFailIfWrongCredentials(BoltWire wire, @Negotiated TransportConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "wrong")));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure((Status)Status.Security.Unauthorized, "The client is unauthorized due to authentication failure.").isEventuallyTerminated();
        Assert.assertEventually(() -> "Matching log call not found in\n" + this.userLogProvider.serialize(), () -> {
            try {
                LogAssertions.assertThat((AssertableLogProvider)this.userLogProvider).forClass(AtomicSchedulingConnection.class).forLevel(AssertableLogProvider.Level.WARN).containsMessages(new String[]{"The client is unauthorized due to authentication failure."});
                return true;
            }
            catch (AssertionError e) {
                return false;
            }
        }, (Condition)Conditions.TRUE, (long)30L, (TimeUnit)TimeUnit.SECONDS);
    }

    @ProtocolTest
    void shouldFailIfWrongCredentialsFollowingSuccessfulLogin(BoltWire wire, @Negotiated TransportConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.send(wire.run("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", AuthenticationIT.singletonMap("password", "secretPassword"), AuthenticationIT.singletonMap("db", "system")));
        connection.send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(2);
        connection.reconnect();
        wire.negotiate(connection);
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "secretPassword")));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.reconnect();
        wire.negotiate(connection);
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure((Status)Status.Security.Unauthorized, "The client is unauthorized due to authentication failure.").isEventuallyTerminated();
    }

    @ProtocolTest
    void shouldFailIfMalformedAuthTokenWrongType(BoltWire wire, @Negotiated TransportConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", List.of("neo4j"), "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailureFuzzy((Status)Status.Security.Unauthorized, "Unsupported authentication token, the value associated with the key `principal` must be a String but was: ArrayList").isEventuallyTerminated();
    }

    @ProtocolTest
    void shouldFailIfMalformedAuthTokenMissingKey(BoltWire wire, @Negotiated TransportConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "this-should-have-been-credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailureFuzzy((Status)Status.Security.Unauthorized, "Unsupported authentication token, missing key `credentials`").isEventuallyTerminated();
    }

    @ProtocolTest
    void shouldFailIfMalformedAuthTokenMissingScheme(BoltWire wire, @Negotiated TransportConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailureFuzzy((Status)Status.Security.Unauthorized, "Unsupported authentication token, missing key `scheme`").isEventuallyTerminated();
    }

    @ProtocolTest
    protected void shouldFailIfMalformedAuthTokenUnknownScheme(BoltWire wire, @Negotiated TransportConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "unknown", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure((Status)Status.Security.Unauthorized, "Unsupported authentication token, scheme 'unknown' is not supported.").isEventuallyTerminated();
    }

    @ProtocolTest
    void shouldFailDifferentlyIfTooManyFailedAuthAttempts(BoltWire wire, TransportConnection connection) {
        Assert.awaitUntilAsserted(() -> {
            connection.reconnect();
            wire.negotiate(connection);
            connection.send(wire.hello());
            BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
            connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "WHAT_WAS_THE_PASSWORD_AGAIN")));
            BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure((Status)Status.Security.AuthenticationRateLimit, "The client has provided incorrect authentication details too many times in a row.").isEventuallyTerminated();
        });
    }

    @ProtocolTest
    void shouldFailWhenReusingTheSamePassword(BoltWire wire, @Negotiated TransportConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"credentials_expired", (Object)true));
        connection.send(wire.reset()).send(wire.run("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", AuthenticationIT.singletonMap("password", "password"), AuthenticationIT.singletonMap("db", "system"))).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(3);
        connection.send(wire.run("ALTER CURRENT USER SET PASSWORD FROM 'password' TO $password", AuthenticationIT.singletonMap("password", "password"), AuthenticationIT.singletonMap("db", "system"))).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailureFuzzy((Status)Status.Statement.ArgumentError, "Old password and new password cannot be the same.").receivesIgnored();
        connection.send(wire.reset()).send(wire.run("ALTER CURRENT USER SET PASSWORD FROM 'password' TO $password", AuthenticationIT.singletonMap("password", "abcdefgh"), AuthenticationIT.singletonMap("db", "system"))).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(3);
    }

    @ProtocolTest
    void shouldFailWhenSubmittingEmptyPassword(BoltWire wire, @Negotiated TransportConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"credentials_expired", (Object)true));
        connection.send(wire.run("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", AuthenticationIT.singletonMap("password", ""), AuthenticationIT.singletonMap("db", "system"))).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailure((Status)Status.Statement.ArgumentError, "A password cannot be empty.").receivesIgnored();
        connection.send(wire.reset()).send(wire.run("ALTER CURRENT USER SET PASSWORD FROM 'neo4j' TO $password", AuthenticationIT.singletonMap("password", "abcdefgh"), AuthenticationIT.singletonMap("db", "system"))).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(3);
    }

    @ProtocolTest
    void shouldNotBeAbleToReadWhenPasswordChangeRequired(BoltWire wire, @Negotiated TransportConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsEntry((Object)"credentials_expired", (Object)true));
        connection.send(wire.run("MATCH (n) RETURN n")).send(wire.pull());
        try {
            BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailureFuzzy((Status)Status.Security.CredentialsExpired, "The credentials you provided were valid, but must be changed before you can use this instance.");
        }
        catch (AssertionError ignore) {
            BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailureFuzzy((Status)Status.Security.CredentialsExpired, "The credentials you provided were valid, but must be changed before you can use this instance.");
        }
    }

    @ProtocolTest
    void shouldBeAbleToLogoffAfterBeingAuthenticatedThenLogBackOn(BoltWire wire, @Negotiated TransportConnection connection) throws IOException {
        connection.send(wire.hello());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).containsKeys((Object[])new String[]{"server", "connection_id"}));
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.send(wire.logoff());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.send(wire.logon(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
    }

    @ProtocolTest
    void shouldBeNotBeAbleToAuthenticateOnHelloMessage(BoltWire wire, @Negotiated TransportConnection connection) throws IOException {
        connection.send(wire.hello(Map.of("scheme", "basic", "principal", "neo4j", "credentials", "neo4j")));
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
        connection.send(wire.begin());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesFailureFuzzy((Status)Status.Request.Invalid, "Message 'org.neo4j.bolt.protocol.v50.message.request.BeginMessage@782' cannot be handled by a session in the AUTHENTICATION state.");
    }
}

