/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm;

import org.assertj.core.api.Assertions;
import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.v51.fsm.AuthenticationState;
import org.neo4j.bolt.protocol.v51.fsm.ReadyState;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.BoltProtocolBreachFatality;
import org.neo4j.bolt.test.annotation.CommunityStateMachineTestExtension;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.annotation.fsm.StateMachineTest;
import org.neo4j.bolt.testing.assertions.ResponseRecorderAssertions;
import org.neo4j.bolt.testing.assertions.StateMachineAssertions;
import org.neo4j.bolt.testing.messages.BoltMessages;
import org.neo4j.bolt.testing.response.ResponseRecorder;

@CommunityStateMachineTestExtension
public class AuthenticationStateIT {
    @StateMachineTest(since={@Version(major=5, minor=1)})
    public void shouldAcceptLogonMessageAndMoveToReadyState(StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws BoltConnectionFatality {
        fsm.process(messages.hello(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(AuthenticationState.class);
        fsm.process(messages.logon(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(ReadyState.class);
    }

    @StateMachineTest(since={@Version(major=5, minor=1)})
    public void shouldNotAcceptABeginMessageAndError(StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws BoltConnectionFatality {
        fsm.process(messages.hello(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(AuthenticationState.class);
        BoltProtocolBreachFatality e = (BoltProtocolBreachFatality)org.junit.jupiter.api.Assertions.assertThrows(BoltProtocolBreachFatality.class, () -> fsm.process(messages.begin(), (ResponseHandler)recorder));
        Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"BeginMessage@782' cannot be handled by a session in the AUTHENTICATION state."});
    }
}

