/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm;

import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.common.message.request.RequestMessage;
import org.neo4j.bolt.protocol.v40.fsm.InterruptedState;
import org.neo4j.bolt.protocol.v40.fsm.ReadyState;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.test.annotation.CommunityStateMachineTestExtension;
import org.neo4j.bolt.testing.annotation.fsm.StateMachineTest;
import org.neo4j.bolt.testing.annotation.fsm.initializer.Autocommit;
import org.neo4j.bolt.testing.assertions.MapValueAssertions;
import org.neo4j.bolt.testing.assertions.ResponseRecorderAssertions;
import org.neo4j.bolt.testing.assertions.StateMachineAssertions;
import org.neo4j.bolt.testing.messages.BoltMessages;
import org.neo4j.bolt.testing.response.ResponseRecorder;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

@CommunityStateMachineTestExtension
class AutoCommitStateIT {
    AutoCommitStateIT() {
    }

    @StateMachineTest
    void shouldMoveFromAutoCommitToReadyOnPullWhenSingleResultIsReturned(@Autocommit StateMachine fsm, ResponseRecorder recorder, BoltMessages messages) throws Throwable {
        fsm.process(messages.pull(1L), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasRecord().hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsKey("type").containsKey("t_last").containsKey("bookmark").containsKey("db"));
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(ReadyState.class);
    }

    @StateMachineTest
    void shouldMoveFromAutoCommitToReadyOnPullWhenMultiplyResultsAreReturned(@Autocommit(value="UNWIND [1, 2, 3] AS n RETURN n") StateMachine fsm, ResponseRecorder recorder, BoltMessages messages) throws Throwable {
        fsm.process(messages.pull(2L), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasRecord(new AnyValue[]{Values.longValue((long)1L)}).hasRecord(new AnyValue[]{Values.longValue((long)2L)}).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsEntry("has_more", (AnyValue)BooleanValue.TRUE).doesNotContainKey("db").doesNotContainKey("bookmark"));
        fsm.process(messages.pull(2L), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasRecord(new AnyValue[]{Values.longValue((long)3L)}).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsKey("type").containsKey("t_last").containsKey("bookmark").containsKey("db"));
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(ReadyState.class);
    }

    @StateMachineTest
    void shouldMoveFromAutoCommitToReadyOnDiscardAllWhenSingleResultIsReturned(@Autocommit StateMachine fsm, ResponseRecorder recorder, BoltMessages messages) throws Throwable {
        fsm.process(messages.discard(1L), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsKey("bookmark").containsKey("db"));
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(ReadyState.class);
    }

    @StateMachineTest
    void shouldMoveFromAutoCommitToReadyOnDiscardAllWhenMultipleResultsAreReturned(@Autocommit(value="UNWIND [1, 2, 3] AS n RETURN n") StateMachine fsm, ResponseRecorder recorder, BoltMessages messages) throws Throwable {
        fsm.process(messages.discard(2L), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsEntry("has_more", (AnyValue)BooleanValue.TRUE).doesNotContainKey("db").doesNotContainKey("bookmark"));
        fsm.process(messages.discard(2L), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsKey("type").containsKey("t_last").containsKey("bookmark").containsKey("db"));
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(ReadyState.class);
    }

    @StateMachineTest
    void shouldMoveFromAutoCommitToInterruptedOnInterrupt(@Autocommit StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws BoltConnectionFatality {
        fsm.connection().interrupt();
        fsm.process(messages.run("RETURN 1"), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasIgnoredResponse();
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(InterruptedState.class);
    }

    @StateMachineTest
    void shouldCloseConnectionInAutoCommitOnHello(@Autocommit StateMachine fsm, ResponseRecorder recorder, BoltMessages messages) {
        this.shouldCloseConnectionInAutoCommitOnMessage(fsm, recorder, messages.hello());
    }

    @StateMachineTest
    void shouldCloseConnectionInAutoCommitOnRun(@Autocommit StateMachine fsm, ResponseRecorder recorder, BoltMessages messages) {
        this.shouldCloseConnectionInAutoCommitOnMessage(fsm, recorder, messages.run("RETURN 1"));
    }

    @StateMachineTest
    void shouldCloseConnectionInAutoCommitOnBegin(@Autocommit StateMachine fsm, ResponseRecorder recorder, BoltMessages messages) {
        this.shouldCloseConnectionInAutoCommitOnMessage(fsm, recorder, messages.begin());
    }

    @StateMachineTest
    void shouldCloseConnectionInAutoCommitOnCommit(@Autocommit StateMachine fsm, ResponseRecorder recorder, BoltMessages messages) {
        this.shouldCloseConnectionInAutoCommitOnMessage(fsm, recorder, messages.commit());
    }

    @StateMachineTest
    void shouldCloseConnectionInAutoCommitOnRollback(@Autocommit StateMachine fsm, ResponseRecorder recorder, BoltMessages messages) {
        this.shouldCloseConnectionInAutoCommitOnMessage(fsm, recorder, messages.rollback());
    }

    @StateMachineTest
    void shouldCloseConnectionInAutoCommitOnReset(@Autocommit StateMachine fsm, ResponseRecorder recorder, BoltMessages messages) {
        this.shouldCloseConnectionInAutoCommitOnMessage(fsm, recorder, messages.reset());
    }

    @StateMachineTest
    void shouldCloseConnectionInAutoCommitOnGoodbye(@Autocommit StateMachine fsm, ResponseRecorder recorder, BoltMessages messages) {
        this.shouldCloseConnectionInAutoCommitOnMessage(fsm, recorder, messages.goodbye());
    }

    private void shouldCloseConnectionInAutoCommitOnMessage(StateMachine fsm, ResponseRecorder recorder, RequestMessage message) {
        StateMachineAssertions.assertThat((StateMachine)fsm).shouldKillConnection(it -> it.process(message, (ResponseHandler)recorder)).isInInvalidState();
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.Request.Invalid);
    }
}

