/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.extension.resolver.connection;

import java.io.IOException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.neo4j.bolt.test.extension.lifecycle.TransportConnectionManager;
import org.neo4j.bolt.test.extension.resolver.connection.AbstractConnectionInitializingParameterResolver;
import org.neo4j.bolt.test.provider.ConnectionProvider;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.internal.helpers.HostnamePort;

public class ConnectionProviderParameterResolver
extends AbstractConnectionInitializingParameterResolver<IOException> {
    public ConnectionProviderParameterResolver(TransportConnectionManager connectionManager, BoltWire wire) {
        super(connectionManager, wire);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType().isAssignableFrom(ConnectionProvider.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return () -> this.acquireConnection(extensionContext, parameterContext);
    }

    @Override
    protected void fail(HostnamePort address, Throwable cause) throws IOException {
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        throw new IOException("Failed to establish connection to " + address, cause);
    }
}

