/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import org.junit.jupiter.api.BeforeEach;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.setup.SettingsFunction;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.test.annotation.wire.selector.ExcludeWire;
import org.neo4j.bolt.test.annotation.wire.selector.IncludeWire;
import org.neo4j.bolt.test.util.ServerUtil;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.EphemeralTestDirectoryExtension;

@EphemeralTestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class KeepAliveIT {
    @Inject
    private Neo4jWithSocket server;

    @SettingsFunction
    static void customizeSettings(Map<Setting<?>, Object> settings) {
        settings.put(BoltConnector.connection_keep_alive, Duration.ofMillis(20L));
        settings.put(BoltConnector.connection_keep_alive_streaming_scheduling_interval, Duration.ofMillis(10L));
    }

    @BeforeEach
    void prepare() throws ProcedureException {
        ServerUtil.installSleepProcedure(this.server);
    }

    @ProtocolTest
    @ExcludeWire(value={@Version(major=4, minor=2, range=2)})
    void shouldSendNoOpForLongRunningTx(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        connection.send(wire.run("CALL boltissue.sleep(100)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().hasReceivedNoopChunks().receivesSuccess();
    }

    @ProtocolTest
    @IncludeWire(value={@Version(major=4, minor=0)})
    void shouldNotSendNoOpForLongRunningTxInLegacyVersions(BoltWire wire, @Authenticated TransportConnection connection) throws IOException {
        connection.send(wire.run("CALL boltissue.sleep(100)")).send(wire.pull());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().hasReceivedNoopChunks(0L).receivesSuccess();
    }
}

