/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm;

import java.util.Map;
import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.test.annotation.CommunityStateMachineTestExtension;
import org.neo4j.bolt.test.annotation.setup.SettingsFunction;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.annotation.fsm.StateMachineTest;
import org.neo4j.bolt.testing.assertions.MapValueAssertions;
import org.neo4j.bolt.testing.assertions.ResponseRecorderAssertions;
import org.neo4j.bolt.testing.assertions.StateMachineAssertions;
import org.neo4j.bolt.testing.messages.BoltMessages;
import org.neo4j.bolt.testing.response.ResponseRecorder;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

@CommunityStateMachineTestExtension
class ConnectedStateAuthenticationIT {
    ConnectedStateAuthenticationIT() {
    }

    @SettingsFunction
    static void customizeSettings(Map<Setting<?>, Object> settings) {
        settings.put(GraphDatabaseSettings.auth_enabled, true);
    }

    @StateMachineTest(until=@Version(major=5, minor=1))
    void shouldGiveCredentialsExpiredStatusOnExpiredCredentials(StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws Throwable {
        fsm.process(messages.hello("neo4j", "neo4j"), (ResponseHandler)recorder);
        fsm.process(messages.run("CREATE ()"), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsEntry("credentials_expired", (AnyValue)Values.TRUE)).hasFailureResponse((Status)Status.Security.CredentialsExpired);
    }

    @StateMachineTest(until=@Version(major=5, minor=1))
    void shouldGiveKernelVersionOnInit(StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws Throwable {
        String version = "Neo4j/" + org.neo4j.kernel.internal.Version.getNeo4jVersion();
        fsm.process(messages.hello("neo4j", "neo4j"), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).extractingEntry("server").isEqualTo(version));
    }

    @StateMachineTest(until=@Version(major=5, minor=1))
    void shouldCloseConnectionAfterAuthenticationFailure(StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws Throwable {
        StateMachineAssertions.assertThat((StateMachine)fsm).shouldKillConnection(it -> it.process(messages.hello("neo4j", "j4oen"), (ResponseHandler)recorder));
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasFailureResponse((Status)Status.Security.Unauthorized);
    }
}

