/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm;

import org.neo4j.bolt.protocol.common.fsm.StateMachine;
import org.neo4j.bolt.protocol.common.fsm.response.ResponseHandler;
import org.neo4j.bolt.protocol.v51.fsm.state.AuthenticationState;
import org.neo4j.bolt.test.annotation.CommunityStateMachineTestExtension;
import org.neo4j.bolt.testing.annotation.Version;
import org.neo4j.bolt.testing.annotation.fsm.StateMachineTest;
import org.neo4j.bolt.testing.assertions.MapValueAssertions;
import org.neo4j.bolt.testing.assertions.ResponseRecorderAssertions;
import org.neo4j.bolt.testing.assertions.StateMachineAssertions;
import org.neo4j.bolt.testing.messages.BoltMessages;
import org.neo4j.bolt.testing.response.ResponseRecorder;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

@CommunityStateMachineTestExtension
public class NegotiationStateIT {
    @StateMachineTest(since=@Version(major=5, minor=1))
    void shouldHandleHelloMessageAndMoveToAuthenticatedState(StateMachine fsm, BoltMessages messages, ResponseRecorder recorder) throws Throwable {
        fsm.process(messages.hello(), (ResponseHandler)recorder);
        ResponseRecorderAssertions.assertThat((ResponseRecorder)recorder).hasSuccessResponse(meta -> MapValueAssertions.assertThat((MapValue)meta).containsEntry("server", (AnyValue)Values.stringValue((String)("Neo4j/" + org.neo4j.kernel.internal.Version.getNeo4jVersion()))).containsEntry("connection_id", (AnyValue)Values.stringValue((String)"bolt-test")));
        StateMachineAssertions.assertThat((StateMachine)fsm).isInState(AuthenticationState.class);
    }
}

