/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.test.connection.initializer;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.neo4j.bolt.protocol.common.connector.connection.Feature;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.connection.initializer.ConnectionInitializer;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.testing.messages.HelloBuilder;

public final class AuthenticateConnectionInitializer
implements ConnectionInitializer {
    @Override
    public void initialize(ExtensionContext extensionContext, ParameterContext context, BoltWire wire, TransportConnection connection) throws ParameterResolutionException {
        ByteBuf command = this.getCommand(context, wire);
        try {
            if (wire.supportsLogonMessage()) {
                connection.send(wire.hello());
            } else {
                connection.send(command);
            }
            if (wire.getEnabledFeatures().isEmpty()) {
                BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
            } else {
                BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess(meta -> Assertions.assertThat((Map)meta).hasEntrySatisfying((Object)"patch_bolt", features -> ((ListAssert)Assertions.assertThat((Object)features).asInstanceOf(InstanceOfAssertFactories.list(String.class))).containsAll((Iterable)wire.getEnabledFeatures().stream().map(Feature::getId).collect(Collectors.toSet()))));
            }
            if (wire.supportsLogonMessage()) {
                connection.send(command);
                BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess();
            }
        }
        catch (IOException | AssertionError ex) {
            throw new ParameterResolutionException("Failed to authenticate connection", (Throwable)ex);
        }
    }

    private ByteBuf getCommand(ParameterContext context, BoltWire wire) {
        return context.findAnnotation(Authenticated.class).flatMap(annotation -> this.getCommand((Authenticated)annotation, wire)).orElseGet(() -> wire.supportsLogonMessage() ? wire.logon() : wire.hello());
    }

    private Optional<ByteBuf> getCommand(Authenticated annotation, BoltWire wire) {
        if (annotation.principal().isEmpty()) {
            return Optional.empty();
        }
        if (wire.supportsLogonMessage()) {
            return Optional.of(wire.logon(annotation.principal(), annotation.credentials()));
        }
        return Optional.of(wire.hello(x -> (HelloBuilder)x.withBasicAuth(annotation.principal(), annotation.credentials())));
    }
}

