/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.tx;

import org.junit.jupiter.api.Timeout;
import org.neo4j.bolt.test.annotation.BoltTestExtension;
import org.neo4j.bolt.test.annotation.connection.initializer.Authenticated;
import org.neo4j.bolt.test.annotation.test.ProtocolTest;
import org.neo4j.bolt.testing.assertions.BoltConnectionAssertions;
import org.neo4j.bolt.testing.client.TransportConnection;
import org.neo4j.bolt.testing.messages.BoltWire;
import org.neo4j.bolt.transport.Neo4jWithSocket;
import org.neo4j.bolt.transport.Neo4jWithSocketExtension;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;

@TestDirectoryExtension
@Neo4jWithSocketExtension
@BoltTestExtension
public class TransactionTerminationIT {
    @Inject
    private Neo4jWithSocket server;

    private void awaitTransactionStart() throws InterruptedException {
        long txCount = 1L;
        while (txCount <= 1L) {
            try (Transaction tx = this.server.graphDatabaseService().beginTx();){
                Result result = tx.execute("SHOW TRANSACTIONS");
                txCount = result.stream().toList().size();
            }
            Thread.sleep(100L);
        }
    }

    @Timeout(value=15L)
    @ProtocolTest
    void killTxViaReset(BoltWire wire, @Authenticated TransportConnection connection) throws Exception {
        connection.send(wire.begin()).send(wire.run("UNWIND range(1, 2000000) AS i CREATE (n)"));
        this.awaitTransactionStart();
        connection.send(wire.reset());
        BoltConnectionAssertions.assertThat((TransportConnection)connection).receivesSuccess().receivesFailure(new Status[]{Status.Transaction.Terminated, Status.Transaction.LockClientStopped}).receivesSuccess();
    }
}

