/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParser;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.SettingsDeclaration;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.server.helpers.CommunityWebContainerBuilder;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.test.Race;

public class ConfigurationIT {
    @Test
    void shouldNotDeadlockWhenConcurrentlyAccessingSettings() {
        Race race = new Race();
        race.addContestant(() -> GraphDatabaseSettings.neo4j_home.defaultValue(), 1);
        race.addContestant(() -> HttpConnector.advertised_address.defaultValue(), 1);
        Assertions.assertThatCode(() -> race.go(1L, TimeUnit.MINUTES)).doesNotThrowAnyException();
    }

    @Test
    void shouldBeAbleToEvaluateSettingFromWebServer() throws IOException {
        Assumptions.assumeTrue((boolean)ConfigurationIT.curlAvailable(), (String)"Curl required");
        TestWebContainer testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().build();
        try {
            Config config = Config.newBuilder().allowCommandExpansion().addSettingsClass(TestSettings.class).setRaw(Map.of(TestSettings.stringSetting.name(), "$(curl -I '" + String.valueOf(testWebContainer.getBaseUri()) + "')")).build();
            Assertions.assertThat((String)((String)config.get(TestSettings.stringSetting))).contains(new CharSequence[]{"200 OK"});
        }
        finally {
            testWebContainer.shutdown();
        }
    }

    private static boolean curlAvailable() {
        try {
            Process process = Runtime.getRuntime().exec("curl --help");
            if (process.waitFor(10L, TimeUnit.SECONDS)) {
                return process.exitValue() == 0;
            }
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        return false;
    }

    private static final class TestSettings
    implements SettingsDeclaration {
        static final Setting<String> stringSetting = SettingImpl.newBuilder((String)"db.test.setting.string", (SettingValueParser)SettingValueParsers.STRING, (Object)"").build();

        private TestSettings() {
        }
    }
}

