/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.PageList;
import org.neo4j.io.pagecache.impl.muninn.StubPinPageFaultEvent;
import org.neo4j.io.pagecache.impl.muninn.SwapperSet;
import org.neo4j.io.pagecache.impl.muninn.VictimPageReference;
import org.neo4j.io.pagecache.tracing.DummyPageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.EvictionEventOpportunity;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.PageReferenceTranslator;
import org.neo4j.io.pagecache.tracing.PinPageFaultEvent;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.test.scheduler.DaemonThreadFactory;
import org.neo4j.util.concurrent.Futures;

public class AbstractPageListTest {
    private static final int ALIGNMENT = 8;
    protected static final Duration TIMEOUT = Duration.ofMinutes(1L);
    private static final int[] pageIds = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
    private static final DummyPageSwapper DUMMY_SWAPPER = new DummyPageSwapper("", UnsafeUtil.pageSize());
    protected ExecutorService executor;
    private MemoryAllocator mman;
    private int prevPageId;
    private int nextPageId;
    protected long pageRef;
    private long prevPageRef;
    private long nextPageRef;
    private int pageSize;
    private SwapperSet swappers;
    private PageList pageList;
    protected boolean multiVersioned;

    private static Stream<Arguments> argumentsProvider() {
        IntFunction<Arguments> toArguments = xva$0 -> Arguments.of((Object[])new Object[]{xva$0});
        return Arrays.stream(pageIds).mapToObj(toArguments);
    }

    @BeforeEach
    void setUpAbstract() {
        this.executor = Executors.newCachedThreadPool((ThreadFactory)new DaemonThreadFactory());
        this.mman = MemoryAllocator.createAllocator((long)ByteUnit.MebiByte.toBytes(1L), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    @AfterEach
    void tearDownAbstract() {
        this.mman.close();
        this.mman = null;
        this.executor.shutdown();
        this.executor = null;
    }

    protected void init(int pageId) {
        this.prevPageId = pageId == 0 ? pageIds.length - 1 : (pageId - 1) % pageIds.length;
        this.nextPageId = (pageId + 1) % pageIds.length;
        this.pageSize = UnsafeUtil.pageSize();
        this.swappers = new SwapperSet();
        long victimPage = VictimPageReference.getVictimPage((int)this.pageSize, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        this.pageList = new PageList(pageIds.length, this.pageSize, this.mman, this.swappers, victimPage, 8L);
        this.pageRef = this.pageList.deref(pageId);
        this.prevPageRef = this.pageList.deref(this.prevPageId);
        this.nextPageRef = this.pageList.deref(this.nextPageId);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void mustExposePageCount(int pageId) {
        this.init(pageId);
        long victimPage = VictimPageReference.getVictimPage((int)this.pageSize, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        int pageCount = 3;
        Assertions.assertThat((int)new PageList(pageCount, this.pageSize, this.mman, this.swappers, victimPage, 8L).getPageCount()).isEqualTo(pageCount);
        pageCount = 42;
        Assertions.assertThat((int)new PageList(pageCount, this.pageSize, this.mman, this.swappers, victimPage, 8L).getPageCount()).isEqualTo(pageCount);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void mustBeAbleToReversePageRedToPageId(int pageId) {
        this.init(pageId);
        Assertions.assertThat((int)this.pageList.toId(this.pageRef)).isEqualTo(pageId);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void pagesAreInitiallyExclusivelyLocked(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isExclusivelyLocked((long)this.pageRef));
        PageList.unlockExclusive((long)this.pageRef);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void uncontendedOptimisticLockMustValidate(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        long stamp = PageList.tryOptimisticReadLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.pageRef, (long)stamp));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void mustNotValidateRandomStamp(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.validateReadLock((long)this.pageRef, (long)4242L));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void writeLockMustInvalidateOptimisticReadLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        long r = PageList.tryOptimisticReadLock((long)this.pageRef);
        PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned);
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void takingWriteLockMustInvalidateOptimisticReadLock(int pageId) {
        this.init(pageId);
        long r = PageList.tryOptimisticReadLock((long)this.pageRef);
        PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void optimisticReadLockMustNotValidateUnderWriteLock(int pageId) {
        this.init(pageId);
        PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned);
        long r = PageList.tryOptimisticReadLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void writeLockReleaseMustInvalidateOptimisticReadLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned);
        long r = PageList.tryOptimisticReadLock((long)this.pageRef);
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void uncontendedWriteLockMustBeAvailable(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void uncontendedOptimisticReadLockMustValidateAfterWriteLockRelease(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned);
        PageList.unlockWrite((long)this.pageRef);
        long r = PageList.tryOptimisticReadLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unmatchedUnlockWriteLockMustThrow(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalMonitorStateException.class, () -> PageList.unlockWrite((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void exclusiveLockMustInvalidateOptimisticLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        long r = PageList.tryOptimisticReadLock((long)this.pageRef);
        PageList.tryExclusiveLock((long)this.pageRef);
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void takingExclusiveLockMustInvalidateOptimisticLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        long r = PageList.tryOptimisticReadLock((long)this.pageRef);
        PageList.tryExclusiveLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void optimisticReadLockMustNotValidateUnderExclusiveLock(int pageId) {
        this.init(pageId);
        long r = PageList.tryOptimisticReadLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void exclusiveLockReleaseMustInvalidateOptimisticReadLock(int pageId) {
        this.init(pageId);
        long r = PageList.tryOptimisticReadLock((long)this.pageRef);
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void uncontendedOptimisticReadLockMustValidateAfterExclusiveLockRelease(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.tryExclusiveLock((long)this.pageRef);
        PageList.unlockExclusive((long)this.pageRef);
        long r = PageList.tryOptimisticReadLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void canTakeUncontendedExclusiveLocks(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void writeLocksMustFailExclusiveLocks(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.tryExclusiveLock((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void exclusiveLockMustBeAvailableAfterWriteLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned);
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void cannotTakeExclusiveLockIfAlreadyTaken(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.tryExclusiveLock((long)this.pageRef));
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.tryExclusiveLock((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void exclusiveLockMustBeAvailableAfterExclusiveLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.pageRef));
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void exclusiveLockMustFailWriteLocks(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)TIMEOUT, () -> org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned)));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unmatchedUnlockExclusiveLockMustThrow(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalMonitorStateException.class, () -> {
            PageList.unlockExclusive((long)this.pageRef);
            PageList.unlockExclusive((long)this.pageRef);
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unmatchedUnlockWriteAfterTakingExclusiveLockMustThrow(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalMonitorStateException.class, () -> {
            PageList.unlockExclusive((long)this.pageRef);
            PageList.tryExclusiveLock((long)this.pageRef);
            PageList.unlockWrite((long)this.pageRef);
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void writeLockMustBeAvailableAfterExclusiveLock(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)TIMEOUT, () -> {
            PageList.unlockExclusive((long)this.pageRef);
            PageList.tryExclusiveLock((long)this.pageRef);
            PageList.unlockExclusive((long)this.pageRef);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
            PageList.unlockWrite((long)this.pageRef);
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockExclusiveMustReturnStampForOptimisticReadLock(int pageId) {
        this.init(pageId);
        long r = PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockExclusiveAndTakeWriteLockMustInvalidateOptimisticReadLocks(int pageId) {
        this.init(pageId);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        long r = PageList.tryOptimisticReadLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockExclusiveAndTakeWriteLockMustPreventExclusiveLocks(int pageId) {
        this.init(pageId);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.tryExclusiveLock((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockExclusiveAndTakeWriteLockMustBeAtomic(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertTimeoutPreemptively((Duration)TIMEOUT, () -> {
            int threads = Runtime.getRuntime().availableProcessors() - 1;
            CountDownLatch start = new CountDownLatch(threads);
            AtomicBoolean stop = new AtomicBoolean();
            PageList.tryExclusiveLock((long)this.pageRef);
            Runnable runnable = () -> {
                while (!stop.get()) {
                    if (PageList.tryExclusiveLock((long)this.pageRef)) {
                        PageList.unlockExclusive((long)this.pageRef);
                        throw new RuntimeException("I should not have gotten that lock");
                    }
                    start.countDown();
                }
            };
            ArrayList futures = new ArrayList();
            for (int i = 0; i < threads; ++i) {
                futures.add(this.executor.submit(runnable));
            }
            start.await();
            PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
            stop.set(true);
            Futures.getAll(futures);
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void stampFromUnlockExclusiveMustNotBeValidIfThereAreWriteLocks(int pageId) {
        this.init(pageId);
        long r = PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void uncontendedFlushLockMustBeAvailable(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((PageList.tryFlushLock((long)this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void flushLockMustNotInvalidateOptimisticReadLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        long r = PageList.tryOptimisticReadLock((long)this.pageRef);
        long s = PageList.tryFlushLock((long)this.pageRef);
        PageList.unlockFlush((long)this.pageRef, (long)s, (boolean)true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void flushLockMustNotFailWriteLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.tryFlushLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void flushLockMustFailExclusiveLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.tryFlushLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.tryExclusiveLock((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void cannotTakeFlushLockIfAlreadyTaken(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((PageList.tryFlushLock((long)this.pageRef) != 0L ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertFalse((PageList.tryFlushLock((long)this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void writeLockMustNotFailFlushLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned);
        org.junit.jupiter.api.Assertions.assertTrue((PageList.tryFlushLock((long)this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void exclusiveLockMustFailFlushLock(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertFalse((PageList.tryFlushLock((long)this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockExclusiveAndTakeWriteLockMustNotFailFlushLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((PageList.tryFlushLock((long)this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void flushUnlockMustNotInvalidateOptimisticReadLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        long r = PageList.tryOptimisticReadLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((PageList.tryFlushLock((long)this.pageRef) != 0L ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void optimisticReadLockMustValidateUnderFlushLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.tryFlushLock((long)this.pageRef);
        long r = PageList.tryOptimisticReadLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void flushLockReleaseMustNotInvalidateOptimisticReadLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        long s = PageList.tryFlushLock((long)this.pageRef);
        long r = PageList.tryOptimisticReadLock((long)this.pageRef);
        PageList.unlockFlush((long)this.pageRef, (long)s, (boolean)true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unmatchedUnlockFlushMustThrow(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalMonitorStateException.class, () -> PageList.unlockFlush((long)this.pageRef, (long)PageList.tryOptimisticReadLock((long)this.pageRef), (boolean)true));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void uncontendedOptimisticReadLockMustBeAvailableAfterFlushLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        long s = PageList.tryFlushLock((long)this.pageRef);
        PageList.unlockFlush((long)this.pageRef, (long)s, (boolean)true);
        long r = PageList.tryOptimisticReadLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void uncontendedWriteLockMustBeAvailableAfterFlushLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        long s = PageList.tryFlushLock((long)this.pageRef);
        PageList.unlockFlush((long)this.pageRef, (long)s, (boolean)true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void uncontendedExclusiveLockMustBeAvailableAfterFlushLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        long s = PageList.tryFlushLock((long)this.pageRef);
        PageList.unlockFlush((long)this.pageRef, (long)s, (boolean)true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void uncontendedFlushLockMustBeAvailableAfterWriteLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned);
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((PageList.tryFlushLock((long)this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void uncontendedFlushLockMustBeAvailableAfterExclusiveLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.tryExclusiveLock((long)this.pageRef);
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((PageList.tryFlushLock((long)this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void uncontendedFlushLockMustBeAvailableAfterFlushLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        long s = PageList.tryFlushLock((long)this.pageRef);
        PageList.unlockFlush((long)this.pageRef, (long)s, (boolean)true);
        org.junit.jupiter.api.Assertions.assertTrue((PageList.tryFlushLock((long)this.pageRef) != 0L ? 1 : 0) != 0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void stampFromUnlockExclusiveMustBeValidUnderFlushLock(int pageId) {
        this.init(pageId);
        long r = PageList.unlockExclusive((long)this.pageRef);
        PageList.tryFlushLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void optimisticReadLockMustNotGetInterferenceFromAdjacentWriteLocks(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.prevPageRef);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.unlockExclusive((long)this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.prevPageRef, (boolean)this.multiVersioned));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.nextPageRef, (boolean)this.multiVersioned));
        long r = PageList.tryOptimisticReadLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
        PageList.unlockWrite((long)this.prevPageRef);
        PageList.unlockWrite((long)this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void optimisticReadLockMustNotGetInterferenceFromAdjacentExclusiveLocks(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.prevPageRef);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.unlockExclusive((long)this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.nextPageRef));
        long r = PageList.tryOptimisticReadLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
        PageList.unlockExclusive((long)this.prevPageRef);
        PageList.unlockExclusive((long)this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void optimisticReadLockMustNotGetInterferenceFromAdjacentExclusiveAndWriteLocks(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.prevPageRef);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.unlockExclusive((long)this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.nextPageRef));
        long r = PageList.tryOptimisticReadLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
        PageList.unlockExclusiveAndTakeWriteLock((long)this.prevPageRef);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
        PageList.unlockWrite((long)this.prevPageRef);
        PageList.unlockWrite((long)this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.pageRef, (long)r));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void writeLockMustNotGetInterferenceFromAdjacentExclusiveLocks(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.prevPageRef);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.unlockExclusive((long)this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.nextPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        PageList.unlockWrite((long)this.pageRef);
        PageList.unlockExclusive((long)this.prevPageRef);
        PageList.unlockExclusive((long)this.nextPageRef);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void flushLockMustNotGetInterferenceFromAdjacentExclusiveLocks(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.prevPageRef);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.unlockExclusive((long)this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.nextPageRef));
        long s = PageList.tryFlushLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((s != 0L ? 1 : 0) != 0);
        PageList.unlockFlush((long)this.pageRef, (long)s, (boolean)true);
        PageList.unlockExclusive((long)this.prevPageRef);
        PageList.unlockExclusive((long)this.nextPageRef);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void flushLockMustNotGetInterferenceFromAdjacentFlushLocks(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.prevPageRef);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.unlockExclusive((long)this.nextPageRef);
        long ps = PageList.tryFlushLock((long)this.prevPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((ps != 0L ? 1 : 0) != 0);
        long ns = PageList.tryFlushLock((long)this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((ns != 0L ? 1 : 0) != 0);
        long s = PageList.tryFlushLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((s != 0L ? 1 : 0) != 0);
        PageList.unlockFlush((long)this.pageRef, (long)s, (boolean)true);
        PageList.unlockFlush((long)this.prevPageRef, (long)ps, (boolean)true);
        PageList.unlockFlush((long)this.nextPageRef, (long)ns, (boolean)true);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void exclusiveLockMustNotGetInterferenceFromAdjacentExclusiveLocks(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.unlockExclusive((long)this.prevPageRef);
        PageList.unlockExclusive((long)this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.nextPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.pageRef));
        PageList.unlockExclusive((long)this.pageRef);
        PageList.unlockExclusive((long)this.prevPageRef);
        PageList.unlockExclusive((long)this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.nextPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void exclusiveLockMustNotGetInterferenceFromAdjacentWriteLocks(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.unlockExclusive((long)this.prevPageRef);
        PageList.unlockExclusive((long)this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.prevPageRef, (boolean)this.multiVersioned));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.nextPageRef, (boolean)this.multiVersioned));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.pageRef));
        PageList.unlockExclusive((long)this.pageRef);
        PageList.unlockWrite((long)this.prevPageRef);
        PageList.unlockWrite((long)this.nextPageRef);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void exclusiveLockMustNotGetInterferenceFromAdjacentExclusiveAndWriteLocks(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.prevPageRef);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.pageRef));
        PageList.unlockExclusive((long)this.pageRef);
        PageList.unlockWrite((long)this.prevPageRef);
        PageList.unlockWrite((long)this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.nextPageRef));
        PageList.unlockExclusiveAndTakeWriteLock((long)this.prevPageRef);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.nextPageRef);
        PageList.unlockWrite((long)this.prevPageRef);
        PageList.unlockWrite((long)this.nextPageRef);
        PageList.unlockExclusive((long)this.pageRef);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void exclusiveLockMustNotGetInterferenceFromAdjacentFlushLocks(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.prevPageRef);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.unlockExclusive((long)this.nextPageRef);
        long ps = PageList.tryFlushLock((long)this.prevPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((ps != 0L ? 1 : 0) != 0);
        long ns = PageList.tryFlushLock((long)this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((ns != 0L ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.pageRef));
        PageList.unlockExclusive((long)this.pageRef);
        PageList.unlockFlush((long)this.prevPageRef, (long)ps, (boolean)true);
        PageList.unlockFlush((long)this.nextPageRef, (long)ns, (boolean)true);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void takingWriteLockMustRaiseModifiedFlag(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isModified((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        PageList.unlockWrite((long)this.pageRef);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void turningExclusiveLockIntoWriteLockMustRaiseModifiedFlag(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isModified((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isModified((long)this.pageRef));
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        PageList.unlockWrite((long)this.pageRef);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void releasingFlushLockMustLowerModifiedFlagIfSuccessful(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        long s = PageList.tryFlushLock((long)this.pageRef);
        PageList.unlockFlush((long)this.pageRef, (long)s, (boolean)true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isModified((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void loweredModifiedFlagMustRemainLoweredAfterReleasingFlushLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        long s = PageList.tryFlushLock((long)this.pageRef);
        PageList.unlockFlush((long)this.pageRef, (long)s, (boolean)true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isModified((long)this.pageRef));
        s = PageList.tryFlushLock((long)this.pageRef);
        PageList.unlockFlush((long)this.pageRef, (long)s, (boolean)true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isModified((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void releasingFlushLockMustNotLowerModifiedFlagIfUnsuccessful(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        long s = PageList.tryFlushLock((long)this.pageRef);
        PageList.unlockFlush((long)this.pageRef, (long)s, (boolean)false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void releasingFlushLockMustNotLowerModifiedFlagIfWriteLockWasWithinFlushFlushLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        long s = PageList.tryFlushLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        PageList.unlockWrite((long)this.pageRef);
        PageList.unlockFlush((long)this.pageRef, (long)s, (boolean)true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void releasingFlushLockMustNotLowerModifiedFlagIfWriteLockOverlappedTakingFlushLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        long s = PageList.tryFlushLock((long)this.pageRef);
        PageList.unlockWrite((long)this.pageRef);
        PageList.unlockFlush((long)this.pageRef, (long)s, (boolean)true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void releasingFlushLockMustNotLowerModifiedFlagIfWriteLockOverlappedReleasingFlushLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        long s = PageList.tryFlushLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        PageList.unlockFlush((long)this.pageRef, (long)s, (boolean)true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void releasingFlushLockMustNotLowerModifiedFlagIfWriteLockOverlappedFlushLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        long s = PageList.tryFlushLock((long)this.pageRef);
        PageList.unlockFlush((long)this.pageRef, (long)s, (boolean)true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void releasingFlushLockMustNotInterfereWithAdjacentModifiedFlags(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.prevPageRef);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.unlockExclusive((long)this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.prevPageRef, (boolean)this.multiVersioned));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.nextPageRef, (boolean)this.multiVersioned));
        PageList.unlockWrite((long)this.prevPageRef);
        PageList.unlockWrite((long)this.pageRef);
        PageList.unlockWrite((long)this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.nextPageRef));
        long s = PageList.tryFlushLock((long)this.pageRef);
        PageList.unlockFlush((long)this.pageRef, (long)s, (boolean)true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isModified((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.nextPageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void writeLockMustNotInterfereWithAdjacentModifiedFlags(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.prevPageRef);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.unlockExclusive((long)this.nextPageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isModified((long)this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isModified((long)this.nextPageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void disallowUnlockedPageToExplicitlyLowerModifiedFlag(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> {
            PageList.unlockExclusive((long)this.pageRef);
            PageList.explicitlyMarkPageUnmodifiedUnderExclusiveLock((long)this.pageRef);
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void disallowReadLockedPageToExplicitlyLowerModifiedFlag(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> {
            PageList.unlockExclusive((long)this.pageRef);
            PageList.tryOptimisticReadLock((long)this.pageRef);
            PageList.explicitlyMarkPageUnmodifiedUnderExclusiveLock((long)this.pageRef);
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void disallowFlushLockedPageToExplicitlyLowerModifiedFlag(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> {
            PageList.unlockExclusive((long)this.pageRef);
            Assertions.assertThat((long)PageList.tryFlushLock((long)this.pageRef)).isNotEqualTo(0L);
            PageList.explicitlyMarkPageUnmodifiedUnderExclusiveLock((long)this.pageRef);
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void disallowWriteLockedPageToExplicitlyLowerModifiedFlag(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> {
            PageList.unlockExclusive((long)this.pageRef);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
            PageList.explicitlyMarkPageUnmodifiedUnderExclusiveLock((long)this.pageRef);
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void allowExclusiveLockedPageToExplicitlyLowerModifiedFlag(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isModified((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        PageList.explicitlyMarkPageUnmodifiedUnderExclusiveLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isModified((long)this.pageRef));
        PageList.unlockExclusive((long)this.pageRef);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockMustTakeFlushLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        long flushStamp = PageList.unlockWriteAndTryTakeFlushLock((long)this.pageRef);
        Assertions.assertThat((long)flushStamp).isNotEqualTo(0L);
        Assertions.assertThat((long)PageList.tryFlushLock((long)this.pageRef)).isEqualTo(0L);
        PageList.unlockFlush((long)this.pageRef, (long)flushStamp, (boolean)true);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockMustThrowIfNotWriteLocked(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalMonitorStateException.class, () -> {
            PageList.unlockExclusive((long)this.pageRef);
            PageList.unlockWriteAndTryTakeFlushLock((long)this.pageRef);
        });
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockMustThrowIfNotWriteLockedButExclusiveLocked(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalMonitorStateException.class, () -> PageList.unlockWriteAndTryTakeFlushLock((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockMustFailIfFlushLockIsAlreadyTaken(int pageId) {
        this.init(pageId);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        long stamp = PageList.tryFlushLock((long)this.pageRef);
        Assertions.assertThat((long)stamp).isNotEqualTo(0L);
        long secondStamp = PageList.unlockWriteAndTryTakeFlushLock((long)this.pageRef);
        Assertions.assertThat((long)secondStamp).isEqualTo(0L);
        PageList.unlockFlush((long)this.pageRef, (long)stamp, (boolean)true);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockMustReleaseWriteLockEvenIfFlushLockFails(int pageId) {
        this.init(pageId);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        long flushStamp = PageList.tryFlushLock((long)this.pageRef);
        Assertions.assertThat((long)flushStamp).isNotEqualTo(0L);
        Assertions.assertThat((long)PageList.unlockWriteAndTryTakeFlushLock((long)this.pageRef)).isEqualTo(0L);
        long readStamp = PageList.tryOptimisticReadLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.pageRef, (long)readStamp));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockMustReleaseWriteLockWhenFlushLockSucceeds(int pageId) {
        this.init(pageId);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        Assertions.assertThat((long)PageList.unlockWriteAndTryTakeFlushLock((long)this.pageRef)).isNotEqualTo(0L);
        long readStamp = PageList.tryOptimisticReadLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.pageRef, (long)readStamp));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTrueTakeFlushLockMustRaiseModifiedFlag(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isModified((long)this.pageRef));
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        Assertions.assertThat((long)PageList.unlockWriteAndTryTakeFlushLock((long)this.pageRef)).isNotEqualTo(0L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockAndThenUnlockFlushMustLowerModifiedFlagIfSuccessful(int pageId) {
        this.init(pageId);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        long stamp = PageList.unlockWriteAndTryTakeFlushLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        PageList.unlockFlush((long)this.pageRef, (long)stamp, (boolean)true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isModified((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockAndThenUnlockFlushMustNotLowerModifiedFlagIfFailed(int pageId) {
        this.init(pageId);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        long stamp = PageList.unlockWriteAndTryTakeFlushLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        PageList.unlockFlush((long)this.pageRef, (long)stamp, (boolean)false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockAndThenUnlockFlushWithOverlappingWriterMustNotLowerModifiedFlag(int pageId) {
        this.init(pageId);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        long stamp = PageList.unlockWriteAndTryTakeFlushLock((long)this.pageRef);
        Assertions.assertThat((long)stamp).isNotEqualTo(0L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        PageList.unlockFlush((long)this.pageRef, (long)stamp, (boolean)true);
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockAndThenUnlockFlushWithContainedWriterMustNotLowerModifiedFlag(int pageId) {
        this.init(pageId);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        long stamp = PageList.unlockWriteAndTryTakeFlushLock((long)this.pageRef);
        Assertions.assertThat((long)stamp).isNotEqualTo(0L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        PageList.unlockWrite((long)this.pageRef);
        PageList.unlockFlush((long)this.pageRef, (long)stamp, (boolean)true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockThatSucceedsMustPreventOverlappingExclusiveLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.tryExclusiveLock((long)this.pageRef));
        long stamp = PageList.unlockWriteAndTryTakeFlushLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.tryExclusiveLock((long)this.pageRef));
        PageList.unlockFlush((long)this.pageRef, (long)stamp, (boolean)true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockThatFailsMustPreventOverlappingExclusiveLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.tryExclusiveLock((long)this.pageRef));
        long stamp = PageList.unlockWriteAndTryTakeFlushLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.tryExclusiveLock((long)this.pageRef));
        PageList.unlockFlush((long)this.pageRef, (long)stamp, (boolean)false);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockThatSucceedsMustPreventOverlappingFlushLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        long stamp = PageList.unlockWriteAndTryTakeFlushLock((long)this.pageRef);
        Assertions.assertThat((long)PageList.tryFlushLock((long)this.pageRef)).isEqualTo(0L);
        PageList.unlockFlush((long)this.pageRef, (long)stamp, (boolean)true);
        Assertions.assertThat((long)PageList.tryFlushLock((long)this.pageRef)).isNotEqualTo(0L);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockThatFailsMustPreventOverlappingFlushLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        long stamp = PageList.unlockWriteAndTryTakeFlushLock((long)this.pageRef);
        Assertions.assertThat((long)PageList.tryFlushLock((long)this.pageRef)).isEqualTo(0L);
        PageList.unlockFlush((long)this.pageRef, (long)stamp, (boolean)false);
        Assertions.assertThat((long)PageList.tryFlushLock((long)this.pageRef)).isNotEqualTo(0L);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockMustNotInvalidateReadersOverlappingWithFlushLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        long flushStamp = PageList.unlockWriteAndTryTakeFlushLock((long)this.pageRef);
        long readStamp = PageList.tryOptimisticReadLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.pageRef, (long)readStamp));
        PageList.unlockFlush((long)this.pageRef, (long)flushStamp, (boolean)true);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.pageRef, (long)readStamp));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    void clearBindingResetPageHorizon(int pageId) {
        this.init(pageId);
        PageList.setPageHorizon((long)this.pageRef, (long)42L);
        PageList.clearBinding((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)PageList.getPageHorizon((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unlockWriteAndTryTakeFlushLockMustInvalidateReadersOverlappingWithWriteLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        long readStamp = PageList.tryOptimisticReadLock((long)this.pageRef);
        long flushStamp = PageList.unlockWriteAndTryTakeFlushLock((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.validateReadLock((long)this.pageRef, (long)readStamp));
        PageList.unlockFlush((long)this.pageRef, (long)flushStamp, (boolean)true);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.validateReadLock((long)this.pageRef, (long)readStamp));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void mustExposeCachePageSize(int pageId) {
        this.init(pageId);
        PageList list = new PageList(0, 42, this.mman, this.swappers, VictimPageReference.getVictimPage((int)42, (MemoryTracker)EmptyMemoryTracker.INSTANCE), 8L);
        Assertions.assertThat((int)list.getCachePageSize()).isEqualTo(42);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void addressesMustBeZeroBeforeInitialisation(int pageId) {
        this.init(pageId);
        Assertions.assertThat((long)PageList.getAddress((long)this.pageRef)).isEqualTo(0L);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void initialisingBufferMustConsumeMemoryFromMemoryManager(int pageId) {
        this.init(pageId);
        long initialUsedMemory = this.mman.usedMemory();
        this.pageList.initBuffer(this.pageRef);
        long resultingUsedMemory = this.mman.usedMemory();
        int allocatedMemory = (int)(resultingUsedMemory - initialUsedMemory);
        Assertions.assertThat((int)allocatedMemory).isGreaterThanOrEqualTo(this.pageSize);
        Assertions.assertThat((int)allocatedMemory).isLessThanOrEqualTo(this.pageSize + 8);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void addressMustNotBeZeroAfterInitialisation(int pageId) {
        this.init(pageId);
        this.pageList.initBuffer(this.pageRef);
        Assertions.assertThat((long)PageList.getAddress((long)this.pageRef)).isNotEqualTo(0L);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void pageListMustBeCopyableViaConstructor(int pageId) {
        this.init(pageId);
        Assertions.assertThat((long)PageList.getAddress((long)this.pageRef)).isEqualTo(0L);
        this.pageList.initBuffer(this.pageRef);
        Assertions.assertThat((long)PageList.getAddress((long)this.pageRef)).isNotEqualTo(0L);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void usageCounterMustBeZeroByDefault(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.decrementUsage((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void usageCounterMustGoUpToFour(int pageId) {
        this.init(pageId);
        PageList.incrementUsage((long)this.pageRef);
        PageList.incrementUsage((long)this.pageRef);
        PageList.incrementUsage((long)this.pageRef);
        PageList.incrementUsage((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.decrementUsage((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.decrementUsage((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.decrementUsage((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.decrementUsage((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void usageCounterMustTruncateAtFour(int pageId) {
        this.init(pageId);
        PageList.incrementUsage((long)this.pageRef);
        PageList.incrementUsage((long)this.pageRef);
        PageList.incrementUsage((long)this.pageRef);
        PageList.incrementUsage((long)this.pageRef);
        PageList.incrementUsage((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.decrementUsage((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.decrementUsage((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.decrementUsage((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.decrementUsage((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.decrementUsage((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void incrementingUsageCounterMustNotInterfereWithAdjacentUsageCounters(int pageId) {
        this.init(pageId);
        PageList.incrementUsage((long)this.pageRef);
        PageList.incrementUsage((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.decrementUsage((long)this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.decrementUsage((long)this.nextPageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.decrementUsage((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void decrementingUsageCounterMustNotInterfereWithAdjacentUsageCounters(int pageId) {
        this.init(pageId);
        for (int id : pageIds) {
            long ref = this.pageList.deref(id);
            PageList.incrementUsage((long)ref);
            PageList.incrementUsage((long)ref);
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.decrementUsage((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.decrementUsage((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.decrementUsage((long)this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.decrementUsage((long)this.nextPageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void filePageIdIsUnboundByDefault(int pageId) {
        this.init(pageId);
        Assertions.assertThat((long)PageList.getFilePageId((long)this.pageRef)).isEqualTo(-1L);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void faultMustThrowWithoutExclusiveLock(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        this.pageList.initBuffer(this.pageRef);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> PageList.validatePageRefAndSetFilePageId((long)this.pageRef, (PageSwapper)DUMMY_SWAPPER, (int)0, (long)0L));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void faultMustReadIntoPage(int pageId) throws Exception {
        this.init(pageId);
        final byte pageByteContents = -9;
        int swapperId = 1;
        final long filePageId = 2L;
        DummyPageSwapper swapper = new DummyPageSwapper(this, "some file", this.pageSize){

            @Override
            public long read(long fpId, long bufferAddress) throws IOException {
                if (fpId == filePageId) {
                    UnsafeUtil.setMemory((long)bufferAddress, (long)this.filePageSize, (byte)pageByteContents);
                    return this.filePageSize;
                }
                throw new IOException("Did not expect this file page id = " + fpId);
            }
        };
        this.pageList.initBuffer(this.pageRef);
        PageList.fault((long)this.pageRef, (PageSwapper)swapper, (int)swapperId, (long)filePageId, (PinPageFaultEvent)PinPageFaultEvent.NULL);
        long address = PageList.getAddress((long)this.pageRef);
        Assertions.assertThat((long)address).isNotEqualTo(0L);
        for (int i = 0; i < this.pageSize; ++i) {
            byte actualByteContents = UnsafeUtil.getByte((long)(address + (long)i));
            if (actualByteContents == pageByteContents) continue;
            org.junit.jupiter.api.Assertions.fail((String)String.format("Page contents where different at address %x + %s, expected %x but was %x", address, i, pageByteContents, actualByteContents));
        }
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void pageMustBeLoadedAndBoundAfterFault(int pageId) throws Exception {
        this.init(pageId);
        int swapperId = 1;
        long filePageId = 42L;
        this.pageList.initBuffer(this.pageRef);
        PageList.validatePageRefAndSetFilePageId((long)this.pageRef, (PageSwapper)DUMMY_SWAPPER, (int)swapperId, (long)filePageId);
        PageList.fault((long)this.pageRef, (PageSwapper)DUMMY_SWAPPER, (int)swapperId, (long)filePageId, (PinPageFaultEvent)PinPageFaultEvent.NULL);
        Assertions.assertThat((long)PageList.getFilePageId((long)this.pageRef)).isEqualTo(filePageId);
        Assertions.assertThat((int)PageList.getSwapperId((long)this.pageRef)).isEqualTo(swapperId);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isLoaded((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isBoundTo((long)this.pageRef, (int)swapperId, (long)filePageId));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void pageWith5BytesFilePageIdMustBeLoadedAndBoundAfterFault(int pageId) throws Exception {
        this.init(pageId);
        int swapperId = 12;
        long filePageId = 0x80000000L;
        this.pageList.initBuffer(this.pageRef);
        PageList.validatePageRefAndSetFilePageId((long)this.pageRef, (PageSwapper)DUMMY_SWAPPER, (int)swapperId, (long)filePageId);
        PageList.fault((long)this.pageRef, (PageSwapper)DUMMY_SWAPPER, (int)swapperId, (long)filePageId, (PinPageFaultEvent)PinPageFaultEvent.NULL);
        Assertions.assertThat((long)PageList.getFilePageId((long)this.pageRef)).isEqualTo(filePageId);
        Assertions.assertThat((int)PageList.getSwapperId((long)this.pageRef)).isEqualTo(swapperId);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isLoaded((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isBoundTo((long)this.pageRef, (int)swapperId, (long)filePageId));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void pageMustBeLoadedAndNotBoundIfFaultThrows(int pageId) {
        this.init(pageId);
        DummyPageSwapper swapper = new DummyPageSwapper(this, "file", this.pageSize){

            @Override
            public long read(long filePageId, long bufferAddress) throws IOException {
                throw new IOException("boo");
            }
        };
        int swapperId = 1;
        long filePageId = 42L;
        this.pageList.initBuffer(this.pageRef);
        try {
            PageList.validatePageRefAndSetFilePageId((long)this.pageRef, (PageSwapper)swapper, (int)swapperId, (long)filePageId);
            PageList.fault((long)this.pageRef, (PageSwapper)swapper, (int)swapperId, (long)filePageId, (PinPageFaultEvent)PinPageFaultEvent.NULL);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (IOException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("boo");
        }
        Assertions.assertThat((long)PageList.getFilePageId((long)this.pageRef)).isEqualTo(filePageId);
        Assertions.assertThat((int)PageList.getSwapperId((long)this.pageRef)).isEqualTo(0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isLoaded((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isBoundTo((long)this.pageRef, (int)swapperId, (long)filePageId));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void faultMustThrowIfPageIsAlreadyBound(int pageId) throws Exception {
        this.init(pageId);
        short swapperId = 1;
        long filePageId = 42L;
        this.pageList.initBuffer(this.pageRef);
        PageList.validatePageRefAndSetFilePageId((long)this.pageRef, (PageSwapper)DUMMY_SWAPPER, (int)swapperId, (long)filePageId);
        PageList.fault((long)this.pageRef, (PageSwapper)DUMMY_SWAPPER, (int)swapperId, (long)filePageId, (PinPageFaultEvent)PinPageFaultEvent.NULL);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> PageList.validatePageRefAndSetFilePageId((long)this.pageRef, (PageSwapper)DUMMY_SWAPPER, (int)swapperId, (long)filePageId));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void faultMustThrowIfPageIsLoadedButNotBound(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        short swapperId = 1;
        long filePageId = 42L;
        this.doFailedFault(swapperId, filePageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalStateException.class, () -> PageList.validatePageRefAndSetFilePageId((long)this.pageRef, (PageSwapper)DUMMY_SWAPPER, (int)swapperId, (long)filePageId));
    }

    private void doFailedFault(short swapperId, long filePageId) {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.pageRef));
        this.pageList.initBuffer(this.pageRef);
        DummyPageSwapper swapper = new DummyPageSwapper(this, "", this.pageSize){

            @Override
            public long read(long filePageId, long bufferAddress) throws IOException {
                throw new IOException("boom");
            }
        };
        try {
            PageList.validatePageRefAndSetFilePageId((long)this.pageRef, (PageSwapper)swapper, (int)swapperId, (long)filePageId);
            PageList.fault((long)this.pageRef, (PageSwapper)swapper, (int)swapperId, (long)filePageId, (PinPageFaultEvent)PinPageFaultEvent.NULL);
            org.junit.jupiter.api.Assertions.fail((String)"fault should have thrown");
        }
        catch (IOException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("boom");
        }
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void faultMustPopulatePageFaultEvent(int pageId) throws Exception {
        this.init(pageId);
        int swapperId = 1;
        long filePageId = 42L;
        this.pageList.initBuffer(this.pageRef);
        DummyPageSwapper swapper = new DummyPageSwapper(this, "", this.pageSize){

            @Override
            public long read(long filePageId, long bufferAddress) {
                return 333L;
            }
        };
        StubPinPageFaultEvent event = new StubPinPageFaultEvent();
        PageList.fault((long)this.pageRef, (PageSwapper)swapper, (int)swapperId, (long)filePageId, (PinPageFaultEvent)event);
        Assertions.assertThat((long)event.bytesRead).isEqualTo(333L);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unboundPageMustNotBeLoaded(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isLoaded((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void unboundPageMustNotBeBoundToAnything(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isBoundTo((long)this.pageRef, (int)0, (long)0L));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void boundPagesAreNotBoundToOtherPagesWithSameSwapper(int pageId) throws Exception {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        long filePageId = 42L;
        int swapperId = 2;
        this.doFault(swapperId, filePageId);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isBoundTo((long)this.pageRef, (int)swapperId, (long)filePageId));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isBoundTo((long)this.pageRef, (int)swapperId, (long)(filePageId + 1L)));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isBoundTo((long)this.pageRef, (int)swapperId, (long)(filePageId - 1L)));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void boundPagesAreNotBoundToOtherPagesWithSameFilePageId(int pageId) throws Exception {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        int swapperId = 2;
        this.doFault(swapperId, 42L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isBoundTo((long)this.pageRef, (int)swapperId, (long)42L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isBoundTo((long)this.pageRef, (int)((short)(swapperId + 1)), (long)42L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isBoundTo((long)this.pageRef, (int)((short)(swapperId - 1)), (long)42L));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void faultMustNotInterfereWithAdjacentPages(int pageId) throws Exception {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        this.doFault(1, 42L);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isLoaded((long)this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isLoaded((long)this.nextPageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isBoundTo((long)this.prevPageRef, (int)1, (long)42L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isBoundTo((long)this.prevPageRef, (int)0, (long)0L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isBoundTo((long)this.nextPageRef, (int)1, (long)42L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isBoundTo((long)this.nextPageRef, (int)0, (long)0L));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void reportWriteLockStatus(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isWriteLocked((long)this.pageRef));
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isWriteLocked((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
        if (!this.multiVersioned) {
            int i;
            for (i = 0; i < 11; ++i) {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryWriteLock((long)this.pageRef, (boolean)this.multiVersioned));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isWriteLocked((long)this.pageRef));
            }
            for (i = 0; i < 11; ++i) {
                PageList.unlockWrite((long)this.pageRef);
                org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isWriteLocked((long)this.pageRef));
            }
        }
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isWriteLocked((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void failedFaultMustNotInterfereWithAdjacentPages(int pageId) {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        this.doFailedFault((short)1, 42L);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isLoaded((long)this.prevPageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isLoaded((long)this.nextPageRef));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isBoundTo((long)this.prevPageRef, (int)1, (long)42L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isBoundTo((long)this.prevPageRef, (int)0, (long)0L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isBoundTo((long)this.nextPageRef, (int)1, (long)42L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isBoundTo((long)this.nextPageRef, (int)0, (long)0L));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void exclusiveLockMustStillBeHeldAfterFault(int pageId) throws Exception {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        this.doFault(1, 42L);
        PageList.unlockExclusive((long)this.pageRef);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictMustFailIfPageIsAlreadyExclusivelyLocked(int pageId) throws Exception {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        int swapperId = this.swappers.allocate((PageSwapper)DUMMY_SWAPPER);
        this.doFault(swapperId, 42L);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictThatFailsOnExclusiveLockMustNotUndoSaidLock(int pageId) throws Exception {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        int swapperId = this.swappers.allocate((PageSwapper)DUMMY_SWAPPER);
        this.doFault(swapperId, 42L);
        this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isExclusivelyLocked((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictMustFailIfPageIsNotLoaded(int pageId) throws Exception {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictMustWhenPageIsNotLoadedMustNotLeavePageLocked(int pageId) throws Exception {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isExclusivelyLocked((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictMustLeavePageExclusivelyLockedOnSuccess(int pageId) throws Exception {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        int swapperId = this.swappers.allocate((PageSwapper)DUMMY_SWAPPER);
        this.doFault(swapperId, 42L);
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        PageList.unlockExclusive((long)this.pageRef);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void pageMustNotBeLoadedAfterSuccessfulEviction(int pageId) throws Exception {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        int swapperId = this.swappers.allocate((PageSwapper)DUMMY_SWAPPER);
        this.doFault(swapperId, 42L);
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isLoaded((long)this.pageRef));
        this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isLoaded((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void pageMustNotBeBoundAfterSuccessfulEviction(int pageId) throws Exception {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        int swapperId = this.swappers.allocate((PageSwapper)DUMMY_SWAPPER);
        this.doFault(swapperId, 42L);
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isBoundTo((long)this.pageRef, (int)1, (long)42L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isLoaded((long)this.pageRef));
        Assertions.assertThat((int)PageList.getSwapperId((long)this.pageRef)).isEqualTo(1);
        this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isBoundTo((long)this.pageRef, (int)1, (long)42L));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isLoaded((long)this.pageRef));
        Assertions.assertThat((int)PageList.getSwapperId((long)this.pageRef)).isEqualTo(0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void pageMustNotBeModifiedAfterSuccessfulEviction(int pageId) throws Exception {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        int swapperId = this.swappers.allocate((PageSwapper)DUMMY_SWAPPER);
        this.doFault(swapperId, 42L);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isModified((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictMustFlushPageIfModified(int pageId) throws Exception {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        final AtomicLong writtenFilePageId = new AtomicLong(-1L);
        final AtomicLong writtenBufferAddress = new AtomicLong(-1L);
        DummyPageSwapper swapper = new DummyPageSwapper(this, "file", this.pageSize){

            @Override
            public long write(long filePageId, long bufferAddress) throws IOException {
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writtenFilePageId.compareAndSet(-1L, filePageId));
                org.junit.jupiter.api.Assertions.assertTrue((boolean)writtenBufferAddress.compareAndSet(-1L, bufferAddress));
                return super.write(filePageId, bufferAddress);
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        Assertions.assertThat((long)writtenFilePageId.get()).isEqualTo(42L);
        Assertions.assertThat((long)writtenBufferAddress.get()).isEqualTo(PageList.getAddress((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictMustNotFlushPageIfNotModified(int pageId) throws Exception {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        final AtomicInteger writes = new AtomicInteger();
        DummyPageSwapper swapper = new DummyPageSwapper(this, "a", 313){

            @Override
            public long write(long filePageId, long bufferAddress) throws IOException {
                writes.getAndIncrement();
                return super.write(filePageId, bufferAddress);
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isModified((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        Assertions.assertThat((int)writes.get()).isEqualTo(0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictMustNotifySwapperOnSuccess(int pageId) throws Exception {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        final AtomicBoolean evictionNotified = new AtomicBoolean();
        DummyPageSwapper swapper = new DummyPageSwapper(this, "a", 313){

            @Override
            public void evicted(long pageRef, long filePageId) {
                evictionNotified.set(true);
                Assertions.assertThat((long)filePageId).isEqualTo(42L);
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)evictionNotified.get());
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictMustNotifySwapperOnSuccessEvenWhenFlushing(int pageId) throws Exception {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        final AtomicBoolean evictionNotified = new AtomicBoolean();
        DummyPageSwapper swapper = new DummyPageSwapper(this, "a", 313){

            @Override
            public void evicted(long pageRef, long filePageId) {
                evictionNotified.set(true);
                Assertions.assertThat((long)filePageId).isEqualTo(42L);
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)evictionNotified.get());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)PageList.isModified((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictMustLeavePageUnlockedAndLoadedAndBoundAndModifiedIfFlushThrows(int pageId) throws Exception {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        DummyPageSwapper swapper = new DummyPageSwapper(this, "a", 313){

            @Override
            public long write(long filePageId, long bufferAddress) throws IOException {
                throw new IOException();
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        try {
            this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL);
            org.junit.jupiter.api.Assertions.fail((String)"tryEvict should have thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isLoaded((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isBoundTo((long)this.pageRef, (int)swapperId, (long)42L));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictMustNotNotifySwapperOfEvictionIfFlushThrows(int pageId) throws Exception {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        final AtomicBoolean evictionNotified = new AtomicBoolean();
        DummyPageSwapper swapper = new DummyPageSwapper(this, "a", 313){

            @Override
            public long write(long filePageId, long bufferAddress) throws IOException {
                throw new IOException();
            }

            @Override
            public void evicted(long pageRef, long filePageId) {
                evictionNotified.set(true);
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        try {
            this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL);
            org.junit.jupiter.api.Assertions.fail((String)"tryEvict should have thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)evictionNotified.get());
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictMustReportToEvictionEvent(int pageId) throws Exception {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        DummyPageSwapper swapper = new DummyPageSwapper("a", 313);
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        PageList.unlockExclusive((long)this.pageRef);
        EvictionRecorderEvent recorder = new EvictionRecorderEvent(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, any -> recorder));
        Assertions.assertThat((boolean)recorder.evictionClosed).isEqualTo(true);
        Assertions.assertThat((long)recorder.filePageId).isEqualTo(42L);
        Assertions.assertThat((Object)recorder.swapper).isSameAs((Object)swapper);
        Assertions.assertThat((Throwable)recorder.evictionException).isNull();
        Assertions.assertThat((long)recorder.cachePageId).isEqualTo(this.pageRef);
        Assertions.assertThat((long)recorder.bytesWritten).isEqualTo(0L);
        Assertions.assertThat((boolean)recorder.flushDone).isEqualTo(false);
        Assertions.assertThat((Throwable)recorder.flushException).isNull();
        Assertions.assertThat((int)recorder.pagesFlushed).isEqualTo(0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictThatFlushesMustReportToEvictionAndFlushEvents(int pageId) throws Exception {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        int filePageSize = 313;
        DummyPageSwapper swapper = new DummyPageSwapper("a", filePageSize);
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        EvictionRecorderEvent recorder = new EvictionRecorderEvent(this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, any -> recorder));
        Assertions.assertThat((boolean)recorder.evictionClosed).isEqualTo(true);
        Assertions.assertThat((long)recorder.filePageId).isEqualTo(42L);
        Assertions.assertThat((Object)recorder.swapper).isSameAs((Object)swapper);
        Assertions.assertThat((Throwable)recorder.evictionException).isNull();
        Assertions.assertThat((long)recorder.cachePageId).isEqualTo(this.pageRef);
        Assertions.assertThat((long)recorder.bytesWritten).isEqualTo((long)filePageSize);
        Assertions.assertThat((boolean)recorder.flushDone).isEqualTo(true);
        Assertions.assertThat((Throwable)recorder.flushException).isNull();
        Assertions.assertThat((int)recorder.pagesFlushed).isEqualTo(1);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictThatFailsMustReportExceptionsToEvictionAndFlushEvents(int pageId) throws Exception {
        this.init(pageId);
        PageList.unlockExclusive((long)this.pageRef);
        final IOException ioException = new IOException();
        DummyPageSwapper swapper = new DummyPageSwapper(this, "a", 313){

            @Override
            public long write(long filePageId, long bufferAddress) throws IOException {
                throw ioException;
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        this.doFault(swapperId, 42L);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        EvictionRecorderEvent recorder = new EvictionRecorderEvent(this.pageRef);
        org.junit.jupiter.api.Assertions.assertThrows(IOException.class, () -> this.pageList.tryEvict(this.pageRef, any -> recorder));
        Assertions.assertThat((boolean)recorder.evictionClosed).isEqualTo(true);
        Assertions.assertThat((long)recorder.filePageId).isEqualTo(42L);
        Assertions.assertThat((Object)recorder.swapper).isSameAs((Object)swapper);
        Assertions.assertThat((Throwable)recorder.evictionException).isSameAs((Object)ioException);
        Assertions.assertThat((long)recorder.cachePageId).isEqualTo(this.pageRef);
        Assertions.assertThat((long)recorder.bytesWritten).isEqualTo(0L);
        Assertions.assertThat((boolean)recorder.flushDone).isEqualTo(true);
        Assertions.assertThat((Throwable)recorder.flushException).isSameAs((Object)ioException);
        Assertions.assertThat((int)recorder.pagesFlushed).isEqualTo(0);
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictThatSucceedsMustNotInterfereWithAdjacentPages(int pageId) throws Exception {
        this.init(pageId);
        PageList.unlockExclusive((long)this.prevPageRef);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.unlockExclusive((long)this.nextPageRef);
        DummyPageSwapper swapper = new DummyPageSwapper("a", 313);
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        long prevStamp = PageList.tryOptimisticReadLock((long)this.prevPageRef);
        long nextStamp = PageList.tryOptimisticReadLock((long)this.nextPageRef);
        this.doFault(swapperId, 42L);
        PageList.unlockExclusive((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.prevPageRef, (long)prevStamp));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.nextPageRef, (long)nextStamp));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictThatFlushesAndSucceedsMustNotInterfereWithAdjacentPages(int pageId) throws Exception {
        this.init(pageId);
        PageList.unlockExclusive((long)this.prevPageRef);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.unlockExclusive((long)this.nextPageRef);
        DummyPageSwapper swapper = new DummyPageSwapper("a", 313);
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        long prevStamp = PageList.tryOptimisticReadLock((long)this.prevPageRef);
        long nextStamp = PageList.tryOptimisticReadLock((long)this.nextPageRef);
        this.doFault(swapperId, 42L);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.prevPageRef, (long)prevStamp));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.nextPageRef, (long)nextStamp));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void tryEvictThatFailsMustNotInterfereWithAdjacentPages(int pageId) throws Exception {
        this.init(pageId);
        PageList.unlockExclusive((long)this.prevPageRef);
        PageList.unlockExclusive((long)this.pageRef);
        PageList.unlockExclusive((long)this.nextPageRef);
        DummyPageSwapper swapper = new DummyPageSwapper(this, "a", 313){

            @Override
            public long write(long filePageId, long bufferAddress) throws IOException {
                throw new IOException();
            }
        };
        int swapperId = this.swappers.allocate((PageSwapper)swapper);
        long prevStamp = PageList.tryOptimisticReadLock((long)this.prevPageRef);
        long nextStamp = PageList.tryOptimisticReadLock((long)this.nextPageRef);
        this.doFault(swapperId, 42L);
        PageList.unlockExclusiveAndTakeWriteLock((long)this.pageRef);
        PageList.unlockWrite((long)this.pageRef);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.isModified((long)this.pageRef));
        try {
            this.pageList.tryEvict(this.pageRef, (EvictionEventOpportunity)EvictionRunEvent.NULL);
            org.junit.jupiter.api.Assertions.fail((String)"tryEvict should have thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.prevPageRef, (long)prevStamp));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.validateReadLock((long)this.nextPageRef, (long)nextStamp));
    }

    @ParameterizedTest(name="pageRef = {0}")
    @MethodSource(value={"argumentsProvider"})
    public void failToSetHigherThenSupportedFilePageIdOnFault(int pageId) {
        this.init(pageId);
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> {
            PageList.unlockExclusive((long)this.pageRef);
            int swapperId = 2;
            this.doFault(swapperId, Long.MAX_VALUE);
        });
    }

    private void doFault(int swapperId, long filePageId) throws IOException {
        org.junit.jupiter.api.Assertions.assertTrue((boolean)PageList.tryExclusiveLock((long)this.pageRef));
        PageList.validatePageRefAndSetFilePageId((long)this.pageRef, (PageSwapper)DUMMY_SWAPPER, (int)swapperId, (long)filePageId);
        this.pageList.initBuffer(this.pageRef);
        PageList.fault((long)this.pageRef, (PageSwapper)DUMMY_SWAPPER, (int)swapperId, (long)filePageId, (PinPageFaultEvent)PinPageFaultEvent.NULL);
    }

    private static class EvictionRecorderEvent
    implements EvictionEvent {
        private long filePageId;
        private PageSwapper swapper;
        private IOException evictionException;
        private final long cachePageId;
        private boolean evictionClosed;
        private long bytesWritten;
        private boolean flushDone;
        private IOException flushException;
        private int pagesFlushed;
        private int pagesMerged;

        EvictionRecorderEvent(long cachePageId) {
            this.cachePageId = cachePageId;
        }

        public void close() {
            this.evictionClosed = true;
        }

        public void setFilePageId(long filePageId) {
            this.filePageId = filePageId;
        }

        public void setSwapper(PageSwapper swapper) {
            this.swapper = swapper;
        }

        public void setException(IOException exception) {
            this.evictionException = exception;
        }

        public FlushEvent beginFlush(long pageRef, PageSwapper swapper, PageReferenceTranslator pageTranslator) {
            return new FlushRecorderEvent();
        }

        private class FlushRecorderEvent
        implements FlushEvent {
            private FlushRecorderEvent() {
            }

            public void addBytesWritten(long bytes) {
                EvictionRecorderEvent.this.bytesWritten += bytes;
            }

            public void close() {
                EvictionRecorderEvent.this.flushDone = true;
            }

            public void setException(IOException exception) {
                EvictionRecorderEvent.this.flushException = exception;
            }

            public void addPagesFlushed(int pageCount) {
                EvictionRecorderEvent.this.pagesFlushed += pageCount;
            }

            public void addEvictionFlushedPages(int pageCount) {
                this.addPagesFlushed(pageCount);
            }

            public void addPagesMerged(int pagesMerged) {
                EvictionRecorderEvent.this.pagesMerged += pagesMerged;
            }
        }
    }
}

