/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.availability;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.graphdb.event.TransactionEventListenerAdapter;
import org.neo4j.kernel.availability.UnavailableException;
import org.neo4j.kernel.database.DatabaseMonitors;
import org.neo4j.kernel.impl.api.ShutdownTransactionMonitor;
import org.neo4j.test.extension.DbmsExtension;
import org.neo4j.test.extension.Inject;

@DbmsExtension
public class DatabaseShutdownTransactionCloseIT {
    @Inject
    DatabaseManagementService managementService;
    @Inject
    GraphDatabaseService databaseService;
    @Inject
    DatabaseMonitors databaseMonitors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void ableToCloseTransactionAfterShutdownStarted() throws InterruptedException {
        CountDownLatch shutdownLatch = new CountDownLatch(1);
        final CountDownLatch transactionCompleted = new CountDownLatch(1);
        final CountDownLatch continueTransactionLatch = new CountDownLatch(1);
        this.databaseMonitors.addMonitorListener((Object)new ShutdownTransactionMonitor(){

            public void awaitActiveTransactionClose() {
                continueTransactionLatch.countDown();
                try {
                    transactionCompleted.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }, new String[0]);
        try (ExecutorService executor = Executors.newSingleThreadExecutor();){
            Future<?> shutdownFuture = executor.submit(() -> {
                try {
                    shutdownLatch.await();
                    this.managementService.shutdown();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            });
            try {
                org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> {
                    try (Transaction tx = this.databaseService.beginTx();){
                        tx.createNode();
                        shutdownLatch.countDown();
                        continueTransactionLatch.await();
                        tx.commit();
                    }
                });
            }
            finally {
                transactionCompleted.countDown();
            }
            org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> shutdownFuture.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void terminateTransactionOnShutdown() throws InterruptedException {
        CountDownLatch shutdownLatch = new CountDownLatch(1);
        final CountDownLatch transactionCompleted = new CountDownLatch(1);
        final CountDownLatch continueTransactionLatch = new CountDownLatch(1);
        this.databaseMonitors.addMonitorListener((Object)new ShutdownTransactionMonitor(){

            public void awaitTerminatedTransactionClose() {
                continueTransactionLatch.countDown();
                try {
                    transactionCompleted.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }, new String[0]);
        try (ExecutorService executor = Executors.newSingleThreadExecutor();){
            Future<?> shutdownFuture = executor.submit(() -> {
                try {
                    shutdownLatch.await();
                    this.managementService.shutdown();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            });
            try {
                Assertions.assertThatThrownBy(() -> {
                    try (Transaction tx = this.databaseService.beginTx();){
                        tx.createNode();
                        shutdownLatch.countDown();
                        continueTransactionLatch.await();
                        tx.commit();
                    }
                }).rootCause().isInstanceOf(TransactionTerminatedException.class);
            }
            finally {
                transactionCompleted.countDown();
            }
            org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> shutdownFuture.get());
        }
    }

    @Test
    void awaitClosingWithMarkedAsTerminatedTransactionOnShutdown() throws InterruptedException {
        CountDownLatch shutdownLatch = new CountDownLatch(1);
        final CountDownLatch continueTransactionLatch = new CountDownLatch(1);
        final AtomicBoolean listenerEnabled = new AtomicBoolean();
        this.databaseMonitors.addMonitorListener((Object)new ShutdownTransactionMonitor(){

            public void awaitClosingTransactionClose() {
                continueTransactionLatch.countDown();
            }
        }, new String[0]);
        try (ExecutorService executor = Executors.newSingleThreadExecutor();){
            Future<?> shutdownFuture = executor.submit(() -> {
                try {
                    shutdownLatch.await();
                    this.managementService.shutdown();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            });
            this.managementService.registerTransactionEventListener(this.databaseService.databaseName(), (TransactionEventListener)new TransactionEventListenerAdapter<Void>(this){

                public Void beforeCommit(TransactionData data, Transaction transaction, GraphDatabaseService databaseService) throws Exception {
                    if (listenerEnabled.get()) {
                        continueTransactionLatch.await();
                    }
                    return null;
                }
            });
            Assertions.assertThatThrownBy(() -> {
                try (Transaction tx = this.databaseService.beginTx();){
                    tx.createNode();
                    shutdownLatch.countDown();
                    listenerEnabled.set(true);
                    tx.commit();
                }
            }).rootCause().isInstanceOf(TransactionTerminatedException.class);
            org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> shutdownFuture.get());
        }
    }

    @Test
    void awaitClosingAndNotMarkedAsTerminatedTransactionOnShutdown() throws InterruptedException {
        CountDownLatch shutdownLatch = new CountDownLatch(1);
        final CountDownLatch continueTransactionLatch = new CountDownLatch(1);
        final AtomicBoolean listenerEnabled = new AtomicBoolean();
        this.databaseMonitors.addMonitorListener((Object)new ShutdownTransactionMonitor(){

            public void awaitClosingTransactionClose() {
                continueTransactionLatch.countDown();
            }
        }, new String[0]);
        try (ExecutorService executor = Executors.newSingleThreadExecutor();){
            Future<?> shutdownFuture = executor.submit(() -> {
                try {
                    shutdownLatch.await();
                    this.managementService.shutdown();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            });
            this.managementService.registerTransactionEventListener(this.databaseService.databaseName(), (TransactionEventListener)new TransactionEventListenerAdapter<Void>(this){

                public void afterCommit(TransactionData data, Void state, GraphDatabaseService databaseService) {
                    if (listenerEnabled.get()) {
                        try {
                            continueTransactionLatch.await();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> {
                try (Transaction tx = this.databaseService.beginTx();){
                    tx.createNode();
                    shutdownLatch.countDown();
                    listenerEnabled.set(true);
                    tx.commit();
                }
            });
            org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> shutdownFuture.get());
        }
    }

    @Test
    void transactionTerminationOnShutdown() {
        int executors = 20;
        try (ExecutorService executor = Executors.newFixedThreadPool(executors);){
            ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(executors);
            for (int i = 0; i < executors; ++i) {
                futures.add(executor.submit(() -> {
                    while (true) {
                        Transaction tx = this.databaseService.beginTx();
                        try {
                            Node start = tx.createNode();
                            Node end = tx.createNode();
                            start.createRelationshipTo(end, RelationshipType.withName((String)RandomStringUtils.insecure().nextAscii(10)));
                            tx.commit();
                            continue;
                        }
                        finally {
                            if (tx == null) continue;
                            tx.close();
                            continue;
                        }
                        break;
                    }
                }));
            }
            this.managementService.shutdown();
            for (Future future : futures) {
                Assertions.assertThatThrownBy(future::get).rootCause().isInstanceOfAny(new Class[]{DatabaseShutdownException.class, UnavailableException.class, TransactionTerminatedException.class});
            }
        }
    }
}

