/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn.multiversion;

import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.OldestTransactionIdFactory;
import org.neo4j.io.pagecache.context.TransactionIdSnapshot;
import org.neo4j.io.pagecache.context.TransactionIdSnapshotFactory;
import org.neo4j.io.pagecache.context.VersionContext;
import org.neo4j.io.pagecache.context.VersionContextSupplier;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.impl.context.TransactionVersionContext;

public class SingleThreadedTestContextFactory
extends CursorContextFactory {
    private final VersionContextSupplier versionContextSupplier;
    private final PageCacheTracer cacheTracer;

    public SingleThreadedTestContextFactory(PageCacheTracer pageCacheTracer) {
        this(pageCacheTracer, new TestVersionContextSupplier());
    }

    SingleThreadedTestContextFactory(PageCacheTracer cacheTracer, VersionContextSupplier versionContextSupplier) {
        super(cacheTracer, versionContextSupplier);
        this.versionContextSupplier = versionContextSupplier;
        this.cacheTracer = cacheTracer;
    }

    public TestCursorContext create(String tag) {
        TestCursorContext testCursorContext = new TestCursorContext(this, this.cacheTracer.createPageCursorTracer(tag), this.versionContextSupplier.createVersionContext());
        testCursorContext.setWriteAndReadVersion(1L);
        return testCursorContext;
    }

    private static class TestVersionContextSupplier
    implements VersionContextSupplier {
        private final MutableTransactionSnapshotSupplier snapshotSupplier = new MutableTransactionSnapshotSupplier();

        private TestVersionContextSupplier() {
        }

        public void init(TransactionIdSnapshotFactory transactionIdSnapshotFactory, OldestTransactionIdFactory oldestTransactionIdFactory) {
        }

        public VersionContext createVersionContext() {
            return new TestTransactionVersionContext(this.snapshotSupplier);
        }
    }

    public static class TestCursorContext
    extends CursorContext {
        private final TestTransactionVersionContext versionContext;

        protected TestCursorContext(CursorContextFactory contextFactory, PageCursorTracer cursorTracer, VersionContext versionContext) {
            super(contextFactory, cursorTracer, versionContext);
            this.versionContext = (TestTransactionVersionContext)versionContext;
        }

        public void setWriteAndReadVersion(long version, long[] nonVisibleIds) {
            this.setWriteAndReadVersion(version, version, nonVisibleIds);
        }

        public void setWriteAndReadVersion(long writeVersion, long readVersion) {
            this.setWriteAndReadVersion(writeVersion, readVersion, ArrayUtils.EMPTY_LONG_ARRAY);
        }

        public void setWriteAndReadVersion(long version) {
            this.setWriteAndReadVersion(version, version, ArrayUtils.EMPTY_LONG_ARRAY);
        }

        public void setWriteAndReadVersion(long writeVersion, long readVersion, long[] notVisibleIds) {
            MutableTransactionSnapshotSupplier snapshotSupplier = this.versionContext.snapshotSupplier;
            snapshotSupplier.setLastClosedTxId(readVersion);
            snapshotSupplier.setHigherBoundaries(readVersion, notVisibleIds);
            this.versionContext.initRead();
            this.versionContext.initWrite(writeVersion);
        }
    }

    private static class MutableTransactionSnapshotSupplier
    implements TransactionIdSnapshotFactory {
        private long lastClosedTxId;
        private long highestVisible;
        private long[] nonVisibleIds = ArrayUtils.EMPTY_LONG_ARRAY;

        private MutableTransactionSnapshotSupplier() {
        }

        public void setLastClosedTxId(long value) {
            this.lastClosedTxId = value;
            this.highestVisible = value;
        }

        public void setHigherBoundaries(long highestVisible, long[] notVisibleIds) {
            this.highestVisible = highestVisible;
            this.nonVisibleIds = notVisibleIds;
        }

        public TransactionIdSnapshot createSnapshot() {
            return new TransactionIdSnapshot(this.lastClosedTxId, this.highestVisible, this.nonVisibleIds);
        }
    }

    private static class TestTransactionVersionContext
    extends TransactionVersionContext {
        private final MutableTransactionSnapshotSupplier snapshotSupplier;

        TestTransactionVersionContext(MutableTransactionSnapshotSupplier snapshotSupplier) {
            super((TransactionIdSnapshotFactory)snapshotSupplier, OldestTransactionIdFactory.EMPTY_OLDEST_ID_FACTORY);
            this.snapshotSupplier = snapshotSupplier;
        }
    }
}

