/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.junit.jupiter.api.Test;
import org.neo4j.server.BlockingBootstrapper;
import org.neo4j.server.Bootstrapper;
import org.neo4j.test.assertion.Assert;
import org.neo4j.test.conditions.Conditions;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.utils.TestDirectory;

@Neo4jLayoutExtension
class BlockingBootstrapperTest {
    @Inject
    private TestDirectory homeDir;

    BlockingBootstrapperTest() {
    }

    @Test
    void shouldBlockUntilStoppedIfTheWrappedStartIsSuccessful() {
        AtomicInteger status = new AtomicInteger();
        AtomicBoolean exited = new AtomicBoolean(false);
        final AtomicBoolean running = new AtomicBoolean(false);
        BlockingBootstrapper bootstrapper = new BlockingBootstrapper(new Bootstrapper(){

            public int start(Path homeDir, Path configFile, Map<String, String> configOverrides, boolean expandCommands, boolean daemonMode) {
                running.set(true);
                return 0;
            }

            public int stop() {
                running.set(false);
                return 0;
            }
        });
        new Thread(() -> {
            status.set(bootstrapper.start(this.homeDir.directory("home-dir"), Collections.emptyMap()));
            exited.set(true);
        }).start();
        Assert.assertEventually((String)"Wrapped was not started", running::get, (Condition)Conditions.TRUE, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)exited.get()).as("Bootstrapper exited early", new Object[0])).isEqualTo(false);
        bootstrapper.stop();
        Assert.assertEventually((String)"Wrapped was not stopped", running::get, (Condition)Conditions.FALSE, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        Assert.assertEventually((String)"Bootstrapper did not exit", exited::get, (Condition)Conditions.TRUE, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        ((AbstractIntegerAssert)Assertions.assertThat((int)status.get()).as("Bootstrapper did not propagate exit status", new Object[0])).isEqualTo(0);
    }

    @Test
    void shouldNotBlockIfTheWrappedStartIsUnsuccessful() {
        AtomicInteger status = new AtomicInteger();
        AtomicBoolean exited = new AtomicBoolean(false);
        BlockingBootstrapper bootstrapper = new BlockingBootstrapper(new Bootstrapper(this){

            public int start(Path homeDir, Path configFile, Map<String, String> configOverrides, boolean expandCommands, boolean daemonMode) {
                return 1;
            }

            public int stop() {
                return 0;
            }
        });
        new Thread(() -> {
            status.set(bootstrapper.start(this.homeDir.directory("home-dir"), null, Collections.emptyMap(), false, false));
            exited.set(true);
        }).start();
        Assert.assertEventually((String)"Blocked unexpectedly", exited::get, (Condition)Conditions.TRUE, (long)10L, (TimeUnit)TimeUnit.SECONDS);
        ((AbstractIntegerAssert)Assertions.assertThat((int)status.get()).as("Bootstrapper did not propagate exit status", new Object[0])).isEqualTo(1);
    }
}

