/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.CharsetUtil;
import java.math.BigInteger;
import java.net.URI;
import java.net.http.HttpClient;
import java.nio.file.Path;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.ssl.SslPolicyConfig;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityWebContainerBuilder;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.ssl.SslResourceBuilder;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;
import org.neo4j.test.server.InsecureTrustManager;

class HttpsCertRotationIT
extends ExclusiveWebContainerTestBase {
    private TestWebContainer testWebContainer;

    HttpsCertRotationIT() {
    }

    @Test
    void shouldReplaceCertificate() throws Exception {
        int keyId = 0;
        Path policyDir = this.testDirectory.homePath().resolve("certificates");
        FileSystemAbstraction fs = this.testDirectory.getFileSystem();
        fs.mkdirs(policyDir);
        SslResourceBuilder.caSignedKeyId((int)keyId).trustSignedByCA().install(policyDir);
        SslPolicyConfig sslPolicy = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.HTTPS);
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().persistent().usingDataDir(this.testDirectory.directory(this.methodName).toAbsolutePath().toString()).withHttpsEnabled().withHttpDisabled().withProperty(ServerSettings.http_enabled_transports.name(), "HTTP1_1,HTTP2").withProperty(sslPolicy.base_directory.name(), "certificates").build();
        SSLContext trustAllSslContext = SSLContext.getInstance("TLS");
        trustAllSslContext.init(null, new TrustManager[]{new InsecureTrustManager()}, null);
        ThrowingSupplier<X509Certificate> testClientInvocation = new ThrowingSupplier<X509Certificate>(){

            @Override
            public X509Certificate get() throws Exception {
                return HttpsCertRotationIT.testClient(HttpsCertRotationIT.this.testWebContainer.getBaseUri().toString());
            }
        };
        int retries = 3;
        long delayBeforeRetryMs = 100L;
        X509Certificate cert1 = HttpsCertRotationIT.retry(testClientInvocation, retries, delayBeforeRetryMs);
        this.testWebContainer.replaceHTTPSCertificate();
        X509Certificate cert2 = HttpsCertRotationIT.retry(testClientInvocation, retries, delayBeforeRetryMs);
        Assertions.assertThat((BigInteger)cert1.getSerialNumber()).isNotEqualTo((Object)cert2.getSerialNumber());
    }

    @AfterEach
    void cleanup() {
        if (this.testWebContainer != null) {
            this.testWebContainer.shutdown();
        }
    }

    private static Stream<HttpClient.Version> httpVersions() {
        return Stream.of(HttpClient.Version.HTTP_1_1, HttpClient.Version.HTTP_2);
    }

    public static X509Certificate testClient(String url) throws Exception {
        URI uri = new URI(url);
        final String host = uri.getHost();
        final int port = uri.getPort() == -1 ? 443 : uri.getPort();
        final SslContext sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        NioEventLoopGroup group = new NioEventLoopGroup();
        final SSLEngine[] lastEngine = new SSLEngine[1];
        try {
            Certificate[] certs;
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline pipeline = ch.pipeline();
                    SslHandler sslHandler = sslContext.newHandler(ch.alloc(), host, port);
                    lastEngine[0] = sslHandler.engine();
                    pipeline.addLast(new ChannelHandler[]{sslHandler});
                    pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
                    pipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
                    pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(0x100000)});
                    pipeline.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<FullHttpResponse>(this){

                        protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) {
                            System.out.println("Response received:");
                            String response = msg.content().toString(CharsetUtil.UTF_8);
                            System.out.println(response);
                        }

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            cause.printStackTrace();
                            ctx.close();
                        }
                    }});
                }
            });
            ChannelFuture future = bootstrap.connect(host, port).sync();
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, uri.getRawPath());
            request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)host);
            request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            future.channel().writeAndFlush((Object)request);
            future.channel().closeFuture().sync();
            Set result = Set.of();
            if (lastEngine[0] != null && (certs = lastEngine[0].getSession().getPeerCertificates()).length > 0) {
                X509Certificate x509Certificate = (X509Certificate)certs[0];
                return x509Certificate;
            }
            throw new IllegalStateException("request succeeded but no certificates seen");
        }
        finally {
            group.shutdownGracefully();
        }
    }

    private static X509Certificate retry(ThrowingSupplier<X509Certificate> function, int maxRetries, long delay) throws Exception {
        int attempts = 0;
        while (true) {
            try {
                return function.get();
            }
            catch (Exception e) {
                if (++attempts >= maxRetries) {
                    throw e;
                }
                Thread.sleep(delay);
                continue;
            }
            break;
        }
    }

    @FunctionalInterface
    private static interface ThrowingSupplier<T> {
        public T get() throws Exception;
    }
}

