/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storemigration;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.ZippedStore;
import org.neo4j.kernel.ZippedStoreCommunity;
import org.neo4j.kernel.impl.transaction.log.CheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.Neo4jLayoutExtension;
import org.neo4j.test.utils.TestDirectory;

@Neo4jLayoutExtension
public class CheckpointMigrationIT {
    @Inject
    protected TestDirectory directory;
    @Inject
    protected Neo4jLayout layout;

    public static List<ZippedStore> legacyStores() {
        return List.of(ZippedStoreCommunity.REC_SF11_V50_EMPTY, ZippedStoreCommunity.REC_SF11_V50_ALL, ZippedStoreCommunity.REC_AF11_V50_ALL, ZippedStoreCommunity.REC_AF11_V50_EMPTY);
    }

    @ParameterizedTest
    @MethodSource(value={"legacyStores"})
    void checkpointDatabaseWithLegacyKernelVersion(ZippedStore zippedStore) throws IOException {
        Path homeDir = this.layout.homeDirectory();
        zippedStore.unzip(homeDir);
        try (DatabaseManagementService dbms = new TestDatabaseManagementServiceBuilder(homeDir).build();){
            GraphDatabaseAPI database = (GraphDatabaseAPI)dbms.database("neo4j");
            CheckpointMigrationIT.forceCheckpoint(database);
            CheckpointInfo latestCheckpoint = (CheckpointInfo)((LogFiles)database.getDependencyResolver().resolveDependency(LogFiles.class)).getCheckpointFile().findLatestCheckpoint().orElseThrow();
            Assertions.assertEquals((Object)KernelVersion.V5_0, (Object)latestCheckpoint.kernelVersion());
        }
    }

    private static void forceCheckpoint(GraphDatabaseAPI database) throws IOException {
        ((CheckPointer)database.getDependencyResolver().resolveDependency(CheckPointer.class)).forceCheckPoint((TriggerInfo)new SimpleTriggerInfo("test"));
    }
}

