/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.connectors.HttpsConnector;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileSystemUtils;
import org.neo4j.logging.InternalLog;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.server.CommunityBootstrapper;
import org.neo4j.server.NeoBootstrapper;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.SuppressOutput;
import org.neo4j.test.extension.SuppressOutputExtension;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
@ExtendWith(value={SuppressOutputExtension.class})
@ResourceLock(value="java.lang.System.out")
class ServerUserLogTest {
    @Inject
    private SuppressOutput suppress;
    @Inject
    private TestDirectory homeDir;

    ServerUserLogTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldLogToStdOutWhenConfigured() throws IOException {
        NeoBootstrapper neoBootstrapper = ServerUserLogTest.getServerBootstrapper();
        Path dir = this.homeDir.homePath();
        InternalLog logBeforeStart = neoBootstrapper.getLog();
        Path xmlConfig = dir.resolve("neo4j.xml");
        try {
            String xml = "<Configuration packages=\"org.neo4j.logging.log4j\">\n    <Appenders>\n        <Console name=\"console\" target=\"SYSTEM_OUT\" follow=\"true\">\n            <PatternLayout pattern=\"%d{yyyy-MM-dd HH:mm:ss.SSSZ}{GMT+0} %-5p %m%n\"/>\n        </Console>\n    </Appenders>\n    <Loggers>\n        <Root level=\"info\">\n            <AppenderRef ref=\"console\"/>\n        </Root>\n    </Loggers>\n</Configuration>\n";
            FileSystemUtils.writeString((FileSystemAbstraction)this.homeDir.getFileSystem(), (Path)xmlConfig, (String)xml, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            Map configOverrides = MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.user_logging_config_path.name(), xmlConfig.toString()});
            configOverrides.putAll(ServerUserLogTest.connectorsConfig());
            int returnCode = neoBootstrapper.start(dir, null, configOverrides, false, false);
            Assertions.assertThat(this.getStdOut()).isNotEmpty();
            Assertions.assertThat((Path)ServerUserLogTest.getUserLogFileLocation(dir)).doesNotExist();
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)returnCode);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)neoBootstrapper.isRunning());
            Assertions.assertThat((Object)neoBootstrapper.getLog()).isNotSameAs((Object)logBeforeStart);
            Assertions.assertThat(this.getStdOut()).isNotEmpty();
            Assertions.assertThat(this.getStdOut()).anyMatch(s -> s.contains("Started."));
        }
        finally {
            neoBootstrapper.stop();
        }
        Assertions.assertThat((Path)ServerUserLogTest.getUserLogFileLocation(dir)).doesNotExist();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void shouldLogToFileAndConsoleByDefault() throws Exception {
        NeoBootstrapper neoBootstrapper = ServerUserLogTest.getServerBootstrapper();
        Path dir = this.homeDir.homePath();
        InternalLog logBeforeStart = neoBootstrapper.getLog();
        try {
            int returnCode = neoBootstrapper.start(dir, ServerUserLogTest.connectorsConfig());
            org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)returnCode);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)neoBootstrapper.isRunning());
            Assertions.assertThat((Object)neoBootstrapper.getLog()).isNotSameAs((Object)logBeforeStart);
        }
        finally {
            neoBootstrapper.stop();
        }
        Assertions.assertThat(this.getStdOut()).isNotEmpty();
        Assertions.assertThat((Path)ServerUserLogTest.getUserLogFileLocation(dir)).exists();
        Assertions.assertThat(ServerUserLogTest.readUserLogFile(dir)).isNotEmpty();
        Assertions.assertThat(ServerUserLogTest.readUserLogFile(dir)).anyMatch(s -> s.contains("Started."));
    }

    private static Map<String, String> connectorsConfig() {
        return Map.of(HttpConnector.listen_address.name(), "localhost:0", BoltConnector.listen_address.name(), "localhost:0", HttpsConnector.listen_address.name(), "localhost:0", HttpConnector.advertised_address.name(), ":0", BoltConnector.advertised_address.name(), ":0", HttpsConnector.advertised_address.name(), ":0", GraphDatabaseSettings.preallocate_logical_logs.name(), "false");
    }

    private List<String> getStdOut() {
        List lines = this.suppress.getOutputVoice().lines();
        return lines.stream().filter(line -> !line.equals("")).collect(Collectors.toList());
    }

    private static NeoBootstrapper getServerBootstrapper() {
        return new CommunityBootstrapper();
    }

    private static List<String> readUserLogFile(Path homeDir) throws IOException {
        return Files.readAllLines(ServerUserLogTest.getUserLogFileLocation(homeDir)).stream().filter(line -> !line.equals("")).collect(Collectors.toList());
    }

    private static Path getUserLogFileLocation(Path homeDir) {
        return homeDir.resolve("logs").resolve("neo4j.log");
    }
}

