/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.helpers.collection.MapUtil;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.server.configuration.ServerSettings;
import org.neo4j.server.helpers.CommunityWebContainerBuilder;
import org.neo4j.server.helpers.TestWebContainer;
import org.neo4j.test.server.ExclusiveWebContainerTestBase;
import org.neo4j.test.server.HTTP;

class TransactionTimeoutIT
extends ExclusiveWebContainerTestBase {
    private TestWebContainer testWebContainer;

    TransactionTimeoutIT() {
    }

    @AfterEach
    void stopTheServer() {
        this.testWebContainer.shutdown();
    }

    @Test
    void shouldHonorReallyLowTransactionTimeout() throws Exception {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().withProperty(ServerSettings.http_transaction_timeout.name(), "1").build();
        String tx = HTTP.POST((String)this.txURI(), (Object)MapUtil.map((Object[])new Object[]{"statements", Collections.singletonList(MapUtil.map((Object[])new Object[]{"statement", "CREATE (n)"}))})).location();
        Thread.sleep(5000L);
        Map response = (Map)HTTP.POST((String)(tx + "/commit")).content();
        List errors = (List)response.get("errors");
        Assertions.assertThat(((Map)errors.get(0)).get("code")).isEqualTo((Object)Status.Transaction.TransactionNotFound.code().serialize());
    }

    @Test
    void shouldEventuallyTimeoutATransaction() throws Exception {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().withProperty(ServerSettings.http_transaction_timeout.name(), "10").build();
        String tx = HTTP.POST((String)this.txURI(), (Object)MapUtil.map((Object[])new Object[]{"statements", Collections.singletonList(MapUtil.map((Object[])new Object[]{"statement", "CREATE (n)"}))})).location();
        Thread.sleep(5000L);
        Assertions.assertThat((int)HTTP.POST((String)tx).status()).isEqualTo(200);
        Thread.sleep(15000L);
        Map response = (Map)HTTP.POST((String)(tx + "/commit")).content();
        List errors = (List)response.get("errors");
        Assertions.assertThat(((Map)errors.get(0)).get("code")).isEqualTo((Object)Status.Transaction.TransactionNotFound.code().serialize());
    }

    @Test
    void shouldTimeoutAtDBMSLevel() throws Exception {
        this.testWebContainer = CommunityWebContainerBuilder.serverOnRandomPorts().withProperty(ServerSettings.http_transaction_timeout.name(), "30").withProperty(GraphDatabaseSettings.transaction_timeout.name(), "5").build();
        String tx = HTTP.POST((String)this.txURI(), (Object)MapUtil.map((Object[])new Object[]{"statements", Collections.singletonList(MapUtil.map((Object[])new Object[]{"statement", "CREATE (n)"}))})).location();
        Thread.sleep(15000L);
        HTTP.Response respA = HTTP.POST((String)(tx + "/commit"));
        Map response = (Map)respA.content();
        List errors = (List)response.get("errors");
        Assertions.assertThat(((Map)errors.get(0)).get("code")).isEqualTo((Object)Status.Transaction.TransactionTimedOutClientConfiguration.code().serialize());
        Map respB = (Map)HTTP.POST((String)(tx + "/commit")).content();
        List errors2 = (List)respB.get("errors");
        Assertions.assertThat(((Map)errors2.get(0)).get("code")).isEqualTo((Object)Status.Transaction.TransactionNotFound.code().serialize());
    }

    private String txURI() {
        return String.valueOf(this.testWebContainer.getBaseUri()) + TransactionTimeoutIT.txEndpoint();
    }
}

