/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.helpers;

import java.net.URI;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.ssl.SslPolicyConfig;
import org.neo4j.configuration.ssl.SslPolicyScope;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.server.AbstractNeoWebServer;
import org.neo4j.server.http.cypher.TransactionRegistry;
import org.neo4j.ssl.config.SslPolicyProvider;
import org.neo4j.test.ssl.SelfSignedCertificateFactory;

public class TestWebContainer {
    private final DatabaseManagementService managementService;
    private final AbstractNeoWebServer neoWebServer;
    private final InternalLogProvider logProvider;

    public TestWebContainer(DatabaseManagementService managementService, InternalLogProvider logProvider) {
        Objects.requireNonNull(managementService);
        this.managementService = managementService;
        this.neoWebServer = TestWebContainer.getNeoWebServer(managementService);
        this.logProvider = logProvider;
    }

    public URI getBaseUri() {
        return this.neoWebServer.getBaseUri();
    }

    public Optional<URI> httpsUri() {
        return this.neoWebServer.httpsUri();
    }

    public void shutdown() {
        this.managementService.shutdown();
        this.logProvider.close();
    }

    public DatabaseManagementService getDatabaseManagementService() {
        return this.managementService;
    }

    public GraphDatabaseFacade getDefaultDatabase() {
        Config config = (Config)TestWebContainer.getDependencyResolver(this.managementService).resolveDependency(Config.class);
        String defaultDatabase = (String)config.get(GraphDatabaseSettings.initial_default_database);
        return (GraphDatabaseFacade)this.managementService.database(defaultDatabase);
    }

    public <T> T resolveDependency(Class<T> clazz) {
        return (T)TestWebContainer.getDependencyResolver(this.managementService).resolveDependency(clazz);
    }

    public Config getConfig() {
        return this.neoWebServer.getConfig();
    }

    public TransactionRegistry getTransactionRegistry() {
        return this.neoWebServer.getTransactionRegistry();
    }

    private static AbstractNeoWebServer getNeoWebServer(DatabaseManagementService managementService) {
        return (AbstractNeoWebServer)TestWebContainer.getDependencyResolver(managementService).resolveDependency(AbstractNeoWebServer.class);
    }

    private static DependencyResolver getDependencyResolver(DatabaseManagementService managementService) {
        return ((GraphDatabaseAPI)managementService.database("system")).getDependencyResolver();
    }

    public void replaceHTTPSCertificate() throws Exception {
        Config config = this.getConfig();
        SslPolicyConfig policy = SslPolicyConfig.forScope((SslPolicyScope)SslPolicyScope.HTTPS);
        if (((Boolean)config.get(policy.enabled)).booleanValue()) {
            Path certDirectory = (Path)config.get(policy.base_directory);
            DefaultFileSystemAbstraction fs = new DefaultFileSystemAbstraction();
            fs.deleteFile((Path)config.get(policy.public_certificate));
            fs.deleteFile((Path)config.get(policy.private_key));
            SelfSignedCertificateFactory.create((FileSystemAbstraction)fs, (Path)certDirectory);
            SslPolicyProvider policyProvider = this.resolveDependency(SslPolicyProvider.class);
            policyProvider.reloadPolicies();
        }
    }
}

