/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.http.cypher.integration;

import java.net.URI;
import java.util.concurrent.ThreadLocalRandom;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.neo4j.server.http.cypher.integration.JoltV1ResultFormatIT;
import org.neo4j.server.rest.AbstractRestFunctionalTestBase;
import org.neo4j.server.rest.domain.JsonParseException;
import org.neo4j.test.server.HTTP;

class JoltV2ResultFormatIT
extends AbstractRestFunctionalTestBase {
    private final HTTP.Builder http = HTTP.withBaseUri((URI)JoltV2ResultFormatIT.container().getBaseUri()).withHeaders(new String[]{"Accept", "application/vnd.neo4j.jolt"});
    private String commitResource;

    JoltV2ResultFormatIT() {
    }

    @BeforeEach
    void setUp() {
        HTTP.Response begin = this.http.POST(JoltV2ResultFormatIT.txUri());
        Assertions.assertThat((int)begin.status()).isEqualTo(201);
        JoltV2ResultFormatIT.assertHasTxLocation(begin);
        try {
            this.commitResource = begin.get("info").get("commit").asText();
        }
        catch (JsonParseException e) {
            org.junit.jupiter.api.Assertions.fail((String)("Exception caught when setting up test: " + e.getMessage()));
        }
        Assertions.assertThat((String)this.commitResource).isEqualTo(begin.location() + "/commit");
    }

    @ParameterizedTest
    @CsvSource(value={"true", "TRUE"})
    void shouldReturnJoltInStrictFormat(String booleanString) {
        String cacheBuster = ";cacheBuster=" + ThreadLocalRandom.current().nextLong();
        String acceptHeaderString = "application/vnd.neo4j.jolt-v2;strict=" + booleanString + cacheBuster;
        HTTP.Response response = this.http.withHeaders(new String[]{"Accept", acceptHeaderString}).POST(this.commitResource, JoltV2ResultFormatIT.queryAsJsonRow("RETURN 1, 5.5, true"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        JoltV1ResultFormatIT.splitAndVerify(response.rawContent(), "\n", "{\"header\":{\"fields\":[\"1\",\"5.5\",\"true\"]}}", "{\"data\":[{\"Z\":\"1\"},{\"R\":\"5.5\"},{\"?\":\"true\"}]}", "{\"summary\":{}}", "{\"info\":{\"commit\":\"" + this.commitResource + "\",\"lastBookmarks\":[");
    }

    @ParameterizedTest
    @CsvSource(value={"true", "TRUE"})
    void shouldReturnJoltInStrictRecordSeparatedFormat(String booleanString) {
        String cacheBuster = ";cacheBuster=" + ThreadLocalRandom.current().nextLong();
        HTTP.Response response = this.http.withHeaders(new String[]{"Accept", "application/vnd.neo4j.jolt-v2+json-seq;strict=" + booleanString + cacheBuster}).POST(this.commitResource, JoltV2ResultFormatIT.queryAsJsonRow("RETURN 1, 5.5, true"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        JoltV1ResultFormatIT.splitAndVerify(response.rawContent(), "\u001e", "", "{\"header\":{\"fields\":[\"1\",\"5.5\",\"true\"]}}\n", "{\"data\":[{\"Z\":\"1\"},{\"R\":\"5.5\"},{\"?\":\"true\"}]}\n", "{\"summary\":{}}\n", "{\"info\":{\"commit\":\"" + this.commitResource + "\",\"lastBookmarks\":[");
    }

    @Test
    void shouldReturnJoltInSparseFormat() {
        HTTP.Response response = this.http.withHeaders(new String[]{"Accept", "application/vnd.neo4j.jolt-v2"}).POST(this.commitResource, JoltV2ResultFormatIT.queryAsJsonRow("RETURN 1, 5.5, true"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        JoltV1ResultFormatIT.splitAndVerify(response.rawContent(), "\n", "{\"header\":{\"fields\":[\"1\",\"5.5\",\"true\"]}}", "{\"data\":[1,{\"R\":\"5.5\"},true]}", "{\"summary\":{}}", "{\"info\":{\"commit\":\"" + this.commitResource + "\",\"lastBookmarks\":[");
    }

    @Test
    void shouldReturnJoltInRecordSeparatedFormat() {
        HTTP.Response response = this.http.withHeaders(new String[]{"Accept", "application/vnd.neo4j.jolt-v2+json-seq"}).POST(this.commitResource, JoltV2ResultFormatIT.queryAsJsonRow("RETURN 1, 5.5, true"));
        Assertions.assertThat((int)response.status()).isEqualTo(200);
        JoltV1ResultFormatIT.splitAndVerify(response.rawContent(), "\u001e", "", "{\"header\":{\"fields\":[\"1\",\"5.5\",\"true\"]}}\n", "{\"data\":[1,{\"R\":\"5.5\"},true]}\n", "{\"summary\":{}}\n", "{\"info\":{\"commit\":\"" + this.commitResource + "\",\"lastBookmarks\":[");
    }

    private static HTTP.RawPayload queryAsJsonRow(String query) {
        return HTTP.RawPayload.quotedJson((String)("{ 'statements': [ { 'statement': '" + query + "' } ] }"));
    }
}

