/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.neo4j.adversaries.Adversary;
import org.neo4j.adversaries.RandomAdversary;
import org.neo4j.adversaries.fs.AdversarialFileSystemAbstraction;
import org.neo4j.internal.helpers.NamedThreadFactory;
import org.neo4j.internal.helpers.ProcessUtils;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.DelegatingFileSystemAbstraction;
import org.neo4j.io.fs.DelegatingStoreChannel;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageSwapperTest;
import org.neo4j.io.pagecache.impl.LockThisFileProgram;
import org.neo4j.io.pagecache.impl.muninn.swapper.FileLockException;
import org.neo4j.io.pagecache.impl.muninn.swapper.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.swapper.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.swapper.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

public class SingleFilePageSwapperTest
extends PageSwapperTest {
    private EphemeralFileSystemAbstraction ephemeralFileSystem;
    private DefaultFileSystemAbstraction fileSystem;
    private Path path;
    private ExecutorService operationExecutor;
    private ThreadRegistryFactory threadRegistryFactory;
    private static final int INTERRUPT_ATTEMPTS = 100;

    @BeforeEach
    void setUp() {
        this.path = Path.of("file", new String[0]).normalize();
        this.ephemeralFileSystem = new EphemeralFileSystemAbstraction();
        this.fileSystem = new DefaultFileSystemAbstraction();
        this.threadRegistryFactory = new ThreadRegistryFactory();
        this.operationExecutor = Executors.newSingleThreadExecutor((ThreadFactory)((Object)this.threadRegistryFactory));
    }

    @AfterEach
    void tearDown() throws Exception {
        this.operationExecutor.shutdown();
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.ephemeralFileSystem, this.fileSystem});
    }

    @Override
    protected PageSwapperFactory swapperFactory(FileSystemAbstraction fileSystem) {
        return new SingleFilePageSwapperFactory(fileSystem, (PageCacheTracer)new DefaultPageCacheTracer(), (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    @Override
    protected void mkdirs(Path dir) throws IOException {
        this.getFs().mkdirs(dir);
    }

    protected Path getPath() {
        return this.path;
    }

    @Override
    protected FileSystemAbstraction getFs() {
        return this.getEphemeralFileSystem();
    }

    private FileSystemAbstraction getEphemeralFileSystem() {
        return this.ephemeralFileSystem;
    }

    FileSystemAbstraction getRealFileSystem() {
        return this.fileSystem;
    }

    private static void putBytes(long page, byte[] data, int srcOffset, int tgtOffset, int length) {
        for (int i = 0; i < length; ++i) {
            UnsafeUtil.putByte((long)(SingleFilePageSwapperTest.address(page) + (long)srcOffset + (long)i), (byte)data[tgtOffset + i]);
        }
    }

    @Test
    void reportExternalIoOnSwapIn() throws IOException {
        byte[] bytes = new byte[]{1, 2, 3, 4};
        try (StoreChannel channel = this.getFs().write(this.getPath());){
            channel.writeAll(SingleFilePageSwapperTest.wrap(bytes));
        }
        PageSwapperFactory factory = this.createSwapperFactory(this.getFs());
        CountingIOController controller = new CountingIOController();
        try (PageSwapper swapper = this.createSwapper(factory, this.getPath(), 4, null, false, false, controller);){
            long target = this.createPage(4);
            int numberOfReads = 12;
            for (int i = 0; i < numberOfReads; ++i) {
                org.junit.jupiter.api.Assertions.assertEquals((long)(4 + RESERVED_BYTES), (long)swapper.read(0L, target));
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)numberOfReads, (long)controller.getExternalIOCounter());
        }
    }

    @Test
    void reportExternalIoOnSwapInWithLength() throws IOException {
        byte[] bytes = new byte[]{1, 2, 3, 4};
        try (StoreChannel channel = this.getFs().write(this.getPath());){
            channel.writeAll(SingleFilePageSwapperTest.wrap(bytes));
        }
        PageSwapperFactory factory = this.createSwapperFactory(this.getFs());
        CountingIOController controller = new CountingIOController();
        try (PageSwapper swapper = this.createSwapper(factory, this.getPath(), 4, null, false, false, controller);){
            long target = this.createPage(4);
            int numberOfReads = 12;
            for (int i = 0; i < numberOfReads; ++i) {
                org.junit.jupiter.api.Assertions.assertEquals((long)(4 + RESERVED_BYTES), (long)swapper.read(0L, target, 4 + RESERVED_BYTES));
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)numberOfReads, (long)controller.getExternalIOCounter());
        }
    }

    @Test
    void reportExternalIoOnSwapInWithMultipleBuffers() throws IOException {
        byte[] bytes1 = new byte[]{1, 2, 3, 4};
        byte[] bytes2 = new byte[]{5, 6, 7, 8};
        byte[] bytes3 = new byte[]{9, 10, 11, 12};
        try (StoreChannel channel = this.getFs().write(this.getPath());){
            channel.writeAll(SingleFilePageSwapperTest.wrap(bytes1));
            channel.writeAll(SingleFilePageSwapperTest.wrap(bytes2));
            channel.writeAll(SingleFilePageSwapperTest.wrap(bytes3));
        }
        PageSwapperFactory factory = this.createSwapperFactory(this.getFs());
        CountingIOController controller = new CountingIOController();
        try (PageSwapper swapper = this.createSwapper(factory, this.getPath(), 4, null, false, false, controller);){
            long target1 = this.createPage(4);
            long target2 = this.createPage(4);
            long target3 = this.createPage(4);
            int numberOfReads = 12;
            int buffers = 3;
            for (int i = 0; i < numberOfReads; ++i) {
                org.junit.jupiter.api.Assertions.assertEquals((long)(12 + RESERVED_BYTES * 3), (long)swapper.read(0L, new long[]{target1, target2, target3}, new int[]{4 + RESERVED_BYTES, 4 + RESERVED_BYTES, 4 + RESERVED_BYTES}, buffers));
            }
            long expectedIO = this.getEphemeralFileSystem() == this.getFs() ? (long)(numberOfReads * buffers) : (long)numberOfReads;
            Assertions.assertThat((long)controller.getExternalIOCounter()).isGreaterThanOrEqualTo(expectedIO);
        }
    }

    @Test
    void reportExternalIoOnSwapOut() throws IOException {
        this.createEmptyFile();
        PageSwapperFactory factory = this.createSwapperFactory(this.getFs());
        CountingIOController controller = new CountingIOController();
        try (PageSwapper swapper = this.createSwapper(factory, this.getPath(), 4, null, false, false, controller);){
            long target = this.createPage(4);
            int numberOfWrites = 42;
            for (int i = 0; i < numberOfWrites; ++i) {
                org.junit.jupiter.api.Assertions.assertEquals((long)(4 + RESERVED_BYTES), (long)swapper.write(0L, target));
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)numberOfWrites, (long)controller.getExternalIOCounter());
        }
    }

    @Test
    void reportExternalIoOnSwapOutWithLength() throws IOException {
        this.createEmptyFile();
        PageSwapperFactory factory = this.createSwapperFactory(this.getFs());
        CountingIOController controller = new CountingIOController();
        try (PageSwapper swapper = this.createSwapper(factory, this.getPath(), 4, null, false, false, controller);){
            long target = this.createPage(4);
            int numberOfWrites = 42;
            for (int i = 0; i < numberOfWrites; ++i) {
                org.junit.jupiter.api.Assertions.assertEquals((long)(4 + RESERVED_BYTES), (long)swapper.write(0L, target, 4 + RESERVED_BYTES));
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)numberOfWrites, (long)controller.getExternalIOCounter());
        }
    }

    @Test
    void doNotReportExternalIoOnCheckpointerCalledVectoredFlush() throws IOException {
        this.createEmptyFile();
        PageSwapperFactory factory = this.createSwapperFactory(this.getFs());
        CountingIOController controller = new CountingIOController();
        try (PageSwapper swapper = this.createSwapper(factory, this.getPath(), 4, null, false, false, controller);){
            long target1 = this.createPage(4);
            long target2 = this.createPage(4);
            long target3 = this.createPage(4);
            int numberOfReads = 12;
            int buffers = 3;
            for (int i = 0; i < numberOfReads; ++i) {
                org.junit.jupiter.api.Assertions.assertEquals((long)(12 + RESERVED_BYTES * 3), (long)swapper.write(0L, new long[]{target1, target2, target3}, new int[]{4 + RESERVED_BYTES, 4 + RESERVED_BYTES, 4 + RESERVED_BYTES}, buffers, buffers));
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)controller.getExternalIOCounter());
        }
    }

    @Test
    void swappingInMustFillPageWithData() throws Exception {
        byte[] bytes = new byte[]{1, 2, 3, 4};
        StoreChannel channel = this.getFs().write(this.getPath());
        channel.writeAll(SingleFilePageSwapperTest.wrap(bytes));
        channel.close();
        PageSwapperFactory factory = this.createSwapperFactory(this.getFs());
        PageSwapper swapper = this.createSwapper(factory, this.getPath(), 4, null, false);
        long target = this.createPage(4);
        org.junit.jupiter.api.Assertions.assertEquals((long)(4 + RESERVED_BYTES), (long)swapper.read(0L, target));
        Assertions.assertThat((byte[])SingleFilePageSwapperTest.array(target)).containsExactly(bytes);
    }

    @Test
    void mustZeroFillPageBeyondEndOfFile() throws Exception {
        byte[] bytes1 = new byte[]{1, 2, 3, 4};
        byte[] bytes2 = new byte[]{5, 6};
        StoreChannel channel = this.getFs().write(this.getPath());
        channel.writeAll(SingleFilePageSwapperTest.wrap(bytes1));
        channel.writeAll(SingleFilePageSwapperTest.wrap(bytes2));
        channel.close();
        PageSwapperFactory factory = this.createSwapperFactory(this.getFs());
        PageSwapper swapper = this.createSwapper(factory, this.getPath(), 4, null, false);
        long target = this.createPage(4);
        org.junit.jupiter.api.Assertions.assertEquals((long)(2 + RESERVED_BYTES), (long)swapper.read(1L, target));
        Assertions.assertThat((byte[])SingleFilePageSwapperTest.array(target)).containsExactly(new int[]{5, 6, 0, 0});
    }

    @Test
    void uninterruptibleRead() throws Exception {
        byte[] pageContent = new byte[]{1, 2, 3, 4};
        StoreChannel channel = this.getFs().write(this.getPath());
        channel.writeAll(SingleFilePageSwapperTest.wrap(pageContent));
        channel.close();
        PageSwapperFactory factory = this.createSwapperFactory(this.getFs());
        PageSwapper swapper = this.createSwapper(factory, this.getPath(), 4, null, false);
        long target = this.createPage(4);
        CountDownLatch startInterruptsLatch = new CountDownLatch(1);
        AtomicBoolean readFlag = new AtomicBoolean(true);
        Future<?> uninterruptibleFuture = this.operationExecutor.submit(() -> {
            startInterruptsLatch.countDown();
            while (readFlag.get()) {
                try {
                    swapper.read(0L, target);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        });
        startInterruptsLatch.await();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.threadRegistryFactory.getThreads().isEmpty());
        for (int i = 0; i < 100; ++i) {
            this.threadRegistryFactory.getThreads().forEach(Thread::interrupt);
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
        readFlag.set(false);
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(uninterruptibleFuture::get);
    }

    @Test
    void uninterruptibleWrite() throws Exception {
        byte[] pageContent = new byte[]{1, 2, 3, 4};
        StoreChannel channel = this.getFs().write(this.getPath());
        channel.writeAll(SingleFilePageSwapperTest.wrap(pageContent));
        channel.close();
        PageSwapperFactory factory = this.createSwapperFactory(this.getFs());
        PageSwapper swapper = this.createSwapper(factory, this.getPath(), 4, null, false);
        long target = this.createPage(4);
        CountDownLatch startInterruptsLatch = new CountDownLatch(1);
        AtomicBoolean writeFlag = new AtomicBoolean(true);
        Future<?> uninterruptibleFuture = this.operationExecutor.submit(() -> {
            startInterruptsLatch.countDown();
            while (writeFlag.get()) {
                try {
                    swapper.write(0L, target);
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
            }
        });
        startInterruptsLatch.await();
        org.junit.jupiter.api.Assertions.assertFalse((boolean)this.threadRegistryFactory.getThreads().isEmpty());
        for (int i = 0; i < 100; ++i) {
            this.threadRegistryFactory.getThreads().forEach(Thread::interrupt);
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(10L));
        }
        writeFlag.set(false);
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(uninterruptibleFuture::get);
    }

    @Test
    void swappingOutMustWritePageToFile() throws Exception {
        this.getFs().write(this.getPath()).close();
        byte[] expected = new byte[]{1, 2, 3, 4};
        long page = this.createPage(expected);
        PageSwapperFactory factory = this.createSwapperFactory(this.getFs());
        PageSwapper swapper = this.createSwapper(factory, this.getPath(), 4, null, false);
        org.junit.jupiter.api.Assertions.assertEquals((long)(4 + RESERVED_BYTES), (long)swapper.write(0L, page));
        try (InputStream stream = this.getFs().openAsInputStream(this.getPath());){
            byte[] actual = new byte[expected.length];
            stream.readNBytes(RESERVED_BYTES);
            Assertions.assertThat((int)stream.read(actual)).isEqualTo(actual.length);
            Assertions.assertThat((byte[])actual).containsExactly(expected);
        }
    }

    private long createPage(byte[] expected) {
        long page = this.createPage(expected.length + RESERVED_BYTES);
        SingleFilePageSwapperTest.putBytes(page, expected, 0, 0, expected.length);
        return page;
    }

    @Test
    void swappingOutMustNotOverwriteDataBeyondPage() throws Exception {
        org.assertj.core.api.Assumptions.assumeThat((int)RESERVED_BYTES).isEqualTo(0);
        byte[] initialData = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        byte[] finalData = new byte[]{1, 2, 3, 4, 8, 7, 6, 5, 9, 10};
        StoreChannel channel = this.getFs().write(this.getPath());
        channel.writeAll(SingleFilePageSwapperTest.wrap(initialData));
        channel.close();
        byte[] change = new byte[]{8, 7, 6, 5};
        long page = this.createPage(change);
        PageSwapperFactory factory = this.createSwapperFactory(this.getFs());
        PageSwapper swapper = this.createSwapper(factory, this.getPath(), 4, null, false);
        swapper.write(1L, page);
        try (InputStream stream = this.getFs().openAsInputStream(this.getPath());){
            byte[] actual = new byte[(int)this.getFs().getFileSize(this.getPath())];
            Assertions.assertThat((int)stream.read(actual)).isEqualTo(actual.length);
            Assertions.assertThat((byte[])actual).containsExactly(finalData);
        }
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    void creatingSwapperForFileMustTakeLockOnFile() throws Exception {
        PageSwapperFactory factory = this.createSwapperFactory((FileSystemAbstraction)this.fileSystem);
        Path file = this.testDir.file("file");
        this.fileSystem.write(file).close();
        try (PageSwapper pageSwapper = this.createSwapper(factory, file, 4, NO_CALLBACK, false);){
            StoreFileChannel channel = this.fileSystem.write(file);
            org.junit.jupiter.api.Assertions.assertThrows(OverlappingFileLockException.class, () -> ((StoreChannel)channel).tryLock());
        }
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    void creatingSwapperForInternallyLockedFileMustThrow() throws Exception {
        PageSwapperFactory factory = this.createSwapperFactory((FileSystemAbstraction)this.fileSystem);
        Path file = this.testDir.file("file");
        StoreFileChannel channel = this.fileSystem.write(file);
        try (FileLock fileLock = channel.tryLock();){
            Assertions.assertThat((Object)fileLock).isNotNull();
            org.junit.jupiter.api.Assertions.assertThrows(FileLockException.class, () -> this.createSwapper(factory, file, 4, NO_CALLBACK, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    void creatingSwapperForExternallyLockedFileMustThrow() throws Exception {
        PageSwapperFactory factory = this.createSwapperFactory((FileSystemAbstraction)this.fileSystem);
        Path file = this.testDir.file("file");
        this.fileSystem.write(file).close();
        Process process = ProcessUtils.start(pb -> pb.directory(Path.of("target/test-classes", new String[0]).toAbsolutePath().toFile()), (String[])new String[]{LockThisFileProgram.class.getCanonicalName(), file.toAbsolutePath().toString()});
        BufferedReader stdout = new BufferedReader(new InputStreamReader(process.getInputStream()));
        InputStream stderr = process.getErrorStream();
        try {
            Assumptions.assumeTrue((boolean)"locked".equals(stdout.readLine()));
        }
        catch (Throwable e) {
            int b = stderr.read();
            while (b != -1) {
                System.err.write(b);
                b = stderr.read();
            }
            System.err.flush();
            int exitCode = process.waitFor();
            System.out.println("exitCode = " + exitCode);
            throw e;
        }
        try {
            org.junit.jupiter.api.Assertions.assertThrows(FileLockException.class, () -> this.createSwapper(factory, file, 4, NO_CALLBACK, true));
        }
        finally {
            process.getOutputStream().write(0);
            process.getOutputStream().flush();
            process.waitFor();
        }
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    void mustUnlockFileWhenThePageSwapperIsClosed() throws Exception {
        PageSwapperFactory factory = this.createSwapperFactory((FileSystemAbstraction)this.fileSystem);
        Path file = this.testDir.file("file");
        this.fileSystem.write(file).close();
        this.createSwapper(factory, file, 4, NO_CALLBACK, false).close();
        try (StoreFileChannel channel = this.fileSystem.write(file);
             FileLock fileLock = channel.tryLock();){
            Assertions.assertThat((Object)fileLock).isNotNull();
        }
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    void fileMustRemainLockedEvenIfChannelIsClosedByStrayInterrupt() throws Exception {
        PageSwapperFactory factory = this.createSwapperFactory((FileSystemAbstraction)this.fileSystem);
        Path file = this.testDir.file("file");
        this.fileSystem.write(file).close();
        try (PageSwapper pageSwapper = this.createSwapper(factory, file, 4, NO_CALLBACK, false);){
            StoreFileChannel channel = this.fileSystem.write(file);
            Thread.currentThread().interrupt();
            pageSwapper.force();
            org.junit.jupiter.api.Assertions.assertThrows(OverlappingFileLockException.class, () -> ((StoreChannel)channel).tryLock());
        }
    }

    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    void mustCloseFilesIfTakingFileLockThrows() throws Exception {
        final AtomicInteger openFilesCounter = new AtomicInteger();
        PageSwapperFactory factory = this.createSwapperFactory((FileSystemAbstraction)new DelegatingFileSystemAbstraction(this, (FileSystemAbstraction)this.fileSystem){

            public StoreChannel open(Path fileName, Set<OpenOption> options) throws IOException {
                openFilesCounter.getAndIncrement();
                return new DelegatingStoreChannel(super.open(fileName, options)){

                    public void close() throws IOException {
                        openFilesCounter.getAndDecrement();
                        super.close();
                    }
                };
            }
        });
        Path file = this.testDir.file("file");
        try (StoreFileChannel ch = this.fileSystem.write(file);
             FileLock ignore = ch.tryLock();){
            this.createSwapper(factory, file, 4, NO_CALLBACK, false).close();
            org.junit.jupiter.api.Assertions.fail((String)"Creating a page swapper for a locked channel should have thrown");
        }
        catch (FileLockException fileLockException) {
            // empty catch block
        }
        Assertions.assertThat((int)openFilesCounter.get()).isEqualTo(0);
    }

    private static byte[] array(long address) {
        int size = SingleFilePageSwapperTest.sizeOfAsInt(address);
        byte[] array = new byte[size];
        for (int i = 0; i < size; ++i) {
            array[i] = UnsafeUtil.getByte((long)(SingleFilePageSwapperTest.address(address) + (long)i));
        }
        return array;
    }

    private static ByteBuffer wrap(byte[] bytes) {
        ByteBuffer buffer = ByteBuffers.allocate((int)(RESERVED_BYTES + bytes.length), (ByteOrder)ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        byte zero = 0;
        for (int i = 0; i < RESERVED_BYTES; ++i) {
            buffer.put(zero);
        }
        for (byte b : bytes) {
            buffer.put(b);
        }
        buffer.clear();
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void mustHandleMischiefInPositionedRead() throws Exception {
        int bytesTotal = 512;
        byte[] data = new byte[bytesTotal];
        ThreadLocalRandom.current().nextBytes(data);
        PageSwapperFactory factory = this.createSwapperFactory(this.getFs());
        Path file = this.getPath();
        try (PageSwapper swapper = this.createSwapper(factory, file, bytesTotal, NO_CALLBACK, true);){
            long page = this.createPage(data);
            swapper.write(0L, page);
        }
        RandomAdversary adversary = new RandomAdversary(0.5, 0.0, 0.0);
        factory = this.createSwapperFactory((FileSystemAbstraction)new AdversarialFileSystemAbstraction((Adversary)adversary, this.getFs()));
        swapper = this.createSwapper(factory, file, bytesTotal, NO_CALLBACK, false);
        long page = this.createPage(bytesTotal);
        try {
            for (int i = 0; i < 10000; ++i) {
                SingleFilePageSwapperTest.clear(page);
                Assertions.assertThat((long)swapper.read(0L, page)).isEqualTo((long)(bytesTotal + RESERVED_BYTES));
                Assertions.assertThat((byte[])SingleFilePageSwapperTest.array(page)).isEqualTo((Object)data);
            }
        }
        finally {
            swapper.close();
        }
    }

    @Test
    void mustHandleMischiefInPositionedWrite() throws Exception {
        int bytesTotal = 512;
        byte[] data = new byte[bytesTotal];
        ThreadLocalRandom.current().nextBytes(data);
        long zeroPage = this.createPage(bytesTotal);
        SingleFilePageSwapperTest.clear(zeroPage);
        Path file = this.getPath();
        RandomAdversary adversary = new RandomAdversary(0.5, 0.0, 0.0);
        PageSwapperFactory factory = this.createSwapperFactory((FileSystemAbstraction)new AdversarialFileSystemAbstraction((Adversary)adversary, this.getFs()));
        try (PageSwapper swapper = this.createSwapper(factory, file, bytesTotal, NO_CALLBACK, true);){
            long page = this.createPage(bytesTotal);
            for (int i = 0; i < 10000; ++i) {
                adversary.enableAdversary(false);
                swapper.write(0L, zeroPage);
                SingleFilePageSwapperTest.putBytes(page, data, 0, 0, data.length);
                adversary.enableAdversary(true);
                Assertions.assertThat((long)swapper.write(0L, page)).isEqualTo((long)(bytesTotal + RESERVED_BYTES));
                SingleFilePageSwapperTest.clear(page);
                adversary.enableAdversary(false);
                swapper.read(0L, page);
                Assertions.assertThat((byte[])SingleFilePageSwapperTest.array(page)).isEqualTo((Object)data);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void mustHandleMischiefInPositionedVectoredRead() throws Exception {
        org.assertj.core.api.Assumptions.assumeThat((int)RESERVED_BYTES).isEqualTo(0);
        int bytesTotal = 512;
        int bytesPerPage = 32;
        int pageCount = bytesTotal / bytesPerPage;
        byte[] data = new byte[bytesTotal];
        ThreadLocalRandom.current().nextBytes(data);
        PageSwapperFactory factory = this.createSwapperFactory(this.getFs());
        Path file = this.getPath();
        try (PageSwapper swapper = this.createSwapper(factory, file, bytesTotal, NO_CALLBACK, true);){
            long page = this.createPage(data);
            swapper.write(0L, page);
        }
        RandomAdversary adversary = new RandomAdversary(0.5, 0.0, 0.0);
        factory = this.createSwapperFactory((FileSystemAbstraction)new AdversarialFileSystemAbstraction((Adversary)adversary, this.getFs()));
        swapper = this.createSwapper(factory, file, bytesPerPage, NO_CALLBACK, false);
        long[] pages = new long[pageCount];
        int[] pageLengths = new int[pageCount];
        for (int i = 0; i < pageCount; ++i) {
            pages[i] = this.createPage(bytesPerPage);
            pageLengths[i] = bytesPerPage;
        }
        byte[] temp = new byte[bytesPerPage];
        try {
            for (int i = 0; i < 10000; ++i) {
                for (long page : pages) {
                    SingleFilePageSwapperTest.clear(page);
                }
                Assertions.assertThat((long)swapper.read(0L, pages, pageLengths, pages.length)).isEqualTo((long)bytesTotal);
                for (int j = 0; j < pageCount; ++j) {
                    System.arraycopy(data, j * bytesPerPage, temp, 0, bytesPerPage);
                    Assertions.assertThat((byte[])SingleFilePageSwapperTest.array(pages[j])).isEqualTo((Object)temp);
                }
            }
        }
        finally {
            swapper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void mustHandleMischiefInPositionedVectoredWrite() throws Exception {
        int i;
        int bytesTotal = 512;
        int bytesPerPage = 32;
        int pageCount = bytesTotal / bytesPerPage;
        byte[] data = new byte[bytesTotal];
        ThreadLocalRandom.current().nextBytes(data);
        long zeroPage = this.createPage(bytesPerPage);
        SingleFilePageSwapperTest.clear(zeroPage);
        Path file = this.getPath();
        RandomAdversary adversary = new RandomAdversary(0.5, 0.0, 0.0);
        PageSwapperFactory factory = this.createSwapperFactory((FileSystemAbstraction)new AdversarialFileSystemAbstraction((Adversary)adversary, this.getFs()));
        PageSwapper swapper = this.createSwapper(factory, file, bytesPerPage, NO_CALLBACK, true);
        long[] writePages = new long[pageCount];
        long[] readPages = new long[pageCount];
        long[] zeroPages = new long[pageCount];
        int[] pageLengths = new int[pageCount];
        for (i = 0; i < pageCount; ++i) {
            writePages[i] = this.createPage(bytesPerPage);
            SingleFilePageSwapperTest.putBytes(writePages[i], data, 0, i * bytesPerPage, bytesPerPage);
            readPages[i] = this.createPage(bytesPerPage);
            zeroPages[i] = zeroPage;
            pageLengths[i] = bytesPerPage + RESERVED_BYTES;
        }
        try {
            for (i = 0; i < 10000; ++i) {
                adversary.enableAdversary(false);
                swapper.write(0L, zeroPages, pageLengths, pageCount, pageCount);
                adversary.enableAdversary(true);
                swapper.write(0L, writePages, pageLengths, pageCount, pageCount);
                for (long readPage : readPages) {
                    SingleFilePageSwapperTest.clear(readPage);
                }
                adversary.enableAdversary(false);
                Assertions.assertThat((long)swapper.read(0L, readPages, pageLengths, pageCount)).isEqualTo((long)(bytesTotal + pageCount * RESERVED_BYTES));
                for (int j = 0; j < pageCount; ++j) {
                    Assertions.assertThat((byte[])SingleFilePageSwapperTest.array(readPages[j])).containsExactly(SingleFilePageSwapperTest.array(writePages[j]));
                }
            }
        }
        finally {
            swapper.close();
        }
    }

    private void createEmptyFile() throws IOException {
        StoreChannel ignored = this.getFs().write(this.getPath());
        if (ignored != null) {
            ignored.close();
        }
    }

    private static class ThreadRegistryFactory
    extends NamedThreadFactory {
        private final Set<Thread> threads = ConcurrentHashMap.newKeySet();

        ThreadRegistryFactory() {
            super("SwapperInterruptTestThreads");
        }

        public Thread newThread(Runnable runnable) {
            Thread thread = super.newThread(runnable);
            this.threads.add(thread);
            return thread;
        }

        public Set<Thread> getThreads() {
            return this.threads;
        }
    }

    private static class CountingIOController
    implements IOController {
        private final AtomicLong externalIOCounter = new AtomicLong();

        private CountingIOController() {
        }

        public void maybeLimitIO(int recentlyCompletedIOs, FileFlushEvent flushes) {
        }

        public void reportIO(int completedIOs) {
            this.externalIOCounter.addAndGet(completedIOs);
        }

        public long configuredLimit() {
            return 0L;
        }

        public long getExternalIOCounter() {
            return this.externalIOCounter.longValue();
        }
    }
}

