/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.pagecache.impl.muninn.swapper.PageSwapper;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.DummyPageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageReferenceTranslator;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.io.pagecache.tracing.PinPageFaultEvent;
import org.neo4j.io.pagecache.tracing.cursor.CursorStatisticSnapshot;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

class DefaultPageCursorTracerTest {
    private static final String TEST_TRACER = "testTracer";
    private PageSwapper swapper;
    private PageCursorTracer pageCursorTracer;
    private DefaultPageCacheTracer cacheTracer;
    private PageReferenceTranslator referenceTranslator;

    DefaultPageCursorTracerTest() {
    }

    @BeforeEach
    void setUp() {
        this.cacheTracer = new DefaultPageCacheTracer();
        this.pageCursorTracer = this.createTracer();
        this.swapper = new DummyPageSwapper("filename", (int)ByteUnit.kibiBytes((long)8L));
        this.referenceTranslator = (PageReferenceTranslator)Mockito.mock(PageReferenceTranslator.class);
    }

    @Test
    void countClosedAndOpenCursors() {
        Assertions.assertEquals((long)0L, (long)this.cacheTracer.closedCursors());
        Assertions.assertEquals((long)0L, (long)this.cacheTracer.openedCursors());
        this.pageCursorTracer.openCursor();
        this.pageCursorTracer.openCursor();
        this.pageCursorTracer.openCursor();
        this.pageCursorTracer.openCursor();
        this.pageCursorTracer.closeCursor();
        this.pageCursorTracer.closeCursor();
        this.pageCursorTracer.closeCursor();
        Assertions.assertEquals((long)3L, (long)this.pageCursorTracer.closedCursors());
        Assertions.assertEquals((long)4L, (long)this.pageCursorTracer.openedCursors());
        Assertions.assertEquals((long)0L, (long)this.cacheTracer.closedCursors());
        Assertions.assertEquals((long)0L, (long)this.cacheTracer.openedCursors());
        this.pageCursorTracer.close();
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.closedCursors());
        Assertions.assertEquals((long)4L, (long)this.cacheTracer.openedCursors());
    }

    @Test
    void countPinsAndUnpins() {
        this.pageCursorTracer.beginPin(true, 0L, this.swapper).close();
        this.pageCursorTracer.unpin(0L, this.swapper);
        this.pageCursorTracer.beginPin(true, 0L, this.swapper).close();
        Assertions.assertEquals((long)2L, (long)this.pageCursorTracer.pins());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.unpins());
    }

    @Test
    void countHits() {
        this.pinAndHit();
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.pins());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.hits());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.unpins());
    }

    @Test
    void countPageFaultsAndBytesRead() {
        try (PinEvent pinEvent = this.pageCursorTracer.beginPin(true, 0L, this.swapper);){
            try (PinPageFaultEvent pageFaultEvent = pinEvent.beginPageFault(1L, this.swapper);){
                pageFaultEvent.addBytesRead(42L);
            }
            pageFaultEvent = pinEvent.beginPageFault(3L, this.swapper);
            try {
                pageFaultEvent.addBytesRead(42L);
            }
            finally {
                if (pageFaultEvent != null) {
                    pageFaultEvent.close();
                }
            }
        }
        this.pageCursorTracer.unpin(0L, this.swapper);
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.pins());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.unpins());
        Assertions.assertEquals((long)2L, (long)this.pageCursorTracer.faults());
        Assertions.assertEquals((long)84L, (long)this.pageCursorTracer.bytesRead());
    }

    @Test
    void countNoFaults() {
        try (PinEvent pinEvent = this.pageCursorTracer.beginPin(true, 0L, this.swapper);){
            pinEvent.noFault();
        }
        this.pageCursorTracer.unpin(0L, this.swapper);
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.pins());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.noFaults());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.unpins());
    }

    @Test
    void countFailedFaults() {
        try (PinEvent pinEvent = this.pageCursorTracer.beginPin(true, 0L, this.swapper);
             PinPageFaultEvent pageFaultEvent = pinEvent.beginPageFault(1L, this.swapper);){
            pageFaultEvent.setException(null);
        }
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.pins());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.faults());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.failedFaults());
    }

    @Test
    void countPageEvictions() {
        try (PinEvent pinEvent = this.pageCursorTracer.beginPin(true, 0L, this.swapper);
             PinPageFaultEvent faultEvent = pinEvent.beginPageFault(1L, this.swapper);){
            EvictionEvent evictionEvent = faultEvent.beginEviction(0L);
            evictionEvent.setSwapper(this.swapper);
            evictionEvent.setFilePageId(0L);
            evictionEvent.setException(new IOException("exception"));
            evictionEvent.close();
        }
        this.pageCursorTracer.unpin(0L, this.swapper);
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.pins());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.unpins());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.faults());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.evictions());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.evictionExceptions());
    }

    @Test
    void countFlushesAndBytesWritten() {
        try (PinEvent pinEvent = this.pageCursorTracer.beginPin(true, 0L, this.swapper);
             PinPageFaultEvent faultEvent = pinEvent.beginPageFault(3L, this.swapper);){
            EvictionEvent evictionEvent = faultEvent.beginEviction(0L);
            evictionEvent.setSwapper(this.swapper);
            try (FlushEvent flushEvent = evictionEvent.beginFlush(0L, this.swapper, this.referenceTranslator);){
                flushEvent.addBytesWritten(27L);
                flushEvent.addPagesMerged(10);
            }
            try (FlushEvent flushEvent1 = evictionEvent.beginFlush(1L, this.swapper, this.referenceTranslator);){
                flushEvent1.addBytesWritten(13L);
                flushEvent1.addPagesFlushed(2);
                flushEvent1.addPagesMerged(2);
            }
            evictionEvent.close();
        }
        this.pageCursorTracer.unpin(0L, this.swapper);
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.pins());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.unpins());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.faults());
        Assertions.assertEquals((long)1L, (long)this.pageCursorTracer.evictions());
        Assertions.assertEquals((long)2L, (long)this.pageCursorTracer.flushes());
        Assertions.assertEquals((long)12L, (long)this.pageCursorTracer.merges());
        Assertions.assertEquals((long)40L, (long)this.pageCursorTracer.bytesWritten());
    }

    @Test
    void reportCountersToPageCursorTracer() {
        this.generateEventSet();
        this.pageCursorTracer.reportEvents();
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.pins());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.unpins());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.faults());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.hits());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.noFaults());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.failedFaults());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.evictions());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.cooperativeEvictions());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.evictionExceptions());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.flushes());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.merges());
        Assertions.assertEquals((long)10L, (long)this.cacheTracer.bytesWritten());
        Assertions.assertEquals((long)150L, (long)this.cacheTracer.bytesRead());
        this.generateEventSet();
        this.generateEventSet();
        this.pageCursorTracer.reportEvents();
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.pins());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.unpins());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.faults());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.hits());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.noFaults());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.failedFaults());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.evictions());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.cooperativeEvictions());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.cooperativeEvictionFlushes());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.evictionExceptions());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.flushes());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.merges());
        Assertions.assertEquals((long)30L, (long)this.cacheTracer.bytesWritten());
        Assertions.assertEquals((long)450L, (long)this.cacheTracer.bytesRead());
    }

    @Test
    void closingTraceCursorReportEvents() {
        this.generateEventSet();
        this.pageCursorTracer.close();
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.pins());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.unpins());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.faults());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.hits());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.noFaults());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.failedFaults());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.evictions());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.cooperativeEvictions());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.cooperativeEvictionFlushes());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.evictionExceptions());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.flushes());
        Assertions.assertEquals((long)1L, (long)this.cacheTracer.merges());
        Assertions.assertEquals((long)10L, (long)this.cacheTracer.bytesWritten());
        Assertions.assertEquals((long)150L, (long)this.cacheTracer.bytesRead());
        this.generateEventSet();
        this.generateEventSet();
        this.pageCursorTracer.close();
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.pins());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.unpins());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.faults());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.hits());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.noFaults());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.failedFaults());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.evictions());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.cooperativeEvictions());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.cooperativeEvictionFlushes());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.evictionExceptions());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.flushes());
        Assertions.assertEquals((long)3L, (long)this.cacheTracer.merges());
        Assertions.assertEquals((long)30L, (long)this.cacheTracer.bytesWritten());
        Assertions.assertEquals((long)450L, (long)this.cacheTracer.bytesRead());
    }

    @Test
    void shouldCalculateHitRatio() {
        Assertions.assertEquals((double)0.0, (double)this.pageCursorTracer.hitRatio(), (double)1.0E-4);
        this.pinAndFault();
        Assertions.assertEquals((double)0.0, (double)this.pageCursorTracer.hitRatio(), (double)1.0E-4);
        this.pinAndHit();
        Assertions.assertEquals((double)0.5, (double)this.pageCursorTracer.hitRatio(), (double)1.0E-4);
        this.pinAndFault();
        this.pinAndFault();
        this.pinAndFault();
        this.pinAndHit();
        this.pinAndHit();
        Assertions.assertEquals((double)0.42857142857142855, (double)this.pageCursorTracer.hitRatio(), (double)1.0E-4);
        this.pageCursorTracer.reportEvents();
        Assertions.assertEquals((double)0.42857142857142855, (double)this.cacheTracer.hitRatio(), (double)1.0E-4);
    }

    @Test
    void pageCursorTracerHasDefinedTag() {
        Assertions.assertEquals((Object)TEST_TRACER, (Object)this.pageCursorTracer.getTag());
    }

    @Test
    void mergePageCursors() {
        PageCursorTracer tracer = this.createTracer();
        for (int i = 0; i < 5; ++i) {
            DummyPageSwapper dummyPageSwapper = new DummyPageSwapper("a", 4);
            try (PinEvent pinEvent = tracer.beginPin(false, 1L, (PageSwapper)dummyPageSwapper);){
                pinEvent.hit();
                pinEvent.noFault();
                try (PinPageFaultEvent pageFaultEvent = pinEvent.beginPageFault(1L, (PageSwapper)dummyPageSwapper);){
                    pageFaultEvent.addBytesRead(16L);
                    pageFaultEvent.setException(null);
                    try (EvictionEvent evictionEvent = pageFaultEvent.beginEviction(3L);){
                        evictionEvent.setSwapper((PageSwapper)dummyPageSwapper);
                        try (FlushEvent flushEvent = evictionEvent.beginFlush(1L, (PageSwapper)dummyPageSwapper, pageRef -> (int)pageRef);){
                            flushEvent.addPagesMerged(7);
                            flushEvent.addBytesWritten(17L);
                        }
                    }
                }
            }
            tracer.unpin(1L, (PageSwapper)dummyPageSwapper);
        }
        this.pageCursorTracer.merge(new CursorStatisticSnapshot(tracer));
        Assertions.assertEquals((long)5L, (long)this.pageCursorTracer.pins());
        Assertions.assertEquals((long)5L, (long)this.pageCursorTracer.unpins());
        Assertions.assertEquals((long)5L, (long)this.pageCursorTracer.evictions());
        Assertions.assertEquals((long)35L, (long)this.pageCursorTracer.merges());
        Assertions.assertEquals((long)5L, (long)this.pageCursorTracer.faults());
        Assertions.assertEquals((long)5L, (long)this.pageCursorTracer.noFaults());
        Assertions.assertEquals((long)5L, (long)this.pageCursorTracer.failedFaults());
        Assertions.assertEquals((long)80L, (long)this.pageCursorTracer.bytesRead());
        Assertions.assertEquals((long)85L, (long)this.pageCursorTracer.bytesWritten());
    }

    private void generateEventSet() {
        try (PinEvent pinEvent = this.pageCursorTracer.beginPin(false, 0L, this.swapper);){
            pinEvent.hit();
            pinEvent.noFault();
            try (PinPageFaultEvent pageFaultEvent = pinEvent.beginPageFault(4L, this.swapper);){
                pageFaultEvent.setException(null);
                pageFaultEvent.addBytesRead(150L);
                try (EvictionEvent evictionEvent = pageFaultEvent.beginEviction(0L);){
                    evictionEvent.setSwapper(this.swapper);
                    try (FlushEvent flushEvent = evictionEvent.beginFlush(0L, this.swapper, this.referenceTranslator);){
                        flushEvent.addBytesWritten(10L);
                        flushEvent.addEvictionFlushedPages(1);
                        flushEvent.addPagesMerged(1);
                    }
                    evictionEvent.setException(new IOException("eviction exception"));
                }
            }
        }
        this.pageCursorTracer.unpin(0L, this.swapper);
    }

    private PageCursorTracer createTracer() {
        DefaultPageCursorTracer tracer = new DefaultPageCursorTracer((PageCacheTracer)this.cacheTracer, TEST_TRACER);
        tracer.setIgnoreCounterCheck(true);
        return tracer;
    }

    private void pinAndHit() {
        try (PinEvent pinEvent = this.pageCursorTracer.beginPin(true, 0L, this.swapper);){
            pinEvent.hit();
        }
        this.pageCursorTracer.unpin(0L, this.swapper);
    }

    private void pinAndFault() {
        try (PinEvent pinEvent = this.pageCursorTracer.beginPin(true, 0L, this.swapper);
             PinPageFaultEvent fault = pinEvent.beginPageFault(0L, this.swapper);){
            fault.addBytesRead(0L);
        }
        this.pageCursorTracer.unpin(0L, this.swapper);
    }
}

