/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing.linear;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import org.neo4j.io.pagecache.impl.muninn.swapper.PageSwapper;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.PageReferenceTranslator;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.io.pagecache.tracing.PinPageFaultEvent;
import org.neo4j.io.pagecache.tracing.linear.LinearHistoryTracer;

class HEvents {
    private HEvents() {
    }

    public static abstract class IntervalHEvent
    extends HEvent {
        protected LinearHistoryTracer tracer;

        IntervalHEvent(LinearHistoryTracer tracer) {
            this.tracer = tracer;
        }

        public void close() {
            this.tracer.add(new EndHEvent(this));
        }
    }

    public static abstract class HEvent {
        static final HEvent end = new HEvent(){

            @Override
            void printBody(PrintStream out, String exceptionLinePrefix) {
                out.print(" EOF ");
            }
        };
        final long time = System.nanoTime();
        final long threadId;
        final String threadName;
        volatile HEvent prev;

        HEvent() {
            Thread thread = Thread.currentThread();
            this.threadId = thread.threadId();
            this.threadName = thread.getName();
            System.identityHashCode(this);
        }

        public static HEvent reverse(HEvent events) {
            HEvent current = end;
            while (events != end) {
                HEvent prev;
                while ((prev = events.prev) == null) {
                }
                events.prev = current;
                current = events;
                events = prev;
            }
            return current;
        }

        public void print(PrintStream out, String exceptionLinePrefix) {
            out.print(this.getClass().getSimpleName());
            out.print('#');
            out.print(System.identityHashCode(this));
            out.print('[');
            out.print("time:");
            out.print((this.time - HEvent.end.time) / 1000L);
            out.print(", threadId:");
            out.print(this.threadId);
            this.printBody(out, exceptionLinePrefix);
            out.print(']');
        }

        abstract void printBody(PrintStream var1, String var2);

        protected static void print(PrintStream out, Path file) {
            out.print(", file:");
            out.print(file == null ? "<null>" : file);
        }

        protected static void print(PrintStream out, Throwable exception, String linePrefix) {
            if (exception != null) {
                out.println(", exception:");
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                PrintStream sbuf = new PrintStream(buf);
                exception.printStackTrace(sbuf);
                sbuf.flush();
                BufferedReader reader = new BufferedReader(new StringReader(buf.toString()));
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        out.print(linePrefix);
                        out.print('\t');
                        out.println(line);
                        line = reader.readLine();
                    }
                    out.print(linePrefix);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static class EvictionHEvent
    extends IntervalHEvent
    implements EvictionEvent {
        private long filePageId;
        private Path path;
        private IOException exception;
        private final long cachePageId;

        EvictionHEvent(LinearHistoryTracer linearHistoryTracer, long cachePageId) {
            super(linearHistoryTracer);
            this.cachePageId = cachePageId;
        }

        public void setFilePageId(long filePageId) {
            this.filePageId = filePageId;
        }

        public void setSwapper(PageSwapper swapper) {
            this.path = swapper == null ? null : swapper.path();
        }

        public void setException(IOException exception) {
            this.exception = exception;
        }

        public FlushEvent beginFlush(long pageRef, PageSwapper swapper, PageReferenceTranslator pageReferenceTranslator) {
            return this.tracer.add(new FlushHEvent(this.tracer, new long[]{pageRef}, swapper, 1, 0));
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            out.print(", filePageId:");
            out.print(this.filePageId);
            out.print(", cachePageId:");
            out.print(this.cachePageId);
            EvictionHEvent.print(out, this.path);
            EvictionHEvent.print(out, this.exception, exceptionLinePrefix);
        }
    }

    public static class PinPageFaultHEvent
    extends IntervalHEvent
    implements PinPageFaultEvent {
        private int bytesRead;
        private long cachePageId;
        private boolean pageEvictedByFaulter;
        private Throwable exception;

        PinPageFaultHEvent(LinearHistoryTracer linearHistoryTracer) {
            super(linearHistoryTracer);
        }

        public void addBytesRead(long bytes) {
            this.bytesRead = (int)((long)this.bytesRead + bytes);
        }

        public void setCachePageId(long cachePageId) {
            this.cachePageId = cachePageId;
        }

        @Override
        public void close() {
            super.close();
        }

        public void setException(Throwable throwable) {
            this.exception = throwable;
        }

        public void freeListSize(int freeListSize) {
        }

        public EvictionEvent beginEviction(long cachePageId) {
            this.pageEvictedByFaulter = true;
            return this.tracer.add(new EvictionHEvent(this.tracer, cachePageId));
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            out.print(", cachePageId:");
            out.print(this.cachePageId);
            out.print(", bytesRead:");
            out.print(this.bytesRead);
            out.print(", pageEvictedByFaulter:");
            out.print(this.pageEvictedByFaulter);
            PinPageFaultHEvent.print(out, this.exception, exceptionLinePrefix);
        }
    }

    public static class PinHEvent
    extends IntervalHEvent
    implements PinEvent {
        private final boolean exclusiveLock;
        private final long filePageId;
        private final Path path;
        private long cachePageId;
        private boolean hit;

        PinHEvent(LinearHistoryTracer tracer, boolean exclusiveLock, long filePageId, PageSwapper swapper) {
            super(tracer);
            this.exclusiveLock = exclusiveLock;
            this.filePageId = filePageId;
            this.hit = true;
            this.path = swapper.path();
        }

        public void setCachePageId(long cachePageId) {
            this.cachePageId = cachePageId;
        }

        public PinPageFaultEvent beginPageFault(long filePageId, PageSwapper swapper) {
            this.hit = false;
            return this.tracer.add(new PinPageFaultHEvent(this.tracer));
        }

        public void noFault() {
        }

        public void snapshotsLoaded(int oldSnapshotsLoaded) {
        }

        public void hit() {
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            out.print(", filePageId:");
            out.print(this.filePageId);
            out.print(", cachePageId:");
            out.print(this.cachePageId);
            out.print(", hit:");
            out.print(this.hit);
            PinHEvent.print(out, this.path);
            out.append(", exclusiveLock:");
            out.print(this.exclusiveLock);
        }
    }

    public static class FileFlushHEvent
    extends IntervalHEvent
    implements FileFlushEvent {
        private final Path path;

        FileFlushHEvent(LinearHistoryTracer tracer, Path path) {
            super(tracer);
            this.path = path;
        }

        public FlushEvent beginFlush(long[] pageRefs, PageSwapper swapper, PageReferenceTranslator pageReferenceTranslator, int pagesToFlush, int mergedPages) {
            return this.tracer.add(new FlushHEvent(this.tracer, pageRefs, swapper, pagesToFlush, mergedPages));
        }

        public FlushEvent beginFlush(long pageRef, PageSwapper swapper, PageReferenceTranslator pageReferenceTranslator) {
            return this.tracer.add(new FlushHEvent(this.tracer, new long[]{pageRef}, swapper, 1, 0));
        }

        public void startFlush(int[][] translationTable) {
        }

        public void reset() {
        }

        public long ioPerformed() {
            return 0L;
        }

        public long limitedNumberOfTimes() {
            return 0L;
        }

        public long limitedMillis() {
            return 0L;
        }

        public long pagesFlushed() {
            return 0L;
        }

        public FileFlushEvent.ChunkEvent startChunk(int[] chunk) {
            return FileFlushEvent.ChunkEvent.NULL;
        }

        public void throttle(long recentlyCompletedIOs, long millis) {
        }

        public void reportIO(int completedIOs) {
        }

        public long localBytesWritten() {
            return 0L;
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            FileFlushHEvent.print(out, this.path);
        }
    }

    public static class FlushHEvent
    extends IntervalHEvent
    implements FlushEvent {
        private final long[] pageRefs;
        private final int pagesToFlush;
        private int pageMerged;
        private int pageCount;
        private final Path path;
        private int bytesWritten;
        private IOException exception;

        FlushHEvent(LinearHistoryTracer tracer, long[] pageRefs, PageSwapper swapper, int pagesToFlush, int pageMerged) {
            super(tracer);
            this.pageRefs = pageRefs;
            this.pagesToFlush = pagesToFlush;
            this.pageMerged = pageMerged;
            this.pageCount = 1;
            this.path = swapper.path();
        }

        public void addBytesWritten(long bytes) {
            this.bytesWritten = (int)((long)this.bytesWritten + bytes);
        }

        @Override
        public void close() {
            super.close();
        }

        public void setException(IOException exception) {
            this.exception = exception;
        }

        public void addPagesFlushed(int pageCount) {
            this.pageCount = pageCount;
        }

        public void addEvictionFlushedPages(int pageCount) {
            this.addPagesFlushed(pageCount);
        }

        public void addPagesMerged(int pagesMerged) {
            this.pageMerged = pagesMerged;
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            out.print(", pageRefs:");
            out.print(Arrays.toString(this.pageRefs));
            out.print(", pageCount:");
            out.print(this.pageCount);
            FlushHEvent.print(out, this.path);
            out.print(", bytesWritten:");
            out.print(this.bytesWritten);
            out.print(", pagesToFlush:");
            out.print(this.pagesToFlush);
            out.print(", PagesMerged:");
            out.print(this.pageMerged);
            FlushHEvent.print(out, this.exception, exceptionLinePrefix);
        }
    }

    public static class EvictionRunHEvent
    extends IntervalHEvent
    implements EvictionRunEvent {
        int pagesToEvict;

        EvictionRunHEvent(LinearHistoryTracer tracer, int pagesToEvict) {
            super(tracer);
            this.pagesToEvict = pagesToEvict;
        }

        public EvictionEvent beginEviction(long cachePageId) {
            return this.tracer.add(new EvictionHEvent(this.tracer, cachePageId));
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            out.print(", pagesToEvict:");
            out.print(this.pagesToEvict);
        }

        public void freeListSize(int size) {
        }
    }

    static class UnmappedFileHEvent
    extends HEvent {
        Path path;

        UnmappedFileHEvent(Path path) {
            this.path = path;
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            UnmappedFileHEvent.print(out, this.path);
        }
    }

    static class MappedFileHEvent
    extends HEvent {
        Path path;

        MappedFileHEvent(Path path) {
            this.path = path;
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            MappedFileHEvent.print(out, this.path);
        }
    }

    static final class EndHEvent
    extends HEvent {
        private static final Map<Class<?>, String> classSimpleNameCache = new IdentityHashMap();
        IntervalHEvent event;

        EndHEvent(IntervalHEvent event) {
            this.event = event;
        }

        @Override
        public void print(PrintStream out, String exceptionLinePrefix) {
            out.print('-');
            super.print(out, exceptionLinePrefix);
        }

        @Override
        void printBody(PrintStream out, String exceptionLinePrefix) {
            out.print(", elapsedMicros:");
            out.print((this.time - this.event.time) / 1000L);
            out.print(", endOf:");
            Class<?> eventClass = this.event.getClass();
            String className = classSimpleNameCache.computeIfAbsent(eventClass, k -> eventClass.getSimpleName());
            out.print(className);
            out.print('#');
            out.print(System.identityHashCode(this.event));
        }
    }
}

