/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.format.aligned.PageAligned;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.testdirectory.TestDirectoryExtension;
import org.neo4j.test.utils.TestDirectory;

@TestDirectoryExtension
public class DbFormatIT {
    @Inject
    TestDirectory directory;

    @Test
    void defaultCommunityFormat() throws IOException {
        String property = System.getProperty("NEO4J_OVERRIDE_STORE_FORMAT");
        String expectedFormat = property != null ? property : PageAligned.LATEST_NAME;
        try (DatabaseManagementService dbms = new TestDatabaseManagementServiceBuilder(this.directory.homePath()).build();){
            GraphDatabaseAPI db = (GraphDatabaseAPI)dbms.database("neo4j");
            this.verifyStoreFormat(db, expectedFormat);
        }
    }

    @Test
    void setFormatIsRespected() throws IOException {
        try (DatabaseManagementService dbms = new TestDatabaseManagementServiceBuilder(this.directory.homePath()).setConfig(GraphDatabaseSettings.db_format, (Object)Standard.LATEST_NAME).build();){
            GraphDatabaseAPI db = (GraphDatabaseAPI)dbms.database("neo4j");
            this.verifyStoreFormat(db, Standard.LATEST_NAME);
        }
    }

    protected void verifyStoreFormat(GraphDatabaseAPI db, String expectedFormat) throws IOException {
        DependencyResolver dependencyResolver = db.getDependencyResolver();
        PageCache pageCache = (PageCache)dependencyResolver.resolveDependency(PageCache.class);
        StorageEngineFactory storageEngineFactory = (StorageEngineFactory)dependencyResolver.resolveDependency(StorageEngineFactory.class);
        StoreId storeId = storageEngineFactory.retrieveStoreId(this.directory.getFileSystem(), db.databaseLayout(), pageCache, CursorContext.NULL_CONTEXT);
        Assertions.assertEquals((Object)expectedFormat, (Object)storeId.getFormatName());
    }
}

