/*
 * Decompiled with CFR 0.152.
 */
package db;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.function.Supplier;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.module.CommunityEditionModule;
import org.neo4j.graphdb.factory.module.DataSourceModule;
import org.neo4j.graphdb.factory.module.EditionModule;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.DelegatingPageCache;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.lifecycle.LifecycleStatus;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.EphemeralFileSystemRule;

public class DatabaseShutdownTest {
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory(this.getClass(), (FileSystemAbstraction)this.fs.get());

    @Test
    public void shouldShutdownCorrectlyWhenCheckPointingOnShutdownFails() throws Exception {
        TestGraphDatabaseFactoryWithFailingPageCacheFlush factory = new TestGraphDatabaseFactoryWithFailingPageCacheFlush();
        try {
            factory.newEmbeddedDatabase(this.testDirectory.graphDbDir()).shutdown();
            Assert.fail((String)"Should have thrown");
        }
        catch (LifecycleException ex) {
            Assert.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)factory.getNeoStoreDataSourceStatus());
        }
    }

    private static class TestGraphDatabaseFactoryWithFailingPageCacheFlush
    extends TestGraphDatabaseFactory {
        private NeoStoreDataSource neoStoreDataSource;

        private TestGraphDatabaseFactoryWithFailingPageCacheFlush() {
        }

        protected GraphDatabaseService newEmbeddedDatabase(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
            return new GraphDatabaseFacadeFactory(DatabaseInfo.COMMUNITY, CommunityEditionModule::new){

                protected DataSourceModule createDataSource(PlatformModule platformModule, EditionModule editionModule, Supplier<QueryExecutionEngine> queryEngine, Procedures procedures) {
                    DataSourceModule dataSource = new DataSourceModule(platformModule, editionModule, queryEngine, procedures);
                    neoStoreDataSource = dataSource.neoStoreDataSource;
                    return dataSource;
                }

                protected PlatformModule createPlatform(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade) {
                    return new PlatformModule(storeDir, config, this.databaseInfo, dependencies, graphDatabaseFacade){

                        protected PageCache createPageCache(FileSystemAbstraction fileSystem, Config config, LogService logging, Tracers tracers, VersionContextSupplier versionContextSupplier) {
                            PageCache pageCache = super.createPageCache(fileSystem, config, logging, tracers, versionContextSupplier);
                            return new DelegatingPageCache(pageCache){

                                public void flushAndForce(IOLimiter ioLimiter) throws IOException {
                                    throw new IOException("Boom!");
                                }
                            };
                        }
                    };
                }
            }.newFacade(storeDir, config, dependencies);
        }

        LifecycleStatus getNeoStoreDataSourceStatus() throws NoSuchFieldException, IllegalAccessException {
            Field f = this.neoStoreDataSource.getClass().getDeclaredField("life");
            f.setAccessible(true);
            LifeSupport life = (LifeSupport)f.get(this.neoStoreDataSource);
            return life.getStatus();
        }
    }
}

