/*
 * Decompiled with CFR 0.152.
 */
package db;

import java.io.File;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public class DatabaseStartupTest {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();

    @Test
    public void startTheDatabaseWithWrongVersionShouldFailWithUpgradeNotAllowed() throws Throwable {
        File storeDir = this.testDirectory.storeDir();
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir);
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        db.shutdown();
        var4_5 = null;
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
             PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fileSystem);){
            MetaDataStore.setRecord((PageCache)pageCache, (File)new File(this.testDirectory.databaseDir(), "neostore"), (MetaDataStore.Position)MetaDataStore.Position.STORE_VERSION, (long)MetaDataStore.versionStringToLong((String)"bad"));
        }
        catch (Throwable throwable) {
            var4_5 = throwable;
            throw throwable;
        }
        try {
            new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir);
            Assert.fail((String)"It should have failed.");
        }
        catch (RuntimeException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof LifecycleException));
            Assert.assertTrue((boolean)(ex.getCause().getCause() instanceof IllegalArgumentException));
            Assert.assertEquals((Object)"Unknown store version 'bad'", (Object)ex.getCause().getCause().getMessage());
        }
    }

    @Test
    public void startTheDatabaseWithWrongVersionShouldFailAlsoWhenUpgradeIsAllowed() throws Throwable {
        File storeDir = this.testDirectory.storeDir();
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabase(storeDir);
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        db.shutdown();
        String badStoreVersion = "bad";
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
             PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fileSystem);){
            MetaDataStore.setRecord((PageCache)pageCache, (File)new File(this.testDirectory.databaseDir(), "neostore"), (MetaDataStore.Position)MetaDataStore.Position.STORE_VERSION, (long)MetaDataStore.versionStringToLong((String)badStoreVersion));
        }
        try {
            new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDir).setConfig(GraphDatabaseSettings.allow_upgrade, "true").newGraphDatabase();
            Assert.fail((String)"It should have failed.");
        }
        catch (RuntimeException ex) {
            Assert.assertTrue((boolean)(ex.getCause() instanceof LifecycleException));
            Assert.assertTrue((boolean)(ex.getCause().getCause() instanceof StoreUpgrader.UnexpectedUpgradingStoreVersionException));
        }
    }
}

