/*
 * Decompiled with CFR 0.152.
 */
package upgrade;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.store.StoreAssertions;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Exceptions;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_3;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

@RunWith(value=Parameterized.class)
public class StoreUpgradeOnStartupTest {
    private final TestDirectory testDir = TestDirectory.testDirectory();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testDir).around((TestRule)this.fileSystemRule).around((TestRule)this.pageCacheRule);
    @Parameterized.Parameter(value=0)
    public String version;
    private FileSystemAbstraction fileSystem;
    private File workingDatabaseDirectory;
    private StoreVersionCheck check;
    private File workingStoreDir;

    @Parameterized.Parameters(name="{0}")
    public static Collection<String> versions() {
        return Collections.singletonList(StandardV2_3.STORE_VERSION);
    }

    @Before
    public void setup() throws IOException {
        this.fileSystem = this.fileSystemRule.get();
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fileSystem);
        this.workingStoreDir = this.testDir.storeDir("working_" + this.version);
        this.workingDatabaseDirectory = this.testDir.databaseDir(this.workingStoreDir);
        this.check = new StoreVersionCheck(pageCache);
        File prepareDirectory = this.testDir.directory("prepare_" + this.version);
        MigrationTestUtils.prepareSampleLegacyDatabase((String)this.version, (FileSystemAbstraction)this.fileSystem, (File)this.workingDatabaseDirectory, (File)prepareDirectory);
    }

    @Test
    public void shouldUpgradeAutomaticallyOnDatabaseStartup() throws ConsistencyCheckIncompleteException {
        GraphDatabaseService database = this.createGraphDatabaseService();
        database.shutdown();
        Assert.assertTrue((String)"Some store files did not have the correct version", (boolean)MigrationTestUtils.checkNeoStoreHasDefaultFormatVersion((StoreVersionCheck)this.check, (File)this.workingDatabaseDirectory));
        StoreAssertions.assertConsistentStore((File)this.workingDatabaseDirectory);
    }

    @Test
    public void shouldAbortOnNonCleanlyShutdown() throws Throwable {
        MigrationTestUtils.removeCheckPointFromTxLog((FileSystemAbstraction)this.fileSystem, (File)this.workingDatabaseDirectory);
        try {
            GraphDatabaseService database = this.createGraphDatabaseService();
            database.shutdown();
            Assert.fail((String)"Should have been unable to start upgrade on old version");
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)Exceptions.rootCause((Throwable)e), (Matcher)Matchers.instanceOf(StoreUpgrader.UnableToUpgradeException.class));
        }
    }

    private GraphDatabaseService createGraphDatabaseService() {
        return new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.workingStoreDir).setConfig(GraphDatabaseSettings.allow_upgrade, "true").newGraphDatabase();
    }
}

