/*
 * Decompiled with CFR 0.152.
 */
package upgrade;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.neo4j.consistency.checking.full.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.store.StoreAssertions;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.logging.NullLogService;
import org.neo4j.kernel.impl.store.format.standard.Standard;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_3;
import org.neo4j.kernel.impl.storemigration.MigrationTestUtils;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.monitoring.SilentMigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.participant.SchemaIndexMigrator;
import org.neo4j.kernel.impl.storemigration.participant.StoreMigrator;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.impl.util.monitoring.ProgressReporter;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.PageCacheRule;
import org.neo4j.test.rule.TestDirectory;
import org.neo4j.test.rule.fs.DefaultFileSystemRule;

@RunWith(value=Parameterized.class)
public class StoreUpgraderInterruptionTestIT {
    private final TestDirectory directory = TestDirectory.testDirectory();
    private final DefaultFileSystemRule fileSystemRule = new DefaultFileSystemRule();
    private final PageCacheRule pageCacheRule = new PageCacheRule();
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.directory).around((TestRule)this.fileSystemRule).around((TestRule)this.pageCacheRule);
    @Parameterized.Parameter
    public String version;
    private static final Config CONFIG = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (String)"8m");
    private File workingDirectory;
    private final FileSystemAbstraction fs = this.fileSystemRule.get();
    private File workingDatabaseDirectory;
    private File prepareDirectory;

    @Parameterized.Parameters(name="{0}")
    public static Collection<String> versions() {
        return Collections.singletonList(StandardV2_3.STORE_VERSION);
    }

    @Before
    public void setUpLabelScanStore() {
        this.workingDirectory = this.directory.storeDir("working");
        this.workingDatabaseDirectory = this.directory.databaseDir(this.workingDirectory);
        this.prepareDirectory = this.directory.directory("prepare");
    }

    @Test
    public void shouldSucceedWithUpgradeAfterPreviousAttemptDiedDuringMigration() throws IOException, ConsistencyCheckIncompleteException {
        MigrationTestUtils.prepareSampleLegacyDatabase((String)this.version, (FileSystemAbstraction)this.fs, (File)this.workingDatabaseDirectory, (File)this.prepareDirectory);
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        StoreVersionCheck check = new StoreVersionCheck(pageCache);
        UpgradableDatabase upgradableDatabase = this.getUpgradableDatabase(check);
        SilentMigrationProgressMonitor progressMonitor = new SilentMigrationProgressMonitor();
        NullLogService logService = NullLogService.getInstance();
        StoreMigrator failingStoreMigrator = new StoreMigrator(this.fs, pageCache, CONFIG, (LogService)logService){

            public void migrate(File sourceStoreDir, File targetStoreDir, ProgressReporter progressReporter, String versionToMigrateFrom, String versionToMigrateTo) throws IOException {
                super.migrate(sourceStoreDir, targetStoreDir, progressReporter, versionToMigrateFrom, versionToMigrateTo);
                throw new RuntimeException("This upgrade is failing");
            }
        };
        try {
            this.newUpgrader(upgradableDatabase, pageCache, (MigrationProgressMonitor)progressMonitor, this.createIndexMigrator(), failingStoreMigrator).migrateIfNeeded(this.workingDatabaseDirectory);
            Assert.fail((String)"Should throw exception");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"This upgrade is failing", (Object)e.getMessage());
        }
        progressMonitor = new SilentMigrationProgressMonitor();
        StoreMigrator migrator = new StoreMigrator(this.fs, pageCache, CONFIG, (LogService)logService);
        SchemaIndexMigrator indexMigrator = this.createIndexMigrator();
        this.newUpgrader(upgradableDatabase, pageCache, (MigrationProgressMonitor)progressMonitor, indexMigrator, migrator).migrateIfNeeded(this.workingDatabaseDirectory);
        Assert.assertTrue((boolean)MigrationTestUtils.checkNeoStoreHasDefaultFormatVersion((StoreVersionCheck)check, (File)this.workingDatabaseDirectory));
        StoreUpgraderInterruptionTestIT.startStopDatabase(this.workingDirectory);
        StoreAssertions.assertConsistentStore((File)this.workingDatabaseDirectory);
    }

    private UpgradableDatabase getUpgradableDatabase(StoreVersionCheck check) throws IOException {
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader();
        LogFiles logFiles = LogFilesBuilder.logFilesBasedOnlyBuilder((File)this.workingDatabaseDirectory, (FileSystemAbstraction)this.fs).build();
        LogTailScanner tailScanner = new LogTailScanner(logFiles, (LogEntryReader)logEntryReader, new Monitors());
        return new UpgradableDatabase(check, Standard.LATEST_RECORD_FORMATS, tailScanner);
    }

    private SchemaIndexMigrator createIndexMigrator() {
        return new SchemaIndexMigrator(this.fs, IndexProvider.EMPTY);
    }

    @Test
    public void shouldSucceedWithUpgradeAfterPreviousAttemptDiedDuringMovingFiles() throws IOException, ConsistencyCheckIncompleteException {
        MigrationTestUtils.prepareSampleLegacyDatabase((String)this.version, (FileSystemAbstraction)this.fs, (File)this.workingDatabaseDirectory, (File)this.prepareDirectory);
        PageCache pageCache = this.pageCacheRule.getPageCache(this.fs);
        StoreVersionCheck check = new StoreVersionCheck(pageCache);
        UpgradableDatabase upgradableDatabase = this.getUpgradableDatabase(check);
        SilentMigrationProgressMonitor progressMonitor = new SilentMigrationProgressMonitor();
        NullLogService logService = NullLogService.getInstance();
        StoreMigrator failingStoreMigrator = new StoreMigrator(this.fs, pageCache, CONFIG, (LogService)logService){

            public void moveMigratedFiles(File migrationDir, File storeDir, String versionToUpgradeFrom, String versionToMigrateTo) throws IOException {
                super.moveMigratedFiles(migrationDir, storeDir, versionToUpgradeFrom, versionToMigrateTo);
                throw new RuntimeException("This upgrade is failing");
            }
        };
        try {
            this.newUpgrader(upgradableDatabase, pageCache, (MigrationProgressMonitor)progressMonitor, this.createIndexMigrator(), failingStoreMigrator).migrateIfNeeded(this.workingDatabaseDirectory);
            Assert.fail((String)"Should throw exception");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)"This upgrade is failing", (Object)e.getMessage());
        }
        Assert.assertTrue((boolean)MigrationTestUtils.checkNeoStoreHasDefaultFormatVersion((StoreVersionCheck)check, (File)this.workingDatabaseDirectory));
        progressMonitor = new SilentMigrationProgressMonitor();
        StoreMigrator migrator = new StoreMigrator(this.fs, pageCache, CONFIG, (LogService)logService);
        this.newUpgrader(upgradableDatabase, pageCache, (MigrationProgressMonitor)progressMonitor, this.createIndexMigrator(), migrator).migrateIfNeeded(this.workingDatabaseDirectory);
        Assert.assertTrue((boolean)MigrationTestUtils.checkNeoStoreHasDefaultFormatVersion((StoreVersionCheck)check, (File)this.workingDatabaseDirectory));
        pageCache.close();
        StoreUpgraderInterruptionTestIT.startStopDatabase(this.workingDirectory);
        StoreAssertions.assertConsistentStore((File)this.workingDatabaseDirectory);
    }

    private StoreUpgrader newUpgrader(UpgradableDatabase upgradableDatabase, PageCache pageCache, MigrationProgressMonitor progressMonitor, SchemaIndexMigrator indexMigrator, StoreMigrator migrator) {
        Config allowUpgrade = Config.defaults((Setting)GraphDatabaseSettings.allow_upgrade, (String)"true");
        StoreUpgrader upgrader = new StoreUpgrader(upgradableDatabase, progressMonitor, allowUpgrade, this.fs, pageCache, (LogProvider)NullLogProvider.getInstance());
        upgrader.addParticipant((StoreMigrationParticipant)indexMigrator);
        upgrader.addParticipant((StoreMigrationParticipant)migrator);
        return upgrader;
    }

    private static void startStopDatabase(File storeDir) {
        GraphDatabaseService databaseService = new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(storeDir).setConfig(GraphDatabaseSettings.allow_upgrade, "true").newGraphDatabase();
        databaseService.shutdown();
    }
}

