/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx.impl;

import javax.management.Attribute;
import javax.management.AttributeList;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.jmx.impl.ConfigurationBean;
import org.neo4j.jmx.impl.JmxKernelExtension;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;

public class ConfigurationBeanIT {
    private static GraphDatabaseService graphdb;

    @BeforeClass
    public static void startDb() {
        graphdb = new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().newGraphDatabase();
    }

    @AfterClass
    public static void stopDb() {
        if (graphdb != null) {
            graphdb.shutdown();
        }
        graphdb = null;
    }

    @Test
    public void durationListedWithUnit() {
        ConfigurationBean configurationBean = (ConfigurationBean)((JmxKernelExtension)((GraphDatabaseAPI)graphdb).getDependencyResolver().resolveDependency(JmxKernelExtension.class)).getSingleManagementBean(ConfigurationBean.class);
        Object v = configurationBean.getAttribute(GraphDatabaseSettings.log_queries_threshold.name());
        Assert.assertEquals((Object)"0ms", (Object)v);
        AttributeList attrs = configurationBean.getAttributes(new String[]{GraphDatabaseSettings.log_queries_threshold.name()});
        Assert.assertEquals((long)1L, (long)attrs.size());
        Attribute attr = (Attribute)attrs.get(0);
        Assert.assertEquals((Object)"0ms", (Object)attr.getValue());
        Assert.assertEquals((Object)"dbms.logs.query.threshold = 0ms", (Object)attr.toString());
    }
}

