/*
 * Decompiled with CFR 0.152.
 */
package db;

import java.io.File;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.DelegatingPageCache;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.lifecycle.LifecycleStatus;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.extension.EphemeralFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={EphemeralFileSystemExtension.class, TestDirectoryExtension.class})
class DatabaseShutdownTest {
    @Inject
    private TestDirectory testDirectory;

    DatabaseShutdownTest() {
    }

    @Test
    void shouldShutdownCorrectlyWhenCheckPointingOnShutdownFails() {
        TestGraphDatabaseFactoryWithFailingPageCacheFlush factory = new TestGraphDatabaseFactoryWithFailingPageCacheFlush();
        Assertions.assertThrows(LifecycleException.class, () -> factory.newEmbeddedDatabase(this.testDirectory.storeDir()).shutdown());
        Assertions.assertEquals((Object)LifecycleStatus.SHUTDOWN, (Object)factory.getNeoStoreDataSourceStatus());
    }

    private static class TestGraphDatabaseFactoryWithFailingPageCacheFlush
    extends TestGraphDatabaseFactory {
        private LifeSupport life;

        private TestGraphDatabaseFactoryWithFailingPageCacheFlush() {
        }

        protected GraphDatabaseService newEmbeddedDatabase(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
            return new GraphDatabaseFacadeFactory(DatabaseInfo.COMMUNITY, CommunityEditionModule::new){

                protected PlatformModule createPlatform(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
                    PlatformModule platformModule = new PlatformModule(storeDir, config, this.databaseInfo, dependencies){

                        protected PageCache createPageCache(FileSystemAbstraction fileSystem, Config config, LogService logging, Tracers tracers, VersionContextSupplier versionContextSupplier, JobScheduler jobScheduler) {
                            PageCache pageCache = super.createPageCache(fileSystem, config, logging, tracers, versionContextSupplier, jobScheduler);
                            return new DelegatingPageCache(pageCache){

                                public void flushAndForce(IOLimiter ioLimiter) throws IOException {
                                    throw new IOException("Boom!");
                                }
                            };
                        }
                    };
                    life = platformModule.life;
                    return platformModule;
                }
            }.newFacade(storeDir, config, dependencies);
        }

        LifecycleStatus getNeoStoreDataSourceStatus() {
            return this.life.getStatus();
        }
    }
}

