/*
 * Decompiled with CFR 0.152.
 */
package files;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.SystemUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.os.OsBeanUtil;
import org.neo4j.test.rule.EmbeddedDatabaseRule;

public class TestNoFileDescriptorLeaks {
    private static final AtomicInteger counter = new AtomicInteger();
    @Rule
    public EmbeddedDatabaseRule db = new EmbeddedDatabaseRule();

    @BeforeClass
    public static void beforeClass() {
        Assume.assumeFalse((boolean)SystemUtils.IS_OS_WINDOWS);
        Assume.assumeThat((Object)OsBeanUtil.getOpenFileDescriptors(), (Matcher)Matchers.not((Object)-1L));
    }

    @Test
    public void mustNotLeakFileDescriptorsFromMerge() {
        try (Transaction tx = this.db.beginTx();){
            this.db.execute("create constraint on (n:Node) assert n.id is unique");
            tx.success();
        }
        this.cycleMerge(1);
        long initialFDs = OsBeanUtil.getOpenFileDescriptors();
        this.cycleMerge(300);
        long finalFDs = OsBeanUtil.getOpenFileDescriptors();
        long upperBoundFDs = initialFDs + 50L;
        Assert.assertThat((Object)finalFDs, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(upperBoundFDs)));
    }

    private void cycleMerge(int iterations) {
        for (int i = 0; i < iterations; ++i) {
            try (Transaction tx = this.db.beginTx();){
                this.db.execute("MERGE (a:Node {id: {a}}) MERGE (b:Node {id: {b}}) MERGE (c:Node {id: {c}}) MERGE (d:Node {id: {d}}) MERGE (e:Node {id: {e}}) MERGE (f:Node {id: {f}}) ", MapUtil.map((Object[])new Object[]{"a", TestNoFileDescriptorLeaks.nextId() % 100, "b", TestNoFileDescriptorLeaks.nextId() % 100, "c", TestNoFileDescriptorLeaks.nextId() % 100, "d", TestNoFileDescriptorLeaks.nextId(), "e", TestNoFileDescriptorLeaks.nextId(), "f", TestNoFileDescriptorLeaks.nextId()}));
                this.db.execute("MERGE (n:Node {id: {a}}) ", MapUtil.map((Object[])new Object[]{"a", TestNoFileDescriptorLeaks.nextId() % 100}));
                this.db.execute("MERGE (n:Node {id: {a}}) ", MapUtil.map((Object[])new Object[]{"a", TestNoFileDescriptorLeaks.nextId() % 100}));
                this.db.execute("MERGE (n:Node {id: {a}}) ", MapUtil.map((Object[])new Object[]{"a", TestNoFileDescriptorLeaks.nextId() % 100}));
                this.db.execute("MERGE (n:Node {id: {a}}) ", MapUtil.map((Object[])new Object[]{"a", TestNoFileDescriptorLeaks.nextId()}));
                this.db.execute("MERGE (n:Node {id: {a}}) ", MapUtil.map((Object[])new Object[]{"a", TestNoFileDescriptorLeaks.nextId()}));
                this.db.execute("MERGE (n:Node {id: {a}}) ", MapUtil.map((Object[])new Object[]{"a", TestNoFileDescriptorLeaks.nextId()}));
                tx.success();
                continue;
            }
        }
    }

    private static int nextId() {
        return counter.incrementAndGet();
    }
}

