/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.DelegatingPageSwapper;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.impl.scheduler.JobSchedulerFactory;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.rule.TestDirectory;

public class MuninnPageCursorTest {
    @Rule
    public final TestDirectory directory = TestDirectory.testDirectory();
    private final LifeSupport life = new LifeSupport();
    private JobScheduler jobScheduler;

    @Before
    public void start() {
        this.jobScheduler = JobSchedulerFactory.createScheduler();
        this.life.add((Lifecycle)this.jobScheduler);
        this.life.start();
    }

    @After
    public void stop() {
        this.life.shutdown();
    }

    @Test
    public void shouldUnlockLatchOnPageFaultingWhenConcurrentlyCursorClosedThrowOnPageFaultRead() throws IOException {
        this.shouldUnlockLatchOnPageFaultingWhenConcurrentlyCursorClosed(true);
    }

    @Test
    public void shouldUnlockLatchOnPageFaultingWhenConcurrentlyCursorClosedDontThrowOnPageFaultRead() throws IOException {
        this.shouldUnlockLatchOnPageFaultingWhenConcurrentlyCursorClosed(false);
    }

    private void shouldUnlockLatchOnPageFaultingWhenConcurrentlyCursorClosed(boolean alsoThrowOnPageFaultRead) throws IOException {
        File file = this.directory.file("dude");
        this.createSomeData(file);
        AtomicReference<PageCursor> cursorHolder = new AtomicReference<PageCursor>();
        Runnable onReadAction = () -> {
            PageCursor cursor = (PageCursor)cursorHolder.get();
            if (cursor != null) {
                cursor.close();
                if (alsoThrowOnPageFaultRead) {
                    throw new RuntimeException();
                }
            }
        };
        try (PageCache pageCache = this.startPageCache(this.customSwapper(this.defaultPageSwapperFactory(), onReadAction));
             PagedFile pagedFile = pageCache.map(file, 8192, new OpenOption[]{StandardOpenOption.CREATE});){
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                cursorHolder.set(cursor);
                Assertions.assertThrows(NullPointerException.class, () -> ((PageCursor)cursor).next());
                cursorHolder.set(null);
            }
            cursor = pagedFile.io(0L, 2);
            var10_14 = null;
            try {
                for (int i = 0; i < 100; ++i) {
                    cursor.next((long)i);
                    for (int j = 0; j < 100; ++j) {
                        Assertions.assertEquals((long)j, (long)cursor.getLong());
                    }
                }
            }
            catch (Throwable throwable) {
                var10_14 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var10_14 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var10_14.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
        }
    }

    private PageCache startPageCache(PageSwapperFactory pageSwapperFactory) {
        return new MuninnPageCache(pageSwapperFactory, 1000, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, EmptyVersionContextSupplier.EMPTY, this.jobScheduler);
    }

    private void createSomeData(File file) throws IOException {
        try (PageCache pageCache = this.startPageCache(this.defaultPageSwapperFactory());
             PagedFile pagedFile = pageCache.map(file, 8192, new OpenOption[]{StandardOpenOption.CREATE});
             PageCursor cursor = pagedFile.io(0L, 2);){
            for (int i = 0; i < 100; ++i) {
                cursor.next((long)i);
                for (int j = 0; j < 100; ++j) {
                    cursor.putLong((long)j);
                }
            }
        }
    }

    private PageSwapperFactory customSwapper(final PageSwapperFactory actual, final Runnable onRead) {
        return new PageSwapperFactory(){

            public void open(FileSystemAbstraction fs, Configuration config) {
                actual.open(fs, config);
            }

            public String implementationName() {
                return actual.implementationName();
            }

            public long getRequiredBufferAlignment() {
                return actual.getRequiredBufferAlignment();
            }

            public PageSwapper createPageSwapper(File file, int filePageSize, PageEvictionCallback onEviction, boolean createIfNotExist, boolean noChannelStriping) throws IOException {
                PageSwapper actualSwapper = actual.createPageSwapper(file, filePageSize, onEviction, createIfNotExist, noChannelStriping);
                return new DelegatingPageSwapper(actualSwapper){

                    public long read(long filePageId, long bufferAddress, int bufferSize) throws IOException {
                        onRead.run();
                        return super.read(filePageId, bufferAddress, bufferSize);
                    }
                };
            }

            public void syncDevice() {
                actual.syncDevice();
            }

            public void close() {
                actual.close();
            }
        };
    }

    private PageSwapperFactory defaultPageSwapperFactory() {
        SingleFilePageSwapperFactory swapperFactory = new SingleFilePageSwapperFactory();
        swapperFactory.open(this.directory.getFileSystem(), null);
        return swapperFactory;
    }
}

