/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jmx;

import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.jmx.Description;
import org.neo4j.jmx.Kernel;
import org.neo4j.jmx.impl.JmxKernelExtension;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;

public class DescriptionTest {
    private static GraphDatabaseService graphdb;

    @BeforeClass
    public static void startDb() {
        graphdb = new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().newGraphDatabase();
    }

    @AfterClass
    public static void stopDb() {
        if (graphdb != null) {
            graphdb.shutdown();
        }
        graphdb = null;
    }

    @Test
    public void canGetBeanDescriptionFromMBeanInterface() throws Exception {
        Assert.assertEquals((Object)Kernel.class.getAnnotation(Description.class).value(), (Object)this.kernelMBeanInfo().getDescription());
    }

    @Test
    public void canGetMethodDescriptionFromMBeanInterface() throws Exception {
        for (MBeanAttributeInfo attr : this.kernelMBeanInfo().getAttributes()) {
            try {
                Assert.assertEquals((Object)Kernel.class.getMethod("get" + attr.getName(), new Class[0]).getAnnotation(Description.class).value(), (Object)attr.getDescription());
            }
            catch (NoSuchMethodException ignored) {
                Assert.assertEquals((Object)Kernel.class.getMethod("is" + attr.getName(), new Class[0]).getAnnotation(Description.class).value(), (Object)attr.getDescription());
            }
        }
    }

    private MBeanInfo kernelMBeanInfo() throws Exception {
        Kernel kernel = (Kernel)((JmxKernelExtension)((GraphDatabaseAPI)graphdb).getDependencyResolver().resolveDependency(JmxKernelExtension.class)).getSingleManagementBean(Kernel.class);
        ObjectName query = kernel.getMBeanQuery();
        Hashtable<String, String> properties = new Hashtable<String, String>(query.getKeyPropertyList());
        properties.put("name", "Kernel");
        return ManagementFactory.getPlatformMBeanServer().getMBeanInfo(new ObjectName(query.getDomain(), properties));
    }
}

