/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.security.auth;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.StubResourceManager;
import org.neo4j.kernel.api.security.AnonymousContext;
import org.neo4j.kernel.impl.api.integrationtest.KernelIntegrationTest;

public class AuthProceduresTest
extends KernelIntegrationTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private final ResourceTracker resourceTracker = new StubResourceManager();

    @Test
    public void shouldFailWhenDeprecatedChangePasswordWithStaticAccessModeInDbmsMode() throws Throwable {
        Object[] inputArray = new Object[]{"newPassword"};
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Anonymous cannot change password");
        this.dbmsOperations().procedureCallDbms(ProcedureSignature.procedureName((String[])new String[]{"dbms", "changePassword"}), inputArray, this.dependencyResolver, AnonymousContext.none().authorize(s -> -1, "graph.db"), this.resourceTracker, ProcedureCallContext.EMPTY);
    }

    @Test
    public void shouldFailWhenChangePasswordWithStaticAccessModeInDbmsMode() throws Throwable {
        Object[] inputArray = new Object[]{"newPassword"};
        this.exception.expect(ProcedureException.class);
        this.exception.expectMessage("Anonymous cannot change password");
        this.dbmsOperations().procedureCallDbms(ProcedureSignature.procedureName((String[])new String[]{"dbms", "security", "changePassword"}), inputArray, this.dependencyResolver, AnonymousContext.none().authorize(s -> -1, "graph.db"), this.resourceTracker, ProcedureCallContext.EMPTY);
    }

    protected GraphDatabaseBuilder configure(GraphDatabaseBuilder graphDatabaseBuilder) {
        graphDatabaseBuilder.setConfig(GraphDatabaseSettings.auth_enabled, "true");
        return graphDatabaseBuilder;
    }
}

