/*
 * Decompiled with CFR 0.152.
 */
package db;

import java.io.File;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.StandalonePageCacheFactory;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.scheduler.ThreadPoolJobScheduler;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.extension.TestDirectoryExtension;
import org.neo4j.test.rule.TestDirectory;

@ExtendWith(value={TestDirectoryExtension.class})
class DatabaseStartupTest {
    @Inject
    private TestDirectory testDirectory;

    DatabaseStartupTest() {
    }

    @Test
    void startTheDatabaseWithWrongVersionShouldFailWithUpgradeNotAllowed() throws Throwable {
        File databaseDir = this.testDirectory.databaseDir();
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabase(databaseDir);
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        db.shutdown();
        var4_4 = null;
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
             ThreadPoolJobScheduler scheduler = new ThreadPoolJobScheduler();
             PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fileSystem, (JobScheduler)scheduler);){
            MetaDataStore.setRecord((PageCache)pageCache, (File)this.testDirectory.databaseLayout().metadataStore(), (MetaDataStore.Position)MetaDataStore.Position.STORE_VERSION, (long)MetaDataStore.versionStringToLong((String)"bad"));
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> new TestGraphDatabaseFactory().newEmbeddedDatabase(databaseDir));
        Assertions.assertTrue((boolean)(exception.getCause() instanceof LifecycleException));
        Assertions.assertTrue((boolean)(exception.getCause().getCause() instanceof IllegalArgumentException));
        Assertions.assertEquals((Object)"Unknown store version 'bad'", (Object)exception.getCause().getCause().getMessage());
    }

    @Test
    void startTheDatabaseWithWrongVersionShouldFailAlsoWhenUpgradeIsAllowed() throws Throwable {
        File databaseDirectory = this.testDirectory.databaseDir();
        GraphDatabaseService db = new TestGraphDatabaseFactory().newEmbeddedDatabase(databaseDirectory);
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        db.shutdown();
        String badStoreVersion = "bad";
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();
             ThreadPoolJobScheduler scheduler = new ThreadPoolJobScheduler();
             PageCache pageCache = StandalonePageCacheFactory.createPageCache((FileSystemAbstraction)fileSystem, (JobScheduler)scheduler);){
            MetaDataStore.setRecord((PageCache)pageCache, (File)this.testDirectory.databaseLayout().metadataStore(), (MetaDataStore.Position)MetaDataStore.Position.STORE_VERSION, (long)MetaDataStore.versionStringToLong((String)badStoreVersion));
        }
        RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> new TestGraphDatabaseFactory().newEmbeddedDatabaseBuilder(databaseDirectory).setConfig(GraphDatabaseSettings.allow_upgrade, "true").newGraphDatabase());
        Assertions.assertTrue((boolean)(exception.getCause() instanceof LifecycleException));
        Assertions.assertTrue((boolean)(exception.getCause().getCause() instanceof StoreUpgrader.UnexpectedUpgradingStoreVersionException));
    }

    @Test
    void startTestDatabaseOnProvidedNonAbsoluteFile() {
        File directory = new File("notAbsoluteDirectory");
        new TestGraphDatabaseFactory().newImpermanentDatabase(directory).shutdown();
    }

    @Test
    void startCommunityDatabaseOnProvidedNonAbsoluteFile() {
        File directory = new File("notAbsoluteDirectory");
        EphemeralCommunityFacadeFactory factory = new EphemeralCommunityFacadeFactory();
        EphemeralGraphDatabaseFactory databaseFactory = new EphemeralGraphDatabaseFactory(factory);
        GraphDatabaseService service = databaseFactory.newEmbeddedDatabase(directory);
        service.shutdown();
    }

    private static class EphemeralGraphDatabaseFactory
    extends GraphDatabaseFactory {
        private final EphemeralCommunityFacadeFactory factory;

        EphemeralGraphDatabaseFactory(EphemeralCommunityFacadeFactory factory) {
            this.factory = factory;
        }

        protected GraphDatabaseFacadeFactory getGraphDatabaseFacadeFactory() {
            return this.factory;
        }
    }

    private static class EphemeralCommunityFacadeFactory
    extends GraphDatabaseFacadeFactory {
        EphemeralCommunityFacadeFactory() {
            super(DatabaseInfo.COMMUNITY, CommunityEditionModule::new);
        }

        protected PlatformModule createPlatform(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
            return new PlatformModule(storeDir, config, this.databaseInfo, dependencies){

                protected FileSystemAbstraction createFileSystemAbstraction() {
                    return new EphemeralFileSystemAbstraction();
                }
            };
        }
    }
}

