/*
 * Decompiled with CFR 0.152.
 */
package db;

import java.io.File;
import java.util.function.LongSupplier;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.facade.GraphDatabaseDependencies;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.factory.module.edition.CommunityEditionModule;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContext;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.context.TransactionVersionContext;
import org.neo4j.kernel.impl.context.TransactionVersionContextSupplier;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.rule.TestDirectory;

public class QueryRestartIT {
    @Rule
    public final TestDirectory testDirectory = TestDirectory.testDirectory();
    private GraphDatabaseService database;
    private TestTransactionVersionContextSupplier testContextSupplier;
    private File storeDir;
    private TestVersionContext testCursorContext;

    @Before
    public void setUp() {
        this.storeDir = this.testDirectory.directory();
        this.testContextSupplier = new TestTransactionVersionContextSupplier();
        this.database = this.startSnapshotQueryDb();
        this.createData();
        this.testCursorContext = this.testCursorContext();
        this.testContextSupplier.setCursorContext((VersionContext)this.testCursorContext);
    }

    @After
    public void tearDown() {
        if (this.database != null) {
            this.database.shutdown();
        }
    }

    @Test
    public void executeQueryWithoutRestarts() {
        this.testCursorContext.setWrongLastClosedTxId(false);
        Result result = this.database.execute("MATCH (n:label) RETURN n.c");
        while (result.hasNext()) {
            Assert.assertEquals((Object)"d", result.next().get("n.c"));
        }
        Assert.assertEquals((long)0L, (long)this.testCursorContext.getAdditionalAttempts());
    }

    @Test
    public void executeQueryWithSingleRetry() {
        Result result = this.database.execute("MATCH (n) RETURN n.c");
        Assert.assertEquals((long)1L, (long)this.testCursorContext.getAdditionalAttempts());
        while (result.hasNext()) {
            Assert.assertEquals((Object)"d", result.next().get("n.c"));
        }
    }

    @Test
    public void executeCountStoreQueryWithSingleRetry() {
        Result result = this.database.execute("MATCH (n:toRetry) RETURN count(n)");
        Assert.assertEquals((long)1L, (long)this.testCursorContext.getAdditionalAttempts());
        while (result.hasNext()) {
            Assert.assertEquals((Object)1L, result.next().get("count(n)"));
        }
    }

    @Test
    public void executeLabelScanQueryWithSingleRetry() {
        Result result = this.database.execute("MATCH (n:toRetry) RETURN n.c");
        Assert.assertEquals((long)1L, (long)this.testCursorContext.getAdditionalAttempts());
        while (result.hasNext()) {
            Assert.assertEquals((Object)"d", result.next().get("n.c"));
        }
    }

    @Test
    public void queryThatModifyDataAndSeeUnstableSnapshotThrowException() {
        try {
            this.database.execute("MATCH (n:toRetry) CREATE () RETURN n.c");
        }
        catch (QueryExecutionException e) {
            Assert.assertEquals((Object)"Unable to get clean data snapshot for query 'MATCH (n:toRetry) CREATE () RETURN n.c' that perform updates.", (Object)e.getMessage());
        }
    }

    private GraphDatabaseService startSnapshotQueryDb() {
        return new CustomGraphDatabaseFactory(new CustomFacadeFactory()).newEmbeddedDatabaseBuilder(this.storeDir).setConfig(GraphDatabaseSettings.snapshot_query, "true").newGraphDatabase();
    }

    private void createData() {
        Label label = Label.label((String)"toRetry");
        try (Transaction transaction = this.database.beginTx();){
            Node node = this.database.createNode(new Label[]{label});
            node.setProperty("c", (Object)"d");
            transaction.success();
        }
    }

    private TestVersionContext testCursorContext() {
        TransactionIdStore transactionIdStore = this.getTransactionIdStore();
        return new TestVersionContext(() -> ((TransactionIdStore)transactionIdStore).getLastClosedTransactionId());
    }

    private TransactionIdStore getTransactionIdStore() {
        DependencyResolver dependencyResolver = ((GraphDatabaseAPI)this.database).getDependencyResolver();
        return (TransactionIdStore)dependencyResolver.resolveDependency(TransactionIdStore.class);
    }

    private class TestTransactionVersionContextSupplier
    extends TransactionVersionContextSupplier {
        private TestTransactionVersionContextSupplier() {
        }

        void setCursorContext(VersionContext versionContext) {
            this.cursorContext.set(versionContext);
        }
    }

    private class TestVersionContext
    extends TransactionVersionContext {
        private boolean wrongLastClosedTxId;
        private int additionalAttempts;

        TestVersionContext(LongSupplier transactionIdSupplier) {
            super(transactionIdSupplier);
            this.wrongLastClosedTxId = true;
        }

        public long lastClosedTransactionId() {
            return this.wrongLastClosedTxId ? 1L : super.lastClosedTransactionId();
        }

        public void markAsDirty() {
            super.markAsDirty();
            this.wrongLastClosedTxId = false;
        }

        void setWrongLastClosedTxId(boolean wrongLastClosedTxId) {
            this.wrongLastClosedTxId = wrongLastClosedTxId;
        }

        public boolean isDirty() {
            boolean dirty = super.isDirty();
            if (dirty) {
                ++this.additionalAttempts;
            }
            return dirty;
        }

        int getAdditionalAttempts() {
            return this.additionalAttempts;
        }
    }

    private class CustomFacadeFactory
    extends GraphDatabaseFacadeFactory {
        CustomFacadeFactory() {
            super(DatabaseInfo.COMMUNITY, CommunityEditionModule::new);
        }

        protected PlatformModule createPlatform(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies) {
            return new PlatformModule(storeDir, config, this.databaseInfo, dependencies){

                protected VersionContextSupplier createCursorContextSupplier(Config config) {
                    return QueryRestartIT.this.testContextSupplier != null ? QueryRestartIT.this.testContextSupplier : super.createCursorContextSupplier(config);
                }
            };
        }
    }

    private class CustomGraphDatabaseFactory
    extends TestGraphDatabaseFactory {
        private GraphDatabaseFacadeFactory customFacadeFactory;

        CustomGraphDatabaseFactory(GraphDatabaseFacadeFactory customFacadeFactory) {
            this.customFacadeFactory = customFacadeFactory;
        }

        protected GraphDatabaseBuilder.DatabaseCreator createDatabaseCreator(final File storeDir, final GraphDatabaseFactoryState state) {
            return new GraphDatabaseBuilder.DatabaseCreator(){

                public GraphDatabaseService newDatabase(Config config) {
                    return CustomGraphDatabaseFactory.this.customFacadeFactory.newFacade(storeDir, config, (GraphDatabaseFacadeFactory.Dependencies)GraphDatabaseDependencies.newDependencies((GraphDatabaseFacadeFactory.Dependencies)state.databaseDependencies()));
                }
            };
        }
    }
}

