/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.randomharness;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.randomharness.Record;
import org.neo4j.io.pagecache.randomharness.RecordFormat;

public class PageCountRecordFormat
extends RecordFormat {
    @Override
    public int getRecordSize() {
        return 16;
    }

    @Override
    public Record createRecord(File file, int recordId) {
        return new PageCountRecord(recordId, this.getRecordSize());
    }

    @Override
    public Record readRecord(PageCursor cursor) throws IOException {
        int offset = cursor.getOffset();
        byte[] bytes = new byte[this.getRecordSize()];
        do {
            cursor.setOffset(offset);
            cursor.getBytes(bytes);
        } while (cursor.shouldRetry());
        return new PageCountRecord(bytes);
    }

    @Override
    public Record zeroRecord() {
        return new PageCountRecord(0, this.getRecordSize());
    }

    @Override
    public void write(Record record, PageCursor cursor) {
        PageCountRecord r = (PageCountRecord)record;
        int shorts = this.getRecordSize() / 2;
        for (int i = 0; i < shorts; ++i) {
            cursor.putShort(r.getRecordId());
        }
    }

    private static final class PageCountRecord
    implements Record {
        private final byte[] bytes;
        private final ByteBuffer buf;

        PageCountRecord(int recordId, int recordSize) {
            if (recordId > Short.MAX_VALUE) {
                throw new IllegalArgumentException("Record ID greater than Short.MAX_VALUE: " + recordId);
            }
            if (recordSize < 2) {
                throw new IllegalArgumentException("Record size must be positive: " + recordSize);
            }
            if (recordSize % 2 != 0) {
                throw new IllegalArgumentException("Record size must be even: " + recordSize);
            }
            this.bytes = new byte[recordSize];
            this.buf = ByteBuffer.wrap(this.bytes);
            for (int i = 0; i < this.bytes.length; i += 2) {
                this.buf.putShort((short)recordId);
            }
        }

        PageCountRecord(byte[] bytes) {
            if (bytes.length == 0) {
                throw new IllegalArgumentException("Bytes cannot be empty");
            }
            if (bytes.length % 2 != 0) {
                throw new IllegalArgumentException("Record size must be even: " + bytes.length);
            }
            byte first = bytes[0];
            for (byte b : bytes) {
                if (b == first) continue;
                throw new IllegalArgumentException("All bytes must be the same: " + Arrays.toString(bytes));
            }
            this.bytes = bytes;
            this.buf = ByteBuffer.wrap(bytes);
        }

        public short getRecordId() {
            return this.buf.getShort(0);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PageCountRecord that = (PageCountRecord)o;
            return Arrays.equals(this.bytes, that.bytes);
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }

        public String toString() {
            return "PageCountRecord[bytes=" + Arrays.toString(this.bytes) + "]";
        }
    }
}

