/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.ArrayUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Test;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.DelegatingFileSystemAbstraction;
import org.neo4j.io.fs.DelegatingStoreChannel;
import org.neo4j.io.fs.EphemeralFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.DelegatingPageSwapper;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.PageCacheTestSupport;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.FileIsNotMappedException;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.randomharness.Record;
import org.neo4j.io.pagecache.randomharness.StandardRecordFormat;
import org.neo4j.io.pagecache.tracing.ConfigurablePageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.DefaultPageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PinEvent;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.test.ThreadTestUtils;
import org.neo4j.test.matchers.ByteArrayMatcher;
import org.neo4j.util.concurrent.BinaryLatch;

public abstract class PageCacheTest<T extends PageCache>
extends PageCacheTestSupport<T> {
    protected OpenOption[] openOptions = new OpenOption[0];

    protected PagedFile map(PageCache pageCache, File file, int filePageSize, OpenOption ... options) throws IOException {
        return pageCache.map(file, filePageSize, (OpenOption[])ArrayUtils.addAll((Object[])this.openOptions, (Object[])options));
    }

    protected PagedFile map(File file, int filePageSize, OpenOption ... options) throws IOException {
        return this.map(this.pageCache, file, filePageSize, options);
    }

    @Test
    void mustReportConfiguredMaxPages() {
        this.configureStandardPageCache();
        MatcherAssert.assertThat((Object)this.pageCache.maxCachedPages(), (Matcher)Matchers.is((Object)this.maxPages));
    }

    @Test
    void mustReportConfiguredCachePageSize() {
        this.configureStandardPageCache();
        MatcherAssert.assertThat((Object)this.pageCache.pageSize(), (Matcher)Matchers.is((Object)this.pageCachePageSize));
    }

    @Test
    void mustHaveAtLeastTwoPages() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.getPageCache(this.fs, 1, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL));
    }

    @Test
    void mustAcceptTwoPagesAsMinimumConfiguration() {
        this.getPageCache(this.fs, 2, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL);
    }

    @Test
    void gettingNameFromMappedFileMustMatchMappedFileName() throws Exception {
        this.configureStandardPageCache();
        File file = this.file("a");
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);){
            MatcherAssert.assertThat((Object)pf.file(), (Matcher)Matchers.equalTo((Object)file));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void mustClosePageSwapperFactoryOnPageCacheClose() throws Exception {
        block12: {
            final AtomicBoolean closed = new AtomicBoolean();
            SingleFilePageSwapperFactory swapperFactory = new SingleFilePageSwapperFactory(){

                public void close() {
                    closed.set(true);
                }
            };
            Object cache = this.createPageCache((PageSwapperFactory)swapperFactory, this.maxPages, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, EmptyVersionContextSupplier.EMPTY);
            Exception exception = null;
            try {
                Assertions.assertFalse((boolean)closed.get());
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                try {
                    cache.close();
                    Assertions.assertTrue((boolean)closed.get());
                }
                catch (Exception e) {
                    if (exception == null) {
                        exception = e;
                    }
                    exception.addSuppressed(e);
                }
                if (exception == null) break block12;
                throw exception;
            }
        }
    }

    @Test
    void closingOfPageCacheMustBeConsideredSuccessfulEvenIfPageSwapperFactoryCloseThrows() {
        final AtomicInteger closed = new AtomicInteger();
        SingleFilePageSwapperFactory swapperFactory = new SingleFilePageSwapperFactory(){

            public void close() {
                closed.getAndIncrement();
                throw new RuntimeException("boo");
            }
        };
        Object cache = this.createPageCache((PageSwapperFactory)swapperFactory, this.maxPages, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, EmptyVersionContextSupplier.EMPTY);
        Exception exception = (Exception)Assertions.assertThrows(Exception.class, () -> cache.close());
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"boo"));
        cache.close();
    }

    @Test
    void mustReadExistingData() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
            int recordId = 0;
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pagedFile.io(0L, 1);){
                while (cursor.next()) {
                    this.verifyRecordsMatchExpected(cursor);
                    recordId += this.recordsPerFilePage;
                }
            }
            MatcherAssert.assertThat((Object)recordId, (Matcher)Matchers.is((Object)this.recordCount));
        });
    }

    @Test
    void mustScanInTheMiddleOfTheFile() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            long startPage = 10L;
            long endPage = this.recordCount / this.recordsPerFilePage - 10;
            this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
            int recordId = (int)(startPage * (long)this.recordsPerFilePage);
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pagedFile.io(startPage, 1);){
                while (cursor.next() && cursor.getCurrentPageId() < endPage) {
                    this.verifyRecordsMatchExpected(cursor);
                    recordId += this.recordsPerFilePage;
                }
            }
            MatcherAssert.assertThat((Object)recordId, (Matcher)Matchers.is((Object)(this.recordCount - 10 * this.recordsPerFilePage)));
        });
    }

    @Test
    void writesFlushedFromPageFileMustBeExternallyObservable() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
            long startPageId = 0L;
            long endPageId = this.recordCount / this.recordsPerFilePage;
            try (PageCursor cursor = pagedFile.io(startPageId, 2);){
                while (cursor.getCurrentPageId() < endPageId && cursor.next()) {
                    this.writeRecords(cursor);
                }
            }
            pagedFile.flushAndForce();
            this.verifyRecordsInFile(this.file("a"), this.recordCount);
            pagedFile.close();
        });
    }

    @Test
    void pageCacheFlushAndForceMustThrowOnNullIOPSLimiter() {
        this.configureStandardPageCache();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.pageCache.flushAndForce(null));
    }

    @Test
    void pagedFileFlushAndForceMustThrowOnNullIOPSLimiter() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            Assertions.assertThrows(IllegalArgumentException.class, () -> pf.flushAndForce(null));
        }
    }

    @Test
    void pageCacheFlushAndForceMustQueryTheGivenIOPSLimiter() throws Exception {
        int pagesToDirty = 10000;
        Object cache = this.getPageCache(this.fs, Numbers.ceilingPowerOfTwo((int)(2 * pagesToDirty)), PageCacheTracer.NULL, PageCursorTracerSupplier.NULL);
        PagedFile pfA = cache.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);
        PagedFile pfB = cache.map(this.existingFile("b"), this.filePageSize, new OpenOption[0]);
        this.dirtyManyPages(pfA, pagesToDirty);
        this.dirtyManyPages(pfB, pagesToDirty);
        AtomicInteger callbackCounter = new AtomicInteger();
        AtomicInteger ioCounter = new AtomicInteger();
        cache.flushAndForce((previousStamp, recentlyCompletedIOs, swapper) -> {
            ioCounter.addAndGet(recentlyCompletedIOs);
            return callbackCounter.getAndIncrement();
        });
        pfA.close();
        pfB.close();
        MatcherAssert.assertThat((Object)callbackCounter.get(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)ioCounter.get(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(pagesToDirty * 2 - 30)));
    }

    @Test
    void pagedFileFlushAndForceMustQueryTheGivenIOPSLimiter() throws Exception {
        int pagesToDirty = 10000;
        Object cache = this.getPageCache(this.fs, Numbers.ceilingPowerOfTwo((int)pagesToDirty), PageCacheTracer.NULL, PageCursorTracerSupplier.NULL);
        PagedFile pf = cache.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        this.dirtyManyPages(pf, pagesToDirty);
        AtomicInteger callbackCounter = new AtomicInteger();
        AtomicInteger ioCounter = new AtomicInteger();
        pf.flushAndForce((previousStamp, recentlyCompletedIOs, swapper) -> {
            ioCounter.addAndGet(recentlyCompletedIOs);
            return callbackCounter.getAndIncrement();
        });
        pf.close();
        MatcherAssert.assertThat((Object)callbackCounter.get(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)ioCounter.get(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(pagesToDirty - 30)));
    }

    private void dirtyManyPages(PagedFile pf, int pagesToDirty) throws IOException {
        try (PageCursor cursor = pf.io(0L, 2);){
            for (int i = 0; i < pagesToDirty; ++i) {
                Assertions.assertTrue((boolean)cursor.next());
            }
        }
    }

    @Test
    void writesFlushedFromPageFileMustBeObservableEvenWhenRacingWithEviction() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.LONG_TIMEOUT_MILLIS), () -> {
            this.getPageCache(this.fs, 20, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL);
            long startPageId = 0L;
            long endPageId = 21L;
            int iterations = 500;
            int shortsPerPage = this.pageCachePageSize / 2;
            try (PagedFile pagedFile = this.map(this.file("a"), this.pageCachePageSize, new OpenOption[0]);){
                for (int i = 1; i <= iterations; ++i) {
                    int j;
                    try (PageCursor cursor = pagedFile.io(startPageId, 2);){
                        while (cursor.getCurrentPageId() < endPageId && cursor.next()) {
                            for (j = 0; j < shortsPerPage; ++j) {
                                cursor.putShort((short)i);
                            }
                        }
                    }
                    pagedFile.flushAndForce();
                    try (DataInputStream stream = new DataInputStream(this.fs.openAsInputStream(this.file("a")));){
                        for (j = 0; j < shortsPerPage; ++j) {
                            short value = stream.readShort();
                            MatcherAssert.assertThat((String)("short pos = " + j + ", iteration = " + i), (Object)value, (Matcher)Matchers.is((Object)i));
                        }
                        continue;
                    }
                }
            }
        });
    }

    @Test
    void flushAndForceMustNotLockPageCacheForWholeDuration() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.maxPages = 5000;
            this.configureStandardPageCache();
            File a = this.existingFile("a");
            File b = this.existingFile("b");
            try (PagedFile pfA = this.map(this.pageCache, a, this.filePageSize, new OpenOption[0]);){
                try (PageCursor cursor = pfA.io(0L, 2);){
                    for (int i = 0; i < this.maxPages; ++i) {
                        Assertions.assertTrue((boolean)cursor.next());
                    }
                }
                BinaryLatch limiterStartLatch = new BinaryLatch();
                BinaryLatch limiterBlockLatch = new BinaryLatch();
                Future<Object> flusher = executor.submit(() -> {
                    this.pageCache.flushAndForce((stamp, ios, flushable) -> {
                        limiterStartLatch.release();
                        limiterBlockLatch.await();
                        return 0L;
                    });
                    return null;
                });
                limiterStartLatch.await();
                this.map(this.pageCache, b, this.filePageSize, new OpenOption[0]).close();
                this.pageCache.listExistingMappings();
                this.pageCache.getExistingMapping(a).ifPresent(PagedFile::close);
                limiterBlockLatch.release();
                flusher.get();
            }
        });
    }

    @Test
    void flushAndForceMustTolerateAsynchronousFileUnmapping() throws Exception {
        Future<Object> flusher;
        this.configureStandardPageCache();
        File a = this.existingFile("a");
        File b = this.existingFile("b");
        File c = this.existingFile("c");
        BinaryLatch limiterStartLatch = new BinaryLatch();
        BinaryLatch limiterBlockLatch = new BinaryLatch();
        try (PagedFile pfA = this.map(this.pageCache, a, this.filePageSize, new OpenOption[0]);
             PagedFile pfB = this.map(this.pageCache, b, this.filePageSize, new OpenOption[0]);
             PagedFile pfC = this.map(this.pageCache, c, this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pfA.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
            }
            cursor = pfB.io(0L, 2);
            try {
                Assertions.assertTrue((boolean)cursor.next());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            cursor = pfC.io(0L, 2);
            try {
                Assertions.assertTrue((boolean)cursor.next());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            flusher = executor.submit(() -> {
                this.pageCache.flushAndForce((stamp, ios, flushable) -> {
                    limiterStartLatch.release();
                    limiterBlockLatch.await();
                    return 0L;
                });
                return null;
            });
            limiterStartLatch.await();
        }
        limiterBlockLatch.release();
        flusher.get();
    }

    @Test
    void writesFlushedFromPageCacheMustBeExternallyObservable() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            long startPageId = 0L;
            long endPageId = this.recordCount / this.recordsPerFilePage;
            File file = this.file("a");
            try (PagedFile pagedFile = this.map(file, this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pagedFile.io(startPageId, 2);){
                while (cursor.getCurrentPageId() < endPageId && cursor.next()) {
                    this.writeRecords(cursor);
                }
            }
            this.verifyRecordsInFile(file, this.recordCount);
        });
    }

    @Test
    void writesToPagesMustNotBleedIntoAdjacentPages() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pagedFile.io(0L, 2);){
                for (int i = 1; i <= 100; ++i) {
                    Assertions.assertTrue((boolean)cursor.next());
                    for (int j = 0; j < this.filePageSize; ++j) {
                        cursor.putByte((byte)i);
                    }
                }
            }
            InputStream inputStream = this.fs.openAsInputStream(this.file("a"));
            for (int i = 1; i <= 100; ++i) {
                for (int j = 0; j < this.filePageSize; ++j) {
                    MatcherAssert.assertThat((Object)inputStream.read(), (Matcher)Matchers.is((Object)i));
                }
            }
            inputStream.close();
        });
    }

    @Test
    void channelMustBeForcedAfterPagedFileFlushAndForce() throws Exception {
        AtomicInteger writeCounter = new AtomicInteger();
        AtomicInteger forceCounter = new AtomicInteger();
        DelegatingFileSystemAbstraction fs = this.writeAndForceCountingFs(writeCounter, forceCounter);
        this.getPageCache((FileSystemAbstraction)fs, this.maxPages, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL);
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
                Assertions.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
            }
            pagedFile.flushAndForce();
            MatcherAssert.assertThat((Object)writeCounter.get(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
            MatcherAssert.assertThat((Object)forceCounter.get(), (Matcher)Matchers.is((Object)1));
        }
    }

    @Test
    void channelsMustBeForcedAfterPageCacheFlushAndForce() throws Exception {
        AtomicInteger writeCounter = new AtomicInteger();
        AtomicInteger forceCounter = new AtomicInteger();
        DelegatingFileSystemAbstraction fs = this.writeAndForceCountingFs(writeCounter, forceCounter);
        this.getPageCache((FileSystemAbstraction)fs, this.maxPages, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL);
        try (PagedFile pagedFileA = this.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);
             PagedFile pagedFileB = this.map(this.existingFile("b"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFileA.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
                Assertions.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
            }
            cursor = pagedFileB.io(0L, 2);
            try {
                Assertions.assertTrue((boolean)cursor.next());
                cursor.putInt(1);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            this.pageCache.flushAndForce();
            MatcherAssert.assertThat((Object)writeCounter.get(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(3)));
            MatcherAssert.assertThat((Object)forceCounter.get(), (Matcher)Matchers.is((Object)2));
        }
    }

    private DelegatingFileSystemAbstraction writeAndForceCountingFs(final AtomicInteger writeCounter, final AtomicInteger forceCounter) {
        return new DelegatingFileSystemAbstraction(this.fs){

            public StoreChannel write(File fileName) throws IOException {
                return new DelegatingStoreChannel(super.write(fileName)){

                    public void writeAll(ByteBuffer src, long position) throws IOException {
                        writeCounter.getAndIncrement();
                        super.writeAll(src, position);
                    }

                    public void force(boolean metaData) throws IOException {
                        forceCounter.getAndIncrement();
                        super.force(metaData);
                    }
                };
            }
        };
    }

    @Test
    void firstNextCallMustReturnFalseWhenTheFileIsEmptyAndNoGrowIsSpecified() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pagedFile.io(0L, 6);){
                Assertions.assertFalse((boolean)cursor.next());
            }
        });
    }

    @Test
    void nextMustReturnTrueThenFalseWhenThereIsOnlyOnePageInTheFileAndNoGrowIsSpecified() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            int numberOfRecordsToGenerate = this.recordsPerFilePage;
            this.generateFileWithRecords(this.file("a"), numberOfRecordsToGenerate, this.recordSize);
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pagedFile.io(0L, 6);){
                Assertions.assertTrue((boolean)cursor.next());
                this.verifyRecordsMatchExpected(cursor);
                Assertions.assertFalse((boolean)cursor.next());
            }
        });
    }

    @Test
    void closingWithoutCallingNextMustLeavePageUnpinnedAndUntouched() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            int numberOfRecordsToGenerate = this.recordsPerFilePage;
            this.generateFileWithRecords(this.file("a"), numberOfRecordsToGenerate, this.recordSize);
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
                PageCursor ignore = pagedFile.io(0L, 2);
                if (ignore != null) {
                    ignore.close();
                }
                try (PageCursor cursor = pagedFile.io(0L, 1);){
                    cursor.next();
                    this.verifyRecordsMatchExpected(cursor);
                }
            }
        });
    }

    @Test
    void nextWithNegativeInitialPageIdMustReturnFalse() throws Exception {
        this.configureStandardPageCache();
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordCount, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pf.io(-1L, 2);){
                Assertions.assertFalse((boolean)cursor.next());
            }
            cursor = pf.io(-1L, 1);
            try {
                Assertions.assertFalse((boolean)cursor.next());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void nextWithNegativePageIdMustReturnFalse() throws Exception {
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordCount, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);){
            long pageId = 12L;
            try (PageCursor cursor = pf.io(pageId, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertFalse((boolean)cursor.next(-1L));
                MatcherAssert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)-1L));
            }
            cursor = pf.io(pageId, 1);
            try {
                Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertFalse((boolean)cursor.next(-1L));
                MatcherAssert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)-1L));
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void rewindMustStartScanningOverFromTheBeginning() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            int numberOfRewindsToTest = 10;
            this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
            int actualPageCounter = 0;
            int filePageCount = this.recordCount / this.recordsPerFilePage;
            int expectedPageCounterResult = numberOfRewindsToTest * filePageCount;
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pagedFile.io(0L, 1);){
                for (int i = 0; i < numberOfRewindsToTest; ++i) {
                    while (cursor.next()) {
                        this.verifyRecordsMatchExpected(cursor);
                        ++actualPageCounter;
                    }
                    cursor.rewind();
                }
            }
            MatcherAssert.assertThat((Object)actualPageCounter, (Matcher)Matchers.is((Object)expectedPageCounterResult));
        });
    }

    @Test
    void mustCloseFileChannelWhenTheLastHandleIsUnmapped() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            Assumptions.assumeTrue((this.fs.getClass() == EphemeralFileSystemAbstraction.class ? 1 : 0) != 0, (String)"This depends on EphemeralFSA specific features");
            this.configureStandardPageCache();
            PagedFile a = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
            PagedFile b = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
            a.close();
            b.close();
            ((EphemeralFileSystemAbstraction)this.fs).assertNoOpenFiles();
        });
    }

    @Test
    void dirtyPagesMustBeFlushedWhenTheCacheIsClosed() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            long startPageId = 0L;
            long endPageId = this.recordCount / this.recordsPerFilePage;
            File file = this.file("a");
            try (PagedFile pagedFile = this.map(file, this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pagedFile.io(startPageId, 2);){
                while (cursor.getCurrentPageId() < endPageId && cursor.next()) {
                    this.writeRecords(cursor);
                }
            }
            finally {
                this.pageCache.close();
            }
            this.verifyRecordsInFile(file, this.recordCount);
        });
    }

    @Test
    void dirtyPagesMustBeFlushedWhenThePagedFileIsClosed() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            long startPageId = 0L;
            long endPageId = this.recordCount / this.recordsPerFilePage;
            File file = this.file("a");
            try (PagedFile pagedFile = this.map(file, this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pagedFile.io(startPageId, 2);){
                while (cursor.getCurrentPageId() < endPageId && cursor.next()) {
                    this.writeRecords(cursor);
                }
            }
            this.verifyRecordsInFile(file, this.recordCount);
        });
    }

    @RepeatedTest(value=100)
    void flushingDuringPagedFileCloseMustRetryUntilItSucceeds() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

                public StoreChannel open(File fileName, Set<OpenOption> options) throws IOException {
                    return new DelegatingStoreChannel(super.open(fileName, options)){
                        private int writeCount;

                        public void writeAll(ByteBuffer src, long position) throws IOException {
                            if (this.writeCount++ < 10) {
                                throw new IOException("This is a benign exception that we expect to be thrown during a flush of a PagedFile.");
                            }
                            super.writeAll(src, position);
                        }
                    };
                }
            };
            this.getPageCache((FileSystemAbstraction)fs, this.maxPages, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL);
            PrintStream oldSystemErr = System.err;
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pf.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                this.writeRecords(cursor);
                System.setErr(new PrintStream(new ByteArrayOutputStream()));
            }
            finally {
                System.setErr(oldSystemErr);
            }
            this.verifyRecordsInFile(this.file("a"), this.recordsPerFilePage);
        });
    }

    @Test
    void mappingFilesInClosedCacheMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.pageCache.close();
            Assertions.assertThrows(IllegalStateException.class, () -> this.map(this.file("a"), this.filePageSize, new OpenOption[0]));
        });
    }

    @Test
    void flushingClosedCacheMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.pageCache.close();
            Assertions.assertThrows(IllegalStateException.class, () -> this.pageCache.flushAndForce());
        });
    }

    @Test
    void mappingFileWithPageSizeGreaterThanCachePageSizeMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.map(this.file("a"), this.pageCachePageSize + 1, new OpenOption[0]));
        });
    }

    @Test
    void mappingFileWithPageSizeSmallerThanLongSizeBytesMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.map(this.file("a"), 7, new OpenOption[0]));
        });
    }

    @Test
    void mappingFileWithPageSizeSmallerThanLongSizeBytesMustThrowEvenWithAnyPageSizeOpenOptionAndNoExistingMapping() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            Assertions.assertThrows(IllegalArgumentException.class, () -> this.map(this.file("a"), 7, new OpenOption[]{PageCacheOpenOptions.ANY_PAGE_SIZE}));
        });
    }

    @Test
    void mappingFileWithPageZeroPageSizeMustThrowEvenWithExistingMapping() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            File file = this.file("a");
            try (PagedFile oldMapping = this.map(file, this.filePageSize, new OpenOption[0]);){
                Assertions.assertThrows(IllegalArgumentException.class, () -> this.map(file, 7, new OpenOption[0]));
            }
        });
    }

    @Test
    void mappingFileWithPageZeroPageSizeAndAnyPageSizeOpenOptionMustNotThrowGivenExistingMapping() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            File file = this.file("a");
            try (PagedFile oldMapping = this.map(file, this.filePageSize, new OpenOption[0]);){
                PagedFile newMapping = this.map(file, 0, new OpenOption[]{PageCacheOpenOptions.ANY_PAGE_SIZE});
                if (newMapping != null) {
                    newMapping.close();
                }
            }
        });
    }

    @Test
    void mappingFileWithPageSizeEqualToCachePageSizeMustNotThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            PagedFile pagedFile = this.map(this.file("a"), this.pageCachePageSize, new OpenOption[0]);
            pagedFile.close();
        });
    }

    @Test
    void flushAndForceAfterCloseAndEvictionMustNotGetStuckOnEvictedPages() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            PagedFile pagedFile = this.pageCache.map(this.file("a"), this.pageCachePageSize, new OpenOption[0]);
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                for (int i = 0; i < 20; ++i) {
                    cursor.next();
                    this.writeRecords(cursor);
                }
            }
            pagedFile.close();
            try (PagedFile b = this.pageCache.map(this.existingFile("b"), this.pageCachePageSize, new OpenOption[0]);
                 PageCursor cursor = b.io(0L, 2);){
                for (int i = 0; i < 200; ++i) {
                    cursor.next();
                }
            }
            pagedFile.flushAndForce();
        });
    }

    @Test
    void notSpecifyingAnyPfFlagsMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
                Assertions.assertThrows(IllegalArgumentException.class, () -> pagedFile.io(0L, 0));
            }
        });
    }

    @Test
    void notSpecifyingAnyPfLockFlagsMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
                Assertions.assertThrows(IllegalArgumentException.class, () -> pagedFile.io(0L, 16));
            }
        });
    }

    @Test
    void specifyingBothReadAndWriteLocksMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
                Assertions.assertThrows(IllegalArgumentException.class, () -> pagedFile.io(0L, 3));
            }
        });
    }

    @Test
    void mustNotPinPagesAfterNextReturnsFalse() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            CountDownLatch startLatch = new CountDownLatch(1);
            CountDownLatch unpinLatch = new CountDownLatch(1);
            AtomicReference exceptionRef = new AtomicReference();
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage, this.recordSize);
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
            Runnable runnable = () -> {
                try (PageCursor cursorA = pagedFile.io(0L, 6);){
                    Assertions.assertTrue((boolean)cursorA.next());
                    Assertions.assertFalse((boolean)cursorA.next());
                    startLatch.countDown();
                    unpinLatch.await();
                }
                catch (Exception e) {
                    exceptionRef.set(e);
                }
            };
            executor.submit(runnable);
            startLatch.await();
            try (PageCursor cursorB = pagedFile.io(1L, 2);){
                Assertions.assertTrue((boolean)cursorB.next());
                unpinLatch.countDown();
            }
            finally {
                pagedFile.close();
            }
            Exception e = (Exception)exceptionRef.get();
            if (e != null) {
                throw new Exception("Child thread got exception", e);
            }
        });
    }

    @Test
    void nextMustResetTheCursorOffset() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                cursor.setOffset(0);
                cursor.putByte((byte)1);
                cursor.putByte((byte)2);
                cursor.putByte((byte)3);
                cursor.putByte((byte)4);
                Assertions.assertTrue((boolean)cursor.next());
                cursor.setOffset(0);
                cursor.putByte((byte)5);
                cursor.putByte((byte)6);
                cursor.putByte((byte)7);
                cursor.putByte((byte)8);
            }
            cursor = pagedFile.io(0L, 2);
            try {
                byte[] bytes = new byte[4];
                Assertions.assertTrue((boolean)cursor.next());
                cursor.getBytes(bytes);
                MatcherAssert.assertThat((Object)bytes, (Matcher)ByteArrayMatcher.byteArray((byte[])new byte[]{1, 2, 3, 4}));
                Assertions.assertTrue((boolean)cursor.next());
                cursor.getBytes(bytes);
                MatcherAssert.assertThat((Object)bytes, (Matcher)ByteArrayMatcher.byteArray((byte[])new byte[]{5, 6, 7, 8}));
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.close();
        });
    }

    @Test
    void nextMustAdvanceCurrentPageId() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pagedFile.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                MatcherAssert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)0L));
                Assertions.assertTrue((boolean)cursor.next());
                MatcherAssert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)1L));
            }
        });
    }

    @Test
    void nextToSpecificPageIdMustAdvanceFromThatPointOn() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pagedFile.io(1L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                MatcherAssert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)1L));
                Assertions.assertTrue((boolean)cursor.next(4L));
                MatcherAssert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)4L));
                Assertions.assertTrue((boolean)cursor.next());
                MatcherAssert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)5L));
            }
        });
    }

    @Test
    void currentPageIdIsUnboundBeforeFirstNextAndAfterRewind() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pagedFile.io(0L, 2);){
                MatcherAssert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)-1L));
                Assertions.assertTrue((boolean)cursor.next());
                MatcherAssert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)0L));
                cursor.rewind();
                MatcherAssert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)-1L));
            }
        });
    }

    @Test
    void pageCursorMustKnowCurrentFilePageSize() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pagedFile.io(0L, 2);){
                MatcherAssert.assertThat((Object)cursor.getCurrentPageSize(), (Matcher)Matchers.is((Object)-1));
                Assertions.assertTrue((boolean)cursor.next());
                MatcherAssert.assertThat((Object)cursor.getCurrentPageSize(), (Matcher)Matchers.is((Object)this.filePageSize));
                cursor.rewind();
                MatcherAssert.assertThat((Object)cursor.getCurrentPageSize(), (Matcher)Matchers.is((Object)-1));
            }
        });
    }

    @Test
    void pageCursorMustKnowCurrentFile() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pagedFile.io(0L, 2);){
                MatcherAssert.assertThat((Object)cursor.getCurrentFile(), (Matcher)Matchers.nullValue());
                Assertions.assertTrue((boolean)cursor.next());
                MatcherAssert.assertThat((Object)cursor.getCurrentFile(), (Matcher)Matchers.is((Object)this.file("a")));
                cursor.rewind();
                MatcherAssert.assertThat((Object)cursor.getCurrentFile(), (Matcher)Matchers.nullValue());
            }
        });
    }

    @Test
    void readingFromUnboundReadCursorMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyOnReadCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkUnboundReadCursorAccess)));
    }

    @Test
    void readingFromUnboundWriteCursorMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyOnReadCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkUnboundWriteCursorAccess)));
    }

    @Test
    void readingFromPreviouslyBoundCursorMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyOnReadCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkPreviouslyBoundWriteCursorAccess)));
    }

    @Test
    void writingToUnboundCursorMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyOnWriteCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkUnboundWriteCursorAccess)));
    }

    @Test
    void writingToPreviouslyBoundCursorMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyOnWriteCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkPreviouslyBoundWriteCursorAccess)));
    }

    @Test
    void readFromReadCursorAfterNextReturnsFalseMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyOnReadCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkReadCursorAfterFailedNext)));
    }

    @Test
    void readFromPreviouslyBoundReadCursorAfterNextReturnsFalseMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyOnReadCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkPreviouslyBoundReadCursorAfterFailedNext)));
    }

    @Test
    void readFromWriteCursorAfterNextReturnsFalseMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyOnReadCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkWriteCursorAfterFailedNext)));
    }

    @Test
    void readFromPreviouslyBoundWriteCursorAfterNextReturnsFalseMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyOnReadCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkPreviouslyBoundWriteCursorAfterFailedNext)));
    }

    @Test
    void writeAfterNextReturnsFalseMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyOnWriteCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkWriteCursorAfterFailedNext)));
    }

    @Test
    void writeToPreviouslyBoundCursorAfterNextReturnsFalseMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyOnWriteCursor((ThrowingConsumer<PageCursorAction, IOException>)((ThrowingConsumer)this::checkPreviouslyBoundWriteCursorAfterFailedNext)));
    }

    private void verifyOnReadCursor(ThrowingConsumer<PageCursorAction, IOException> testTemplate) throws IOException {
        testTemplate.accept(PageCursor::getByte);
        testTemplate.accept(PageCursor::getInt);
        testTemplate.accept(PageCursor::getLong);
        testTemplate.accept(PageCursor::getShort);
        testTemplate.accept(cursor -> cursor.getByte(0));
        testTemplate.accept(cursor -> cursor.getInt(0));
        testTemplate.accept(cursor -> cursor.getLong(0));
        testTemplate.accept(cursor -> cursor.getShort(0));
    }

    private void verifyOnWriteCursor(ThrowingConsumer<PageCursorAction, IOException> testTemplate) throws IOException {
        testTemplate.accept(cursor -> cursor.putByte((byte)1));
        testTemplate.accept(cursor -> cursor.putInt(1));
        testTemplate.accept(cursor -> cursor.putLong(1L));
        testTemplate.accept(cursor -> cursor.putShort((short)1));
        testTemplate.accept(cursor -> cursor.putByte(0, (byte)1));
        testTemplate.accept(cursor -> cursor.putInt(0, 1));
        testTemplate.accept(cursor -> cursor.putLong(0, 1L));
        testTemplate.accept(cursor -> cursor.putShort(0, (short)1));
        testTemplate.accept(PageCursor::zapPage);
    }

    private void checkUnboundReadCursorAccess(PageCursorAction action) throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 1);){
            action.apply(cursor);
            Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    private void checkUnboundWriteCursorAccess(PageCursorAction action) throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 2);){
            action.apply(cursor);
            Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    private void checkPreviouslyBoundWriteCursorAccess(PageCursorAction action) throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            PageCursor cursor = pagedFile.io(0L, 2);
            Assertions.assertTrue((boolean)cursor.next());
            action.apply(cursor);
            Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
            cursor.close();
            action.apply(cursor);
            Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    private void checkReadCursorAfterFailedNext(PageCursorAction action) throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 1);){
            Assertions.assertFalse((boolean)cursor.next());
            action.apply(cursor);
            Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    private void checkPreviouslyBoundReadCursorAfterFailedNext(PageCursorAction action) throws IOException {
        PageCursor cursor;
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            cursor = pagedFile.io(0L, 2);
            try {
                Assertions.assertTrue((boolean)cursor.next());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        try {
            cursor = pagedFile.io(0L, 1);
            try {
                Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertFalse((boolean)cursor.next());
                action.apply(cursor);
                Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        finally {
            if (pagedFile != null) {
                pagedFile.close();
            }
        }
    }

    private void checkWriteCursorAfterFailedNext(PageCursorAction action) throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 6);){
            Assertions.assertFalse((boolean)cursor.next());
            action.apply(cursor);
            Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    private void checkPreviouslyBoundWriteCursorAfterFailedNext(PageCursorAction action) throws IOException {
        PageCursor cursor;
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            cursor = pagedFile.io(0L, 2);
            try {
                Assertions.assertTrue((boolean)cursor.next());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        try {
            cursor = pagedFile.io(0L, 6);
            try {
                Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertFalse((boolean)cursor.next());
                action.apply(cursor);
                Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        finally {
            if (pagedFile != null) {
                pagedFile.close();
            }
        }
    }

    @Test
    void tryMappedPagedFileShouldReportMappedFilePresent() throws Exception {
        this.configureStandardPageCache();
        File file = this.file("a");
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);){
            Optional optional = this.pageCache.getExistingMapping(file);
            Assertions.assertTrue((boolean)optional.isPresent());
            PagedFile actual = (PagedFile)optional.get();
            MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.sameInstance((Object)pf));
            actual.close();
        }
    }

    @Test
    void tryMappedPagedFileShouldReportNonMappedFileNotPresent() throws Exception {
        this.configureStandardPageCache();
        Optional dontExist = this.pageCache.getExistingMapping(new File("dont_exist"));
        Assertions.assertFalse((boolean)dontExist.isPresent());
    }

    @Test
    void mustListExistingMappings() throws Exception {
        this.configureStandardPageCache();
        File f1 = this.existingFile("1");
        File f2 = this.existingFile("2");
        File f3 = this.existingFile("3");
        this.existingFile("4");
        try (PagedFile pf1 = this.map(f1, this.filePageSize, new OpenOption[0]);
             PagedFile pf2 = this.map(f2, this.filePageSize, new OpenOption[0]);){
            this.map(f3, this.filePageSize, new OpenOption[0]).close();
            List existingMappings = this.pageCache.listExistingMappings();
            MatcherAssert.assertThat((Object)existingMappings.size(), (Matcher)Matchers.is((Object)2));
            MatcherAssert.assertThat((Object)existingMappings, (Matcher)Matchers.containsInAnyOrder((Object[])new PagedFile[]{pf1, pf2}));
        }
    }

    @Test
    void listExistingMappingsMustNotIncrementPagedFileReferenceCount() throws Exception {
        PagedFile existingMapping;
        this.configureStandardPageCache();
        File file = this.file("a");
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);){
            existingMapping = (PagedFile)this.pageCache.listExistingMappings().get(0);
            try (PageCursor cursor = existingMapping.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
            }
        }
        Assertions.assertThrows(FileIsNotMappedException.class, () -> existingMapping.io(0L, 2).next());
    }

    @Test
    void listExistingMappingsMustThrowOnClosedPageCache() {
        this.configureStandardPageCache();
        PageCache pc = this.pageCache;
        this.pageCache = null;
        pc.close();
        Assertions.assertThrows(IllegalStateException.class, () -> ((PageCache)pc).listExistingMappings());
    }

    @Test
    void lastPageMustBeAccessibleWithNoGrowSpecified() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
                try (PageCursor cursor = pagedFile.io(0L, 6);){
                    Assertions.assertTrue((boolean)cursor.next());
                    Assertions.assertTrue((boolean)cursor.next());
                    Assertions.assertFalse((boolean)cursor.next());
                }
                cursor = pagedFile.io(0L, 1);
                try {
                    Assertions.assertTrue((boolean)cursor.next());
                    Assertions.assertTrue((boolean)cursor.next());
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(1L, 6);
                try {
                    Assertions.assertTrue((boolean)cursor.next());
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(1L, 1);
                try {
                    Assertions.assertTrue((boolean)cursor.next());
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(2L, 6);
                try {
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(2L, 1);
                try {
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(3L, 6);
                try {
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(3L, 1);
                try {
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
        });
    }

    @Test
    void lastPageMustBeAccessibleWithNoGrowSpecifiedEvenIfLessThanFilePageSize() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2 - 1, this.recordSize);
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
                try (PageCursor cursor = pagedFile.io(0L, 6);){
                    Assertions.assertTrue((boolean)cursor.next());
                    Assertions.assertTrue((boolean)cursor.next());
                    Assertions.assertFalse((boolean)cursor.next());
                }
                cursor = pagedFile.io(0L, 1);
                try {
                    Assertions.assertTrue((boolean)cursor.next());
                    Assertions.assertTrue((boolean)cursor.next());
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(1L, 6);
                try {
                    Assertions.assertTrue((boolean)cursor.next());
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(1L, 1);
                try {
                    Assertions.assertTrue((boolean)cursor.next());
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(2L, 6);
                try {
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(2L, 1);
                try {
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(3L, 6);
                try {
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(3L, 1);
                try {
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
        });
    }

    @Test
    void firstPageMustBeAccessibleWithNoGrowSpecifiedIfItIsTheOnlyPage() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage, this.recordSize);
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
                try (PageCursor cursor = pagedFile.io(0L, 6);){
                    Assertions.assertTrue((boolean)cursor.next());
                    Assertions.assertFalse((boolean)cursor.next());
                }
                cursor = pagedFile.io(0L, 1);
                try {
                    Assertions.assertTrue((boolean)cursor.next());
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(1L, 6);
                try {
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(1L, 1);
                try {
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
        });
    }

    @Test
    void firstPageMustBeAccessibleEvenIfTheFileIsNonEmptyButSmallerThanFilePageSize() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.generateFileWithRecords(this.file("a"), 1, this.recordSize);
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
                try (PageCursor cursor = pagedFile.io(0L, 6);){
                    Assertions.assertTrue((boolean)cursor.next());
                    Assertions.assertFalse((boolean)cursor.next());
                }
                cursor = pagedFile.io(0L, 1);
                try {
                    Assertions.assertTrue((boolean)cursor.next());
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(1L, 6);
                try {
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(1L, 1);
                try {
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
        });
    }

    @Test
    void firstPageMustNotBeAccessibleIfFileIsEmptyAndNoGrowSpecified() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
                try (PageCursor cursor = pagedFile.io(0L, 6);){
                    Assertions.assertFalse((boolean)cursor.next());
                    Assertions.assertFalse((boolean)cursor.next());
                }
                cursor = pagedFile.io(0L, 1);
                try {
                    Assertions.assertFalse((boolean)cursor.next());
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(1L, 6);
                try {
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
                cursor = pagedFile.io(1L, 1);
                try {
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
        });
    }

    @Test
    void newlyWrittenPagesMustBeAccessibleWithNoGrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            int initialPages = 1;
            int pagesToAdd = 3;
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * initialPages, this.recordSize);
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
            try (PageCursor cursor = pagedFile.io(1L, 2);){
                for (int i = 0; i < pagesToAdd; ++i) {
                    Assertions.assertTrue((boolean)cursor.next());
                    this.writeRecords(cursor);
                }
            }
            int pagesChecked = 0;
            try (PageCursor cursor = pagedFile.io(0L, 6);){
                while (cursor.next()) {
                    this.verifyRecordsMatchExpected(cursor);
                    ++pagesChecked;
                }
            }
            MatcherAssert.assertThat((Object)pagesChecked, (Matcher)Matchers.is((Object)(initialPages + pagesToAdd)));
            pagesChecked = 0;
            cursor = pagedFile.io(0L, 1);
            try {
                while (cursor.next()) {
                    this.verifyRecordsMatchExpected(cursor);
                    ++pagesChecked;
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            MatcherAssert.assertThat((Object)pagesChecked, (Matcher)Matchers.is((Object)(initialPages + pagesToAdd)));
            pagedFile.close();
        });
    }

    @Test
    void readLockImpliesNoGrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            int initialPages = 3;
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * initialPages, this.recordSize);
            int pagesChecked = 0;
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pagedFile.io(0L, 1);){
                while (cursor.next()) {
                    ++pagesChecked;
                }
            }
            MatcherAssert.assertThat((Object)pagesChecked, (Matcher)Matchers.is((Object)initialPages));
        });
    }

    @Test
    void retryMustResetCursorOffset() throws Exception {
        int i;
        this.configureStandardPageCache();
        PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        AtomicReference caughtWriterException = new AtomicReference();
        CountDownLatch startLatch = new CountDownLatch(1);
        int expectedByte = 13;
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            if (cursor.next()) {
                cursor.putByte((byte)13);
            }
        }
        AtomicBoolean end = new AtomicBoolean(false);
        Runnable writer = () -> {
            while (!end.get()) {
                try {
                    PageCursor cursor = pagedFile.io(0L, 2);
                    try {
                        if (cursor.next()) {
                            cursor.setOffset(this.recordSize);
                            cursor.putByte((byte)14);
                        }
                        startLatch.countDown();
                    }
                    finally {
                        if (cursor == null) continue;
                        cursor.close();
                    }
                }
                catch (IOException e) {
                    caughtWriterException.set(e);
                    throw new RuntimeException(e);
                }
            }
        };
        Future<?> writerFuture = executor.submit(writer);
        startLatch.await();
        long timeout = System.currentTimeMillis() + this.SHORT_TIMEOUT_MILLIS;
        for (i = 0; i < 1000 && System.currentTimeMillis() < timeout; ++i) {
            try (PageCursor cursor = pagedFile.io(0L, 1);){
                Assertions.assertTrue((boolean)cursor.next());
                do {
                    MatcherAssert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)13));
                } while (cursor.shouldRetry() && System.currentTimeMillis() < timeout);
                continue;
            }
        }
        end.set(true);
        writerFuture.get();
        Assertions.assertTrue((i > 1 ? 1 : 0) != 0);
        pagedFile.close();
    }

    @Test
    void nextWithPageIdMustAllowTraversingInReverse() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
            long lastFilePageId = this.recordCount / this.recordsPerFilePage - 1;
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pagedFile.io(0L, 1);){
                for (long currentPageId = lastFilePageId; currentPageId >= 0L; --currentPageId) {
                    Assertions.assertTrue((boolean)cursor.next(currentPageId), (String)("next( currentPageId = " + currentPageId + " )"));
                    MatcherAssert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)currentPageId));
                    this.verifyRecordsMatchExpected(cursor);
                }
            }
        });
    }

    @Test
    void nextWithPageIdMustReturnFalseIfPageIdIsBeyondFilePageRangeAndNoGrowSpecified() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
                try (PageCursor cursor = pagedFile.io(0L, 6);){
                    Assertions.assertFalse((boolean)cursor.next(2L));
                    Assertions.assertTrue((boolean)cursor.next(1L));
                }
                cursor = pagedFile.io(0L, 1);
                try {
                    Assertions.assertFalse((boolean)cursor.next(2L));
                    Assertions.assertTrue((boolean)cursor.next(1L));
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
        });
    }

    @Test
    void pagesAddedWithNextWithPageIdMustBeAccessibleWithNoGrowSpecified() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next(2L));
                this.writeRecords(cursor);
                Assertions.assertTrue((boolean)cursor.next(0L));
                this.writeRecords(cursor);
                Assertions.assertTrue((boolean)cursor.next(1L));
                this.writeRecords(cursor);
            }
            cursor = pagedFile.io(0L, 6);
            try {
                while (cursor.next()) {
                    this.verifyRecordsMatchExpected(cursor);
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            cursor = pagedFile.io(0L, 1);
            try {
                while (cursor.next()) {
                    this.verifyRecordsMatchExpected(cursor);
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            pagedFile.close();
        });
    }

    @Test
    void writesOfDifferentUnitsMustHaveCorrectEndianness() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), 23, new OpenOption[0]);){
                try (PageCursor cursor = pagedFile.io(0L, 2);){
                    Assertions.assertTrue((boolean)cursor.next());
                    byte[] data = new byte[]{42, 43, 44, 45, 46};
                    cursor.putLong(41L);
                    cursor.putInt(41);
                    cursor.putShort((short)41);
                    cursor.putByte((byte)41);
                    cursor.putBytes(data);
                    cursor.putBytes(3, (byte)47);
                }
                cursor = pagedFile.io(0L, 2);
                try {
                    Assertions.assertTrue((boolean)cursor.next());
                    long a = cursor.getLong();
                    int b = cursor.getInt();
                    short c = cursor.getShort();
                    byte[] data = new byte[]{cursor.getByte(), cursor.getByte(), cursor.getByte(), cursor.getByte(), cursor.getByte(), cursor.getByte()};
                    byte d = cursor.getByte();
                    byte e = cursor.getByte();
                    byte f = cursor.getByte();
                    cursor.setOffset(0);
                    cursor.putLong(1L + a);
                    cursor.putInt(1 + b);
                    cursor.putShort((short)(1 + c));
                    for (byte g : data) {
                        g = (byte)(g + 1);
                        cursor.putByte(g);
                    }
                    cursor.putByte((byte)(1 + d));
                    cursor.putByte((byte)(1 + e));
                    cursor.putByte((byte)(1 + f));
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            ByteBuffer buf = ByteBuffers.allocate((int)23);
            try (StoreChannel channel = this.fs.read(this.file("a"));){
                channel.readAll(buf);
            }
            buf.flip();
            MatcherAssert.assertThat((Object)buf.getLong(), (Matcher)Matchers.is((Object)42L));
            MatcherAssert.assertThat((Object)buf.getInt(), (Matcher)Matchers.is((Object)42));
            MatcherAssert.assertThat((Object)buf.getShort(), (Matcher)Matchers.is((Object)42));
            MatcherAssert.assertThat((Object)buf.get(), (Matcher)Matchers.is((Object)42));
            MatcherAssert.assertThat((Object)buf.get(), (Matcher)Matchers.is((Object)43));
            MatcherAssert.assertThat((Object)buf.get(), (Matcher)Matchers.is((Object)44));
            MatcherAssert.assertThat((Object)buf.get(), (Matcher)Matchers.is((Object)45));
            MatcherAssert.assertThat((Object)buf.get(), (Matcher)Matchers.is((Object)46));
            MatcherAssert.assertThat((Object)buf.get(), (Matcher)Matchers.is((Object)47));
            MatcherAssert.assertThat((Object)buf.get(), (Matcher)Matchers.is((Object)48));
            MatcherAssert.assertThat((Object)buf.get(), (Matcher)Matchers.is((Object)48));
            MatcherAssert.assertThat((Object)buf.get(), (Matcher)Matchers.is((Object)48));
        });
    }

    @Test
    void mappingFileSecondTimeWithLesserPageSizeMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile ignore = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
                Assertions.assertThrows(IllegalArgumentException.class, () -> this.map(this.file("a"), this.filePageSize - 1, new OpenOption[0]));
            }
        });
    }

    @Test
    void mappingFileSecondTimeWithGreaterPageSizeMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile ignore = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
                Assertions.assertThrows(IllegalArgumentException.class, () -> this.map(this.file("a"), this.filePageSize + 1, new OpenOption[0]));
            }
        });
    }

    @Test
    void allowOpeningMultipleReadAndWriteCursorsPerThread() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            File fileA = this.existingFile("a");
            File fileB = this.existingFile("b");
            this.generateFileWithRecords(fileA, 1, 16);
            this.generateFileWithRecords(fileB, 1, 16);
            try (PagedFile pfA = this.map(fileA, this.filePageSize, new OpenOption[0]);
                 PagedFile pfB = this.map(fileB, this.filePageSize, new OpenOption[0]);
                 PageCursor a = pfA.io(0L, 1);
                 PageCursor b = pfA.io(0L, 1);
                 PageCursor c = pfA.io(0L, 2);
                 PageCursor d = pfA.io(0L, 2);
                 PageCursor e = pfB.io(0L, 1);
                 PageCursor f = pfB.io(0L, 1);
                 PageCursor g = pfB.io(0L, 2);
                 PageCursor h = pfB.io(0L, 2);){
                Assertions.assertTrue((boolean)a.next());
                Assertions.assertTrue((boolean)b.next());
                Assertions.assertTrue((boolean)c.next());
                Assertions.assertTrue((boolean)d.next());
                Assertions.assertTrue((boolean)e.next());
                Assertions.assertTrue((boolean)f.next());
                Assertions.assertTrue((boolean)g.next());
                Assertions.assertTrue((boolean)h.next());
            }
        });
    }

    @Test
    void mustNotLiveLockIfWeRunOutOfEvictablePages() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            LinkedList cursors = new LinkedList();
            try (PagedFile pf = this.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);){
                try {
                    Assertions.assertThrows(IOException.class, () -> {
                        long i = 0L;
                        while (true) {
                            PageCursor cursor = pf.io(i, 2);
                            cursors.add(cursor);
                            Assertions.assertTrue((boolean)cursor.next());
                            ++i;
                        }
                    });
                }
                finally {
                    for (PageCursor cursor : cursors) {
                        cursor.close();
                    }
                }
            }
        });
    }

    @Test
    void writeLocksMustNotBeExclusive() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pf.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                executor.submit(() -> {
                    try (PageCursor innerCursor = pf.io(0L, 2);){
                        Assertions.assertTrue((boolean)innerCursor.next());
                    }
                    return null;
                }).get();
            }
        });
    }

    @Test
    void writeLockMustInvalidateInnerReadLock() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pf.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                executor.submit(() -> {
                    try (PageCursor innerCursor = pf.io(0L, 1);){
                        Assertions.assertTrue((boolean)innerCursor.next());
                        Assertions.assertTrue((boolean)innerCursor.shouldRetry());
                    }
                    return null;
                }).get();
            }
        });
    }

    @Test
    void writeLockMustInvalidateExistingReadLock() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            BinaryLatch startLatch = new BinaryLatch();
            BinaryLatch continueLatch = new BinaryLatch();
            try (PagedFile pf = this.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pf.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertTrue((boolean)cursor.next());
                Future<Object> read = executor.submit(() -> {
                    try (PageCursor innerCursor = pf.io(0L, 1);){
                        Assertions.assertTrue((boolean)innerCursor.next());
                        Assertions.assertFalse((boolean)innerCursor.shouldRetry());
                        startLatch.release();
                        continueLatch.await();
                        Assertions.assertTrue((boolean)innerCursor.shouldRetry());
                    }
                    return null;
                });
                startLatch.await();
                Assertions.assertTrue((boolean)cursor.next(0L));
                continueLatch.release();
                read.get();
            }
        });
    }

    @Test
    void writeUnlockMustInvalidateReadLocks() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            BinaryLatch startLatch = new BinaryLatch();
            BinaryLatch continueLatch = new BinaryLatch();
            try (PagedFile pf = this.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pf.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                Future<Object> read = executor.submit(() -> {
                    try (PageCursor innerCursor = pf.io(0L, 1);){
                        Assertions.assertTrue((boolean)innerCursor.next());
                        Assertions.assertTrue((boolean)innerCursor.shouldRetry());
                        startLatch.release();
                        continueLatch.await();
                        Assertions.assertTrue((boolean)innerCursor.shouldRetry());
                    }
                    return null;
                });
                startLatch.await();
                Assertions.assertTrue((boolean)cursor.next());
                continueLatch.release();
                read.get();
            }
        });
    }

    @Test
    void mustNotFlushCleanPagesWhenEvicting() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            final AtomicBoolean observedWrite = new AtomicBoolean();
            DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

                public StoreChannel open(File fileName, Set<OpenOption> options) throws IOException {
                    StoreChannel channel = super.open(fileName, options);
                    return new DelegatingStoreChannel(channel){

                        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
                            observedWrite.set(true);
                            throw new IOException("not allowed");
                        }

                        public void writeAll(ByteBuffer src, long position) throws IOException {
                            observedWrite.set(true);
                            throw new IOException("not allowed");
                        }

                        public void writeAll(ByteBuffer src) throws IOException {
                            observedWrite.set(true);
                            throw new IOException("not allowed");
                        }

                        public int write(ByteBuffer src) throws IOException {
                            observedWrite.set(true);
                            throw new IOException("not allowed");
                        }

                        public long write(ByteBuffer[] srcs) throws IOException {
                            observedWrite.set(true);
                            throw new IOException("not allowed");
                        }
                    };
                }
            };
            this.getPageCache((FileSystemAbstraction)fs, this.maxPages, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL);
            this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pagedFile.io(0L, 1);){
                while (cursor.next()) {
                    this.verifyRecordsMatchExpected(cursor);
                }
            }
            Assertions.assertFalse((boolean)observedWrite.get());
        });
    }

    @Test
    void evictionMustFlushPagesToTheRightFiles() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
            int filePageSize2 = this.filePageSize - 3;
            long maxPageIdCursor1 = this.recordCount / this.recordsPerFilePage;
            File file2 = this.file("b");
            long file2sizeBytes = (maxPageIdCursor1 + 17L) * (long)filePageSize2;
            try (OutputStream outputStream = this.fs.openAsOutputStream(file2, false);){
                int i = 0;
                while ((long)i < file2sizeBytes) {
                    outputStream.write(97);
                    ++i;
                }
                outputStream.flush();
            }
            try (PagedFile pagedFile1 = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PagedFile pagedFile2 = this.map(file2, filePageSize2, new OpenOption[0]);){
                boolean cursorReady2;
                boolean cursorReady1;
                boolean moreWorkToDo;
                long pageId1 = 0L;
                long pageId2 = 0L;
                do {
                    try (PageCursor cursor = pagedFile1.io(pageId1, 2);){
                        boolean bl = cursorReady1 = cursor.next() && cursor.getCurrentPageId() < maxPageIdCursor1;
                        if (cursorReady1) {
                            this.writeRecords(cursor);
                            ++pageId1;
                        }
                    }
                    cursor = pagedFile2.io(pageId2, 6);
                    try {
                        cursorReady2 = cursor.next();
                        if (cursorReady2) {
                            for (int i = 0; i < filePageSize2; ++i) {
                                cursor.putByte((byte)98);
                            }
                            Assertions.assertFalse((boolean)cursor.shouldRetry());
                        }
                        ++pageId2;
                    }
                    finally {
                        if (cursor != null) {
                            cursor.close();
                        }
                    }
                } while (moreWorkToDo = cursorReady1 || cursorReady2);
            }
            MatcherAssert.assertThat((Object)this.fs.getFileSize(file2), (Matcher)Matchers.is((Object)file2sizeBytes));
            try (InputStream inputStream = this.fs.openAsInputStream(file2);){
                int i = 0;
                while ((long)i < file2sizeBytes) {
                    int b = inputStream.read();
                    MatcherAssert.assertThat((Object)b, (Matcher)Matchers.is((Object)98));
                    ++i;
                }
                MatcherAssert.assertThat((Object)inputStream.read(), (Matcher)Matchers.is((Object)-1));
            }
            try (StoreChannel channel = this.fs.read(this.file("a"));){
                ByteBuffer bufB = ByteBuffers.allocate((int)this.recordSize);
                for (int i = 0; i < this.recordCount; ++i) {
                    this.bufA.clear();
                    channel.readAll(this.bufA);
                    this.bufA.flip();
                    bufB.clear();
                    PageCacheTest.generateRecordForId(i, bufB);
                    MatcherAssert.assertThat((Object)bufB.array(), (Matcher)ByteArrayMatcher.byteArray((byte[])this.bufA.array()));
                }
            }
        });
    }

    @Test
    void tracerMustBeNotifiedAboutPinUnpinFaultAndEvictEventsWhenReading() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            DefaultPageCacheTracer tracer = new DefaultPageCacheTracer();
            DefaultPageCursorTracerSupplier cursorTracerSupplier = PageCacheTest.getCursorTracerSupplier(tracer);
            this.getPageCache(this.fs, this.maxPages, (PageCacheTracer)tracer, (PageCursorTracerSupplier)cursorTracerSupplier);
            this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
            long countedPages = 0L;
            long countedFaults = 0L;
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pagedFile.io(0L, 1);){
                int i;
                while (cursor.next()) {
                    ++countedPages;
                    ++countedFaults;
                }
                ++countedPages;
                for (i = 0; i < 20; ++i) {
                    Assertions.assertTrue((boolean)cursor.next(1L));
                }
                for (i = 0; i < 20; ++i) {
                    Assertions.assertTrue((boolean)cursor.next((long)i));
                    ++countedPages;
                }
            }
            this.pageCache.reportEvents();
            MatcherAssert.assertThat((String)"wrong count of pins", (Object)tracer.pins(), (Matcher)Matchers.is((Object)countedPages));
            MatcherAssert.assertThat((String)"wrong count of unpins", (Object)tracer.unpins(), (Matcher)Matchers.is((Object)countedPages));
            long faults = tracer.faults();
            long bytesRead = tracer.bytesRead();
            MatcherAssert.assertThat((String)"wrong count of faults", (Object)faults, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(countedFaults)));
            MatcherAssert.assertThat((String)"wrong number of bytes read", (Object)bytesRead, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(countedFaults * (long)this.filePageSize)));
            MatcherAssert.assertThat((String)"wrong count of evictions", (Object)tracer.evictions(), (Matcher)Matchers.both((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(countedFaults - (long)this.maxPages))).and(Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(countedPages + faults))));
        });
    }

    @Test
    void tracerMustBeNotifiedAboutPinUnpinFaultFlushAndEvictionEventsWhenWriting() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            long pagesToGenerate = 142L;
            DefaultPageCacheTracer tracer = new DefaultPageCacheTracer();
            DefaultPageCursorTracerSupplier tracerSupplier = PageCacheTest.getCursorTracerSupplier(tracer);
            this.getPageCache(this.fs, this.maxPages, (PageCacheTracer)tracer, (PageCursorTracerSupplier)tracerSupplier);
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pagedFile.io(0L, 2);){
                for (long i = 0L; i < pagesToGenerate; ++i) {
                    Assertions.assertTrue((boolean)cursor.next());
                    MatcherAssert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)i));
                    Assertions.assertTrue((boolean)cursor.next(i));
                    MatcherAssert.assertThat((Object)cursor.getCurrentPageId(), (Matcher)Matchers.is((Object)i));
                    this.writeRecords(cursor);
                }
                Assertions.assertTrue((boolean)cursor.next(0L));
                Assertions.assertTrue((boolean)cursor.next(0L));
            }
            this.pageCache.reportEvents();
            MatcherAssert.assertThat((String)"wrong count of pins", (Object)tracer.pins(), (Matcher)Matchers.is((Object)(pagesToGenerate + 1L)));
            MatcherAssert.assertThat((String)"wrong count of unpins", (Object)tracer.unpins(), (Matcher)Matchers.is((Object)(pagesToGenerate + 1L)));
            long faults = tracer.faults();
            MatcherAssert.assertThat((String)"wrong count of faults", (Object)faults, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(pagesToGenerate)));
            MatcherAssert.assertThat((String)"wrong count of evictions", (Object)tracer.evictions(), (Matcher)Matchers.both((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(pagesToGenerate - (long)this.maxPages))).and(Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(pagesToGenerate + faults))));
            long flushes = tracer.flushes();
            long bytesWritten = tracer.bytesWritten();
            MatcherAssert.assertThat((String)"wrong count of flushes", (Object)flushes, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(pagesToGenerate - (long)this.maxPages)));
            MatcherAssert.assertThat((String)"wrong count of bytes written", (Object)bytesWritten, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(pagesToGenerate * (long)this.filePageSize)));
        });
    }

    @Test
    void tracerMustBeNotifiedOfReadAndWritePins() throws Exception {
        final AtomicInteger writeCount = new AtomicInteger();
        final AtomicInteger readCount = new AtomicInteger();
        DefaultPageCacheTracer tracer = new DefaultPageCacheTracer();
        DefaultPageCursorTracer pageCursorTracer = new DefaultPageCursorTracer(){

            public PinEvent beginPin(boolean writeLock, long filePageId, PageSwapper swapper) {
                (writeLock ? writeCount : readCount).getAndIncrement();
                return super.beginPin(writeLock, filePageId, swapper);
            }
        };
        ConfigurablePageCursorTracerSupplier<6> cursorTracerSupplier = new ConfigurablePageCursorTracerSupplier<6>(pageCursorTracer);
        this.getPageCache(this.fs, this.maxPages, (PageCacheTracer)tracer, cursorTracerSupplier);
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        int pinsForRead = 13;
        int pinsForWrite = 42;
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 1);){
                for (int i = 0; i < pinsForRead; ++i) {
                    Assertions.assertTrue((boolean)cursor.next());
                }
            }
            this.dirtyManyPages(pagedFile, pinsForWrite);
        }
        this.pageCache.reportEvents();
        MatcherAssert.assertThat((String)"wrong read pin count", (Object)readCount.get(), (Matcher)Matchers.is((Object)pinsForRead));
        MatcherAssert.assertThat((String)"wrong write pin count", (Object)writeCount.get(), (Matcher)Matchers.is((Object)pinsForWrite));
    }

    @Test
    void lastPageIdOfEmptyFileIsLessThanZero() throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            MatcherAssert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(0L)));
        }
    }

    @Test
    void lastPageIdOfFileWithOneByteIsZero() throws IOException {
        StoreChannel channel = this.fs.write(this.file("a"));
        channel.write(ByteBuffer.wrap(new byte[]{1}));
        channel.close();
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            MatcherAssert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.is((Object)0L));
        }
    }

    @Test
    void lastPageIdOfFileWithExactlyTwoPagesWorthOfDataIsOne() throws IOException {
        this.configureStandardPageCache();
        int twoPagesWorthOfRecords = this.recordsPerFilePage * 2;
        this.generateFileWithRecords(this.file("a"), twoPagesWorthOfRecords, this.recordSize);
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            MatcherAssert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.is((Object)1L));
        }
    }

    @Test
    void lastPageIdOfFileWithExactlyTwoPagesAndOneByteWorthOfDataIsTwo() throws IOException {
        this.configureStandardPageCache();
        int twoPagesWorthOfRecords = this.recordsPerFilePage * 2;
        this.generateFileWithRecords(this.file("a"), twoPagesWorthOfRecords, this.recordSize);
        OutputStream outputStream = this.fs.openAsOutputStream(this.file("a"), true);
        outputStream.write(97);
        outputStream.close();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            MatcherAssert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.is((Object)2L));
        }
    }

    @Test
    void lastPageIdMustNotIncreaseWhenReadingToEndWithReadLock() throws IOException {
        this.configureStandardPageCache();
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        long initialLastPageId = pagedFile.getLastPageId();
        try (PageCursor cursor = pagedFile.io(0L, 1);){
            while (cursor.next()) {
            }
        }
        long resultingLastPageId = pagedFile.getLastPageId();
        pagedFile.close();
        MatcherAssert.assertThat((Object)resultingLastPageId, (Matcher)Matchers.is((Object)initialLastPageId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void lastPageIdMustNotIncreaseWhenReadingToEndWithNoGrowAndWriteLock() throws IOException {
        this.configureStandardPageCache();
        this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
        PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        long initialLastPageId = pagedFile.getLastPageId();
        try (PageCursor cursor = pagedFile.io(0L, 6);){
            while (cursor.next()) {
            }
        }
        long resultingLastPageId = pagedFile.getLastPageId();
        try {
            MatcherAssert.assertThat((Object)resultingLastPageId, (Matcher)Matchers.is((Object)initialLastPageId));
        }
        catch (Throwable throwable) {
            IOUtils.closeAllSilently((AutoCloseable[])new PagedFile[]{pagedFile});
            throw throwable;
        }
        IOUtils.closeAllSilently((AutoCloseable[])new PagedFile[]{pagedFile});
    }

    @Test
    void lastPageIdMustIncreaseWhenScanningPastEndWithWriteLock() throws IOException {
        this.configureStandardPageCache();
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 10, this.recordSize);
        PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        MatcherAssert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.is((Object)9L));
        this.dirtyManyPages(pagedFile, 15);
        try {
            MatcherAssert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.is((Object)14L));
        }
        catch (Throwable throwable) {
            IOUtils.closeAllSilently((AutoCloseable[])new PagedFile[]{pagedFile});
            throw throwable;
        }
        IOUtils.closeAllSilently((AutoCloseable[])new PagedFile[]{pagedFile});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void lastPageIdMustIncreaseWhenJumpingPastEndWithWriteLock() throws IOException {
        this.configureStandardPageCache();
        this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 10, this.recordSize);
        PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        MatcherAssert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.is((Object)9L));
        try (PageCursor cursor = pagedFile.io(0L, 2);){
            Assertions.assertTrue((boolean)cursor.next(15L));
        }
        try {
            MatcherAssert.assertThat((Object)pagedFile.getLastPageId(), (Matcher)Matchers.is((Object)15L));
        }
        catch (Throwable throwable) {
            IOUtils.closeAllSilently((AutoCloseable[])new PagedFile[]{pagedFile});
            throw throwable;
        }
        IOUtils.closeAllSilently((AutoCloseable[])new PagedFile[]{pagedFile});
    }

    @Test
    void lastPageIdFromUnmappedFileMustThrow() throws IOException {
        PagedFile file;
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, StandardOpenOption.CREATE);){
            file = pf;
        }
        Assertions.assertThrows(FileIsNotMappedException.class, () -> ((PagedFile)file).getLastPageId());
    }

    @Test
    void cursorOffsetMustBeUpdatedReadAndWrite() throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                this.verifyWriteOffsets(cursor);
                cursor.setOffset(0);
                this.verifyReadOffsets(cursor);
            }
            cursor = pagedFile.io(0L, 1);
            try {
                Assertions.assertTrue((boolean)cursor.next());
                this.verifyReadOffsets(cursor);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    private void verifyWriteOffsets(PageCursor cursor) {
        cursor.setOffset(this.filePageSize / 2);
        cursor.zapPage();
        MatcherAssert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)(this.filePageSize / 2)));
        cursor.setOffset(0);
        cursor.putLong(1L);
        MatcherAssert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)8));
        cursor.putInt(1);
        MatcherAssert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)12));
        cursor.putShort((short)1);
        MatcherAssert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)14));
        cursor.putByte((byte)1);
        MatcherAssert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)15));
        cursor.putBytes(new byte[]{1, 2, 3});
        MatcherAssert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)18));
        cursor.putBytes(new byte[]{1, 2, 3}, 1, 1);
        MatcherAssert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)19));
        cursor.putBytes(5, (byte)1);
        MatcherAssert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)24));
    }

    private void verifyReadOffsets(PageCursor cursor) {
        MatcherAssert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)0));
        cursor.getLong();
        MatcherAssert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)8));
        cursor.getInt();
        MatcherAssert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)12));
        cursor.getShort();
        MatcherAssert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)14));
        cursor.getByte();
        MatcherAssert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)15));
        cursor.getBytes(new byte[3]);
        MatcherAssert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)18));
        cursor.getBytes(new byte[3], 1, 1);
        MatcherAssert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)19));
        cursor.getBytes(new byte[5]);
        MatcherAssert.assertThat((Object)cursor.getOffset(), (Matcher)Matchers.is((Object)24));
        byte[] expectedBytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 1, 1, 2, 3, 2, 1, 1, 1, 1, 1};
        byte[] actualBytes = new byte[24];
        cursor.setOffset(0);
        cursor.getBytes(actualBytes);
        MatcherAssert.assertThat((Object)actualBytes, (Matcher)ByteArrayMatcher.byteArray((byte[])expectedBytes));
    }

    @Test
    void getBytesMustRespectOffsets() throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assertions.assertTrue((boolean)cursor.next());
            cursor.putByte((byte)1);
            cursor.putByte((byte)2);
            cursor.putByte((byte)3);
            cursor.putByte((byte)4);
            cursor.putByte((byte)5);
            cursor.putByte((byte)6);
            cursor.putByte((byte)7);
            cursor.putByte((byte)8);
            byte[] data = new byte[]{42, 42, 42, 42, 42};
            cursor.setOffset(1);
            cursor.getBytes(data, 1, 3);
            byte[] expected = new byte[]{42, 2, 3, 4, 42};
            Assertions.assertArrayEquals((byte[])expected, (byte[])data);
        }
    }

    @Test
    void putBytesMustRespectOffsets() throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assertions.assertTrue((boolean)cursor.next());
            cursor.putByte((byte)1);
            cursor.putByte((byte)2);
            cursor.putByte((byte)3);
            cursor.putByte((byte)4);
            cursor.putByte((byte)5);
            cursor.putByte((byte)6);
            cursor.putByte((byte)7);
            cursor.putByte((byte)8);
            byte[] data = new byte[]{42, 41, 40, 39, 38};
            cursor.setOffset(1);
            cursor.putBytes(data, 1, 3);
            cursor.setOffset(0);
            MatcherAssert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)41));
            MatcherAssert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)40));
            MatcherAssert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)39));
            MatcherAssert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)5));
            MatcherAssert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)6));
            MatcherAssert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)7));
            MatcherAssert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)8));
        }
    }

    @Test
    void getBytesMustRespectLargeOffsets() throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            int i;
            Assertions.assertTrue((boolean)cursor.next());
            for (int i2 = 0; i2 < 200; ++i2) {
                cursor.putByte((byte)(i2 + 1));
            }
            byte[] data = new byte[200];
            for (i = 0; i < data.length; ++i) {
                data[i] = (byte)(data.length - i);
            }
            cursor.setOffset(1);
            cursor.getBytes(data, 1, data.length - 2);
            MatcherAssert.assertThat((Object)data[0], (Matcher)Matchers.is((Object)-56));
            for (i = 1; i < 199; ++i) {
                MatcherAssert.assertThat((Object)data[i], (Matcher)Matchers.is((Object)((byte)(i + 1))));
            }
            MatcherAssert.assertThat((Object)data[199], (Matcher)Matchers.is((Object)1));
        }
    }

    @Test
    void putBytesMustRespectLargeOffsets() throws IOException {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            int i;
            Assertions.assertTrue((boolean)cursor.next());
            for (int i2 = 0; i2 < 200; ++i2) {
                cursor.putByte((byte)(i2 + 1));
            }
            byte[] data = new byte[200];
            for (i = 0; i < data.length; ++i) {
                data[i] = (byte)(data.length - i);
            }
            cursor.setOffset(1);
            cursor.putBytes(data, 1, data.length - 2);
            cursor.setOffset(0);
            MatcherAssert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)1));
            for (i = 0; i < 198; ++i) {
                MatcherAssert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)((byte)(199 - i))));
            }
            MatcherAssert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)-56));
        }
    }

    @Test
    void getBytesMustThrowArrayIndexOutOfBounds() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assertions.assertTrue((boolean)cursor.next());
            byte[] bytes = new byte[3];
            Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> cursor.getBytes(bytes, 1, 3));
        }
    }

    @Test
    void putBytesMustThrowArrayIndexOutOfBounds() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assertions.assertTrue((boolean)cursor.next());
            byte[] bytes = new byte[3];
            Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> cursor.putBytes(bytes, 1, 3));
        }
    }

    @Test
    void closeOnPageCacheMustThrowIfFilesAreStillMapped() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile ignore = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
                Assertions.assertThrows(IllegalStateException.class, () -> this.pageCache.close());
            }
        });
    }

    @Test
    void pagedFileIoMustThrowIfFileIsUnmapped() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
            this.closeThisPagedFile(pagedFile);
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                FileIsNotMappedException exception = (FileIsNotMappedException)Assertions.assertThrows(FileIsNotMappedException.class, () -> ((PageCursor)cursor).next());
                StringWriter out = new StringWriter();
                exception.printStackTrace(new PrintWriter(out));
                MatcherAssert.assertThat((Object)out.toString(), (Matcher)Matchers.containsString((String)"closeThisPagedFile"));
            }
        });
    }

    private void closeThisPagedFile(PagedFile pagedFile) {
        pagedFile.close();
    }

    @Test
    void writeLockedPageCursorNextMustThrowIfFileIsUnmapped() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
            PageCursor cursor = pagedFile.io(0L, 2);
            this.closeThisPagedFile(pagedFile);
            FileIsNotMappedException exception = (FileIsNotMappedException)Assertions.assertThrows(FileIsNotMappedException.class, () -> ((PageCursor)cursor).next());
            StringWriter out = new StringWriter();
            exception.printStackTrace(new PrintWriter(out));
            MatcherAssert.assertThat((Object)out.toString(), (Matcher)Matchers.containsString((String)"closeThisPagedFile"));
        });
    }

    @Test
    void writeLockedPageCursorNextWithIdMustThrowIfFileIsUnmapped() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
            PageCursor cursor = pagedFile.io(0L, 2);
            pagedFile.close();
            Assertions.assertThrows(FileIsNotMappedException.class, () -> cursor.next(1L));
        });
    }

    @Test
    void readLockedPageCursorNextMustThrowIfFileIsUnmapped() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), 1, this.recordSize);
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
            PageCursor cursor = pagedFile.io(0L, 1);
            pagedFile.close();
            Assertions.assertThrows(FileIsNotMappedException.class, () -> ((PageCursor)cursor).next());
        });
    }

    @Test
    void readLockedPageCursorNextWithIdMustThrowIfFileIsUnmapped() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
            PageCursor cursor = pagedFile.io(0L, 1);
            pagedFile.close();
            Assertions.assertThrows(FileIsNotMappedException.class, () -> cursor.next(1L));
        });
    }

    @Test
    void writeLockedPageMustBlockFileUnmapping() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
            PageCursor cursor = pagedFile.io(0L, 2);
            Assertions.assertTrue((boolean)cursor.next());
            Thread unmapper = ThreadTestUtils.fork((Runnable)this.closePageFile(pagedFile));
            unmapper.join(100L);
            cursor.close();
            unmapper.join();
        });
    }

    @Test
    void optimisticReadLockedPageMustNotBlockFileUnmapping() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.generateFileWithRecords(this.file("a"), 1, this.recordSize);
            this.configureStandardPageCache();
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
            PageCursor cursor = pagedFile.io(0L, 1);
            Assertions.assertTrue((boolean)cursor.next());
            ThreadTestUtils.fork((Runnable)this.closePageFile(pagedFile)).join();
            cursor.close();
        });
    }

    @Test
    void advancingPessimisticReadLockingCursorAfterUnmappingMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
            PageCursor cursor = pagedFile.io(0L, 1);
            Assertions.assertTrue((boolean)cursor.next());
            ThreadTestUtils.fork((Runnable)this.closePageFile(pagedFile)).join();
            Assertions.assertThrows(FileIsNotMappedException.class, () -> ((PageCursor)cursor).next());
        });
    }

    @Test
    void advancingOptimisticReadLockingCursorAfterUnmappingMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
            PageCursor cursor = pagedFile.io(0L, 1);
            Assertions.assertTrue((boolean)cursor.next());
            Assertions.assertTrue((boolean)cursor.next());
            Assertions.assertTrue((boolean)cursor.next(0L));
            ThreadTestUtils.fork((Runnable)this.closePageFile(pagedFile)).join();
            Assertions.assertThrows(FileIsNotMappedException.class, () -> ((PageCursor)cursor).next());
        });
    }

    @Test
    void readingAndRetryingOnPageWithOptimisticReadLockingAfterUnmappingMustNotThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
            PageCursor cursor = pagedFile.io(0L, 1);
            Assertions.assertTrue((boolean)cursor.next());
            Assertions.assertTrue((boolean)cursor.next());
            Assertions.assertTrue((boolean)cursor.next(0L));
            ThreadTestUtils.fork((Runnable)this.closePageFile(pagedFile)).join();
            this.pageCache.close();
            this.pageCache = null;
            cursor.getByte();
            cursor.shouldRetry();
            Assertions.assertThrows(FileIsNotMappedException.class, () -> ((PageCursor)cursor).next());
        });
    }

    @Test
    void shouldRetryFromUnboundReadCursorMustNotThrow() throws Exception {
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage, this.recordSize);
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 1);){
            Assertions.assertFalse((boolean)cursor.shouldRetry());
        }
    }

    @Test
    void shouldRetryFromUnboundWriteCursorMustNotThrow() throws Exception {
        this.configureStandardPageCache();
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assertions.assertFalse((boolean)cursor.shouldRetry());
        }
    }

    @Test
    void shouldRetryFromUnboundLinkedReadCursorMustNotThrow() throws Exception {
        this.configureStandardPageCache();
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 1);){
            Assertions.assertTrue((boolean)cursor.next());
            try (PageCursor linked = cursor.openLinkedCursor(1L);){
                Assertions.assertFalse((boolean)cursor.shouldRetry());
            }
        }
    }

    @Test
    void shouldRetryFromUnboundLinkedWriteCursorMustNotThrow() throws Exception {
        this.configureStandardPageCache();
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assertions.assertTrue((boolean)cursor.next());
            try (PageCursor linked = cursor.openLinkedCursor(1L);){
                Assertions.assertFalse((boolean)cursor.shouldRetry());
            }
        }
    }

    @Test
    void shouldRetryOnWriteParentOfClosedLinkedCursorMustNotThrow() throws Exception {
        this.configureStandardPageCache();
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assertions.assertTrue((boolean)cursor.next());
            try (PageCursor linked = cursor.openLinkedCursor(1L);){
                Assertions.assertTrue((boolean)linked.next());
            }
            cursor.shouldRetry();
        }
    }

    @Test
    void shouldRetryOnReadParentOfClosedLinkedCursorMustNotThrow() throws Exception {
        this.configureStandardPageCache();
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 1);){
            Assertions.assertTrue((boolean)cursor.next());
            try (PageCursor linked = cursor.openLinkedCursor(1L);){
                Assertions.assertTrue((boolean)linked.next());
            }
            cursor.shouldRetry();
        }
    }

    @Test
    void shouldRetryOnReadParentOnDirtyPageOfClosedLinkedCursorMustNotThrow() throws Exception {
        this.configureStandardPageCache();
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor reader = pf.io(0L, 1);){
            Assertions.assertTrue((boolean)reader.next());
            try (PageCursor writer = pf.io(0L, 2);){
                Assertions.assertTrue((boolean)writer.next());
            }
            try (PageCursor linked = reader.openLinkedCursor(1L);){
                Assertions.assertTrue((boolean)linked.next());
            }
            Assertions.assertTrue((boolean)reader.shouldRetry());
        }
    }

    @Test
    void pageCursorCloseShouldNotReturnAlreadyClosedLinkedCursorToPool() throws Exception {
        this.getPageCache(this.fs, this.maxPages, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL);
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);){
            PageCursor a = pf.io(0L, 2);
            PageCursor b = a.openLinkedCursor(0L);
            b.close();
            PageCursor c = a.openLinkedCursor(0L);
            PageCursor d = pf.io(0L, 2);
            Assertions.assertNotSame((Object)c, (Object)d);
            c.close();
            d.close();
        }
    }

    @Test
    void pageCursorCloseShouldNotReturnSameObjectToCursorPoolTwice() throws Exception {
        this.getPageCache(this.fs, this.maxPages, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL);
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);){
            PageCursor a = pf.io(0L, 2);
            a.close();
            a.close();
            PageCursor b = pf.io(0L, 2);
            PageCursor c = pf.io(0L, 2);
            Assertions.assertNotSame((Object)b, (Object)c);
            b.close();
            c.close();
        }
    }

    @Test
    void pageCursorCloseWithClosedLinkedCursorShouldNotReturnSameObjectToCursorPoolTwice() throws Exception {
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL);
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);){
            PageCursor a = pf.io(0L, 2);
            a.openLinkedCursor(0L);
            a.openLinkedCursor(0L).close();
            a.close();
            PageCursor x = pf.io(0L, 2);
            PageCursor y = pf.io(0L, 2);
            PageCursor z = pf.io(0L, 2);
            Assertions.assertNotSame((Object)x, (Object)y);
            Assertions.assertNotSame((Object)x, (Object)z);
            Assertions.assertNotSame((Object)y, (Object)z);
            x.close();
            y.close();
            z.close();
        }
    }

    @Test
    void pageCursorCloseMustNotClosePreviouslyLinkedCursorThatGotReused() throws Exception {
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        this.getPageCache(this.fs, this.maxPages, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL);
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);){
            PageCursor a = pf.io(0L, 2);
            a.openLinkedCursor(0L).close();
            PageCursor x = pf.io(0L, 2);
            a.close();
            Assertions.assertTrue((boolean)x.next(1L));
            x.close();
        }
    }

    @Test
    void getByteBeyondPageEndMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyPageBounds(PageCursor::getByte));
    }

    @Test
    void putByteBeyondPageEndMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyPageBounds(cursor -> cursor.putByte((byte)42)));
    }

    @Test
    void getShortBeyondPageEndMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyPageBounds(PageCursor::getShort));
    }

    @Test
    void putShortBeyondPageEndMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyPageBounds(cursor -> cursor.putShort((short)42)));
    }

    @Test
    void getIntBeyondPageEndMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyPageBounds(PageCursor::getInt));
    }

    @Test
    void putIntBeyondPageEndMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyPageBounds(cursor -> cursor.putInt(42)));
    }

    @Test
    void putLongBeyondPageEndMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyPageBounds(cursor -> cursor.putLong(42L)));
    }

    @Test
    void getLongBeyondPageEndMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyPageBounds(PageCursor::getLong));
    }

    @Test
    void putBytesBeyondPageEndMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            byte[] bytes = new byte[]{1, 2, 3};
            this.verifyPageBounds(cursor -> cursor.putBytes(bytes));
        });
    }

    @Test
    void putBytesRepeatedByteBeyondPageEndMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> this.verifyPageBounds(cursor -> cursor.putBytes(3, (byte)1)));
    }

    @Test
    void getBytesBeyondPageEndMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            byte[] bytes = new byte[3];
            this.verifyPageBounds(cursor -> cursor.getBytes(bytes));
        });
    }

    @Test
    void putBytesWithOffsetAndLengthBeyondPageEndMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            byte[] bytes = new byte[]{1, 2, 3};
            this.verifyPageBounds(cursor -> cursor.putBytes(bytes, 1, 1));
        });
    }

    @Test
    void getBytesWithOffsetAndLengthBeyondPageEndMustThrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            byte[] bytes = new byte[3];
            this.verifyPageBounds(cursor -> cursor.getBytes(bytes, 1, 1));
        });
    }

    private void verifyPageBounds(PageCursorAction action) throws IOException {
        this.configureStandardPageCache();
        this.generateFileWithRecords(this.file("a"), 1, this.recordSize);
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 2);){
            cursor.next();
            Assertions.assertThrows(IndexOutOfBoundsException.class, () -> {
                for (int i = 0; i < 100000; ++i) {
                    action.apply(cursor);
                    if (!cursor.checkAndClearBoundsFlag()) continue;
                    throw new IndexOutOfBoundsException();
                }
            });
        }
    }

    @Test
    void shouldRetryMustClearBoundsFlagWhenReturningTrue() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor reader = pf.io(0L, 1);){
                PageCursor writer = pf.io(0L, 2);
                Assertions.assertTrue((boolean)writer.next());
                Assertions.assertTrue((boolean)reader.next());
                reader.getByte(-1);
                writer.close();
                Assertions.assertTrue((boolean)reader.shouldRetry());
                Assertions.assertFalse((boolean)reader.checkAndClearBoundsFlag());
            }
        });
    }

    @Test
    void shouldRetryMustNotClearBoundsFlagWhenReturningFalse() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor reader = pf.io(0L, 1);){
                PageCursor writer = pf.io(0L, 2);
                Assertions.assertTrue((boolean)writer.next());
                writer.close();
                Assertions.assertTrue((boolean)reader.next());
                reader.getByte(-1);
                Assertions.assertFalse((boolean)reader.shouldRetry());
                Assertions.assertTrue((boolean)reader.checkAndClearBoundsFlag());
            }
        });
    }

    @Test
    void nextThatReturnsTrueMustNotClearBoundsFlagOnReadCursor() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor reader = pf.io(0L, 1);){
                PageCursor writer = pf.io(0L, 2);
                Assertions.assertTrue((boolean)writer.next());
                Assertions.assertTrue((boolean)reader.next());
                reader.getByte(-1);
                writer.next();
                writer.close();
                Assertions.assertTrue((boolean)reader.next());
                Assertions.assertTrue((boolean)reader.checkAndClearBoundsFlag());
            }
        });
    }

    @Test
    void nextThatReturnsTrueMustNotClearBoundsFlagOnWriteCursor() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor writer = pf.io(0L, 2);){
                Assertions.assertTrue((boolean)writer.next());
                writer.getByte(-1);
                Assertions.assertTrue((boolean)writer.next());
                Assertions.assertTrue((boolean)writer.checkAndClearBoundsFlag());
            }
        });
    }

    @Test
    void nextThatReturnsFalseMustNotClearBoundsFlagOnReadCursor() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor reader = pf.io(0L, 1);){
                PageCursor writer = pf.io(0L, 2);
                Assertions.assertTrue((boolean)writer.next());
                Assertions.assertTrue((boolean)reader.next());
                reader.getByte(-1);
                writer.close();
                Assertions.assertFalse((boolean)reader.next());
                Assertions.assertTrue((boolean)reader.checkAndClearBoundsFlag());
            }
        });
    }

    @Test
    void nextThatReturnsFalseMustNotClearBoundsFlagOnWriteCursor() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            File file = this.file("a");
            this.generateFileWithRecords(file, this.recordsPerFilePage, this.recordSize);
            try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);
                 PageCursor writer = pf.io(0L, 6);){
                Assertions.assertTrue((boolean)writer.next());
                writer.getByte(-1);
                Assertions.assertFalse((boolean)writer.next());
                Assertions.assertTrue((boolean)writer.checkAndClearBoundsFlag());
            }
        });
    }

    @Test
    void nextWithPageIdThatReturnsTrueMustNotClearBoundsFlagOnReadCursor() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor reader = pf.io(0L, 1);){
                PageCursor writer = pf.io(0L, 2);
                Assertions.assertTrue((boolean)writer.next());
                Assertions.assertTrue((boolean)reader.next());
                reader.getByte(-1);
                writer.next(3L);
                writer.close();
                Assertions.assertTrue((boolean)reader.next(3L));
                Assertions.assertTrue((boolean)reader.checkAndClearBoundsFlag());
            }
        });
    }

    @Test
    void nextWithPageIdMustNotClearBoundsFlagOnWriteCursor() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor writer = pf.io(0L, 2);){
                Assertions.assertTrue((boolean)writer.next());
                writer.getByte(-1);
                Assertions.assertTrue((boolean)writer.next(3L));
                Assertions.assertTrue((boolean)writer.checkAndClearBoundsFlag());
            }
        });
    }

    @Test
    void settingOutOfBoundsCursorOffsetMustRaiseBoundsFlag() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), 1, this.recordSize);
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pagedFile.io(0L, 1);){
                cursor.setOffset(-1);
                Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
                Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
                cursor.setOffset(this.filePageSize + 1);
                Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
                Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
                cursor.setOffset(this.pageCachePageSize + 1);
                Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
                Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
            }
        });
    }

    @Test
    void manuallyRaisedBoundsFlagMustBeObservable() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor writer = pagedFile.io(0L, 2);
             PageCursor reader = pagedFile.io(0L, 1);){
            Assertions.assertTrue((boolean)writer.next());
            writer.raiseOutOfBounds();
            Assertions.assertTrue((boolean)writer.checkAndClearBoundsFlag());
            Assertions.assertTrue((boolean)reader.next());
            reader.raiseOutOfBounds();
            Assertions.assertTrue((boolean)reader.checkAndClearBoundsFlag());
        }
    }

    @Test
    void pageFaultForWriteMustThrowIfOutOfStorageSpace() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            final AtomicInteger writeCounter = new AtomicInteger();
            final AtomicBoolean restrictWrites = new AtomicBoolean(true);
            DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){
                private List channels;
                {
                    super(delegate);
                    this.channels = new CopyOnWriteArrayList();
                }

                public StoreChannel write(File fileName) throws IOException {
                    DelegatingStoreChannel channel = new DelegatingStoreChannel(super.write(fileName)){

                        public void writeAll(ByteBuffer src, long position) throws IOException {
                            if (restrictWrites.get() && writeCounter.incrementAndGet() > 10) {
                                throw new IOException("No space left on device");
                            }
                            super.writeAll(src, position);
                        }
                    };
                    this.channels.add(channel);
                    return channel;
                }

                public void close() throws IOException {
                    IOUtils.closeAll((Collection)this.channels);
                    super.close();
                }
            };
            fs.write(this.file("a")).close();
            this.getPageCache((FileSystemAbstraction)fs, this.maxPages, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL);
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
            try (PageCursor cursor = pagedFile.io(0L, 2);){
                Assertions.assertThrows(IOException.class, () -> {
                    while (cursor.next()) {
                    }
                });
            }
            finally {
                restrictWrites.set(false);
                pagedFile.close();
                this.pageCache.close();
                fs.close();
            }
        });
    }

    @Test
    void pageFaultForReadMustThrowIfOutOfStorageSpace() {
        try {
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
                final AtomicInteger writeCounter = new AtomicInteger();
                final AtomicBoolean restrictWrites = new AtomicBoolean(true);
                DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){
                    private final List channels;
                    {
                        super(delegate);
                        this.channels = new CopyOnWriteArrayList();
                    }

                    public StoreChannel write(File fileName) throws IOException {
                        DelegatingStoreChannel channel = new DelegatingStoreChannel(super.write(fileName)){

                            public void writeAll(ByteBuffer src, long position) throws IOException {
                                if (restrictWrites.get() && writeCounter.incrementAndGet() >= 1) {
                                    throw new IOException("No space left on device");
                                }
                                super.writeAll(src, position);
                            }
                        };
                        this.channels.add(channel);
                        return channel;
                    }

                    public void close() throws IOException {
                        IOUtils.closeAll((Collection)this.channels);
                        super.close();
                    }
                };
                this.getPageCache((FileSystemAbstraction)fs, this.maxPages, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL);
                this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
                PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                try (PageCursor cursor = pagedFile.io(0L, 2);){
                    Assertions.assertTrue((boolean)cursor.next());
                }
                try {
                    cursor = pagedFile.io(0L, 1);
                    try {
                        while (true) {
                            if (cursor.next()) {
                                continue;
                            }
                            cursor.rewind();
                        }
                    }
                    catch (Throwable throwable) {
                        if (cursor != null) {
                            try {
                                cursor.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    restrictWrites.set(false);
                    pagedFile.close();
                    this.pageCache.close();
                    fs.close();
                    throw throwable;
                }
            });
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.instanceOf(IOException.class));
        }
    }

    @Test
    void mustRecoverViaFileCloseFromFullDriveWhenMoreStorageBecomesAvailable() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            final AtomicBoolean hasSpace = new AtomicBoolean();
            DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

                public StoreChannel write(File fileName) throws IOException {
                    return new DelegatingStoreChannel(super.write(fileName)){

                        public void writeAll(ByteBuffer src, long position) throws IOException {
                            if (!hasSpace.get()) {
                                throw new IOException("No space left on device");
                            }
                            super.writeAll(src, position);
                        }
                    };
                }
            };
            fs.write(this.file("a")).close();
            this.getPageCache((FileSystemAbstraction)fs, this.maxPages, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL);
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
            try {
                PageCursor cursor = pagedFile.io(0L, 2);
                try {
                    while (true) {
                        Assertions.assertTrue((boolean)cursor.next());
                        this.writeRecords(cursor);
                    }
                }
                catch (Throwable throwable) {
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (IOException cursor) {
                hasSpace.set(true);
                pagedFile.close();
                try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                     PageCursor cursor2 = pf.io(0L, 1);){
                    Assertions.assertTrue((boolean)cursor2.next());
                }
                return;
            }
        });
    }

    @Test
    void mustRecoverViaFileFlushFromFullDriveWhenMoreStorageBecomesAvailable() throws Exception {
        PageCursor cursor2;
        final AtomicBoolean hasSpace = new AtomicBoolean();
        final AtomicBoolean hasThrown = new AtomicBoolean();
        DelegatingFileSystemAbstraction fs = new DelegatingFileSystemAbstraction(this.fs){

            public StoreChannel write(File fileName) throws IOException {
                return new DelegatingStoreChannel(super.write(fileName)){

                    public void writeAll(ByteBuffer src, long position) throws IOException {
                        if (!hasSpace.get()) {
                            hasThrown.set(true);
                            throw new IOException("No space left on device");
                        }
                        super.writeAll(src, position);
                    }
                };
            }
        };
        fs.write(this.file("a")).close();
        this.getPageCache((FileSystemAbstraction)fs, this.maxPages, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL);
        PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        try {
            cursor2 = pagedFile.io(0L, 2);
            try {
                while (!hasThrown.get()) {
                    Assertions.assertTrue((boolean)cursor2.next());
                    this.writeRecords(cursor2);
                }
            }
            finally {
                if (cursor2 != null) {
                    cursor2.close();
                }
            }
        }
        catch (IOException cursor2) {
            // empty catch block
        }
        hasSpace.set(true);
        pagedFile.flushAndForce();
        cursor2 = pagedFile.io(0L, 1);
        try {
            Assertions.assertTrue((boolean)cursor2.next());
        }
        finally {
            if (cursor2 != null) {
                cursor2.close();
            }
        }
        pagedFile.close();
    }

    @Test
    void dataFromDifferentFilesMustNotBleedIntoEachOther() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            int i;
            this.configureStandardPageCache();
            File fileB = this.existingFile("b");
            int filePageSizeA = this.pageCachePageSize - 2;
            int filePageSizeB = this.pageCachePageSize - 6;
            int pagesToWriteA = 100;
            int pagesToWriteB = 3;
            PagedFile pagedFileA = this.map(this.existingFile("a"), filePageSizeA, new OpenOption[0]);
            try (PageCursor cursor = pagedFileA.io(0L, 2);){
                for (int i2 = 0; i2 < pagesToWriteA; ++i2) {
                    Assertions.assertTrue((boolean)cursor.next());
                    for (int j = 0; j < filePageSizeA; ++j) {
                        cursor.putByte((byte)42);
                    }
                }
            }
            PagedFile pagedFileB = this.map(fileB, filePageSizeB, new OpenOption[0]);
            try (PageCursor cursor = pagedFileB.io(0L, 2);){
                for (i = 0; i < pagesToWriteB; ++i) {
                    Assertions.assertTrue((boolean)cursor.next());
                    cursor.putByte((byte)63);
                }
            }
            pagedFileA.close();
            pagedFileB.close();
            InputStream inputStream = this.fs.openAsInputStream(fileB);
            MatcherAssert.assertThat((String)"first page first byte", (Object)inputStream.read(), (Matcher)Matchers.is((Object)63));
            for (i = 0; i < filePageSizeB - 1; ++i) {
                MatcherAssert.assertThat((String)("page 0 byte pos " + i), (Object)inputStream.read(), (Matcher)Matchers.is((Object)0));
            }
            MatcherAssert.assertThat((String)"second page first byte", (Object)inputStream.read(), (Matcher)Matchers.is((Object)63));
            for (i = 0; i < filePageSizeB - 1; ++i) {
                MatcherAssert.assertThat((String)("page 1 byte pos " + i), (Object)inputStream.read(), (Matcher)Matchers.is((Object)0));
            }
            MatcherAssert.assertThat((String)"third page first byte", (Object)inputStream.read(), (Matcher)Matchers.is((Object)63));
            for (i = 0; i < filePageSizeB - 1; ++i) {
                MatcherAssert.assertThat((String)("page 2 byte pos " + i), (Object)inputStream.read(), (Matcher)Matchers.is((Object)0));
            }
            MatcherAssert.assertThat((String)"expect EOF", (Object)inputStream.read(), (Matcher)Matchers.is((Object)-1));
        });
    }

    @Test
    void freshlyCreatedPagesMustContainAllZeros() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            int j;
            int i;
            PageCursor cursor;
            ThreadLocalRandom rng = ThreadLocalRandom.current();
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.existingFile("a"), this.filePageSize, new OpenOption[0]);){
                cursor = pagedFile.io(0L, 2);
                try {
                    for (i = 0; i < 100; ++i) {
                        Assertions.assertTrue((boolean)cursor.next());
                        for (j = 0; j < this.filePageSize; ++j) {
                            cursor.putByte((byte)rng.nextInt());
                        }
                    }
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            this.pageCache.close();
            this.pageCache = null;
            this.configureStandardPageCache();
            pagedFile = this.map(this.existingFile("b"), this.filePageSize, new OpenOption[0]);
            try {
                cursor = pagedFile.io(0L, 2);
                try {
                    for (i = 0; i < 100; ++i) {
                        Assertions.assertTrue((boolean)cursor.next());
                        for (j = 0; j < this.filePageSize; ++j) {
                            MatcherAssert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)0));
                        }
                    }
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            finally {
                if (pagedFile != null) {
                    pagedFile.close();
                }
            }
        });
    }

    @Test
    void optimisticReadLockMustFaultOnRetryIfPageHasBeenEvicted() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            int a = 97;
            int b = 98;
            File fileA = this.existingFile("a");
            File fileB = this.existingFile("b");
            this.configureStandardPageCache();
            PagedFile pagedFileA = this.map(fileA, this.filePageSize, new OpenOption[0]);
            PagedFile pagedFileB = this.map(fileB, this.filePageSize, new OpenOption[0]);
            try (PageCursor cursor = pagedFileA.io(0L, 2);){
                for (int i = 0; i < this.maxPages; ++i) {
                    Assertions.assertTrue((boolean)cursor.next());
                    for (int j = 0; j < this.filePageSize; ++j) {
                        cursor.putByte((byte)97);
                    }
                }
            }
            Runnable fillPagedFileB = () -> {
                try (PageCursor cursor = pagedFileB.io(0L, 2);){
                    for (int i = 0; i < this.maxPages * 30; ++i) {
                        Assertions.assertTrue((boolean)cursor.next());
                        for (int j = 0; j < this.filePageSize; ++j) {
                            cursor.putByte((byte)98);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            };
            try (PageCursor cursor = pagedFileA.io(0L, 1);){
                Assertions.assertTrue((boolean)cursor.next(0L));
                Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertTrue((boolean)cursor.next(0L));
                for (int i = 0; i < this.filePageSize; ++i) {
                    MatcherAssert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)97));
                }
                ThreadTestUtils.fork((Runnable)fillPagedFileB).join();
                if (cursor.shouldRetry()) {
                    int actual;
                    int expected = 97 * this.filePageSize;
                    do {
                        actual = 0;
                        for (int i = 0; i < this.filePageSize; ++i) {
                            actual += cursor.getByte();
                        }
                    } while (cursor.shouldRetry());
                    MatcherAssert.assertThat((Object)actual, (Matcher)Matchers.is((Object)expected));
                }
            }
            pagedFileA.close();
            pagedFileB.close();
        });
    }

    @Test
    void pagesMustReturnToFreelistIfSwapInThrows() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordCount, this.recordSize);
            PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
            int iterations = this.maxPages * 2;
            this.accessPagesWhileInterrupted(pagedFile, 1, iterations);
            this.accessPagesWhileInterrupted(pagedFile, 2, iterations);
            Thread.interrupted();
            try (PageCursor cursor = pagedFile.io(0L, 1);){
                Assertions.assertTrue((boolean)cursor.next());
                this.verifyRecordsMatchExpected(cursor);
            }
            pagedFile.close();
        });
    }

    private void accessPagesWhileInterrupted(PagedFile pagedFile, int pf_flags, int iterations) throws IOException {
        try (PageCursor cursor = pagedFile.io(0L, pf_flags);){
            for (int i = 0; i < iterations; ++i) {
                Thread.currentThread().interrupt();
                try {
                    cursor.next(0L);
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Test
    void mustSupportUnalignedWordAccesses() throws Exception {
        this.getPageCache(this.fs, 5, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL);
        int pageSize = this.pageCache.pageSize();
        ThreadLocalRandom rng = ThreadLocalRandom.current();
        try (PagedFile pagedFile = this.map(this.file("a"), pageSize, new OpenOption[0]);
             PageCursor cursor = pagedFile.io(0L, 2);){
            Assertions.assertTrue((boolean)cursor.next());
            long x = rng.nextLong();
            int limit = pageSize - 8;
            for (int i = 0; i < limit; ++i) {
                cursor.setOffset(i);
                cursor.putLong(x += (long)i);
                cursor.setOffset(i);
                long y = cursor.getLong();
                Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag(), (String)"Should not have had a page out-of-bounds access!");
                if (x == y) continue;
                String reason = "Failed to read back the value that was written at offset " + Long.toHexString(i);
                MatcherAssert.assertThat((String)reason, (Object)Long.toHexString(y), (Matcher)Matchers.is((Object)Long.toHexString(x)));
            }
        }
    }

    @RepeatedTest(value=50)
    void mustEvictPagesFromUnmappedFiles() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            PageCursor cursor;
            this.configureStandardPageCache();
            try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
                cursor = pagedFile.io(0L, 2);
                try {
                    Assertions.assertTrue((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
            try {
                cursor = pagedFile.io(0L, 2);
                try {
                    for (int i = 0; i < this.maxPages + 5; ++i) {
                        Assertions.assertTrue((boolean)cursor.next());
                    }
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            finally {
                if (pagedFile != null) {
                    pagedFile.close();
                }
            }
        });
    }

    @Test
    void mustReadZerosFromBeyondEndOfFile() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            StandardRecordFormat recordFormat = new StandardRecordFormat();
            File[] files = new File[]{this.file("1"), this.file("2"), this.file("3"), this.file("4"), this.file("5"), this.file("6"), this.file("7"), this.file("8"), this.file("9"), this.file("0"), this.file("A"), this.file("B")};
            for (int fileId = 0; fileId < files.length; ++fileId) {
                File file = files[fileId];
                StoreChannel channel = this.fs.write(file);
                for (int recordId = 0; recordId < fileId + 1; ++recordId) {
                    Record record = recordFormat.createRecord(file, recordId);
                    recordFormat.writeRecord(record, channel);
                }
                channel.close();
            }
            this.getPageCache(this.fs, 2, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL);
            int pageSize = this.pageCache.pageSize();
            int fileId = files.length;
            while (fileId-- > 0) {
                File file = files[fileId];
                PagedFile pf = this.map(file, pageSize, new OpenOption[0]);
                try {
                    PageCursor cursor = pf.io(0L, 1);
                    try {
                        int pageCount = 0;
                        while (cursor.next()) {
                            ++pageCount;
                            recordFormat.assertRecordsWrittenCorrectly(cursor);
                        }
                        MatcherAssert.assertThat((String)("pages in file " + file), (Object)pageCount, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
                    }
                    finally {
                        if (cursor == null) continue;
                        cursor.close();
                    }
                }
                finally {
                    if (pf == null) continue;
                    pf.close();
                }
            }
        });
    }

    @Test
    void mustThrowWhenMappingNonExistingFile() {
        Assertions.assertThrows(NoSuchFileException.class, () -> {
            this.configureStandardPageCache();
            this.map(this.file("does not exist"), this.filePageSize, new OpenOption[0]);
        });
    }

    @Test
    void mustCreateNonExistingFileWithCreateOption() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("does not exist"), this.filePageSize, StandardOpenOption.CREATE);
                 PageCursor cursor = pf.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
            }
        });
    }

    @Test
    void mustIgnoreCreateOptionIfFileAlreadyExists() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize, StandardOpenOption.CREATE);
                 PageCursor cursor = pf.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
            }
        });
    }

    @Test
    void mustIgnoreCertainOpenOptions() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.APPEND, StandardOpenOption.SPARSE);
                 PageCursor cursor = pf.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
            }
        });
    }

    @Test
    void mustThrowOnUnsupportedOpenOptions() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.verifyMappingWithOpenOptionThrows(StandardOpenOption.CREATE_NEW);
            this.verifyMappingWithOpenOptionThrows(StandardOpenOption.SYNC);
            this.verifyMappingWithOpenOptionThrows(StandardOpenOption.DSYNC);
            this.verifyMappingWithOpenOptionThrows(new OpenOption(){

                public String toString() {
                    return "NonStandardOpenOption";
                }
            });
        });
    }

    private void verifyMappingWithOpenOptionThrows(OpenOption option) throws IOException {
        try {
            this.map(this.file("a"), this.filePageSize, option).close();
            Assertions.fail((String)("Expected map() to throw when given the OpenOption " + option));
        }
        catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
            // empty catch block
        }
    }

    @Test
    void mappingFileWithTruncateOptionMustTruncateFile() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            PageCursor cursor;
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
                cursor = pf.io(10L, 2);
                try {
                    MatcherAssert.assertThat((Object)pf.getLastPageId(), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(0L)));
                    Assertions.assertTrue((boolean)cursor.next());
                    cursor.putInt(-889275714);
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            pf = this.map(this.file("a"), this.filePageSize, StandardOpenOption.TRUNCATE_EXISTING);
            try {
                cursor = pf.io(0L, 1);
                try {
                    MatcherAssert.assertThat((Object)pf.getLastPageId(), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(0L)));
                    Assertions.assertFalse((boolean)cursor.next());
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            finally {
                if (pf != null) {
                    pf.close();
                }
            }
        });
    }

    @Test
    void mappingAlreadyMappedFileWithTruncateOptionMustThrow() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile first = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            Assertions.assertThrows(UnsupportedOperationException.class, () -> {
                PagedFile second = this.map(this.file("a"), this.filePageSize, StandardOpenOption.TRUNCATE_EXISTING);
                if (second != null) {
                    second.close();
                }
            });
        }
    }

    @Test
    void mustThrowIfFileIsClosedMoreThanItIsMapped() throws Exception {
        this.configureStandardPageCache();
        PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
        pf.close();
        Assertions.assertThrows(IllegalStateException.class, () -> ((PagedFile)pf).close());
    }

    @Test
    void fileMappedWithDeleteOnCloseMustNotExistAfterUnmap() throws Exception {
        this.configureStandardPageCache();
        this.map(this.file("a"), this.filePageSize, StandardOpenOption.DELETE_ON_CLOSE).close();
        Assertions.assertThrows(NoSuchFileException.class, () -> this.map(this.file("a"), this.filePageSize, new OpenOption[0]));
    }

    @Test
    void fileMappedWithDeleteOnCloseMustNotExistAfterLastUnmap() throws Exception {
        this.configureStandardPageCache();
        File file = this.file("a");
        try (PagedFile ignore = this.map(file, this.filePageSize, new OpenOption[0]);){
            this.map(file, this.filePageSize, StandardOpenOption.DELETE_ON_CLOSE).close();
        }
        Assertions.assertThrows(NoSuchFileException.class, () -> this.map(file, this.filePageSize, new OpenOption[0]));
    }

    @Test
    void fileMappedWithDeleteOnCloseShouldNotFlushDirtyPagesOnClose() throws Exception {
        AtomicInteger flushCounter = new AtomicInteger();
        SingleFilePageSwapperFactory swapperFactory = PageCacheTest.flushCountingPageSwapperFactory(flushCounter);
        swapperFactory.open(this.fs);
        File file = this.file("a");
        try (Object cache = this.createPageCache((PageSwapperFactory)swapperFactory, this.maxPages, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, EmptyVersionContextSupplier.EMPTY);
             PagedFile pf = cache.map(file, this.filePageSize, new OpenOption[]{StandardOpenOption.DELETE_ON_CLOSE});
             PageCursor cursor = pf.io(0L, 2);){
            this.writeRecords(cursor);
            Assertions.assertTrue((boolean)cursor.next());
        }
        MatcherAssert.assertThat((Object)flushCounter.get(), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(this.recordCount / this.recordsPerFilePage)));
    }

    @Test
    void mustFlushAllDirtyPagesWhenClosingPagedFileThatIsNotMappedWithDeleteOnClose() throws Exception {
        AtomicInteger flushCounter = new AtomicInteger();
        SingleFilePageSwapperFactory swapperFactory = PageCacheTest.flushCountingPageSwapperFactory(flushCounter);
        swapperFactory.open(this.fs);
        File file = this.file("a");
        try (Object cache = this.createPageCache((PageSwapperFactory)swapperFactory, this.maxPages, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, EmptyVersionContextSupplier.EMPTY);
             PagedFile pf = cache.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            this.writeRecords(cursor);
            Assertions.assertTrue((boolean)cursor.next());
        }
        MatcherAssert.assertThat((Object)flushCounter.get(), (Matcher)Matchers.is((Object)1));
    }

    private static SingleFilePageSwapperFactory flushCountingPageSwapperFactory(final AtomicInteger flushCounter) {
        return new SingleFilePageSwapperFactory(){

            public PageSwapper createPageSwapper(File file, int filePageSize, PageEvictionCallback onEviction, boolean createIfNotExist, boolean noChannelStriping, boolean useDirectIO) throws IOException {
                PageSwapper swapper = super.createPageSwapper(file, filePageSize, onEviction, createIfNotExist, noChannelStriping, useDirectIO);
                return new DelegatingPageSwapper(swapper){

                    public long write(long filePageId, long bufferAddress) throws IOException {
                        flushCounter.getAndIncrement();
                        return super.write(filePageId, bufferAddress);
                    }

                    public long write(long startFilePageId, long[] bufferAddresses, int arrayOffset, int length) throws IOException {
                        flushCounter.getAndAdd(length);
                        return super.write(startFilePageId, bufferAddresses, arrayOffset, length);
                    }
                };
            }
        };
    }

    @Test
    void fileMappedWithDeleteOnCloseMustNotLeakDirtyPages() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SEMI_LONG_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            File file = this.file("a");
            int iterations = 50;
            for (int i = 0; i < iterations; ++i) {
                this.ensureExists(file);
                try (PagedFile pf = this.map(file, this.filePageSize, StandardOpenOption.DELETE_ON_CLOSE);
                     PageCursor cursor = pf.io(0L, 2);){
                    this.writeRecords(cursor);
                    Assertions.assertTrue((boolean)cursor.next());
                    continue;
                }
            }
        });
    }

    @Test
    void mustNotThrowWhenMappingFileWithDifferentFilePageSizeAndAnyPageSizeIsSpecified() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile ignore = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            this.map(this.file("a"), this.filePageSize + 1, new OpenOption[]{PageCacheOpenOptions.ANY_PAGE_SIZE}).close();
        }
    }

    @Test
    void mustCopyIntoSameSizedWritePageCursor() throws Exception {
        this.configureStandardPageCache();
        int bytes = 200;
        try (PagedFile pf = this.map(this.file("a"), 32, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            for (int i = 0; i < bytes; ++i) {
                if ((i & 0x1F) == 0) {
                    Assertions.assertTrue((boolean)cursor.next());
                }
                cursor.putByte((byte)i);
            }
        }
        int pageSize = 16;
        try (PagedFile pfA = this.map(this.file("a"), pageSize, new OpenOption[0]);
             PagedFile pfB = this.map(this.existingFile("b"), pageSize, new OpenOption[0]);
             PageCursor cursorA = pfA.io(0L, 1);
             PageCursor cursorB = pfB.io(0L, 2);){
            while (cursorA.next()) {
                int bytesCopied;
                Assertions.assertTrue((boolean)cursorB.next());
                do {
                    bytesCopied = cursorA.copyTo(0, cursorB, 0, cursorA.getCurrentPageSize());
                } while (cursorA.shouldRetry());
                MatcherAssert.assertThat((Object)bytesCopied, (Matcher)Matchers.is((Object)pageSize));
            }
        }
        try (PagedFile pf = this.map(this.file("b"), 32, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 1);){
            for (int i = 0; i < bytes; ++i) {
                byte b;
                if ((i & 0x1F) == 0) {
                    Assertions.assertTrue((boolean)cursor.next());
                }
                int offset = cursor.getOffset();
                do {
                    cursor.setOffset(offset);
                    b = cursor.getByte();
                } while (cursor.shouldRetry());
                MatcherAssert.assertThat((Object)b, (Matcher)Matchers.is((Object)((byte)i)));
            }
        }
    }

    @Test
    void mustCopyIntoLargerPageCursor() throws Exception {
        this.configureStandardPageCache();
        int smallPageSize = 16;
        int largePageSize = 17;
        try (PagedFile pfA = this.map(this.file("a"), smallPageSize, new OpenOption[0]);
             PagedFile pfB = this.map(this.existingFile("b"), largePageSize, new OpenOption[0]);
             PageCursor cursorA = pfA.io(0L, 2);
             PageCursor cursorB = pfB.io(0L, 2);){
            int i;
            Assertions.assertTrue((boolean)cursorA.next());
            for (i = 0; i < smallPageSize; ++i) {
                cursorA.putByte((byte)(i + 1));
            }
            Assertions.assertTrue((boolean)cursorB.next());
            MatcherAssert.assertThat((Object)cursorA.copyTo(0, cursorB, 0, smallPageSize), (Matcher)Matchers.is((Object)smallPageSize));
            for (i = 0; i < smallPageSize; ++i) {
                MatcherAssert.assertThat((Object)cursorB.getByte(), (Matcher)Matchers.is((Object)((byte)(i + 1))));
            }
            MatcherAssert.assertThat((Object)cursorB.getByte(), (Matcher)Matchers.is((Object)0));
        }
    }

    @Test
    void mustCopyIntoSmallerPageCursor() throws Exception {
        this.configureStandardPageCache();
        int smallPageSize = 16;
        int largePageSize = 17;
        try (PagedFile pfA = this.map(this.file("a"), largePageSize, new OpenOption[0]);
             PagedFile pfB = this.map(this.existingFile("b"), smallPageSize, new OpenOption[0]);
             PageCursor cursorA = pfA.io(0L, 2);
             PageCursor cursorB = pfB.io(0L, 2);){
            int i;
            Assertions.assertTrue((boolean)cursorA.next());
            for (i = 0; i < largePageSize; ++i) {
                cursorA.putByte((byte)(i + 1));
            }
            Assertions.assertTrue((boolean)cursorB.next());
            MatcherAssert.assertThat((Object)cursorA.copyTo(0, cursorB, 0, largePageSize), (Matcher)Matchers.is((Object)smallPageSize));
            for (i = 0; i < smallPageSize; ++i) {
                MatcherAssert.assertThat((Object)cursorB.getByte(), (Matcher)Matchers.is((Object)((byte)(i + 1))));
            }
        }
    }

    @Test
    void mustThrowOnCopyIntoReadPageCursor() throws Exception {
        this.configureStandardPageCache();
        int pageSize = 17;
        try (PagedFile pfA = this.map(this.file("a"), pageSize, new OpenOption[0]);
             PagedFile pfB = this.map(this.existingFile("b"), pageSize, new OpenOption[0]);){
            PageCursor cursorB;
            try (PageCursor cursorA = pfA.io(0L, 2);){
                cursorB = pfB.io(0L, 2);
                try {
                    Assertions.assertTrue((boolean)cursorA.next());
                    Assertions.assertTrue((boolean)cursorB.next());
                }
                finally {
                    if (cursorB != null) {
                        cursorB.close();
                    }
                }
            }
            cursorA = pfA.io(0L, 2);
            try {
                cursorB = pfB.io(0L, 1);
                try {
                    Assertions.assertTrue((boolean)cursorA.next());
                    Assertions.assertTrue((boolean)cursorB.next());
                    Assertions.assertThrows(IllegalArgumentException.class, () -> cursorA.copyTo(0, cursorB, 0, pageSize));
                }
                finally {
                    if (cursorB != null) {
                        cursorB.close();
                    }
                }
            }
            finally {
                if (cursorA != null) {
                    cursorA.close();
                }
            }
        }
    }

    @Test
    void copyToPageCursorMustCheckBounds() throws Exception {
        this.configureStandardPageCache();
        int pageSize = 16;
        try (PagedFile pf = this.map(this.file("a"), pageSize, new OpenOption[0]);
             PageCursor cursorA = pf.io(0L, 1);
             PageCursor cursorB = pf.io(0L, 2);){
            Assertions.assertTrue((boolean)cursorB.next());
            Assertions.assertTrue((boolean)cursorB.next());
            Assertions.assertTrue((boolean)cursorA.next());
            cursorA.copyTo(-1, cursorB, 0, 1);
            Assertions.assertTrue((boolean)cursorA.checkAndClearBoundsFlag());
            Assertions.assertFalse((boolean)cursorB.checkAndClearBoundsFlag());
            cursorA.copyTo(0, cursorB, -1, 1);
            Assertions.assertTrue((boolean)cursorA.checkAndClearBoundsFlag());
            Assertions.assertFalse((boolean)cursorB.checkAndClearBoundsFlag());
            cursorA.copyTo(pageSize, cursorB, 0, 1);
            Assertions.assertTrue((boolean)cursorA.checkAndClearBoundsFlag());
            Assertions.assertFalse((boolean)cursorB.checkAndClearBoundsFlag());
            cursorA.copyTo(0, cursorB, pageSize, 1);
            Assertions.assertTrue((boolean)cursorA.checkAndClearBoundsFlag());
            Assertions.assertFalse((boolean)cursorB.checkAndClearBoundsFlag());
            MatcherAssert.assertThat((Object)cursorA.copyTo(1, cursorB, 0, pageSize), (Matcher)Matchers.is((Object)(pageSize - 1)));
            Assertions.assertFalse((boolean)cursorA.checkAndClearBoundsFlag());
            Assertions.assertFalse((boolean)cursorB.checkAndClearBoundsFlag());
            MatcherAssert.assertThat((Object)cursorA.copyTo(0, cursorB, 1, pageSize), (Matcher)Matchers.is((Object)(pageSize - 1)));
            Assertions.assertFalse((boolean)cursorA.checkAndClearBoundsFlag());
            Assertions.assertFalse((boolean)cursorB.checkAndClearBoundsFlag());
            MatcherAssert.assertThat((Object)cursorA.copyTo(0, cursorB, 1, 0), (Matcher)Matchers.is((Object)0));
            Assertions.assertFalse((boolean)cursorA.checkAndClearBoundsFlag());
            Assertions.assertFalse((boolean)cursorB.checkAndClearBoundsFlag());
            cursorA.copyTo(1, cursorB, 1, -1);
            Assertions.assertTrue((boolean)cursorA.checkAndClearBoundsFlag());
            Assertions.assertFalse((boolean)cursorB.checkAndClearBoundsFlag());
        }
    }

    @Test
    void copyToHeapByteBufferFromReadPageCursorMustCheckBounds() throws Exception {
        this.configureStandardPageCache();
        ByteBuffer buffer = ByteBuffers.allocate((int)this.filePageSize);
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 1);){
            Assertions.assertTrue((boolean)cursor.next());
            this.verifyCopyToBufferBounds(cursor, buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void copyToDirectByteBufferFromReadPageCursorMustCheckBounds() throws Exception {
        this.configureStandardPageCache();
        ByteBuffer buffer = ByteBuffers.allocateDirect((int)this.filePageSize);
        try {
            File file = this.file("a");
            this.generateFileWithRecords(file, this.recordsPerFilePage, this.recordSize);
            try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pf.io(0L, 1);){
                Assertions.assertTrue((boolean)cursor.next());
                this.verifyCopyToBufferBounds(cursor, buffer);
            }
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)buffer);
        }
    }

    @Test
    void copyToHeapByteBufferFromWritePageCursorMustCheckBounds() throws Exception {
        this.configureStandardPageCache();
        ByteBuffer buffer = ByteBuffers.allocate((int)this.filePageSize);
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assertions.assertTrue((boolean)cursor.next());
            this.verifyCopyToBufferBounds(cursor, buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void copyToDirectByteBufferFromWritePageCursorMustCheckBounds() throws Exception {
        this.configureStandardPageCache();
        ByteBuffer buffer = ByteBuffers.allocateDirect((int)this.filePageSize);
        try {
            File file = this.file("a");
            this.generateFileWithRecords(file, this.recordsPerFilePage, this.recordSize);
            try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pf.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                this.verifyCopyToBufferBounds(cursor, buffer);
            }
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)buffer);
        }
    }

    private void verifyCopyToBufferBounds(PageCursor cursor, ByteBuffer buffer) throws IOException {
        int copied;
        do {
            buffer.clear();
            copied = cursor.copyTo(0, buffer);
        } while (cursor.shouldRetry());
        MatcherAssert.assertThat((Object)copied, (Matcher)Matchers.is((Object)this.filePageSize));
        buffer.clear();
        this.verifyRecordsMatchExpected(0L, 0, buffer);
        buffer.clear();
        cursor.copyTo(-1, buffer);
        Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        buffer.clear();
        copied = cursor.copyTo(1, buffer);
        Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
        MatcherAssert.assertThat((Object)copied, (Matcher)Matchers.is((Object)(this.filePageSize - 1)));
        MatcherAssert.assertThat((Object)buffer.position(), (Matcher)Matchers.is((Object)(this.filePageSize - 1)));
        MatcherAssert.assertThat((Object)buffer.remaining(), (Matcher)Matchers.is((Object)1));
        buffer.clear();
        PageCacheTest.zapBuffer(buffer);
        do {
            buffer.clear();
            buffer.limit(this.filePageSize - this.recordSize);
            copied = cursor.copyTo(0, buffer);
        } while (cursor.shouldRetry());
        MatcherAssert.assertThat((Object)copied, (Matcher)Matchers.is((Object)(this.filePageSize - this.recordSize)));
        MatcherAssert.assertThat((Object)buffer.position(), (Matcher)Matchers.is((Object)(this.filePageSize - this.recordSize)));
        MatcherAssert.assertThat((Object)buffer.remaining(), (Matcher)Matchers.is((Object)0));
        buffer.clear();
        buffer.limit(this.filePageSize - this.recordSize);
        this.verifyRecordsMatchExpected(0L, 0, buffer);
        PageCacheTest.zapBuffer(buffer);
        do {
            buffer.clear();
            buffer.limit(this.filePageSize - this.recordSize);
            copied = cursor.copyTo(this.recordSize, buffer);
        } while (cursor.shouldRetry());
        MatcherAssert.assertThat((Object)copied, (Matcher)Matchers.is((Object)(this.filePageSize - this.recordSize)));
        MatcherAssert.assertThat((Object)buffer.position(), (Matcher)Matchers.is((Object)(this.filePageSize - this.recordSize)));
        MatcherAssert.assertThat((Object)buffer.remaining(), (Matcher)Matchers.is((Object)0));
        buffer.clear();
        buffer.limit(this.filePageSize - this.recordSize);
        this.verifyRecordsMatchExpected(0L, this.recordSize, buffer);
    }

    private static void zapBuffer(ByteBuffer buffer) {
        byte zero = 0;
        if (buffer.hasArray()) {
            Arrays.fill(buffer.array(), zero);
        } else {
            buffer.clear();
            while (buffer.hasRemaining()) {
                buffer.put(zero);
            }
        }
    }

    @Test
    void copyToReadOnlyHeapByteBufferMustThrow() throws Exception {
        this.configureStandardPageCache();
        ByteBuffer buf = ByteBuffers.allocate((int)this.filePageSize).asReadOnlyBuffer();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assertions.assertTrue((boolean)cursor.next());
            Assertions.assertThrows(ReadOnlyBufferException.class, () -> cursor.copyTo(0, buf));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void copyToReadOnlyDirectByteBufferMustThrow() throws Exception {
        this.configureStandardPageCache();
        ByteBuffer allocation = ByteBuffers.allocateDirect((int)this.filePageSize);
        try {
            ByteBuffer buf = allocation.asReadOnlyBuffer();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor cursor = pf.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                Assertions.assertThrows(ReadOnlyBufferException.class, () -> cursor.copyTo(0, buf));
            }
        }
        finally {
            ByteBuffers.releaseBuffer((ByteBuffer)allocation);
        }
    }

    @Test
    void shiftBytesMustNotRaiseOutOfBoundsOnLengthWithinPageBoundary() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assertions.assertTrue((boolean)cursor.next());
            cursor.shiftBytes(0, this.filePageSize, 0);
            Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
            cursor.shiftBytes(0, this.filePageSize - 1, 1);
            Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
            cursor.shiftBytes(1, this.filePageSize - 1, -1);
            Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    @Test
    void shiftBytesMustRaiseOutOfBoundsOnLengthLargerThanPageSize() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assertions.assertTrue((boolean)cursor.next());
            cursor.shiftBytes(0, this.filePageSize + 1, 0);
            Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    @Test
    void shiftBytesMustRaiseOutOfBoundsOnNegativeLength() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assertions.assertTrue((boolean)cursor.next());
            cursor.shiftBytes(1, -1, 0);
            Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    @Test
    void shiftBytesMustRaiseOutOfBoundsOnNegativeSource() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assertions.assertTrue((boolean)cursor.next());
            cursor.shiftBytes(-1, 10, 0);
            Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    @Test
    void shiftBytesMustRaiseOutOfBoundsOnOverSizedSource() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assertions.assertTrue((boolean)cursor.next());
            cursor.shiftBytes(this.filePageSize, 1, 0);
            Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
            cursor.shiftBytes(this.filePageSize + 1, 0, 0);
            Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    @Test
    void shiftBytesMustRaiseOutOfBoundsOnBufferUnderflow() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assertions.assertTrue((boolean)cursor.next());
            cursor.shiftBytes(0, 1, -1);
            Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    @Test
    void shiftBytesMustRaiseOutOfBoundsOnBufferOverflow() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assertions.assertTrue((boolean)cursor.next());
            cursor.shiftBytes(this.filePageSize - 1, 1, 1);
            Assertions.assertTrue((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    @Test
    void shiftBytesMustThrowOnReadCursor() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor writer = pf.io(0L, 2);
             PageCursor reader = pf.io(0L, 1);){
            Assertions.assertTrue((boolean)writer.next());
            Assertions.assertTrue((boolean)reader.next());
            Assertions.assertThrows(IllegalStateException.class, () -> reader.shiftBytes(0, 0, 0));
        }
    }

    @Test
    void shiftBytesMustShiftBytesToTheRightOverlapping() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            int i;
            Assertions.assertTrue((boolean)cursor.next());
            byte[] bytes = new byte[30];
            for (int i2 = 0; i2 < bytes.length; ++i2) {
                bytes[i2] = (byte)(i2 + 1);
            }
            int srcOffset = 10;
            cursor.setOffset(srcOffset);
            cursor.putBytes(bytes);
            int shift = 5;
            PageCacheTest.assertZeroes(cursor, 0, srcOffset);
            PageCacheTest.assertZeroes(cursor, srcOffset + bytes.length, this.filePageSize - srcOffset - bytes.length);
            cursor.shiftBytes(srcOffset, bytes.length, shift);
            PageCacheTest.assertZeroes(cursor, 0, srcOffset);
            PageCacheTest.assertZeroes(cursor, srcOffset + bytes.length + shift, this.filePageSize - srcOffset - bytes.length - shift);
            cursor.setOffset(srcOffset);
            for (i = 0; i < shift; ++i) {
                MatcherAssert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)((byte)(i + 1))));
            }
            for (i = 0; i < bytes.length; ++i) {
                MatcherAssert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)((byte)(i + 1))));
            }
            Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    @Test
    void shiftBytesMustShiftBytesToTheRightNotOverlapping() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            int i;
            Assertions.assertTrue((boolean)cursor.next());
            byte[] bytes = new byte[30];
            for (int i2 = 0; i2 < bytes.length; ++i2) {
                bytes[i2] = (byte)(i2 + 1);
            }
            int srcOffset = 10;
            cursor.setOffset(srcOffset);
            cursor.putBytes(bytes);
            int gap = 5;
            int shift = bytes.length + gap;
            PageCacheTest.assertZeroes(cursor, 0, srcOffset);
            PageCacheTest.assertZeroes(cursor, srcOffset + bytes.length, this.filePageSize - srcOffset - bytes.length);
            cursor.shiftBytes(srcOffset, bytes.length, shift);
            PageCacheTest.assertZeroes(cursor, 0, srcOffset);
            PageCacheTest.assertZeroes(cursor, srcOffset + bytes.length + shift, this.filePageSize - srcOffset - bytes.length - shift);
            cursor.setOffset(srcOffset);
            for (i = 0; i < bytes.length; ++i) {
                MatcherAssert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)((byte)(i + 1))));
            }
            PageCacheTest.assertZeroes(cursor, srcOffset + bytes.length + shift, gap);
            cursor.setOffset(srcOffset + shift);
            for (i = 0; i < bytes.length; ++i) {
                MatcherAssert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)((byte)(i + 1))));
            }
            Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    @Test
    void shiftBytesMustShiftBytesToTheLeftOverlapping() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            int i;
            Assertions.assertTrue((boolean)cursor.next());
            byte[] bytes = new byte[30];
            for (int i2 = 0; i2 < bytes.length; ++i2) {
                bytes[i2] = (byte)(i2 + 1);
            }
            int srcOffset = 10;
            cursor.setOffset(srcOffset);
            cursor.putBytes(bytes);
            int shift = -5;
            PageCacheTest.assertZeroes(cursor, 0, srcOffset);
            PageCacheTest.assertZeroes(cursor, srcOffset + bytes.length, this.filePageSize - srcOffset - bytes.length);
            cursor.shiftBytes(srcOffset, bytes.length, shift);
            PageCacheTest.assertZeroes(cursor, 0, srcOffset + shift);
            PageCacheTest.assertZeroes(cursor, srcOffset + bytes.length, this.filePageSize - srcOffset - bytes.length);
            cursor.setOffset(srcOffset + shift);
            for (i = 0; i < bytes.length; ++i) {
                MatcherAssert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)((byte)(i + 1))));
            }
            for (i = shift; i < 0; ++i) {
                MatcherAssert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)((byte)(bytes.length + i + 1))));
            }
            Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    @Test
    void shiftBytesMustShiftBytesToTheLeftNotOverlapping() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            int i;
            Assertions.assertTrue((boolean)cursor.next());
            byte[] bytes = new byte[30];
            for (int i2 = 0; i2 < bytes.length; ++i2) {
                bytes[i2] = (byte)(i2 + 1);
            }
            int srcOffset = this.filePageSize - bytes.length - 10;
            cursor.setOffset(srcOffset);
            cursor.putBytes(bytes);
            int gap = 5;
            int shift = -bytes.length - gap;
            PageCacheTest.assertZeroes(cursor, 0, srcOffset);
            PageCacheTest.assertZeroes(cursor, srcOffset + bytes.length, this.filePageSize - srcOffset - bytes.length);
            cursor.shiftBytes(srcOffset, bytes.length, shift);
            PageCacheTest.assertZeroes(cursor, 0, srcOffset + shift);
            PageCacheTest.assertZeroes(cursor, srcOffset + bytes.length, this.filePageSize - srcOffset - bytes.length);
            cursor.setOffset(srcOffset + shift);
            for (i = 0; i < bytes.length; ++i) {
                MatcherAssert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)((byte)(i + 1))));
            }
            PageCacheTest.assertZeroes(cursor, srcOffset + bytes.length + shift, gap);
            cursor.setOffset(srcOffset);
            for (i = 0; i < bytes.length; ++i) {
                MatcherAssert.assertThat((Object)cursor.getByte(), (Matcher)Matchers.is((Object)((byte)(i + 1))));
            }
            Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
        }
    }

    private static void assertZeroes(PageCursor cursor, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            MatcherAssert.assertThat((Object)cursor.getByte(offset + i), (Matcher)Matchers.is((Object)0));
        }
    }

    @Test
    void readCursorsCanOpenLinkedCursor() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor parent = pf.io(0L, 1);){
                PageCursor linked = parent.openLinkedCursor(1L);
                Assertions.assertTrue((boolean)parent.next());
                Assertions.assertTrue((boolean)linked.next());
                this.verifyRecordsMatchExpected(parent);
                this.verifyRecordsMatchExpected(linked);
            }
        });
    }

    @Test
    void writeCursorsCanOpenLinkedCursor() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            File file = this.file("a");
            try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);
                 PageCursor parent = pf.io(0L, 2);){
                PageCursor linked = parent.openLinkedCursor(1L);
                Assertions.assertTrue((boolean)parent.next());
                Assertions.assertTrue((boolean)linked.next());
                this.writeRecords(parent);
                this.writeRecords(linked);
            }
            this.verifyRecordsInFile(file, this.recordsPerFilePage * 2);
        });
    }

    @Test
    void closingParentCursorMustCloseLinkedCursor() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
                PageCursor writerParent = pf.io(0L, 2);
                PageCursor readerParent = pf.io(0L, 1);
                Assertions.assertTrue((boolean)writerParent.next());
                Assertions.assertTrue((boolean)readerParent.next());
                PageCursor writerLinked = writerParent.openLinkedCursor(1L);
                PageCursor readerLinked = readerParent.openLinkedCursor(1L);
                Assertions.assertTrue((boolean)writerLinked.next());
                Assertions.assertTrue((boolean)readerLinked.next());
                writerParent.close();
                readerParent.close();
                writerLinked.getByte(0);
                Assertions.assertTrue((boolean)writerLinked.checkAndClearBoundsFlag());
                readerLinked.getByte(0);
                Assertions.assertTrue((boolean)readerLinked.checkAndClearBoundsFlag());
            }
        });
    }

    @Test
    void writeCursorWithNoGrowCanOpenLinkedCursorWithNoGrow() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor parent = pf.io(0L, 6);){
                PageCursor linked = parent.openLinkedCursor(1L);
                Assertions.assertTrue((boolean)parent.next());
                Assertions.assertTrue((boolean)linked.next());
                this.verifyRecordsMatchExpected(parent);
                this.verifyRecordsMatchExpected(linked);
                Assertions.assertFalse((boolean)linked.next());
            }
        });
    }

    @Test
    void openingLinkedCursorMustCloseExistingLinkedCursor() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            PageCursor linked;
            PageCursor parent;
            this.configureStandardPageCache();
            File file = this.file("a");
            try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);){
                parent = pf.io(0L, 2);
                try {
                    linked = parent.openLinkedCursor(1L);
                    Assertions.assertTrue((boolean)parent.next());
                    Assertions.assertTrue((boolean)linked.next());
                    this.writeRecords(parent);
                    this.writeRecords(linked);
                    parent.openLinkedCursor(2L);
                    linked.putByte(0, (byte)1);
                    Assertions.assertTrue((boolean)linked.checkAndClearBoundsFlag());
                }
                finally {
                    if (parent != null) {
                        parent.close();
                    }
                }
            }
            pf = this.map(file, this.filePageSize, new OpenOption[0]);
            try {
                parent = pf.io(0L, 1);
                try {
                    linked = parent.openLinkedCursor(1L);
                    Assertions.assertTrue((boolean)parent.next());
                    Assertions.assertTrue((boolean)linked.next());
                    parent.openLinkedCursor(2L);
                    linked.getByte(0);
                    Assertions.assertTrue((boolean)linked.checkAndClearBoundsFlag());
                }
                finally {
                    if (parent != null) {
                        parent.close();
                    }
                }
            }
            finally {
                if (pf != null) {
                    pf.close();
                }
            }
        });
    }

    @Test
    void shouldRetryOnParentCursorMustReturnTrueIfLinkedCursorNeedsRetry() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            this.generateFileWithRecords(this.file("a"), this.recordsPerFilePage * 2, this.recordSize);
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor parentReader = pf.io(0L, 1);
                 PageCursor writer = pf.io(1L, 2);){
                PageCursor linkedReader = parentReader.openLinkedCursor(1L);
                Assertions.assertTrue((boolean)parentReader.next());
                Assertions.assertTrue((boolean)linkedReader.next());
                Assertions.assertTrue((boolean)writer.next());
                Assertions.assertTrue((boolean)writer.next());
                Assertions.assertTrue((boolean)parentReader.shouldRetry());
                Assertions.assertFalse((boolean)parentReader.shouldRetry());
            }
        });
    }

    @Test
    void checkAndClearBoundsFlagMustCheckAndClearLinkedCursor() {
        Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.SHORT_TIMEOUT_MILLIS), () -> {
            this.configureStandardPageCache();
            try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
                 PageCursor parent = pf.io(0L, 2);){
                Assertions.assertTrue((boolean)parent.next());
                PageCursor linked = parent.openLinkedCursor(1L);
                linked.raiseOutOfBounds();
                Assertions.assertTrue((boolean)parent.checkAndClearBoundsFlag());
                Assertions.assertFalse((boolean)linked.checkAndClearBoundsFlag());
            }
        });
    }

    @Test
    void shouldRetryMustClearBoundsFlagIfLinkedCursorNeedsRetry() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor writer = pf.io(0L, 2);
             PageCursor reader = pf.io(0L, 1);){
            Assertions.assertTrue((boolean)writer.next());
            Assertions.assertTrue((boolean)writer.next());
            Assertions.assertTrue((boolean)writer.next());
            Assertions.assertTrue((boolean)reader.next());
            try (PageCursor linkedReader = reader.openLinkedCursor(1L);){
                Assertions.assertTrue((boolean)linkedReader.next());
                Assertions.assertTrue((boolean)writer.next(1L));
                Assertions.assertTrue((boolean)writer.next());
                reader.raiseOutOfBounds();
                Assertions.assertTrue((boolean)reader.shouldRetry());
                Assertions.assertFalse((boolean)reader.checkAndClearBoundsFlag());
            }
        }
    }

    @Test
    void checkAndClearCursorExceptionMustNotThrowIfNoExceptionIsSet() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pf.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                cursor.checkAndClearCursorException();
            }
            cursor = pf.io(0L, 1);
            try {
                Assertions.assertTrue((boolean)cursor.next());
                cursor.checkAndClearCursorException();
                while (cursor.shouldRetry()) {
                }
                cursor.checkAndClearCursorException();
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void checkAndClearCursorExceptionMustThrowIfExceptionIsSet() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            PageCursor cursor;
            String msg = "Boo" + ThreadLocalRandom.current().nextInt();
            try {
                cursor = pf.io(0L, 2);
                try {
                    Assertions.assertTrue((boolean)cursor.next());
                    cursor.setCursorException(msg);
                    cursor.checkAndClearCursorException();
                    Assertions.fail((String)"checkAndClearError on write cursor should have thrown");
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            catch (CursorException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)msg));
            }
            msg = "Boo" + ThreadLocalRandom.current().nextInt();
            try {
                cursor = pf.io(0L, 1);
                try {
                    Assertions.assertTrue((boolean)cursor.next());
                    cursor.setCursorException(msg);
                    cursor.checkAndClearCursorException();
                    Assertions.fail((String)"checkAndClearError on read cursor should have thrown");
                }
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                }
            }
            catch (CursorException e) {
                MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)msg));
            }
        }
    }

    @Test
    void checkAndClearCursorExceptionMustClearExceptionIfSet() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pf.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                cursor.setCursorException("boo");
                try {
                    cursor.checkAndClearCursorException();
                    Assertions.fail((String)"checkAndClearError on write cursor should have thrown");
                }
                catch (CursorException cursorException) {
                    // empty catch block
                }
                cursor.checkAndClearCursorException();
            }
            cursor = pf.io(0L, 1);
            try {
                Assertions.assertTrue((boolean)cursor.next());
                cursor.setCursorException("boo");
                try {
                    cursor.checkAndClearCursorException();
                    Assertions.fail((String)"checkAndClearError on read cursor should have thrown");
                }
                catch (CursorException cursorException) {
                    // empty catch block
                }
                cursor.checkAndClearCursorException();
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void nextMustClearCursorExceptionIfSet() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pf.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                cursor.setCursorException("boo");
                Assertions.assertTrue((boolean)cursor.next());
                cursor.checkAndClearCursorException();
            }
            cursor = pf.io(0L, 1);
            try {
                Assertions.assertTrue((boolean)cursor.next());
                cursor.setCursorException("boo");
                Assertions.assertTrue((boolean)cursor.next());
                cursor.checkAndClearCursorException();
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void nextWithIdMustClearCursorExceptionIfSet() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            try (PageCursor cursor = pf.io(0L, 2);){
                Assertions.assertTrue((boolean)cursor.next(1L));
                cursor.setCursorException("boo");
                Assertions.assertTrue((boolean)cursor.next(2L));
                cursor.checkAndClearCursorException();
            }
            cursor = pf.io(0L, 1);
            try {
                Assertions.assertTrue((boolean)cursor.next(1L));
                cursor.setCursorException("boo");
                Assertions.assertTrue((boolean)cursor.next(2L));
                cursor.checkAndClearCursorException();
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void shouldRetryMustClearCursorExceptionIfItReturnsTrue() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor writer = pf.io(0L, 2);
             PageCursor reader = pf.io(0L, 1);){
            Assertions.assertTrue((boolean)writer.next());
            Assertions.assertTrue((boolean)writer.next());
            Assertions.assertTrue((boolean)reader.next());
            Assertions.assertTrue((boolean)writer.next(0L));
            Assertions.assertTrue((boolean)writer.next());
            reader.setCursorException("boo");
            Assertions.assertTrue((boolean)reader.shouldRetry());
            reader.checkAndClearCursorException();
        }
    }

    @Test
    void shouldRetryMustNotClearCursorExceptionIfItReturnsFalse() throws Exception {
        this.configureStandardPageCache();
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordCount, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 1);){
            Assertions.assertTrue((boolean)cursor.next());
            do {
                cursor.setCursorException("boo");
            } while (cursor.shouldRetry());
            Assertions.assertThrows(CursorException.class, () -> ((PageCursor)cursor).checkAndClearCursorException());
        }
    }

    @Test
    void shouldRetryMustClearCursorExceptionIfLinkedShouldRetryReturnsTrue() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor writer = pf.io(0L, 2);
             PageCursor reader = pf.io(0L, 1);){
            Assertions.assertTrue((boolean)writer.next());
            Assertions.assertTrue((boolean)writer.next());
            Assertions.assertTrue((boolean)writer.next());
            Assertions.assertTrue((boolean)reader.next());
            try (PageCursor linkedReader = reader.openLinkedCursor(1L);){
                Assertions.assertTrue((boolean)linkedReader.next());
                Assertions.assertTrue((boolean)writer.next(1L));
                Assertions.assertTrue((boolean)writer.next());
                reader.setCursorException("boo");
                Assertions.assertTrue((boolean)reader.shouldRetry());
                reader.checkAndClearCursorException();
            }
        }
    }

    @Test
    void shouldRetryMustClearLinkedCursorExceptionIfItReturnsTrue() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor writer = pf.io(0L, 2);
             PageCursor reader = pf.io(0L, 1);){
            Assertions.assertTrue((boolean)writer.next());
            Assertions.assertTrue((boolean)writer.next());
            Assertions.assertTrue((boolean)writer.next());
            Assertions.assertTrue((boolean)reader.next());
            try (PageCursor linkedReader = reader.openLinkedCursor(1L);){
                Assertions.assertTrue((boolean)linkedReader.next());
                linkedReader.setCursorException("boo");
                Assertions.assertTrue((boolean)writer.next(0L));
                Assertions.assertTrue((boolean)reader.shouldRetry());
                linkedReader.checkAndClearCursorException();
                reader.checkAndClearCursorException();
            }
        }
    }

    @Test
    void shouldRetryMustClearLinkedCursorExceptionIfLinkedShouldRetryReturnsTrue() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor writer = pf.io(0L, 2);
             PageCursor reader = pf.io(0L, 1);){
            Assertions.assertTrue((boolean)writer.next());
            Assertions.assertTrue((boolean)writer.next());
            Assertions.assertTrue((boolean)writer.next());
            Assertions.assertTrue((boolean)reader.next());
            try (PageCursor linkedReader = reader.openLinkedCursor(1L);){
                Assertions.assertTrue((boolean)linkedReader.next());
                linkedReader.setCursorException("boo");
                Assertions.assertTrue((boolean)writer.next(1L));
                Assertions.assertTrue((boolean)reader.shouldRetry());
                linkedReader.checkAndClearCursorException();
                reader.checkAndClearCursorException();
            }
        }
    }

    @Test
    void shouldRetryMustNotClearCursorExceptionIfBothItAndLinkedShouldRetryReturnsFalse() throws Exception {
        this.configureStandardPageCache();
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordCount, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor reader = pf.io(0L, 1);
             PageCursor linkedReader = reader.openLinkedCursor(1L);){
            Assertions.assertTrue((boolean)reader.next());
            Assertions.assertTrue((boolean)linkedReader.next());
            do {
                reader.setCursorException("boo");
            } while (reader.shouldRetry());
            Assertions.assertThrows(CursorException.class, () -> ((PageCursor)reader).checkAndClearCursorException());
        }
    }

    @Test
    void shouldRetryMustNotClearLinkedCursorExceptionIfBothItAndLinkedShouldRetryReturnsFalse() throws Exception {
        this.configureStandardPageCache();
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordCount, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor reader = pf.io(0L, 1);
             PageCursor linkedReader = reader.openLinkedCursor(1L);){
            Assertions.assertTrue((boolean)reader.next());
            Assertions.assertTrue((boolean)linkedReader.next());
            do {
                linkedReader.setCursorException("boo");
            } while (reader.shouldRetry());
            Assertions.assertThrows(CursorException.class, () -> ((PageCursor)reader).checkAndClearCursorException());
        }
    }

    @Test
    void checkAndClearCursorExceptionMustThrowIfLinkedCursorHasErrorSet() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor writer = pf.io(0L, 2);
             PageCursor reader = pf.io(0L, 1);){
            CursorException exception;
            String msg = "Boo" + ThreadLocalRandom.current().nextInt();
            Assertions.assertTrue((boolean)writer.next());
            try (PageCursor linkedWriter = writer.openLinkedCursor(1L);){
                Assertions.assertTrue((boolean)linkedWriter.next());
                linkedWriter.setCursorException(msg);
                exception = (CursorException)Assertions.assertThrows(CursorException.class, () -> ((PageCursor)writer).checkAndClearCursorException());
                MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)msg));
            }
            msg = "Boo" + ThreadLocalRandom.current().nextInt();
            Assertions.assertTrue((boolean)reader.next());
            try (PageCursor linkedReader = reader.openLinkedCursor(1L);){
                Assertions.assertTrue((boolean)linkedReader.next());
                linkedReader.setCursorException(msg);
                exception = (CursorException)Assertions.assertThrows(CursorException.class, () -> ((PageCursor)reader).checkAndClearCursorException());
                MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)msg));
            }
        }
    }

    @Test
    void checkAndClearCursorMustNotThrowIfErrorHasBeenSetButTheCursorHasBeenClosed() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            PageCursor writer = pf.io(0L, 2);
            Assertions.assertTrue((boolean)writer.next());
            writer.setCursorException("boo");
            writer.close();
            writer.checkAndClearCursorException();
            PageCursor reader = pf.io(0L, 1);
            Assertions.assertTrue((boolean)reader.next());
            reader.setCursorException("boo");
            reader.close();
            reader.checkAndClearCursorException();
            writer = pf.io(0L, 2);
            PageCursor linkedWriter = writer.openLinkedCursor(1L);
            Assertions.assertTrue((boolean)linkedWriter.next());
            linkedWriter.setCursorException("boo");
            writer.close();
            linkedWriter.checkAndClearCursorException();
            reader = pf.io(0L, 1);
            PageCursor linkedReader = reader.openLinkedCursor(1L);
            Assertions.assertTrue((boolean)linkedReader.next());
            linkedReader.setCursorException("boo");
            reader.close();
            linkedReader.checkAndClearCursorException();
        }
    }

    @Test
    void openingLinkedCursorOnClosedCursorMustThrow() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            PageCursor writer = pf.io(0L, 2);
            Assertions.assertTrue((boolean)writer.next());
            writer.close();
            Assertions.assertThrows(IllegalStateException.class, () -> writer.openLinkedCursor(1L));
            PageCursor reader = pf.io(0L, 1);
            Assertions.assertTrue((boolean)reader.next());
            reader.close();
            Assertions.assertThrows(IllegalStateException.class, () -> reader.openLinkedCursor(1L));
        }
    }

    @Test
    void settingNullCursorExceptionMustThrow() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor writer = pf.io(0L, 2);
             PageCursor reader = pf.io(0L, 1);){
            Assertions.assertTrue((boolean)writer.next());
            Assertions.assertThrows(Exception.class, () -> writer.setCursorException(null));
            Assertions.assertTrue((boolean)reader.next());
            Assertions.assertThrows(Exception.class, () -> reader.setCursorException(null));
        }
    }

    @Test
    void clearCursorExceptionMustUnsetErrorCondition() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor writer = pf.io(0L, 2);
             PageCursor reader = pf.io(0L, 1);){
            Assertions.assertTrue((boolean)writer.next());
            writer.setCursorException("boo");
            writer.clearCursorException();
            writer.checkAndClearCursorException();
            Assertions.assertTrue((boolean)reader.next());
            reader.setCursorException("boo");
            reader.clearCursorException();
            reader.checkAndClearCursorException();
        }
    }

    @Test
    void clearCursorExceptionMustUnsetErrorConditionOnLinkedCursor() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor writer = pf.io(0L, 2);
             PageCursor reader = pf.io(0L, 1);){
            Assertions.assertTrue((boolean)writer.next());
            PageCursor linkedWriter = writer.openLinkedCursor(1L);
            Assertions.assertTrue((boolean)linkedWriter.next());
            linkedWriter.setCursorException("boo");
            writer.clearCursorException();
            writer.checkAndClearCursorException();
            Assertions.assertTrue((boolean)reader.next());
            PageCursor linkedReader = reader.openLinkedCursor(1L);
            Assertions.assertTrue((boolean)linkedReader.next());
            linkedReader.setCursorException("boo");
            reader.clearCursorException();
            reader.checkAndClearCursorException();
        }
    }

    @Test
    void sizeOfEmptyFileMustBeZero() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            MatcherAssert.assertThat((Object)pf.fileSize(), (Matcher)Matchers.is((Object)0L));
        }
    }

    @Test
    void fileSizeMustIncreaseInPageIncrements() throws Exception {
        this.configureStandardPageCache();
        long increment = this.filePageSize;
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assertions.assertTrue((boolean)cursor.next());
            MatcherAssert.assertThat((Object)pf.fileSize(), (Matcher)Matchers.is((Object)increment));
            Assertions.assertTrue((boolean)cursor.next());
            MatcherAssert.assertThat((Object)pf.fileSize(), (Matcher)Matchers.is((Object)(2L * increment)));
        }
    }

    @Test
    void shouldZeroAllBytesOnClear() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pagedFile = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);){
            byte[] read;
            long pageId = 0L;
            try (PageCursor cursor = pagedFile.io(pageId, 2);){
                ThreadLocalRandom rng = ThreadLocalRandom.current();
                byte[] bytes = new byte[this.filePageSize];
                rng.nextBytes(bytes);
                Assertions.assertTrue((boolean)cursor.next());
                cursor.putBytes(bytes);
            }
            byte[] allZeros = new byte[this.filePageSize];
            try (PageCursor cursor = pagedFile.io(pageId, 2);){
                Assertions.assertTrue((boolean)cursor.next());
                cursor.zapPage();
                read = new byte[this.filePageSize];
                cursor.getBytes(read);
                Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
                Assertions.assertArrayEquals((byte[])allZeros, (byte[])read);
            }
            cursor = pagedFile.io(pageId, 1);
            try {
                Assertions.assertTrue((boolean)cursor.next());
                read = new byte[this.filePageSize];
                do {
                    cursor.getBytes(read);
                } while (cursor.shouldRetry());
                Assertions.assertFalse((boolean)cursor.checkAndClearBoundsFlag());
                Assertions.assertArrayEquals((byte[])allZeros, (byte[])read);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
    }

    @Test
    void isWriteLockingMustBeTrueForCursorOpenedWithSharedWriteLock() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 2);){
            Assertions.assertTrue((boolean)cursor.isWriteLocked());
        }
    }

    @Test
    void isWriteLockingMustBeFalseForCursorOpenedWithSharedReadLock() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 1);){
            Assertions.assertFalse((boolean)cursor.isWriteLocked());
        }
    }

    @Test
    void eagerFlushMustWriteToFileOnUnpin() throws Exception {
        this.configureStandardPageCache();
        File file = this.file("a");
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor cursor = pf.io(0L, 66);){
            Assertions.assertTrue((boolean)cursor.next());
            this.writeRecords(cursor);
            Assertions.assertTrue((boolean)cursor.next());
            this.verifyRecordsInFile(file, this.recordsPerFilePage);
        }
    }

    @Test
    void noFaultNextReadOnInMemoryPages() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor faulter = pf.io(0L, 2);
             PageCursor nofault = pf.io(0L, 17);){
            PageCacheTest.verifyNoFaultAccessToInMemoryPages(faulter, nofault);
        }
    }

    @Test
    void noFaultNextWriteOnInMemoryPages() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor faulter = pf.io(0L, 2);
             PageCursor nofault = pf.io(0L, 18);){
            PageCacheTest.verifyNoFaultAccessToInMemoryPages(faulter, nofault);
        }
    }

    @Test
    void noFaultNextLinkedReadOnInMemoryPages() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor faulter = pf.io(0L, 2);
             PageCursor nofault = pf.io(0L, 17);
             PageCursor linkedNoFault = nofault.openLinkedCursor(0L);){
            PageCacheTest.verifyNoFaultAccessToInMemoryPages(faulter, linkedNoFault);
        }
    }

    @Test
    void noFaultNextLinkedWriteOnInMemoryPages() throws Exception {
        this.configureStandardPageCache();
        try (PagedFile pf = this.map(this.file("a"), this.filePageSize, new OpenOption[0]);
             PageCursor faulter = pf.io(0L, 2);
             PageCursor nofault = pf.io(0L, 18);
             PageCursor linkedNoFault = nofault.openLinkedCursor(0L);){
            PageCacheTest.verifyNoFaultAccessToInMemoryPages(faulter, linkedNoFault);
        }
    }

    private static void verifyNoFaultAccessToInMemoryPages(PageCursor faulter, PageCursor nofault) throws IOException {
        Assertions.assertTrue((boolean)faulter.next());
        Assertions.assertTrue((boolean)nofault.next());
        PageCacheTest.verifyNoFaultCursorIsInMemory(nofault, 0L);
        Assertions.assertTrue((boolean)faulter.next());
        Assertions.assertTrue((boolean)nofault.next(1L));
        PageCacheTest.verifyNoFaultCursorIsInMemory(nofault, 1L);
    }

    private static void verifyNoFaultCursorIsInMemory(PageCursor nofault, long expectedPageId) {
        MatcherAssert.assertThat((Object)nofault.getCurrentPageId(), (Matcher)Matchers.is((Object)expectedPageId));
        nofault.getByte();
        Assertions.assertFalse((boolean)nofault.checkAndClearBoundsFlag());
        nofault.getByte(0);
        Assertions.assertFalse((boolean)nofault.checkAndClearBoundsFlag());
    }

    @Test
    void noFaultReadOfPagesNotInMemory() throws Exception {
        DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer();
        DefaultPageCursorTracerSupplier cursorTracerSupplier = PageCacheTest.getCursorTracerSupplier(cacheTracer);
        this.getPageCache(this.fs, this.maxPages, (PageCacheTracer)cacheTracer, (PageCursorTracerSupplier)cursorTracerSupplier);
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor nofault = pf.io(0L, 17);){
            PageCacheTest.verifyNoFaultAccessToPagesNotInMemory(cacheTracer, cursorTracerSupplier, nofault);
        }
    }

    private static DefaultPageCursorTracerSupplier getCursorTracerSupplier(DefaultPageCacheTracer cacheTracer) {
        DefaultPageCursorTracerSupplier cursorTracerSupplier = DefaultPageCursorTracerSupplier.INSTANCE;
        PageCursorTracer cursorTracer = cursorTracerSupplier.get();
        cursorTracer.init((PageCacheTracer)new DefaultPageCacheTracer());
        cursorTracer.reportEvents();
        cursorTracer.init((PageCacheTracer)cacheTracer);
        return cursorTracerSupplier;
    }

    @Test
    void noFaultWriteOnPagesNotInMemory() throws Exception {
        DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer();
        DefaultPageCursorTracerSupplier cursorTracerSupplier = PageCacheTest.getCursorTracerSupplier(cacheTracer);
        this.getPageCache(this.fs, this.maxPages, (PageCacheTracer)cacheTracer, (PageCursorTracerSupplier)cursorTracerSupplier);
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor nofault = pf.io(0L, 18);){
            PageCacheTest.verifyNoFaultAccessToPagesNotInMemory(cacheTracer, cursorTracerSupplier, nofault);
            PageCacheTest.verifyNoFaultWriteIsOutOfBounds(nofault);
        }
    }

    @Test
    void noFaultLinkedReadOfPagesNotInMemory() throws Exception {
        DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer();
        DefaultPageCursorTracerSupplier cursorTracerSupplier = PageCacheTest.getCursorTracerSupplier(cacheTracer);
        this.getPageCache(this.fs, this.maxPages, (PageCacheTracer)cacheTracer, (PageCursorTracerSupplier)cursorTracerSupplier);
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor nofault = pf.io(0L, 17);
             PageCursor linkedNoFault = nofault.openLinkedCursor(0L);){
            PageCacheTest.verifyNoFaultAccessToPagesNotInMemory(cacheTracer, cursorTracerSupplier, linkedNoFault);
        }
    }

    @Test
    void noFaultLinkedWriteOnPagesNotInMemory() throws Exception {
        DefaultPageCacheTracer cacheTracer = new DefaultPageCacheTracer();
        DefaultPageCursorTracerSupplier cursorTracerSupplier = PageCacheTest.getCursorTracerSupplier(cacheTracer);
        this.getPageCache(this.fs, this.maxPages, (PageCacheTracer)cacheTracer, (PageCursorTracerSupplier)cursorTracerSupplier);
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 2, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor nofault = pf.io(0L, 18);
             PageCursor linkedNoFault = nofault.openLinkedCursor(0L);){
            PageCacheTest.verifyNoFaultAccessToPagesNotInMemory(cacheTracer, cursorTracerSupplier, linkedNoFault);
            PageCacheTest.verifyNoFaultWriteIsOutOfBounds(linkedNoFault);
        }
    }

    private static void verifyNoFaultAccessToPagesNotInMemory(DefaultPageCacheTracer cacheTracer, DefaultPageCursorTracerSupplier cursorTracerSupplier, PageCursor nofault) throws IOException {
        Assertions.assertTrue((boolean)nofault.next());
        PageCacheTest.verifyNoFaultReadIsNotInMemory(nofault);
        Assertions.assertTrue((boolean)nofault.next());
        PageCacheTest.verifyNoFaultReadIsNotInMemory(nofault);
        Assertions.assertFalse((boolean)nofault.next());
        Assertions.assertTrue((boolean)nofault.next(0L));
        PageCacheTest.verifyNoFaultReadIsNotInMemory(nofault);
        Assertions.assertFalse((boolean)nofault.next(2L));
        cursorTracerSupplier.get().reportEvents();
        MatcherAssert.assertThat((Object)cacheTracer.faults(), (Matcher)Matchers.is((Object)0L));
    }

    private static void verifyNoFaultReadIsNotInMemory(PageCursor nofault) {
        MatcherAssert.assertThat((Object)nofault.getCurrentPageId(), (Matcher)Matchers.is((Object)-1L));
        nofault.getByte();
        Assertions.assertTrue((boolean)nofault.checkAndClearBoundsFlag());
        nofault.getByte(0);
        Assertions.assertTrue((boolean)nofault.checkAndClearBoundsFlag());
    }

    private static void verifyNoFaultWriteIsOutOfBounds(PageCursor nofault) throws IOException {
        Assertions.assertTrue((boolean)nofault.next(0L));
        MatcherAssert.assertThat((Object)nofault.getCurrentPageId(), (Matcher)Matchers.is((Object)-1L));
        nofault.putByte((byte)1);
        Assertions.assertTrue((boolean)nofault.checkAndClearBoundsFlag());
        nofault.putByte(0, (byte)1);
        Assertions.assertTrue((boolean)nofault.checkAndClearBoundsFlag());
    }

    @Test
    void noFaultNextReadMustStrideForwardMonotonically() throws Exception {
        this.configureStandardPageCache();
        File file = this.file("a");
        this.generateFileWithRecords(file, this.recordsPerFilePage * 6, this.recordSize);
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor faulter = pf.io(0L, 1);
             PageCursor nofault = pf.io(0L, 17);){
            Assertions.assertTrue((boolean)faulter.next(1L));
            Assertions.assertTrue((boolean)faulter.next(3L));
            Assertions.assertTrue((boolean)faulter.next(5L));
            Assertions.assertTrue((boolean)nofault.next());
            PageCacheTest.verifyNoFaultReadIsNotInMemory(nofault);
            Assertions.assertTrue((boolean)nofault.next());
            PageCacheTest.verifyNoFaultCursorIsInMemory(nofault, 1L);
            Assertions.assertTrue((boolean)nofault.next());
            PageCacheTest.verifyNoFaultReadIsNotInMemory(nofault);
            Assertions.assertTrue((boolean)nofault.next());
            PageCacheTest.verifyNoFaultCursorIsInMemory(nofault, 3L);
            Assertions.assertTrue((boolean)nofault.next());
            PageCacheTest.verifyNoFaultReadIsNotInMemory(nofault);
            Assertions.assertTrue((boolean)nofault.next());
            PageCacheTest.verifyNoFaultCursorIsInMemory(nofault, 5L);
            Assertions.assertFalse((boolean)nofault.next());
        }
    }

    @Test
    void noFaultReadCursorMustCopeWithPageEviction() throws Exception {
        this.configureStandardPageCache();
        File file = this.file("a");
        try (PagedFile pf = this.map(file, this.filePageSize, new OpenOption[0]);
             PageCursor faulter = pf.io(0L, 2);
             PageCursor nofault = pf.io(0L, 17);){
            Assertions.assertTrue((boolean)faulter.next());
            Assertions.assertTrue((boolean)faulter.next());
            Assertions.assertTrue((boolean)nofault.next());
            PageCacheTest.verifyNoFaultCursorIsInMemory(nofault, 0L);
            PageCursor[] writerArray = new PageCursor[this.maxPages - 1];
            for (int i = 0; i < writerArray.length; ++i) {
                writerArray[i] = pf.io((long)(2 + i), 2);
                Assertions.assertTrue((boolean)writerArray[i].next());
            }
            for (PageCursor writer : writerArray) {
                writer.close();
            }
            Assertions.assertTrue((boolean)nofault.shouldRetry());
            PageCacheTest.verifyNoFaultReadIsNotInMemory(nofault);
        }
    }

    private static interface PageCursorAction {
        public void apply(PageCursor var1);
    }
}

